/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.rendacm;

import java.lang.ref.WeakReference;
import java.util.List;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.gui.rendacm.PainelDadosRendAcm;
import serpro.ppgd.irpf.rendacm.RendAcmTitular;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ObjetoFicha;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Valor;

public class ColecaoRendAcmTitular
extends Colecao<RendAcmTitular>
implements ObjetoFicha {
    public static final String NOME_TOTAIS_AJUSTE = "Totais Rend. Recebidos - Ajuste";
    protected Valor totaisRendRecebidos = new Valor((ObjetoNegocio)this, "Totais Rend. Recebidos");
    protected Valor totaisContribuicaoPrevOficial = new Valor((ObjetoNegocio)this, "Totais Contr. Prev. Oficial");
    protected Valor totaisPensaoAlimenticia = new Valor((ObjetoNegocio)this, "Totais Pens\u00e3o Aliment\u00edcia");
    protected Valor totaisImpostoRetidoFonte = new Valor((ObjetoNegocio)this, "Totais Imposto Retido na Fonte");
    protected Valor totaisImpostoDevidoRRA = new Valor((ObjetoNegocio)this, "Totais Imposto Devido RRA");
    protected Valor totaisRendRecebidosAjuste = new Valor((ObjetoNegocio)this, "Totais Rend. Recebidos - Ajuste");
    protected Valor totaisRendRecebidosExclusiva = new Valor((ObjetoNegocio)this, "Totais Rend. Recebidos - Exclusiva");
    protected Valor totaisContribuicaoPrevOficialAjuste = new Valor((ObjetoNegocio)this, "Totais Contr. Prev. Oficial - Ajuste");
    protected Valor totaisContribuicaoPrevOficialExclusiva = new Valor((ObjetoNegocio)this, "Totais Contr. Prev. Oficial - Exclusiva");
    protected Valor totaisPensaoAlimenticiaAjuste = new Valor((ObjetoNegocio)this, "Totais Pens\u00e3o Aliment\u00edcia - Ajuste");
    protected Valor totaisPensaoAlimenticiaExclusiva = new Valor((ObjetoNegocio)this, "Totais Pens\u00e3o Aliment\u00edcia - Exclusiva");
    protected Valor totaisImpostoRetidoFonteAjuste = new Valor((ObjetoNegocio)this, "Totais Imposto Retido na Fonte - Ajuste");
    protected Valor totaisImpostoRetidoFonteExclusiva = new Valor((ObjetoNegocio)this, "Totais Imposto Retido na Fonte - Exclusiva");
    protected WeakReference<DeclaracaoIRPF> weakDec = null;

    public ColecaoRendAcmTitular(DeclaracaoIRPF declaracaoIRPF) {
        this.weakDec = new WeakReference<DeclaracaoIRPF>(declaracaoIRPF);
        this.totaisRendRecebidos.setReadOnly(true);
        this.totaisContribuicaoPrevOficial.setReadOnly(true);
        this.totaisPensaoAlimenticia.setReadOnly(true);
        this.totaisImpostoRetidoFonte.setReadOnly(true);
        this.totaisImpostoDevidoRRA.setReadOnly(true);
        this.setFicha("Rendimentos Recebidos Acumuladamente pelo Titular");
    }

    public void objetoInserido(RendAcmTitular rendAcmTitular) {
        rendAcmTitular.setFicha(this.getFicha());
    }

    public RendAcmTitular instanciaNovoObjeto() {
        return new RendAcmTitular((DeclaracaoIRPF)((Object)this.weakDec.get()), this);
    }

    public Valor getTotaisContribuicaoPrevOficial() {
        return this.totaisContribuicaoPrevOficial;
    }

    public Valor getTotaisImpostoDevidoRRA() {
        return this.totaisImpostoDevidoRRA;
    }

    public Valor getTotaisImpostoRetidoFonte() {
        return this.totaisImpostoRetidoFonte;
    }

    public Valor getTotaisRendRecebidos() {
        return this.totaisRendRecebidos;
    }

    public Valor getTotaisPensaoAlimenticia() {
        return this.totaisPensaoAlimenticia;
    }

    public Valor getTotaisRendRecebidosAjuste() {
        return this.totaisRendRecebidosAjuste;
    }

    public Valor getTotaisImpostoRetidoFonteExclusiva() {
        return this.totaisImpostoRetidoFonteExclusiva;
    }

    public Valor getTotaisContribuicaoPrevOficialAjuste() {
        return this.totaisContribuicaoPrevOficialAjuste;
    }

    public Valor getTotaisPensaoAlimenticiaAjuste() {
        return this.totaisPensaoAlimenticiaAjuste;
    }

    public Valor getTotaisImpostoRetidoFonteAjuste() {
        return this.totaisImpostoRetidoFonteAjuste;
    }

    public Valor getTotaisContribuicaoPrevOficialExclusiva() {
        return this.totaisContribuicaoPrevOficialExclusiva;
    }

    public Valor getTotaisPensaoAlimenticiaExclusiva() {
        return this.totaisPensaoAlimenticiaExclusiva;
    }

    public Valor getTotaisRendRecebidosExclusiva() {
        return this.totaisRendRecebidosExclusiva;
    }

    protected List<Informacao> recuperarListaCamposPendencia() {
        List list = super.recuperarListaCamposPendencia();
        list.add(this.getTotaisRendRecebidos());
        return list;
    }

    public String getClasseFicha() {
        return PainelDadosRendAcm.class.getName();
    }

    public String getNomeAba() {
        return null;
    }

    public boolean existeRendAcmComAlimentando(String string) {
        for (RendAcmTitular rendAcmTitular : this.itens()) {
            if (!rendAcmTitular.getPensaoAlimenticiaQuadroAuxiliar().existeAlimentando(string)) continue;
            return true;
        }
        return false;
    }

    public void excluirRendAcmComAlimentando(String string) {
        for (RendAcmTitular rendAcmTitular : this.itens()) {
            rendAcmTitular.getPensaoAlimenticiaQuadroAuxiliar().excluirAlimentando(string);
        }
    }

    public String getTituloFichaDashboard() {
        return "Rendimentos Recebidos Acumuladamente pelo Titular";
    }
}

