/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.rendacm;

import classes.bv;
import classes.dL;
import classes.dc;
import java.lang.ref.WeakReference;
import java.util.List;
import serpro.ppgd.cacheni.CacheNI;
import serpro.ppgd.irpf.ColecaoItemQuadroPensaoAlimenticia;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.Y;
import serpro.ppgd.irpf.af;
import serpro.ppgd.irpf.ai;
import serpro.ppgd.irpf.gui.rendacm.PainelDadosRendAcm;
import serpro.ppgd.irpf.rendacm.RendAcmDependente;
import serpro.ppgd.irpf.rendacm.d;
import serpro.ppgd.irpf.rendacm.e;
import serpro.ppgd.irpf.rendacm.f;
import serpro.ppgd.irpf.rendacm.g;
import serpro.ppgd.irpf.rendacm.h;
import serpro.ppgd.irpf.rendacm.i;
import serpro.ppgd.irpf.rendacm.j;
import serpro.ppgd.irpf.rendacm.k;
import serpro.ppgd.irpf.rendacm.l;
import serpro.ppgd.irpf.rendacm.m;
import serpro.ppgd.irpf.rendacm.n;
import serpro.ppgd.irpf.rendacm.o;
import serpro.ppgd.irpf.rendacm.p;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.Codigo;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.NI;
import serpro.ppgd.negocio.ObjetoFicha;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.Pendencia;
import serpro.ppgd.negocio.ValidadorIf;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorNI;

public class RendAcmTitular
extends ObjetoNegocio
implements ObjetoFicha {
    public static final String NOME_OPCAO_TRIBUTACAO = "Op\u00e7\u00e3o pela Forma de Tributa\u00e7\u00e3o";
    public static final String NOME_NOME_FONTE_PAGADORA = "Nome da Fonte Pagadora";
    public static final String NOME_NI_FONTE_PAGADORA = "CPF/CNPJ da Fonte Pagadora";
    public static final String NOME_REND_RECEB = "Rendimentos Recebidos";
    public static final String NOME_CONTRIB_PREV = "Contribui\u00e7\u00e3o Previdenci\u00e1ria Oficial";
    public static final String NOME_IMPOSTO_RETIDO = "Imposto Retido na Fonte";
    public static final String NOME_PENSAO_ALIMENTICIA = "Pens\u00e3o Aliment\u00edcia";
    public static final String NOME_MES_RECEBIMENTO = "M\u00eas do Recebimento";
    public static final String NOME_NUM_MESES = "N\u00famero de Meses";
    public static final String NOME_IMPOSTO_DEVIDO_RRA = "Imposto Devido RRA";
    protected Alfa opcaoTributacao = new Alfa((ObjetoNegocio)this, "Op\u00e7\u00e3o pela Forma de Tributa\u00e7\u00e3o", 1);
    protected Alfa nomeFontePagadora = new Alfa((ObjetoNegocio)this, "Nome da Fonte Pagadora", 60);
    protected NI niFontePagadora = new NI((ObjetoNegocio)this, "CPF/CNPJ da Fonte Pagadora");
    protected ai rendRecebidos = new ai(this, "Rendimentos Recebidos");
    protected ai contribuicaoPrevOficial = new ai(this, "Contribui\u00e7\u00e3o Previdenci\u00e1ria Oficial");
    protected ai impostoRetidoFonte = new ai(this, "Imposto Retido na Fonte");
    protected ai pensaoAlimenticia = new ai(this, "Pens\u00e3o Aliment\u00edcia");
    protected ColecaoItemQuadroPensaoAlimenticia pensaoAlimenticiaQuadroAuxiliar = new ColecaoItemQuadroPensaoAlimenticia(this);
    protected Codigo mesRecebimento = new Codigo((ObjetoNegocio)this, "M\u00eas do Recebimento", dc.E());
    protected ai numMeses = new ai(this, "N\u00famero de Meses", 3, 1);
    protected ai impostoDevidoRRA = new ai(this, "Imposto Devido RRA");
    protected String chave = null;
    protected WeakReference<DeclaracaoIRPF> weakDec = null;
    private WeakReference<? extends Colecao<RendAcmTitular>> weakColecao = null;

    public RendAcmTitular(DeclaracaoIRPF declaracaoIRPF, Colecao<RendAcmTitular> colecao) {
        this.weakDec = new WeakReference<DeclaracaoIRPF>(declaracaoIRPF);
        this.weakColecao = new WeakReference<Colecao<RendAcmTitular>>(colecao);
        CacheNI.getInstancia().registrarNINome(this.niFontePagadora, this.nomeFontePagadora);
        if (this.opcaoTributacao.isVazio()) {
            this.opcaoTributacao.setConteudo("V");
        }
        this.getPensaoAlimenticia().setReadOnly(true);
        this.getImpostoDevidoRRA().setReadOnly(true);
        this.adicionaValidadores();
        this.adicionaObservadores();
    }

    private void adicionaObservadores() {
        bv bv2 = new bv(this);
        this.getOpcaoTributacao().addObservador((Observador)bv2);
        this.getRendRecebidos().addObservador(bv2);
        this.getContribuicaoPrevOficial().addObservador(bv2);
        this.getPensaoAlimenticia().addObservador(bv2);
        this.getNumMeses().addObservador(bv2);
        this.getMesRecebimento().addObservador((Observador)bv2);
        this.getOpcaoTributacao().addObservador((Observador)new d(this));
        this.getNomeFontePagadora().addObservador((Observador)new Y());
        this.getPensaoAlimenticiaQuadroAuxiliar().getTotais().addObservador((Observador)new i(this));
    }

    protected void adicionaValidadores() {
        this.getOpcaoTributacao().addValidador((ValidadorIf)new j(this, 3, dL.a("rendacm_opcao_tributacao_nao_informada")));
        this.getOpcaoTributacao().addValidador((ValidadorIf)new k(this, 3));
        this.getNomeFontePagadora().addValidador((ValidadorIf)new l(this, 3));
        this.getNiFontePagadora().addValidador((ValidadorIf)new m(this, 3));
        this.getNiFontePagadora().addValidador((ValidadorIf)new ValidadorNI(3, dL.a("campo_invalido", new String[]{this.getNiFontePagadora().getNomeCampo()})));
        if (!(this instanceof RendAcmDependente)) {
            this.getNiFontePagadora().addValidador((ValidadorIf)new n(this, 3));
        }
        this.getMesRecebimento().addValidador((ValidadorIf)new af(3));
        this.getMesRecebimento().addValidador((ValidadorIf)new o(this, 3));
        this.getNumMeses().addValidador((ValidadorIf)new p(this, 3, dL.a("rendacm_num_meses_branco")));
        this.getPensaoAlimenticia().addValidador((ValidadorIf)new e(this, 3));
        this.getPensaoAlimenticia().addValidador((ValidadorIf)new f(this, 3));
        this.getPensaoAlimenticia().addValidador((ValidadorIf)new g(this, 3));
        this.getPensaoAlimenticia().addValidador((ValidadorIf)new h(this, 3));
    }

    public void addObservador(Observador observador) {
        this.opcaoTributacao.addObservador(observador);
        this.rendRecebidos.addObservador(observador);
        this.contribuicaoPrevOficial.addObservador(observador);
        this.impostoRetidoFonte.addObservador(observador);
        this.pensaoAlimenticia.addObservador(observador);
        this.impostoDevidoRRA.addObservador(observador);
    }

    public void removeObservador(Observador observador) {
        this.opcaoTributacao.addObservador(observador);
        this.rendRecebidos.removeObservador(observador);
        this.contribuicaoPrevOficial.removeObservador(observador);
        this.impostoRetidoFonte.removeObservador(observador);
        this.pensaoAlimenticia.removeObservador(observador);
        this.impostoDevidoRRA.removeObservador(observador);
    }

    public Pendencia verificaValores(int n2) {
        Pendencia pendencia = null;
        if (this.getImpostoRetidoFonte().isVazio() && this.getContribuicaoPrevOficial().isVazio() && this.getPensaoAlimenticia().isVazio() && this.getRendRecebidos().isVazio()) {
            pendencia = new Pendencia(3, (Informacao)this.getRendRecebidos(), "Valores Rend. Receb. Acum.", dL.a("rendacm_faltam_valores"), n2);
            pendencia.setNomeAba(this.getNomeAba());
        }
        return pendencia;
    }

    public List<Pendencia> verificarPendencias(int n2) {
        List list = super.verificarPendencias(n2);
        Pendencia pendencia = this.verificaValores(n2);
        if (pendencia != null) {
            pendencia.setClassePainel(this.getClasseFicha());
            list.add(pendencia);
        }
        return list;
    }

    protected List<Informacao> recuperarListaCamposPendencia() {
        List list = this.recuperarCamposInformacao();
        return list;
    }

    public boolean isVazio() {
        boolean bl2;
        boolean bl3 = bl2 = this.getNomeFontePagadora().isVazio() && this.getNiFontePagadora().isVazio() && this.getRendRecebidos().isVazio() && this.getContribuicaoPrevOficial().isVazio() && this.getPensaoAlimenticia().isVazio() && this.getImpostoRetidoFonte().isVazio() && this.getMesRecebimento().isVazio();
        if (this.opcaoTributacao.naoFormatado().equals("E")) {
            bl2 = bl2 && this.getNumMeses().isVazio() && this.getImpostoDevidoRRA().isVazio();
        }
        return bl2;
    }

    public Alfa getOpcaoTributacao() {
        return this.opcaoTributacao;
    }

    public Alfa getNomeFontePagadora() {
        return this.nomeFontePagadora;
    }

    public NI getNiFontePagadora() {
        return this.niFontePagadora;
    }

    public ai getRendRecebidos() {
        return this.rendRecebidos;
    }

    public ai getContribuicaoPrevOficial() {
        return this.contribuicaoPrevOficial;
    }

    public ai getImpostoRetidoFonte() {
        return this.impostoRetidoFonte;
    }

    public ai getPensaoAlimenticia() {
        return this.pensaoAlimenticia;
    }

    public ColecaoItemQuadroPensaoAlimenticia getPensaoAlimenticiaQuadroAuxiliar() {
        return this.pensaoAlimenticiaQuadroAuxiliar;
    }

    public Codigo getMesRecebimento() {
        return this.mesRecebimento;
    }

    public ai getNumMeses() {
        return this.numMeses;
    }

    public ai getImpostoDevidoRRA() {
        return this.impostoDevidoRRA;
    }

    public String getClasseFicha() {
        return PainelDadosRendAcm.class.getName();
    }

    public String getNomeAba() {
        return "Titular";
    }

    public String getChave() {
        return this.chave;
    }

    public void setChave(String string) {
        this.chave = string;
    }

    public String getTituloFichaDashboard() {
        return "Rendimentos Recebidos Acumuladamente pelo Titular";
    }

    static /* synthetic */ WeakReference a(RendAcmTitular rendAcmTitular) {
        return rendAcmTitular.weakColecao;
    }
}

