/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.rendavariavel;

import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Map;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.rendIsentos.c;
import serpro.ppgd.irpf.rendavariavel.ItemFundosInvestimentosDependente;
import serpro.ppgd.irpf.rendavariavel.RendaVariavel;
import serpro.ppgd.negocio.CPF;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.Valor;

public class ColecaoFundosInvestimentosDependente
extends Colecao<ItemFundosInvestimentosDependente> {
    private static final String NOME_FICHA = "Renda Vari\u00e1vel - Opera\u00e7\u00f5es de Fundos de Investimento Imobili\u00e1rio - Dependentes";
    private WeakReference<DeclaracaoIRPF> weakDec;
    private Valor totalBaseCalculo = new Valor((ObjetoNegocio)this, "Total Base C\u00e1lculo");
    private Valor totalImpostoDevido = new Valor((ObjetoNegocio)this, "Total Imposto Devido");
    private Valor totalImpostoRetidoFonteLei11033 = new Valor((ObjetoNegocio)this, "Total Imposto Retido Na Fonte");
    private Valor totalImpostoPago = new Valor((ObjetoNegocio)this, "Total Imposto Pago");
    private c observadorRecuperacaoPrejuizoBolsaDeValores;

    public ColecaoFundosInvestimentosDependente(DeclaracaoIRPF declaracaoIRPF) {
        this.weakDec = new WeakReference<DeclaracaoIRPF>(declaracaoIRPF);
        this.setFicha(NOME_FICHA);
    }

    public void adicionarObservGanhosFundInvest(Observador observador) {
        this.getTotalBaseCalculo().addObservador(observador);
        this.getTotalImpostoDevido().addObservador(observador);
        this.getTotalImpostoRetidoFonteLei11033().addObservador(observador);
        this.getTotalImpostoPago().addObservador(observador);
    }

    public void adicionarObservadorRecuperacaoPrejuizoBolsaDeValores(c c2) {
        this.observadorRecuperacaoPrejuizoBolsaDeValores = c2;
    }

    public ItemFundosInvestimentosDependente instanciaNovoObjeto() {
        return new ItemFundosInvestimentosDependente((DeclaracaoIRPF)((Object)this.weakDec.get()));
    }

    public void objetoInserido(ItemFundosInvestimentosDependente itemFundosInvestimentosDependente) {
        itemFundosInvestimentosDependente.addValidador();
        itemFundosInvestimentosDependente.setFicha(NOME_FICHA);
        itemFundosInvestimentosDependente.getFundosInvestimentos().getJan().getResultNegativoAnterior().addObservador((Observador)this.observadorRecuperacaoPrejuizoBolsaDeValores);
        itemFundosInvestimentosDependente.getFundosInvestimentos().getDez().getPrejuizoCompensar().addObservador((Observador)this.observadorRecuperacaoPrejuizoBolsaDeValores);
    }

    public void objetoRemovido(Object object) {
        object = (ItemFundosInvestimentosDependente)((Object)object);
        ((ItemFundosInvestimentosDependente)((Object)object)).getFundosInvestimentos().getJan().getResultNegativoAnterior().removeObservador((Observador)this.observadorRecuperacaoPrejuizoBolsaDeValores);
        ((ItemFundosInvestimentosDependente)((Object)object)).getFundosInvestimentos().getDez().getPrejuizoCompensar().removeObservador((Observador)this.observadorRecuperacaoPrejuizoBolsaDeValores);
    }

    public boolean todosCpfsPreenchidos() {
        boolean bl2 = true;
        Iterator iterator = this.itens().iterator();
        while (iterator.hasNext() && bl2) {
            ItemFundosInvestimentosDependente itemFundosInvestimentosDependente = (ItemFundosInvestimentosDependente)((Object)iterator.next());
            boolean bl3 = bl2 = bl2 && !itemFundosInvestimentosDependente.getCpf().isVazio();
        }
        return bl2;
    }

    public Map<String, Valor> obterTotalAnual() {
        Map<String, Valor> map = null;
        for (ItemFundosInvestimentosDependente itemFundosInvestimentosDependente : this.itens()) {
            if (map == null) {
                map = itemFundosInvestimentosDependente.getFundosInvestimentos().obterTotalAnual();
                continue;
            }
            RendaVariavel.somarTotalAnual(map, itemFundosInvestimentosDependente.getFundosInvestimentos().obterTotalAnual());
        }
        return map;
    }

    public boolean possuiDependenteComCPF(String string) {
        if ("".equals(string.trim())) {
            return false;
        }
        for (ItemFundosInvestimentosDependente itemFundosInvestimentosDependente : this.itens()) {
            if (!string.equals(itemFundosInvestimentosDependente.getCpf().naoFormatado())) continue;
            return true;
        }
        return false;
    }

    public void excluirDependentesComCPF(String string) {
        Iterator iterator = this.itens().iterator();
        while (iterator.hasNext()) {
            ItemFundosInvestimentosDependente itemFundosInvestimentosDependente = (ItemFundosInvestimentosDependente)((Object)iterator.next());
            if (!string.equals(itemFundosInvestimentosDependente.getCpf().naoFormatado())) continue;
            iterator.remove();
        }
    }

    public boolean temResultadoLiquido() {
        for (ItemFundosInvestimentosDependente itemFundosInvestimentosDependente : this.itens()) {
            if (!itemFundosInvestimentosDependente.getFundosInvestimentos().temResultadoLiquido()) continue;
            return true;
        }
        return false;
    }

    public Valor getTotalBaseCalculo() {
        return this.totalBaseCalculo;
    }

    public Valor getTotalImpostoDevido() {
        return this.totalImpostoDevido;
    }

    public Valor getTotalImpostoRetidoFonteLei11033() {
        return this.totalImpostoRetidoFonteLei11033;
    }

    public Valor getTotalImpostoPago() {
        return this.totalImpostoPago;
    }

    public Valor recuperarTotalRendimentosPorBeneficiario(CPF cPF) {
        Valor valor = new Valor("0,00");
        for (ItemFundosInvestimentosDependente itemFundosInvestimentosDependente : this.itens()) {
            if (!itemFundosInvestimentosDependente.getCpf().naoFormatado().equals(cPF.naoFormatado())) continue;
            int n2 = 0;
            while (n2 < 12) {
                valor.append('+', itemFundosInvestimentosDependente.getFundosInvestimentos().getMeses()[n2].getResultLiquidoMes());
                ++n2;
            }
        }
        return valor;
    }
}

