/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.rendavariavel;

import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Map;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.rendIsentos.c;
import serpro.ppgd.irpf.rendavariavel.ItemRendaVariavelDependente;
import serpro.ppgd.irpf.rendavariavel.RendaVariavel;
import serpro.ppgd.negocio.CPF;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.Valor;

public class ColecaoRendaVariavelDependente
extends Colecao<ItemRendaVariavelDependente> {
    private static final String NOME_FICHA = "Renda Vari\u00e1vel - Opera\u00e7\u00f5es Comuns/Day-Trade - Dependentes";
    private WeakReference<DeclaracaoIRPF> weakDec;
    private Valor totalBaseCalculo = new Valor((ObjetoNegocio)this, "");
    private Valor totalIRFonteDayTrade = new Valor((ObjetoNegocio)this, "");
    private Valor totalImpostoRetidoFonteLei11033 = new Valor((ObjetoNegocio)this, "");
    private Valor totalImpostoAPagar = new Valor((ObjetoNegocio)this, "");
    private Valor totalImpostoPago = new Valor((ObjetoNegocio)this, "");
    private c observadorRecuperacaoPrejuizoBolsaDeValores;

    public ColecaoRendaVariavelDependente(DeclaracaoIRPF declaracaoIRPF) {
        this.weakDec = new WeakReference<DeclaracaoIRPF>(declaracaoIRPF);
        this.setFicha(NOME_FICHA);
    }

    public void adicionarObservGanhosRendaVar(Observador observador) {
        this.getTotalBaseCalculo().addObservador(observador);
        this.getTotalIRFonteDayTrade().addObservador(observador);
        this.getTotalImpostoAPagar().addObservador(observador);
        this.getTotalImpostoPago().addObservador(observador);
        this.getTotalImpostoRetidoFonteLei11033().addObservador(observador);
    }

    public void adicionarObservadorRecuperacaoPrejuizoBolsaDeValores(c c2) {
        this.observadorRecuperacaoPrejuizoBolsaDeValores = c2;
    }

    public ItemRendaVariavelDependente instanciaNovoObjeto() {
        return new ItemRendaVariavelDependente((DeclaracaoIRPF)((Object)this.weakDec.get()));
    }

    public void objetoInserido(ItemRendaVariavelDependente itemRendaVariavelDependente) {
        itemRendaVariavelDependente.addValidador();
        itemRendaVariavelDependente.setFicha(NOME_FICHA);
        itemRendaVariavelDependente.getRendaVariavel().getJaneiro().getOperacoesComuns().getResultadoNegativoMesAnterior().addObservador(this.observadorRecuperacaoPrejuizoBolsaDeValores);
        itemRendaVariavelDependente.getRendaVariavel().getJaneiro().getOperacoesDayTrade().getResultadoNegativoMesAnterior().addObservador(this.observadorRecuperacaoPrejuizoBolsaDeValores);
        itemRendaVariavelDependente.getRendaVariavel().getDezembro().getOperacoesComuns().getPrejuizoCompensar().addObservador((Observador)this.observadorRecuperacaoPrejuizoBolsaDeValores);
        itemRendaVariavelDependente.getRendaVariavel().getDezembro().getOperacoesDayTrade().getPrejuizoCompensar().addObservador((Observador)this.observadorRecuperacaoPrejuizoBolsaDeValores);
    }

    public void objetoRemovido(Object object) {
        object = (ItemRendaVariavelDependente)((Object)object);
        ((ItemRendaVariavelDependente)((Object)object)).getRendaVariavel().getJaneiro().getOperacoesComuns().getResultadoNegativoMesAnterior().removeObservador(this.observadorRecuperacaoPrejuizoBolsaDeValores);
        ((ItemRendaVariavelDependente)((Object)object)).getRendaVariavel().getJaneiro().getOperacoesDayTrade().getResultadoNegativoMesAnterior().removeObservador(this.observadorRecuperacaoPrejuizoBolsaDeValores);
        ((ItemRendaVariavelDependente)((Object)object)).getRendaVariavel().getDezembro().getOperacoesComuns().getPrejuizoCompensar().removeObservador((Observador)this.observadorRecuperacaoPrejuizoBolsaDeValores);
        ((ItemRendaVariavelDependente)((Object)object)).getRendaVariavel().getDezembro().getOperacoesDayTrade().getPrejuizoCompensar().removeObservador((Observador)this.observadorRecuperacaoPrejuizoBolsaDeValores);
    }

    public boolean todosCpfsPreenchidos() {
        boolean bl2 = true;
        Iterator iterator = this.itens().iterator();
        while (iterator.hasNext() && bl2) {
            ItemRendaVariavelDependente itemRendaVariavelDependente = (ItemRendaVariavelDependente)((Object)iterator.next());
            boolean bl3 = bl2 = bl2 && !itemRendaVariavelDependente.getCpf().isVazio();
        }
        return bl2;
    }

    public Map<String, Valor> obterTotalAnual() {
        Map<String, Valor> map = null;
        for (ItemRendaVariavelDependente itemRendaVariavelDependente : this.itens()) {
            if (map == null) {
                map = itemRendaVariavelDependente.getRendaVariavel().obterTotalAnual();
                continue;
            }
            RendaVariavel.somarTotalAnual(map, itemRendaVariavelDependente.getRendaVariavel().obterTotalAnual());
        }
        return map;
    }

    public boolean possuiDependenteComCPF(String string) {
        if ("".equals(string.trim())) {
            return false;
        }
        for (ItemRendaVariavelDependente itemRendaVariavelDependente : this.itens()) {
            if (!string.equals(itemRendaVariavelDependente.getCpf().naoFormatado())) continue;
            return true;
        }
        return false;
    }

    public void excluirDependentesComCPF(String string) {
        Iterator iterator = this.itens().iterator();
        while (iterator.hasNext()) {
            ItemRendaVariavelDependente itemRendaVariavelDependente = (ItemRendaVariavelDependente)((Object)iterator.next());
            if (!string.equals(itemRendaVariavelDependente.getCpf().naoFormatado())) continue;
            iterator.remove();
        }
    }

    public boolean temResultadoLiquido() {
        for (ItemRendaVariavelDependente itemRendaVariavelDependente : this.itens()) {
            if (!itemRendaVariavelDependente.getRendaVariavel().temResultadoLiquido()) continue;
            return true;
        }
        return false;
    }

    public Valor getTotalBaseCalculo() {
        return this.totalBaseCalculo;
    }

    public Valor getTotalIRFonteDayTrade() {
        return this.totalIRFonteDayTrade;
    }

    public Valor getTotalImpostoRetidoFonteLei11033() {
        return this.totalImpostoRetidoFonteLei11033;
    }

    public Valor getTotalImpostoAPagar() {
        return this.totalImpostoAPagar;
    }

    public Valor getTotalImpostoPago() {
        return this.totalImpostoPago;
    }

    public Valor recuperarTotalRendimentosPorBeneficiario(CPF cPF) {
        Valor valor = new Valor("0,00");
        for (ItemRendaVariavelDependente itemRendaVariavelDependente : this.itens()) {
            if (!itemRendaVariavelDependente.getCpf().naoFormatado().equals(cPF.naoFormatado())) continue;
            int n2 = 0;
            while (n2 < 12) {
                valor.append('+', itemRendaVariavelDependente.getRendaVariavel().getGanhosPorIndice(n2).getOperacoesComuns().getResultadoLiquidoMes());
                valor.append('+', itemRendaVariavelDependente.getRendaVariavel().getGanhosPorIndice(n2).getOperacoesDayTrade().getResultadoLiquidoMes());
                ++n2;
            }
        }
        return valor;
    }
}

