/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.rendavariavel;

import java.util.List;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.ai;
import serpro.ppgd.irpf.gui.rendavariavel.PainelDadosRendaVariavelOpComunsDayTrade;
import serpro.ppgd.irpf.rendavariavel.Operacoes;
import serpro.ppgd.irpf.rendavariavel.f;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ObjetoFicha;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.Valor;

public class GanhosLiquidosOuPerdas
extends ObjetoNegocio
implements ObjetoFicha {
    public static final String PROP_IMP_DEVIDO = "Total do Imposto Devido";
    public static final String PROP_IR_FONTE_DAYTRADE = "IRFONTEDAYTRADE";
    public static final String PROP_IR_FONTE_DAYTRADE_MESES_ANTERIORES = "IRFONTEDAYTRADEANTERIOR";
    public static final String PROP_IR_FONTE_DAYTRADE_MESES_COMPENSAR = "IRFONTEDAYTRADECOMPENSAR";
    public static final String PROP_IMP_PAGAR = "Imposto a Pagar";
    public static final String PROP_IMP_RETIDO_LEI_11033 = "IR LEI 11033";
    public static final String PROP_IMP_RETIDO_LEI_11033_MESES_ANTERIORES = "IR LEI 11033 Meses Anteriores";
    public static final String PROP_IMP_RETIDO_LEI_11033_MESES_COMPENSAR = "IR LEI 11033 Meses Compensar";
    public static final String PROP_IMP_PAGO = "IMP PAGO";
    private Operacoes operacoesComuns = new Operacoes("15");
    private Operacoes operacoesDayTrade = new Operacoes("20");
    private Valor totalImpostoDevido = new Valor((ObjetoNegocio)this, "Total do Imposto Devido");
    private ai irFonteDayTradeMesAtual = new ai(this, "IRFONTEDAYTRADE");
    private Valor irFonteDayTradeMesesAnteriores = new Valor((ObjetoNegocio)this, "IRFONTEDAYTRADEANTERIOR");
    private Valor irFonteDayTradeAcompensar = new Valor((ObjetoNegocio)this, "IRFONTEDAYTRADECOMPENSAR");
    private ai impostoApagar = new ai(this, "Imposto a Pagar");
    private ai impostoPago = new ai(this, "IMP PAGO");
    private ai impostoRetidoFonteLei11033 = new ai(this, "IR LEI 11033");
    private ai impostoRetidoFonteLei11033MesesAnteriores = new ai(this, "IR LEI 11033 Meses Anteriores");
    private ai impostoRetidoFonteLei11033MesesCompensar = new ai(this, "IR LEI 11033 Meses Compensar");
    private boolean ehDependente = false;
    public static final String ALIQUOTA_DAYTRADE = "20";
    public static final String ALIQUOTA_COMUM = "15";
    public static final String TITULO_FICHA_SEM_MES = "Renda Vari\u00e1vel - Opera\u00e7\u00f5es Comuns/Day-Trade";

    public GanhosLiquidosOuPerdas(DeclaracaoIRPF object, String string, boolean bl2) {
        this.setFicha("Renda Vari\u00e1vel - Opera\u00e7\u00f5es Comuns/Day-Trade - " + string);
        this.getOperacoesComuns().setFicha("Renda Vari\u00e1vel - Opera\u00e7\u00f5es Comuns/Day-Trade - " + (bl2 ? "Dependentes" : "Titular") + " - " + string);
        this.getOperacoesDayTrade().setFicha("Renda Vari\u00e1vel - Opera\u00e7\u00f5es Comuns/Day-Trade - " + (bl2 ? "Dependentes" : "Titular") + " - " + string);
        this.getOperacoesComuns().getAliquotaDoImposto().setConteudo("15%");
        this.getOperacoesDayTrade().getAliquotaDoImposto().setConteudo("20%");
        this.getOperacoesComuns().getResultadoLiquidoMes().setReadOnly(true);
        this.getOperacoesDayTrade().getResultadoLiquidoMes().setReadOnly(true);
        this.getOperacoesComuns().getBaseCalculoImposto().setReadOnly(true);
        this.getOperacoesDayTrade().getBaseCalculoImposto().setReadOnly(true);
        this.getOperacoesComuns().getPrejuizoCompensar().setReadOnly(true);
        this.getOperacoesDayTrade().getPrejuizoCompensar().setReadOnly(true);
        this.getOperacoesComuns().getAliquotaDoImposto().setReadOnly(false);
        this.getOperacoesDayTrade().getAliquotaDoImposto().setReadOnly(false);
        this.getOperacoesComuns().getImpostoDevido().setReadOnly(true);
        this.getOperacoesDayTrade().getImpostoDevido().setReadOnly(true);
        if (!string.equals("Janeiro")) {
            this.getOperacoesComuns().getResultadoNegativoMesAnterior().setReadOnly(true);
            this.getOperacoesDayTrade().getResultadoNegativoMesAnterior().setReadOnly(true);
        }
        this.getTotalImpostoDevido().setReadOnly(true);
        this.getIrFonteDayTradeMesesAnteriores().setReadOnly(true);
        this.getIrFonteDayTradeAcompensar().setReadOnly(true);
        this.getImpostoRetidoFonteLei11033MesesAnteriores().setReadOnly(true);
        this.getImpostoRetidoFonteLei11033MesesCompensar().setReadOnly(true);
        this.getImpostoApagar().setReadOnly(true);
        object = new f();
        this.getTotalImpostoDevido().addObservador((Observador)object);
        this.getIrFonteDayTradeMesAtual().addObservador((Observador)object);
        this.getIrFonteDayTradeMesesAnteriores().addObservador((Observador)object);
        this.getImpostoRetidoFonteLei11033().addObservador((Observador)object);
        this.getImpostoRetidoFonteLei11033MesesAnteriores().addObservador((Observador)object);
        this.getOperacoesComuns().getImpostoDevido().addObservador((Observador)this);
        this.getOperacoesDayTrade().getImpostoDevido().addObservador((Observador)this);
        this.getIrFonteDayTradeMesAtual().addObservador((Observador)this);
        this.getIrFonteDayTradeMesesAnteriores().addObservador((Observador)this);
        this.getImpostoRetidoFonteLei11033().addObservador((Observador)this);
        this.getImpostoRetidoFonteLei11033MesesAnteriores().addObservador((Observador)this);
        this.ehDependente = bl2;
    }

    public void notifica(Object object, String string, Object object2, Object object3) {
        this.totalImpostoDevido.setConteudo(this.getOperacoesComuns().getImpostoDevido().operacao('+', this.getOperacoesDayTrade().getImpostoDevido()));
        object = new Valor();
        object.append('+', (Valor)this.getIrFonteDayTradeMesAtual());
        object.append('+', this.getIrFonteDayTradeMesesAnteriores());
        string = new Valor();
        string.append('+', (Valor)this.getImpostoRetidoFonteLei11033());
        string.append('+', (Valor)this.getImpostoRetidoFonteLei11033MesesAnteriores());
        object2 = new Valor();
        object2.append('+', (Valor)object);
        object2.append('+', (Valor)string);
        if (object2.comparacao(">", this.getTotalImpostoDevido())) {
            object3 = new Valor();
            object2 = new Valor();
            Valor valor = new Valor(this.totalImpostoDevido.formatado());
            valor.append('-', (Valor)object);
            if (object.comparacao("=", this.totalImpostoDevido)) {
                this.getIrFonteDayTradeAcompensar().clear();
                this.getImpostoRetidoFonteLei11033MesesCompensar().setConteudo((Valor)string);
            } else if (object.comparacao(">", this.totalImpostoDevido)) {
                object3.append('+', (Valor)object);
                object3.append('-', this.getTotalImpostoDevido());
                this.getIrFonteDayTradeAcompensar().setConteudo((Valor)object3);
                this.getImpostoRetidoFonteLei11033MesesCompensar().setConteudo((Valor)string);
            } else if (valor.comparacao("=", (Valor)string)) {
                this.getIrFonteDayTradeAcompensar().clear();
                this.getImpostoRetidoFonteLei11033MesesCompensar().clear();
            } else {
                this.getIrFonteDayTradeAcompensar().clear();
                object2.append('+', (Valor)string);
                object2.append('-', valor);
                this.getImpostoRetidoFonteLei11033MesesCompensar().setConteudo((Valor)object2);
            }
            this.getImpostoApagar().clear();
            return;
        }
        this.getIrFonteDayTradeAcompensar().clear();
        this.getImpostoRetidoFonteLei11033MesesCompensar().clear();
        object3 = new Valor();
        object3.append('+', this.getTotalImpostoDevido());
        object3.append('-', (Valor)object2);
        this.getImpostoApagar().setConteudo((Valor)object3);
    }

    public void adicionarObservadorCalculosRendaVariavel(Observador observador) {
        this.operacoesComuns.getBaseCalculoImposto().addObservador(observador);
        this.operacoesDayTrade.getBaseCalculoImposto().addObservador(observador);
        this.irFonteDayTradeMesAtual.addObservador(observador);
        this.impostoPago.addObservador(observador);
        this.impostoRetidoFonteLei11033.addObservador(observador);
        this.impostoRetidoFonteLei11033MesesAnteriores.addObservador(observador);
        this.impostoRetidoFonteLei11033MesesCompensar.addObservador(observador);
        this.impostoApagar.addObservador(observador);
    }

    public void removerObservadorCalculosRendaVariavel(Observador observador) {
        this.operacoesComuns.getBaseCalculoImposto().removeObservador(observador);
        this.operacoesDayTrade.getBaseCalculoImposto().removeObservador(observador);
        this.irFonteDayTradeMesAtual.removeObservador(observador);
        this.impostoPago.removeObservador(observador);
        this.impostoRetidoFonteLei11033.removeObservador(observador);
        this.impostoRetidoFonteLei11033MesesAnteriores.removeObservador(observador);
        this.impostoRetidoFonteLei11033MesesCompensar.removeObservador(observador);
        this.impostoApagar.removeObservador(observador);
    }

    public Operacoes getOperacoesComuns() {
        return this.operacoesComuns;
    }

    public Operacoes getOperacoesDayTrade() {
        return this.operacoesDayTrade;
    }

    public ai getImpostoApagar() {
        return this.impostoApagar;
    }

    public ai getImpostoPago() {
        return this.impostoPago;
    }

    public Valor getIrFonteDayTradeAcompensar() {
        return this.irFonteDayTradeAcompensar;
    }

    public ai getIrFonteDayTradeMesAtual() {
        return this.irFonteDayTradeMesAtual;
    }

    public Valor getIrFonteDayTradeMesesAnteriores() {
        return this.irFonteDayTradeMesesAnteriores;
    }

    public Valor getTotalImpostoDevido() {
        return this.totalImpostoDevido;
    }

    protected List<Informacao> recuperarListaCamposPendencia() {
        List list = super.recuperarCamposInformacao();
        list.add(this.getImpostoRetidoFonteLei11033());
        return list;
    }

    public boolean isVazio() {
        boolean bl2 = this.operacoesComuns.isVazio();
        bl2 = bl2 && this.operacoesDayTrade.isVazio();
        bl2 = bl2 && this.irFonteDayTradeMesAtual.isVazio();
        bl2 = bl2 && this.impostoPago.isVazio();
        bl2 = bl2 && this.impostoRetidoFonteLei11033.isVazio();
        bl2 = bl2 && this.operacoesComuns.getResultadoLiquidoMes().isVazio();
        bl2 = bl2 && this.operacoesComuns.getResultadoNegativoMesAnterior().isVazio();
        bl2 = bl2 && this.operacoesDayTrade.getResultadoLiquidoMes().isVazio();
        bl2 = bl2 && this.operacoesDayTrade.getResultadoNegativoMesAnterior().isVazio();
        return bl2;
    }

    public ai getImpostoRetidoFonteLei11033() {
        return this.impostoRetidoFonteLei11033;
    }

    public void clear() {
        this.operacoesComuns.clear();
        this.operacoesDayTrade.clear();
        this.irFonteDayTradeMesAtual.clear();
        this.impostoRetidoFonteLei11033.clear();
        this.impostoPago.clear();
    }

    public String getClasseFicha() {
        return PainelDadosRendaVariavelOpComunsDayTrade.class.getName();
    }

    public String getNomeAba() {
        if (this.ehDependente) {
            return "Dependentes";
        }
        return "Titular";
    }

    public ai getImpostoRetidoFonteLei11033MesesAnteriores() {
        return this.impostoRetidoFonteLei11033MesesAnteriores;
    }

    public ai getImpostoRetidoFonteLei11033MesesCompensar() {
        return this.impostoRetidoFonteLei11033MesesCompensar;
    }

    public String getTituloFichaDashboard() {
        return TITULO_FICHA_SEM_MES;
    }
}

