/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.rendavariavel;

import java.util.List;
import serpro.ppgd.irpf.ai;
import serpro.ppgd.irpf.gui.rendavariavel.PainelDadosRendaVariavelOpComunsDayTrade;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ObjetoFicha;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.Valor;

public class Operacoes
extends ObjetoNegocio
implements ObjetoFicha {
    public static final String PROP_BASE_CALC = "BASE CALCULO";
    private Valor mercadoVistaAcoes = new Valor((ObjetoNegocio)this, "Mercado \u00e0 Vista - A\u00e7\u00f5es");
    private Valor mercadoVistaOuro = new Valor((ObjetoNegocio)this, "Mercado \u00e0 Vista - Ouro");
    private Valor mercadoVistaForaBolsa = new Valor((ObjetoNegocio)this, "Mercado \u00e0 Vista - Fora Bolsa");
    private Valor mercadoOpcoesAcoes = new Valor((ObjetoNegocio)this, "Mercado Op\u00e7\u00f5es - A\u00e7\u00f5es");
    private Valor mercadoOpcoesOuro = new Valor((ObjetoNegocio)this, "Mercado Op\u00e7\u00f5es - Ouro");
    private Valor mercadoOpcoesForaDeBolsa = new Valor((ObjetoNegocio)this, "Mercado Op\u00e7\u00f5es - Fora Bolsa");
    private Valor mercadoOpcoesOutros = new Valor((ObjetoNegocio)this, "Mercado Op\u00e7\u00f5es - Outros");
    private Valor mercadoFuturoDolar = new Valor((ObjetoNegocio)this, "Mercado Futuro - D\u00f3lar dos EUA");
    private Valor mercadoFuturoIndices = new Valor((ObjetoNegocio)this, "Mercado Futuro - \u00cdndices");
    private Valor mercadoFuturoJuros = new Valor((ObjetoNegocio)this, "Mercado Futuro - Juros");
    private Valor mercadoFuturoOutros = new Valor((ObjetoNegocio)this, "Mercado Futuro - Outros");
    private Valor mercadoTermoAcoes = new Valor((ObjetoNegocio)this, "Mercado a Termo - A\u00e7\u00f5es/Ouro");
    private Valor mercadoTermoOutros = new Valor((ObjetoNegocio)this, "Mercado a Termo - Outros");
    private Valor resultadoLiquidoMes = new Valor((ObjetoNegocio)this, "Resultado L\u00edquido do M\u00eas");
    private ai resultadoNegativoMesAnterior = new ai(this, "Resultado Negativo at\u00e9 o M\u00eas Anterior");
    private Valor baseCalculoImposto = new Valor((ObjetoNegocio)this, "BASE CALCULO");
    private ai prejuizoCompensar = new ai(this, "Preju\u00edzo a Compensar");
    private Alfa aliquotaDoImposto = new Alfa((ObjetoNegocio)this, "Al\u00edquota do Imposto");
    private Valor impostoDevido = new Valor((ObjetoNegocio)this, "Imposto Devido");
    private String VALOR_ALIQUOTA;

    public Operacoes(String string) {
        this.VALOR_ALIQUOTA = string;
        this.adicionarObservadorValoresMercado((Observador)this);
    }

    public void notifica(Object object, String string, Object object2, Object object3) {
        this.atualizaOperacoes(this);
    }

    private void adicionarObservadorValoresMercado(Observador observador) {
        this.adicionaObservador((Informacao)this.mercadoVistaAcoes, observador);
        this.adicionaObservador((Informacao)this.mercadoVistaOuro, observador);
        this.adicionaObservador((Informacao)this.mercadoVistaForaBolsa, observador);
        this.adicionaObservador((Informacao)this.mercadoOpcoesAcoes, observador);
        this.adicionaObservador((Informacao)this.mercadoTermoOutros, observador);
        this.adicionaObservador((Informacao)this.mercadoTermoAcoes, observador);
        this.adicionaObservador((Informacao)this.mercadoFuturoOutros, observador);
        this.adicionaObservador((Informacao)this.mercadoFuturoJuros, observador);
        this.adicionaObservador((Informacao)this.mercadoFuturoIndices, observador);
        this.adicionaObservador((Informacao)this.mercadoFuturoDolar, observador);
        this.adicionaObservador((Informacao)this.mercadoOpcoesOutros, observador);
        this.adicionaObservador((Informacao)this.mercadoOpcoesOuro, observador);
        this.adicionaObservador((Informacao)this.mercadoOpcoesForaDeBolsa, observador);
        this.adicionaObservador((Informacao)this.resultadoNegativoMesAnterior, observador);
    }

    private void atualizaOperacoes(Operacoes operacoes) {
        Object object = new Valor();
        object.append('+', operacoes.getMercadoVistaAcoes());
        object.append('+', operacoes.getMercadoVistaOuro());
        object.append('+', operacoes.getMercadoVistaForaBolsa());
        object.append('+', operacoes.getMercadoOpcoesAcoes());
        object.append('+', operacoes.getMercadoOpcoesOuro());
        object.append('+', operacoes.getMercadoOpcoesForaDeBolsa());
        object.append('+', operacoes.getMercadoOpcoesOutros());
        object.append('+', operacoes.getMercadoFuturoDolar());
        object.append('+', operacoes.getMercadoFuturoIndices());
        object.append('+', operacoes.getMercadoFuturoJuros());
        object.append('+', operacoes.getMercadoFuturoOutros());
        object.append('+', operacoes.getMercadoTermoAcoes());
        object.append('+', operacoes.getMercadoTermoOutros());
        operacoes.getResultadoLiquidoMes().setConteudo(object);
        if (operacoes.getResultadoLiquidoMes().comparacao(">", (Valor)operacoes.getResultadoNegativoMesAnterior())) {
            object = new Valor();
            object.append('+', operacoes.getResultadoLiquidoMes());
            object.append('-', (Valor)operacoes.getResultadoNegativoMesAnterior());
            operacoes.getBaseCalculoImposto().setConteudo(object);
            operacoes.getPrejuizoCompensar().clear();
        } else {
            object = new Valor();
            object.append('+', (Valor)operacoes.getResultadoNegativoMesAnterior());
            object.append('-', operacoes.getResultadoLiquidoMes());
            operacoes.getPrejuizoCompensar().setConteudo(object);
            operacoes.getBaseCalculoImposto().clear();
        }
        if (operacoes.getBaseCalculoImposto().comparacao(">", "0,00")) {
            object = "0," + this.VALOR_ALIQUOTA;
            Valor valor = new Valor();
            valor.setConteudo(operacoes.getBaseCalculoImposto());
            valor.append('*', (String)object);
            operacoes.getImpostoDevido().setConteudo(valor);
            return;
        }
        operacoes.getImpostoDevido().clear();
    }

    private void adicionaObservador(Informacao informacao, Observador observador) {
        informacao.addObservador(observador);
    }

    public Alfa getAliquotaDoImposto() {
        return this.aliquotaDoImposto;
    }

    public Valor getImpostoDevido() {
        return this.impostoDevido;
    }

    public Valor getMercadoTermoAcoes() {
        return this.mercadoTermoAcoes;
    }

    public Valor getMercadoTermoOutros() {
        return this.mercadoTermoOutros;
    }

    public Valor getPrejuizoCompensar() {
        return this.prejuizoCompensar;
    }

    public Valor getBaseCalculoImposto() {
        return this.baseCalculoImposto;
    }

    public Valor getMercadoFuturoDolar() {
        return this.mercadoFuturoDolar;
    }

    public Valor getMercadoFuturoIndices() {
        return this.mercadoFuturoIndices;
    }

    public Valor getMercadoFuturoJuros() {
        return this.mercadoFuturoJuros;
    }

    public Valor getMercadoFuturoOutros() {
        return this.mercadoFuturoOutros;
    }

    public Valor getMercadoOpcoesAcoes() {
        return this.mercadoOpcoesAcoes;
    }

    public Valor getMercadoOpcoesForaDeBolsa() {
        return this.mercadoOpcoesForaDeBolsa;
    }

    public Valor getMercadoOpcoesOuro() {
        return this.mercadoOpcoesOuro;
    }

    public Valor getMercadoOpcoesOutros() {
        return this.mercadoOpcoesOutros;
    }

    public Valor getMercadoVistaAcoes() {
        return this.mercadoVistaAcoes;
    }

    public Valor getMercadoVistaForaBolsa() {
        return this.mercadoVistaForaBolsa;
    }

    public Valor getMercadoVistaOuro() {
        return this.mercadoVistaOuro;
    }

    public Valor getResultadoLiquidoMes() {
        return this.resultadoLiquidoMes;
    }

    public ai getResultadoNegativoMesAnterior() {
        return this.resultadoNegativoMesAnterior;
    }

    protected List<Informacao> recuperarListaCamposPendencia() {
        List list = this.recuperarCamposInformacao();
        return list;
    }

    public boolean isVazio() {
        boolean bl2 = this.mercadoVistaAcoes.isVazio();
        bl2 = bl2 && this.mercadoVistaOuro.isVazio();
        bl2 = bl2 && this.mercadoVistaForaBolsa.isVazio();
        bl2 = bl2 && this.mercadoOpcoesAcoes.isVazio();
        bl2 = bl2 && this.mercadoOpcoesOuro.isVazio();
        bl2 = bl2 && this.mercadoOpcoesForaDeBolsa.isVazio();
        bl2 = bl2 && this.mercadoOpcoesOutros.isVazio();
        bl2 = bl2 && this.mercadoFuturoDolar.isVazio();
        bl2 = bl2 && this.mercadoFuturoIndices.isVazio();
        bl2 = bl2 && this.mercadoFuturoJuros.isVazio();
        bl2 = bl2 && this.mercadoFuturoOutros.isVazio();
        bl2 = bl2 && this.mercadoTermoAcoes.isVazio();
        bl2 = bl2 && this.mercadoTermoOutros.isVazio();
        return bl2;
    }

    public void clear() {
        this.mercadoVistaAcoes.clear();
        this.mercadoVistaOuro.clear();
        this.mercadoVistaForaBolsa.clear();
        this.mercadoOpcoesAcoes.clear();
        this.mercadoOpcoesOuro.clear();
        this.mercadoOpcoesForaDeBolsa.clear();
        this.mercadoOpcoesOutros.clear();
        this.mercadoFuturoDolar.clear();
        this.mercadoFuturoIndices.clear();
        this.mercadoFuturoJuros.clear();
        this.mercadoFuturoOutros.clear();
        this.mercadoTermoAcoes.clear();
        this.mercadoTermoOutros.clear();
    }

    public String getClasseFicha() {
        return PainelDadosRendaVariavelOpComunsDayTrade.class.getName();
    }

    public String getNomeAba() {
        return null;
    }

    public String getTituloFichaDashboard() {
        return null;
    }
}

