/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.rendpf;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.rendpf.CPFDependente;
import serpro.ppgd.irpf.rendpf.ColecaoCPFDependentes;
import serpro.ppgd.irpf.rendpf.ContasAno;
import serpro.ppgd.irpf.rendpf.ItemRendPFDependente;
import serpro.ppgd.irpf.rendpf.a;
import serpro.ppgd.negocio.CPF;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Pendencia;
import serpro.ppgd.negocio.ValidadorIf;
import serpro.ppgd.negocio.Valor;
import serpro.ppgd.negocio.util.FabricaUtilitarios;

public class ColecaoRendPFDependente
extends Colecao<ItemRendPFDependente> {
    private WeakReference<DeclaracaoIRPF> refDeclaracao;
    private Valor totalPessoaFisica = new Valor((ObjetoNegocio)this, "Total Pessoa F\u00edsica");
    private Valor totalAlugueis = new Valor((ObjetoNegocio)this, "Total Alugueis");
    private Valor totalOutros = new Valor((ObjetoNegocio)this, "Total Outros");
    private Valor totalExterior = new Valor((ObjetoNegocio)this, "Total Exterior");
    private Valor totalPrevidencia = new Valor((ObjetoNegocio)this, "Total Previd\u00eancia");
    private Valor totalDependentes = new Valor((ObjetoNegocio)this, "Total Dependentes");
    private Valor totalPensao = new Valor((ObjetoNegocio)this, "Total Pens\u00e3o");
    private Valor totalLivroCaixa = new Valor((ObjetoNegocio)this, "Total Livro Caixa");
    private Valor totalImpostoPagoExteriorCompensar = new Valor((ObjetoNegocio)this, "Total Imposto Pago no Exterior a Compensar");
    private Valor totalDarfPago = new Valor((ObjetoNegocio)this, "Total DARF");

    public ColecaoRendPFDependente(DeclaracaoIRPF declaracaoIRPF) {
        this.refDeclaracao = new WeakReference<DeclaracaoIRPF>(declaracaoIRPF);
        this.setFicha("Rendimentos Tribut\u00e1veis Recebidos de PF e do Exterior - Dependentes");
    }

    public void objetoInserido(ItemRendPFDependente itemRendPFDependente) {
        itemRendPFDependente.addValidador((DeclaracaoIRPF)((Object)this.refDeclaracao.get()));
        itemRendPFDependente.getRendimentos().getNITPISPASEP().addValidador((ValidadorIf)new a(this, 3, itemRendPFDependente));
        itemRendPFDependente.aplicaNomeFicha();
    }

    public Boolean existeContribuicaoPrevidenciariaPorDependente(CPF cPF) {
        Boolean bl2 = false;
        for (ItemRendPFDependente itemRendPFDependente : this.itens()) {
            if (!itemRendPFDependente.getCpf().naoFormatado().equals(cPF.naoFormatado()) || !itemRendPFDependente.getRendimentos().existeContribuicaoPrevidenciaria()) continue;
            bl2 = true;
            break;
        }
        return bl2;
    }

    public Valor getTotalDarfPago() {
        return this.totalDarfPago;
    }

    public Valor getTotalDependentes() {
        return this.totalDependentes;
    }

    public Valor getTotalExterior() {
        return this.totalExterior;
    }

    public Valor getTotalLivroCaixa() {
        return this.totalLivroCaixa;
    }

    public Valor getTotalPensao() {
        return this.totalPensao;
    }

    public Valor getTotalPrevidencia() {
        return this.totalPrevidencia;
    }

    public Valor getTotalPessoaFisica() {
        return this.totalPessoaFisica;
    }

    public boolean todosCpfsPreenchidos() {
        boolean bl2 = true;
        Iterator iterator = this.itens().iterator();
        while (iterator.hasNext() && bl2) {
            ItemRendPFDependente itemRendPFDependente = (ItemRendPFDependente)((Object)iterator.next());
            boolean bl3 = bl2 = bl2 && !itemRendPFDependente.getCpf().isVazio();
        }
        return bl2;
    }

    public ColecaoCPFDependentes getCpfDependentes() {
        ColecaoCPFDependentes colecaoCPFDependentes = new ColecaoCPFDependentes();
        for (ItemRendPFDependente itemRendPFDependente : this.itens()) {
            CPFDependente cPFDependente = new CPFDependente();
            cPFDependente.getCpf().setConteudo(itemRendPFDependente.getCpf().naoFormatado());
            colecaoCPFDependentes.itens().add(cPFDependente);
        }
        return colecaoCPFDependentes;
    }

    public boolean possuiMaisDeUmDependenteComCPF(String string) {
        int n2 = 0;
        if ("".equals(string.trim())) {
            return false;
        }
        for (ItemRendPFDependente itemRendPFDependente : this.itens()) {
            if (!string.equals(itemRendPFDependente.getCpf().naoFormatado())) continue;
            ++n2;
        }
        return n2 > 1;
    }

    public boolean possuiDependenteComCPF(String string) {
        if ("".equals(string.trim())) {
            return false;
        }
        for (ItemRendPFDependente itemRendPFDependente : this.itens()) {
            if (!string.equals(itemRendPFDependente.getCpf().naoFormatado())) continue;
            return true;
        }
        return false;
    }

    public void excluirDependentesComCPF(String string) {
        Iterator iterator = this.itens().iterator();
        while (iterator.hasNext()) {
            ItemRendPFDependente itemRendPFDependente = (ItemRendPFDependente)((Object)iterator.next());
            if (!string.equals(itemRendPFDependente.getCpf().naoFormatado())) continue;
            iterator.remove();
        }
    }

    public Valor obterRendimentosRecebidosPorDependente(CPF cPF) {
        Valor valor = new Valor();
        for (ItemRendPFDependente itemRendPFDependente : this.itens()) {
            if (!itemRendPFDependente.getCpf().naoFormatado().equals(cPF.naoFormatado())) continue;
            valor.append('+', itemRendPFDependente.getRendimentos().getTotalPessoaFisica());
            valor.append('+', itemRendPFDependente.getRendimentos().getTotalExterior());
            valor.append('+', itemRendPFDependente.getRendimentos().getTotalAlugueis());
            valor.append('+', itemRendPFDependente.getRendimentos().getTotalOutros());
        }
        return valor;
    }

    public ContasAno obterContasAnoPorCPF(String string) {
        ContasAno contasAno = null;
        for (ItemRendPFDependente itemRendPFDependente : this.itens()) {
            if (!itemRendPFDependente.getCpf().naoFormatado().equals(string)) continue;
            contasAno = itemRendPFDependente.getRendimentos().getContasAno();
            break;
        }
        return contasAno;
    }

    public ItemRendPFDependente obterItemRendPFDependentePorCPF(String string) {
        ItemRendPFDependente itemRendPFDependente = null;
        for (ItemRendPFDependente itemRendPFDependente2 : this.itens()) {
            if (!itemRendPFDependente2.getCpf().naoFormatado().equals(string)) continue;
            itemRendPFDependente = itemRendPFDependente2;
            break;
        }
        return itemRendPFDependente;
    }

    public Valor getTotalAlugueis() {
        return this.totalAlugueis;
    }

    public Valor getTotalOutros() {
        return this.totalOutros;
    }

    public Valor getTotalImpostoPagoExteriorCompensar() {
        return this.totalImpostoPagoExteriorCompensar;
    }

    private List<Pendencia> getListaPendencias() {
        ArrayList<Pendencia> arrayList = new ArrayList<Pendencia>();
        for (Object object2 : this.itens()) {
            for (Object object2 : object2.getRendimentos().getContasAno().getColecaoEscrituracao().itens()) {
                arrayList.addAll(FabricaUtilitarios.verificarPendencias((Object)object2));
            }
        }
        return arrayList;
    }

    public List<Pendencia> verificarPendencias(int n2) {
        List list = super.verificarPendencias(n2);
        list.addAll(this.getListaPendencias());
        return list;
    }
}

