/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.rendpf;

import classes.dL;
import java.util.ArrayList;
import java.util.List;
import serpro.ppgd.irpf.gui.rendpf.PainelDadosEscrituracao;
import serpro.ppgd.irpf.rendpf.b;
import serpro.ppgd.irpf.rendpf.c;
import serpro.ppgd.irpf.rendpf.d;
import serpro.ppgd.irpf.rendpf.e;
import serpro.ppgd.irpf.rendpf.f;
import serpro.ppgd.irpf.rendpf.g;
import serpro.ppgd.irpf.rendpf.h;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.CPF;
import serpro.ppgd.negocio.Logico;
import serpro.ppgd.negocio.ObjetoFicha;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.ValidadorIf;
import serpro.ppgd.negocio.Valor;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorCPF;

public class Conta
extends ObjetoNegocio
implements ObjetoFicha {
    public static String TITULO_FICHA_TITULAR = "Rendimentos Tribut\u00e1veis Recebidos de PF e do Exterior - Titular";
    public static String TITULO_FICHA_DEPENDENTES = "Rendimentos Tribut\u00e1veis Recebidos de PF e do Exterior - Dependentes";
    private Alfa dataMesAno = new Alfa((ObjetoNegocio)this, "dataMesAno", 6);
    private Valor valor = new Valor((ObjetoNegocio)this, "ValorR$");
    private Alfa nomeMes = new Alfa((ObjetoNegocio)this, "Nome do Mes");
    private CPF cpfTitularPagamento = new CPF((ObjetoNegocio)this, "Titular do Pagamento");
    private Alfa indTitularEhBeneficiario = new Alfa((ObjetoNegocio)this, "Titular \u00e9 benefici\u00e1rio");
    private CPF cpfBeneficiarioServico = new CPF((ObjetoNegocio)this, "Benefici\u00e1rio do Servi\u00e7o");
    private Alfa indBeneficiarioNaoPossuiCPF = new Alfa((ObjetoNegocio)this, "Benefici\u00e1rio n\u00e3o possui CPF");
    private CPF cpfContribuinte = new CPF((ObjetoNegocio)this, "CPF do Contribuinte");
    private transient CPF cpfDeclaranteIRPF = new CPF((ObjetoNegocio)this, "CPF do Declarante do IRPF");

    public Conta() {
        this.indTitularEhBeneficiario.setConteudo(Logico.NAO);
        this.indBeneficiarioNaoPossuiCPF.setConteudo(Logico.NAO);
        this.valor.addValidador((ValidadorIf)new b(this, 3));
        this.cpfTitularPagamento.addValidador((ValidadorIf)new ValidadorCPF(3));
        this.cpfTitularPagamento.addValidador((ValidadorIf)new c(this, 3));
        this.cpfTitularPagamento.addValidador((ValidadorIf)new d(this, 3, dL.a("msg_validador_nao_nulo", new String[]{this.getCpfTitularPagamento().getNomeCampo()})));
        this.cpfBeneficiarioServico.addValidador((ValidadorIf)new ValidadorCPF(3));
        this.cpfBeneficiarioServico.addValidador((ValidadorIf)new e(this, 3));
        this.cpfBeneficiarioServico.addValidador((ValidadorIf)new f(this, 3, dL.a("msg_validador_nao_nulo", new String[]{this.getCpfBeneficiarioServico().getNomeCampo()})));
        this.cpfTitularPagamento.addObservador((Observador)new g(this));
        this.dataMesAno.addObservador((Observador)new h(this));
    }

    public List recuperarListaCamposPendencia() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(this.getCpfTitularPagamento());
        arrayList.add(this.getCpfBeneficiarioServico());
        arrayList.add(this.getValor());
        return arrayList;
    }

    public Conta obterCopia() {
        Conta conta = new Conta();
        conta.getCpfContribuinte().setConteudo(this.getCpfContribuinte());
        conta.getCpfBeneficiarioServico().setConteudo(this.getCpfBeneficiarioServico());
        conta.getCpfTitularPagamento().setConteudo(this.getCpfTitularPagamento());
        conta.getIndBeneficiarioNaoPossuiCPF().setConteudo(this.getIndBeneficiarioNaoPossuiCPF());
        conta.getIndTitularEhBeneficiario().setConteudo(this.getIndTitularEhBeneficiario());
        conta.getNomeMes().setConteudo(this.getNomeMes());
        conta.getDataMesAno().setConteudo(this.getDataMesAno());
        conta.getValor().setConteudo(this.getValor());
        return conta;
    }

    public Alfa getDataMesAno() {
        return this.dataMesAno;
    }

    public Valor getValor() {
        return this.valor;
    }

    public int compareTo(Object object) {
        object = (Conta)((Object)object);
        if (this.getCpfTitularPagamento().isVazio() && ((Conta)((Object)object)).getCpfTitularPagamento().isVazio()) {
            return 0;
        }
        if (((Conta)((Object)object)).getCpfTitularPagamento().isVazio()) {
            return -1;
        }
        if (this.getCpfTitularPagamento().isVazio()) {
            return 1;
        }
        return ((Conta)((Object)object)).getCpfTitularPagamento().naoFormatado().compareTo(this.getCpfTitularPagamento().naoFormatado());
    }

    public boolean isVazio() {
        return this.getCpfTitularPagamento().isVazio() && this.getValor().isVazio();
    }

    public boolean isEmpty() {
        return this.valor.isVazio() && this.cpfTitularPagamento.isVazio() && this.cpfBeneficiarioServico.isVazio() && this.valor.isVazio();
    }

    public String getClasseFicha() {
        return PainelDadosEscrituracao.class.getName();
    }

    public String getNomeAba() {
        return this.getFicha();
    }

    public Alfa getNomeMes() {
        return this.nomeMes;
    }

    public Alfa converteNomeMesABC() {
        String string = "";
        Alfa alfa = new Alfa();
        switch (this.nomeMes.naoFormatado()) {
            case "1": {
                string = "A";
                break;
            }
            case "2": {
                string = "B";
                break;
            }
            case "3": {
                string = "C";
                break;
            }
            case "4": {
                string = "D";
                break;
            }
            case "5": {
                string = "E";
                break;
            }
            case "6": {
                string = "F";
                break;
            }
            case "7": {
                string = "G";
                break;
            }
            case "8": {
                string = "H";
                break;
            }
            case "9": {
                string = "I";
                break;
            }
            case "10": {
                string = "J";
                break;
            }
            case "11": {
                string = "K";
                break;
            }
            case "12": {
                string = "L";
            }
        }
        alfa.setConteudo(string);
        return alfa;
    }

    public CPF getCpfTitularPagamento() {
        return this.cpfTitularPagamento;
    }

    public Alfa getIndTitularEhBeneficiario() {
        return this.indTitularEhBeneficiario;
    }

    public CPF getCpfBeneficiarioServico() {
        return this.cpfBeneficiarioServico;
    }

    public Alfa getIndBeneficiarioNaoPossuiCPF() {
        return this.indBeneficiarioNaoPossuiCPF;
    }

    public String getNomeMesExtenso(int n2) {
        String string = "";
        switch (Integer.valueOf(n2)) {
            case 1: {
                string = "Janeiro";
                break;
            }
            case 2: {
                string = "Fevereiro";
                break;
            }
            case 3: {
                string = "Mar\u00e7o";
                break;
            }
            case 4: {
                string = "Abril";
                break;
            }
            case 5: {
                string = "Maio";
                break;
            }
            case 6: {
                string = "Junho";
                break;
            }
            case 7: {
                string = "Julho";
                break;
            }
            case 8: {
                string = "Agosto";
                break;
            }
            case 9: {
                string = "Setembro";
                break;
            }
            case 10: {
                string = "Outubro";
                break;
            }
            case 11: {
                string = "Novembro";
                break;
            }
            case 12: {
                string = "Dezembro";
            }
        }
        return string;
    }

    public CPF getCpfContribuinte() {
        return this.cpfContribuinte;
    }

    public String getTituloFichaDashboard() {
        if (this.getFicha().indexOf("Titular") >= 0) {
            return "Rendimentos Tribut\u00e1veis Recebidos de PF e do Exterior - Titular";
        }
        return "Rendimentos Tribut\u00e1veis Recebidos de PF e do Exterior - Dependente";
    }

    public CPF getCpfDeclaranteIRPF() {
        return this.cpfDeclaranteIRPF;
    }

    static /* synthetic */ Valor a(Conta conta) {
        return conta.valor;
    }

    static /* synthetic */ CPF b(Conta conta) {
        return conta.cpfDeclaranteIRPF;
    }

    static /* synthetic */ CPF c(Conta conta) {
        return conta.cpfTitularPagamento;
    }

    static /* synthetic */ Alfa d(Conta conta) {
        return conta.indBeneficiarioNaoPossuiCPF;
    }

    static /* synthetic */ Alfa e(Conta conta) {
        return conta.nomeMes;
    }
}

