/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.rendpf;

import java.util.Iterator;
import serpro.ppgd.irpf.IRPFFacade;
import serpro.ppgd.irpf.rendpf.Conta;
import serpro.ppgd.irpf.rendpf.i;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.Valor;

public class ContasMes
extends Colecao<Conta> {
    public static final String NOME_ABA_JANEIRO = "JAN";
    public static final String NOME_ABA_FEVEREIRO = "FEV";
    public static final String NOME_ABA_MARCO = "MAR";
    public static final String NOME_ABA_ABRIL = "ABR";
    public static final String NOME_ABA_MAIO = "MAI";
    public static final String NOME_ABA_JUNHO = "JUN";
    public static final String NOME_ABA_JULHO = "JUL";
    public static final String NOME_ABA_AGOSTO = "AGO";
    public static final String NOME_ABA_SETEMBRO = "SET";
    public static final String NOME_ABA_OUTUBRO = "OUT";
    public static final String NOME_ABA_NOVEMBRO = "NOV";
    public static final String NOME_ABA_DEZEMBRO = "DEZ";
    private int numMes = 0;
    private Alfa nomeMes = new Alfa((ObjetoNegocio)this, "");
    private Valor totalRendTrabNaoAssPF = new Valor((ObjetoNegocio)this, "C1");

    public ContasMes() {
        this.setFicha("Rendimentos Tribut\u00e1veis Recebidos de PF e do Exterior - Titular");
    }

    public Alfa getNomeMes() {
        return this.nomeMes;
    }

    public Valor getTotalRendTrabNaoAssPF() {
        return this.totalRendTrabNaoAssPF;
    }

    public int getNumMes() {
        return this.numMes;
    }

    public void setNumMes(int n2) {
        this.numMes = n2;
        this.nomeMes.setConteudo(String.valueOf(n2));
    }

    public String getNumMesAsString() {
        String string = String.valueOf(this.numMes);
        if (this.numMes < 10) {
            string = "0" + string;
        }
        return string;
    }

    public static String obterNomeMesExtenso(String string) {
        string = string.equals(NOME_ABA_JANEIRO) ? "janeiro" : (string.equals(NOME_ABA_FEVEREIRO) ? "fevereiro" : (string.equals(NOME_ABA_MARCO) ? "mar\u00e7o" : (string.equals(NOME_ABA_ABRIL) ? "abril" : (string.equals(NOME_ABA_MAIO) ? "maio" : (string.equals(NOME_ABA_JUNHO) ? "junho" : (string.equals(NOME_ABA_JULHO) ? "julho" : (string.equals(NOME_ABA_AGOSTO) ? "agosto" : (string.equals(NOME_ABA_SETEMBRO) ? "setembro" : (string.equals(NOME_ABA_OUTUBRO) ? "outubro" : (string.equals(NOME_ABA_NOVEMBRO) ? "novembro" : (string.equals(NOME_ABA_DEZEMBRO) ? "dezembro" : "***")))))))))));
        return string;
    }

    public static String obterNomeMesExtenso(int n2) {
        String string = n2 == 1 ? "janeiro" : (n2 == 2 ? "fevereiro" : (n2 == 3 ? "mar\u00e7o" : (n2 == 4 ? "abril" : (n2 == 5 ? "maio" : (n2 == 6 ? "junho" : (n2 == 7 ? "julho" : (n2 == 8 ? "agosto" : (n2 == 9 ? "setembro" : (n2 == 10 ? "outubro" : (n2 == 11 ? "novembro" : (n2 == 12 ? "dezembro" : "***")))))))))));
        return string;
    }

    public static String obterSiglaMes(int n2) {
        String string = n2 == 1 ? NOME_ABA_JANEIRO : (n2 == 2 ? NOME_ABA_FEVEREIRO : (n2 == 3 ? NOME_ABA_MARCO : (n2 == 4 ? NOME_ABA_ABRIL : (n2 == 5 ? NOME_ABA_MAIO : (n2 == 6 ? NOME_ABA_JUNHO : (n2 == 7 ? NOME_ABA_JULHO : (n2 == 8 ? NOME_ABA_AGOSTO : (n2 == 9 ? NOME_ABA_SETEMBRO : (n2 == 10 ? NOME_ABA_OUTUBRO : (n2 == 11 ? NOME_ABA_NOVEMBRO : (n2 == 12 ? NOME_ABA_DEZEMBRO : "***")))))))))));
        return string;
    }

    public static String obterIndiceAsString(String string) {
        String string2 = "";
        if (string.equals(NOME_ABA_JANEIRO)) {
            string2 = "01";
        } else if (string.equals(NOME_ABA_FEVEREIRO)) {
            string2 = "02";
        } else if (string.equals(NOME_ABA_MARCO)) {
            string2 = "03";
        } else if (string.equals(NOME_ABA_ABRIL)) {
            string2 = "04";
        } else if (string.equals(NOME_ABA_MAIO)) {
            string2 = "05";
        } else if (string.equals(NOME_ABA_JUNHO)) {
            string2 = "06";
        } else if (string.equals(NOME_ABA_JULHO)) {
            string2 = "07";
        } else if (string.equals(NOME_ABA_AGOSTO)) {
            string2 = "08";
        } else if (string.equals(NOME_ABA_SETEMBRO)) {
            string2 = "09";
        } else if (string.equals(NOME_ABA_OUTUBRO)) {
            string2 = "10";
        } else if (string.equals(NOME_ABA_NOVEMBRO)) {
            string2 = "11";
        } else if (string.equals(NOME_ABA_DEZEMBRO)) {
            string2 = "12";
        }
        return string2;
    }

    public void removerContasEmBranco() {
        Iterator iterator = this.itens().iterator();
        while (iterator.hasNext()) {
            Conta conta = (Conta)((Object)iterator.next());
            if (!conta.isEmpty()) continue;
            iterator.remove();
        }
    }

    public Valor getSomaTrabalhoNaoAssalariadoMes() {
        Valor valor = new Valor("0,00");
        for (Conta conta : this.itens()) {
            valor.append('+', conta.getValor());
        }
        return valor;
    }

    public void objetoRemovido(Object object) {
        super.objetoRemovido(object);
        this.totalRendTrabNaoAssPF.setConteudo(this.getSomaTrabalhoNaoAssalariadoMes());
    }

    public void objetoInserido(Conta conta) {
        super.objetoInserido((ObjetoNegocio)conta);
        try {
            String string = null;
            if (IRPFFacade.getInstancia().getIdDeclaracaoAberto() != null) {
                string = IRPFFacade.getInstancia().getIdDeclaracaoAberto().getCpf().naoFormatado();
            } else if (IRPFFacade.getInstancia().getDeclaracaoEmGravacao() != null) {
                string = IRPFFacade.getInstancia().getDeclaracaoEmGravacao().getIdentificadorDeclaracao().getCpf().naoFormatado();
            }
            if (string != null) {
                if (conta.getCpfContribuinte().naoFormatado().equals(string)) {
                    conta.setFicha(Conta.TITULO_FICHA_TITULAR);
                } else {
                    conta.setFicha(Conta.TITULO_FICHA_DEPENDENTES);
                }
            }
        }
        catch (Exception exception) {}
        this.totalRendTrabNaoAssPF.setConteudo(this.getSomaTrabalhoNaoAssalariadoMes());
        conta.getValor().addObservador((Observador)new i(this));
    }

    static /* synthetic */ Valor a(ContasMes contasMes) {
        return contasMes.totalRendTrabNaoAssPF;
    }
}

