/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.rendpf;

import classes.dL;
import java.util.ArrayList;
import java.util.List;
import serpro.ppgd.irpf.gui.rendpf.PainelDadosEscrituracao;
import serpro.ppgd.irpf.gui.rendpf.PainelDadosEscrituracaoDependente;
import serpro.ppgd.irpf.gui.rendpf.PainelDadosEscrituracaoTitular;
import serpro.ppgd.irpf.rendpf.ContasAno;
import serpro.ppgd.irpf.rendpf.MesRendPF;
import serpro.ppgd.irpf.rendpf.p;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.ObjetoFicha;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.ValidadorIf;
import serpro.ppgd.negocio.Valor;

public class RendPF
extends ObjetoNegocio
implements ObjetoFicha {
    public static final String FICHA_TIT = "Rendimentos Tribut\u00e1veis Recebidos de PF e do Exterior - Titular";
    public static final String FICHA_DEP = "Rendimentos Tribut\u00e1veis Recebidos de PF e do Exterior - Dependentes";
    public static final String NOME_TOTAL_PF = "Total Pessoa F\u00edsica";
    public static final String NOME_TOTAL_ALUGUEIS = "Total Alugueis";
    public static final String NOME_TOTAL_OUTROS = "Total Outros";
    public static final String NOME_TOTAL_EXTERIOR = "Total Exterior";
    public static final String NOME_TOTAL_PREVIDENCIA = "Total Previd\u00eancia";
    public static final String NOME_TOTAL_DEPENDENTES = "Total Dependentes";
    public static final String NOME_TOTAL_PENSAO = "Total Pens\u00e3o";
    public static final String NOME_TOTAL_IMPOSTO_PAGO_COMPENSAR_EXTEIOR = "Total Imposto Pago no Exterior a Compensar";
    public static final String NOME_TOTAL_LIVROCAIXA = "Total Livro Caixa";
    public static final String NOME_TOTAL_DARF = "Total DARF";
    private MesRendPF janeiro;
    private MesRendPF fevereiro;
    private MesRendPF marco;
    private MesRendPF abril;
    private MesRendPF maio;
    private MesRendPF junho;
    private MesRendPF julho;
    private MesRendPF agosto;
    private MesRendPF setembro;
    private MesRendPF outubro;
    private MesRendPF novembro;
    private MesRendPF dezembro;
    protected MesRendPF[] meses;
    private Valor totalPessoaFisica = new Valor((ObjetoNegocio)this, "Total Pessoa F\u00edsica");
    private Valor totalAlugueis = new Valor((ObjetoNegocio)this, "Total Alugueis");
    private Valor totalOutros = new Valor((ObjetoNegocio)this, "Total Outros");
    private Valor totalExterior = new Valor((ObjetoNegocio)this, "Total Exterior");
    private Valor totalPrevidencia = new Valor((ObjetoNegocio)this, "Total Previd\u00eancia");
    private Valor totalDependentes = new Valor((ObjetoNegocio)this, "Total Dependentes");
    private Alfa totalNumDependentes = new Alfa((ObjetoNegocio)this, "");
    private Valor totalPensao = new Valor((ObjetoNegocio)this, "Total Pens\u00e3o");
    private Valor totalImpostoPagoExteriorCompensar = new Valor((ObjetoNegocio)this, "Total Imposto Pago no Exterior a Compensar");
    private Valor totalLivroCaixa = new Valor((ObjetoNegocio)this, "Total Livro Caixa");
    private Valor totalDarfPago = new Valor((ObjetoNegocio)this, "Total DARF");
    private Alfa NITPISPASEP = new Alfa((ObjetoNegocio)this, "NIT/PIS/PASEP do contribuinte");
    private ContasAno contasAno;

    public RendPF() {
        this.getNITPISPASEP().addValidador((ValidadorIf)new p(this, 3, dL.a("nit_pis_pasep_invalido")));
        this.contasAno = new ContasAno();
        this.janeiro = new MesRendPF(0, this.getContasAno().getArrayMeses()[0]);
        this.fevereiro = new MesRendPF(1, this.getContasAno().getArrayMeses()[1]);
        this.marco = new MesRendPF(2, this.getContasAno().getArrayMeses()[2]);
        this.abril = new MesRendPF(3, this.getContasAno().getArrayMeses()[3]);
        this.maio = new MesRendPF(4, this.getContasAno().getArrayMeses()[4]);
        this.junho = new MesRendPF(5, this.getContasAno().getArrayMeses()[5]);
        this.julho = new MesRendPF(6, this.getContasAno().getArrayMeses()[6]);
        this.agosto = new MesRendPF(7, this.getContasAno().getArrayMeses()[7]);
        this.setembro = new MesRendPF(8, this.getContasAno().getArrayMeses()[8]);
        this.outubro = new MesRendPF(9, this.getContasAno().getArrayMeses()[9]);
        this.novembro = new MesRendPF(10, this.getContasAno().getArrayMeses()[10]);
        this.dezembro = new MesRendPF(11, this.getContasAno().getArrayMeses()[11]);
        this.meses = new MesRendPF[]{this.janeiro, this.fevereiro, this.marco, this.abril, this.maio, this.junho, this.julho, this.agosto, this.setembro, this.outubro, this.novembro, this.dezembro};
        this.aplicaNomeFicha();
    }

    public void limparTrabalhoNaoAssalariadoSemLancamento() {
        int n2 = 0;
        while (n2 < 12) {
            if (this.contasAno.getArrayMeses()[n2].itens().size() == 0) {
                this.meses[n2].getPessoaFisica().clear();
            }
            ++n2;
        }
    }

    public List recuperarListaCamposPendencia() {
        ArrayList<Alfa> arrayList = new ArrayList<Alfa>();
        arrayList.add(this.getNITPISPASEP());
        return arrayList;
    }

    public void aplicaNomeFicha() {
        this.setFicha(FICHA_TIT);
        int n2 = 0;
        while (n2 < 12) {
            this.meses[n2].setFicha(FICHA_TIT);
            ++n2;
        }
    }

    public MesRendPF getMesRendPFPorIndice(int n2) {
        if (n2 == 0) {
            return this.janeiro;
        }
        if (n2 == 1) {
            return this.fevereiro;
        }
        if (n2 == 2) {
            return this.marco;
        }
        if (n2 == 3) {
            return this.abril;
        }
        if (n2 == 4) {
            return this.maio;
        }
        if (n2 == 5) {
            return this.junho;
        }
        if (n2 == 6) {
            return this.julho;
        }
        if (n2 == 7) {
            return this.agosto;
        }
        if (n2 == 8) {
            return this.setembro;
        }
        if (n2 == 9) {
            return this.outubro;
        }
        if (n2 == 10) {
            return this.novembro;
        }
        if (n2 == 11) {
            return this.dezembro;
        }
        return null;
    }

    public int obterMesFormatoNumerico(MesRendPF mesRendPF) {
        if (((Object)((Object)mesRendPF)).equals((Object)this.janeiro)) {
            return 0;
        }
        if (((Object)((Object)mesRendPF)).equals((Object)this.fevereiro)) {
            return 1;
        }
        if (((Object)((Object)mesRendPF)).equals((Object)this.marco)) {
            return 2;
        }
        if (((Object)((Object)mesRendPF)).equals((Object)this.abril)) {
            return 3;
        }
        if (((Object)((Object)mesRendPF)).equals((Object)this.maio)) {
            return 4;
        }
        if (((Object)((Object)mesRendPF)).equals((Object)this.junho)) {
            return 5;
        }
        if (((Object)((Object)mesRendPF)).equals((Object)this.julho)) {
            return 6;
        }
        if (((Object)((Object)mesRendPF)).equals((Object)this.agosto)) {
            return 7;
        }
        if (((Object)((Object)mesRendPF)).equals((Object)this.setembro)) {
            return 8;
        }
        if (((Object)((Object)mesRendPF)).equals((Object)this.outubro)) {
            return 9;
        }
        if (((Object)((Object)mesRendPF)).equals((Object)this.novembro)) {
            return 10;
        }
        if (((Object)((Object)mesRendPF)).equals((Object)this.dezembro)) {
            return 11;
        }
        return 0;
    }

    public boolean existeContribuicaoPrevidenciaria() {
        boolean bl2 = false;
        int n2 = 0;
        while (n2 < 12) {
            if (!this.getMesRendPFPorIndice(n2).getPrevidencia().isVazio()) {
                bl2 = true;
                break;
            }
            ++n2;
        }
        return bl2;
    }

    public void addObservador(Observador observador) {
        this.janeiro.addObservador(observador);
        this.fevereiro.addObservador(observador);
        this.marco.addObservador(observador);
        this.abril.addObservador(observador);
        this.maio.addObservador(observador);
        this.junho.addObservador(observador);
        this.julho.addObservador(observador);
        this.agosto.addObservador(observador);
        this.setembro.addObservador(observador);
        this.outubro.addObservador(observador);
        this.novembro.addObservador(observador);
        this.dezembro.addObservador(observador);
    }

    public void removeObservador(Observador observador) {
        this.janeiro.removeObservador(observador);
        this.fevereiro.removeObservador(observador);
        this.marco.removeObservador(observador);
        this.abril.removeObservador(observador);
        this.maio.removeObservador(observador);
        this.junho.removeObservador(observador);
        this.julho.removeObservador(observador);
        this.agosto.removeObservador(observador);
        this.setembro.removeObservador(observador);
        this.outubro.removeObservador(observador);
        this.novembro.removeObservador(observador);
        this.dezembro.removeObservador(observador);
    }

    public MesRendPF getAbril() {
        return this.abril;
    }

    public MesRendPF getAgosto() {
        return this.agosto;
    }

    public MesRendPF getDezembro() {
        return this.dezembro;
    }

    public MesRendPF getFevereiro() {
        return this.fevereiro;
    }

    public MesRendPF getJaneiro() {
        return this.janeiro;
    }

    public MesRendPF getJulho() {
        return this.julho;
    }

    public MesRendPF getJunho() {
        return this.junho;
    }

    public MesRendPF getMaio() {
        return this.maio;
    }

    public MesRendPF getMarco() {
        return this.marco;
    }

    public MesRendPF getNovembro() {
        return this.novembro;
    }

    public MesRendPF getOutubro() {
        return this.outubro;
    }

    public MesRendPF getSetembro() {
        return this.setembro;
    }

    public Valor getTotalDarfPago() {
        return this.totalDarfPago;
    }

    public Valor getTotalDependentes() {
        return this.totalDependentes;
    }

    public Valor getTotalExterior() {
        return this.totalExterior;
    }

    public Valor getTotalLivroCaixa() {
        return this.totalLivroCaixa;
    }

    public Valor getTotalPensao() {
        return this.totalPensao;
    }

    public Valor getTotalPessoaFisica() {
        return this.totalPessoaFisica;
    }

    public Valor getTotalPrevidencia() {
        return this.totalPrevidencia;
    }

    public Alfa getNITPISPASEP() {
        return this.NITPISPASEP;
    }

    public ContasAno getContasAno() {
        return this.contasAno;
    }

    public boolean isVazio() {
        return this.janeiro.isVazio() && this.fevereiro.isVazio() && this.marco.isVazio() && this.abril.isVazio() && this.maio.isVazio() && this.junho.isVazio() && this.julho.isVazio() && this.agosto.isVazio() && this.setembro.isVazio() && this.outubro.isVazio() && this.novembro.isVazio() && this.dezembro.isVazio() && this.contasAno.isVazio() && this.NITPISPASEP.isVazio();
    }

    public void clear() {
        super.clear();
        this.janeiro.clear();
        this.fevereiro.clear();
        this.marco.clear();
        this.abril.clear();
        this.maio.clear();
        this.junho.clear();
        this.julho.clear();
        this.agosto.clear();
        this.setembro.clear();
        this.outubro.clear();
        this.novembro.clear();
        this.dezembro.clear();
    }

    public String getClasseFicha() {
        return PainelDadosEscrituracao.class.getName();
    }

    public String getNomeAba() {
        if (this.getFicha().equals(FICHA_TIT)) {
            return PainelDadosEscrituracaoTitular.a;
        }
        return PainelDadosEscrituracaoDependente.a;
    }

    public Valor getTotalAlugueis() {
        return this.totalAlugueis;
    }

    public Valor getTotalOutros() {
        return this.totalOutros;
    }

    public Valor getTotalImpostoPagoExteriorCompensar() {
        return this.totalImpostoPagoExteriorCompensar;
    }

    public String getTituloFichaDashboard() {
        return "Rendimentos Tribut\u00e1veis Recebidos de PF e do Exterior";
    }

    public Alfa getTotalNumDependentes() {
        return this.totalNumDependentes;
    }
}

