/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.rendpj;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.rendpj.ColecaoRendPJTitular;
import serpro.ppgd.irpf.rendpj.RendPJDependente;
import serpro.ppgd.irpf.rendpj.RendPJTitular;
import serpro.ppgd.negocio.CPF;
import serpro.ppgd.negocio.Logico;
import serpro.ppgd.negocio.NI;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Valor;

public class ColecaoRendPJDependente
extends ColecaoRendPJTitular {
    private WeakReference<DeclaracaoIRPF> declaracaoRef = null;

    public ColecaoRendPJDependente(DeclaracaoIRPF declaracaoIRPF) {
        super(declaracaoIRPF.getIdentificadorDeclaracao());
        this.declaracaoRef = new WeakReference<DeclaracaoIRPF>(declaracaoIRPF);
        this.setFicha("Rendimentos Tribut\u00e1veis Recebidos de PJ pelos Dependentes");
    }

    @Override
    public RendPJDependente instanciaNovoObjeto() {
        DeclaracaoIRPF declaracaoIRPF = (DeclaracaoIRPF)((Object)this.declaracaoRef.get());
        return new RendPJDependente(declaracaoIRPF);
    }

    public RendPJDependente obterRendimentoPorChave(String string, String string2) {
        for (RendPJTitular rendPJTitular : this.itens()) {
            if (!(rendPJTitular = (RendPJDependente)rendPJTitular).getNIFontePagadora().naoFormatado().equals(string) || !((RendPJDependente)rendPJTitular).getCpfDependente().naoFormatado().equals(string2)) continue;
            return rendPJTitular;
        }
        return null;
    }

    public boolean possuiDependenteComCPF(String string) {
        if ("".equals(string.trim())) {
            return false;
        }
        for (RendPJDependente rendPJDependente : this.itens()) {
            if (!rendPJDependente.getCpfDependente().naoFormatado().equals(string)) continue;
            return true;
        }
        return false;
    }

    public void excluirDependentesComCPF(String string) {
        Iterator iterator = this.itens().iterator();
        while (iterator.hasNext()) {
            RendPJDependente rendPJDependente = (RendPJDependente)((Object)iterator.next());
            if (!rendPJDependente.getCpfDependente().naoFormatado().equals(string)) continue;
            iterator.remove();
        }
    }

    public RendPJDependente getRendimentoVazioPorNIFontePagadora(CPF cPF, NI nI) {
        for (RendPJTitular rendPJTitular : this.itens()) {
            if (!((RendPJDependente)(rendPJTitular = (RendPJDependente)rendPJTitular)).getCpfDependente().naoFormatado().equals(cPF.naoFormatado()) || !rendPJTitular.getNIFontePagadora().naoFormatado().equals(nI.naoFormatado()) || !rendPJTitular.todosValoresZerados()) continue;
            return rendPJTitular;
        }
        return null;
    }

    @Override
    public boolean existeRendimentoPreenchidoComNIFontePagadora(NI nI) {
        for (RendPJTitular rendPJTitular : this.itens()) {
            if (!rendPJTitular.getNIFontePagadora().naoFormatado().equals(nI.naoFormatado()) || rendPJTitular.todosValoresZerados()) continue;
            return true;
        }
        return false;
    }

    public List<ObjetoNegocio> obterListaRendimentosDeDependentesQueSairamDoPais() {
        ArrayList<ObjetoNegocio> arrayList = new ArrayList<ObjetoNegocio>();
        for (RendPJDependente rendPJDependente : this.itens()) {
            if (!rendPJDependente.getDependenteSaiuPaisMesmaDataDeclarante().naoFormatado().equals(Logico.SIM)) continue;
            arrayList.add(rendPJDependente);
        }
        return arrayList;
    }

    public Valor obterRendimentosRecebidosPorDependente(CPF cPF) {
        Valor valor = new Valor();
        for (RendPJDependente rendPJDependente : this.itens()) {
            if (!rendPJDependente.getCpfDependente().naoFormatado().equals(cPF.naoFormatado())) continue;
            valor.append('+', rendPJDependente.getRendRecebidoPJ());
            valor.append('+', rendPJDependente.getDecimoTerceiro());
        }
        return valor;
    }

    public Boolean existeContribuicaoPrevidenciariaOficialPorDependente(CPF cPF) {
        Boolean bl2 = false;
        for (RendPJDependente rendPJDependente : this.itens()) {
            if (!rendPJDependente.getCpfDependente().naoFormatado().equals(cPF.naoFormatado()) || rendPJDependente.getContribuicaoPrevOficial().isVazio()) continue;
            bl2 = true;
            break;
        }
        return bl2;
    }

    @Override
    public String getNomeAba() {
        return "Dependentes";
    }
}

