/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.rendpj;

import java.util.List;
import serpro.ppgd.irpf.IdentificadorDeclaracao;
import serpro.ppgd.irpf.gui.rendpj.PainelDadosRendPJ;
import serpro.ppgd.irpf.rendpj.RendPJTitular;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.NI;
import serpro.ppgd.negocio.ObjetoFicha;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Valor;

public class ColecaoRendPJTitular
extends Colecao<RendPJTitular>
implements ObjetoFicha {
    public static final String NOME_TOTAIS_RENDPJ = "Totais Rend. Recebid";
    protected transient IdentificadorDeclaracao identificadorDeclaracao = null;
    protected NI niMaiorFontePagadora = new NI((ObjetoNegocio)this, "NI");
    protected Valor totaisRendRecebidoPJ = new Valor((ObjetoNegocio)this, "Totais Rend. Recebid");
    protected Valor totaisContribuicaoPrevOficial = new Valor((ObjetoNegocio)this, "Totais Contr. Prev. Oficial");
    protected Valor totaisImpostoRetidoFonte = new Valor((ObjetoNegocio)this, "Totais IR Retido na Fonte");
    protected Valor totaisDecimoTerceiro = new Valor((ObjetoNegocio)this, "Totais 13\u00ba Sal\u00e1rio");
    protected Valor totaisIRRFDecimoTerceiro = new Valor((ObjetoNegocio)this, "IRRF sobre o 13\u00ba Sal\u00e1rio");

    public Valor getTotaisIRRFDecimoTerceiro() {
        return this.totaisIRRFDecimoTerceiro;
    }

    public ColecaoRendPJTitular(IdentificadorDeclaracao identificadorDeclaracao) {
        this.identificadorDeclaracao = identificadorDeclaracao;
        this.totaisRendRecebidoPJ.setReadOnly(true);
        this.totaisContribuicaoPrevOficial.setReadOnly(true);
        this.totaisImpostoRetidoFonte.setReadOnly(true);
        this.totaisDecimoTerceiro.setReadOnly(true);
        this.totaisIRRFDecimoTerceiro.setReadOnly(true);
        this.niMaiorFontePagadora.setReadOnly(true);
        this.setFicha("Rendimentos Tribut\u00e1veis Recebidos de PJ pelo Titular");
    }

    public RendPJTitular obterRendimentoPorChave(String string) {
        for (RendPJTitular rendPJTitular : this.itens()) {
            if (!rendPJTitular.getNIFontePagadora().naoFormatado().equals(string)) continue;
            return rendPJTitular;
        }
        return null;
    }

    public RendPJTitular getRendimentoVazioPorNIFontePagadora(NI nI) {
        for (RendPJTitular rendPJTitular : this.itens()) {
            if (!rendPJTitular.getNIFontePagadora().naoFormatado().equals(nI.naoFormatado()) || !rendPJTitular.todosValoresZerados()) continue;
            return rendPJTitular;
        }
        return null;
    }

    public boolean existeRendimentoPreenchidoComNIFontePagadora(NI nI) {
        for (RendPJTitular rendPJTitular : this.itens()) {
            if (!rendPJTitular.getNIFontePagadora().naoFormatado().equals(nI.naoFormatado()) || rendPJTitular.todosValoresZerados()) continue;
            return true;
        }
        return false;
    }

    public boolean existeContribuicaoPrevidenciariaOficial() {
        for (RendPJTitular rendPJTitular : this.itens()) {
            if (rendPJTitular.getContribuicaoPrevOficial().isVazio()) continue;
            return true;
        }
        return false;
    }

    public void objetoInserido(RendPJTitular rendPJTitular) {
        rendPJTitular.setFicha(this.getFicha());
    }

    public RendPJTitular instanciaNovoObjeto() {
        return new RendPJTitular(this.identificadorDeclaracao);
    }

    public boolean existeRendimentoComDadosIncompletos() {
        boolean bl2 = false;
        for (RendPJTitular rendPJTitular : this.itens()) {
            if (rendPJTitular.getNomeFontePagadora().isValido() && rendPJTitular.getNIFontePagadora().isValido() && !rendPJTitular.getNomeFontePagadora().isVazio() && !rendPJTitular.getNIFontePagadora().isVazio()) continue;
            bl2 = true;
            break;
        }
        return bl2;
    }

    public Valor getTotaisContribuicaoPrevOficial() {
        return this.totaisContribuicaoPrevOficial;
    }

    public Valor getTotaisDecimoTerceiro() {
        return this.totaisDecimoTerceiro;
    }

    public Valor getTotaisImpostoRetidoFonte() {
        return this.totaisImpostoRetidoFonte;
    }

    public Valor getTotaisRendRecebidoPJ() {
        return this.totaisRendRecebidoPJ;
    }

    public NI getNiMaiorFontePagadora() {
        return this.niMaiorFontePagadora;
    }

    protected List<Informacao> recuperarListaCamposPendencia() {
        List list = super.recuperarListaCamposPendencia();
        list.add(this.totaisRendRecebidoPJ);
        return list;
    }

    public String getClasseFicha() {
        return PainelDadosRendPJ.class.getName();
    }

    public String getNomeAba() {
        return "Titular";
    }

    public String getTituloFichaDashboard() {
        return "Rendimentos Tribut\u00e1veis Recebidos de PJ pelo Titular";
    }
}

