/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.rendpj;

import classes.dL;
import classes.dP;
import java.util.List;
import serpro.ppgd.cacheni.CacheNI;
import serpro.ppgd.irpf.IdentificadorDeclaracao;
import serpro.ppgd.irpf.Y;
import serpro.ppgd.irpf.af;
import serpro.ppgd.irpf.ai;
import serpro.ppgd.irpf.gui.rendpj.PainelDadosRendPJ;
import serpro.ppgd.irpf.rendpj.h;
import serpro.ppgd.irpf.rendpj.i;
import serpro.ppgd.irpf.rendpj.j;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.Data;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.NI;
import serpro.ppgd.negocio.ObjetoFicha;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.Pendencia;
import serpro.ppgd.negocio.ValidadorIf;
import serpro.ppgd.negocio.Valor;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorNI;

public class RendPJTitular
extends ObjetoNegocio
implements ObjetoFicha {
    public static final String NOME_NI_FONTE_PAGADORA = "CPF/CNPJ da Fonte Pagadora";
    public static final String NOME_REND_RECEB_PJ = "Rendimentos Recebidos de Pessoa Jur\u00eddica";
    public static final String NOME_CONTRIB_PREV = "Contribui\u00e7\u00e3o Previdenci\u00e1ria Oficial";
    public static final String NOME_IMPOSTO_RETIDO = "Imposto Retido na Fonte";
    public static final String NOME_DECIMO_TERCEIRO = "13\u00ba Sal\u00e1rio";
    public static final String NOME_IRRF_DECIMO_TERCEIRO = "IRRF sobre o 13\u00ba Sal\u00e1rio";
    public static final String NOME_DATA_COMUNICACAO_SAIDA = "Data de Comunica\u00e7\u00e3o da Condi\u00e7\u00e3o de N\u00e3o Residente \u00e0 Fonte Pagadora";
    protected transient IdentificadorDeclaracao identificadorDeclaracao = null;
    protected Alfa nomeFontePagadora = new Alfa((ObjetoNegocio)this, "Nome da Fonte Pagadora");
    protected NI NIFontePagadora = new NI((ObjetoNegocio)this, "CPF/CNPJ da Fonte Pagadora");
    protected ai rendRecebidoPJ = new ai(this, "Rendimentos Recebidos de Pessoa Jur\u00eddica");
    protected ai contribuicaoPrevOficial = new ai(this, "Contribui\u00e7\u00e3o Previdenci\u00e1ria Oficial");
    protected ai impostoRetidoFonte = new ai(this, "Imposto Retido na Fonte");
    protected ai decimoTerceiro = new ai(this, "13\u00ba Sal\u00e1rio");
    protected Data dataComunicacaoSaida = new Data((ObjetoNegocio)this, "Data de Comunica\u00e7\u00e3o da Condi\u00e7\u00e3o de N\u00e3o Residente \u00e0 Fonte Pagadora");
    protected ai IRRFDecimoTerceiro = new ai(this, "IRRF sobre o 13\u00ba Sal\u00e1rio");
    protected boolean isSaida = false;

    public RendPJTitular(IdentificadorDeclaracao identificadorDeclaracao) {
        this.identificadorDeclaracao = identificadorDeclaracao;
        this.isSaida = this.identificadorDeclaracao.getTipoDeclaracaoAES().formatado().equals(dP.c.a());
        CacheNI.getInstancia().registrarNINome(this.NIFontePagadora, this.nomeFontePagadora);
        this.addValidadores();
    }

    public void addValidadores() {
        af af2 = new h(this, 3);
        this.getNomeFontePagadora().addObservador((Observador)new Y());
        this.getNomeFontePagadora().addValidador((ValidadorIf)af2);
        af2 = new i(this, 3);
        this.getNIFontePagadora().addValidador((ValidadorIf)new ValidadorNI(3, dL.a("campo_invalido", new String[]{this.getNIFontePagadora().getNomeCampo()})));
        this.getNIFontePagadora().addValidador((ValidadorIf)af2);
        if (this.isSaida) {
            this.getDataComunicacaoSaida().addValidador((ValidadorIf)new af(2));
            this.getDataComunicacaoSaida().addValidador((ValidadorIf)new j(this, 3));
        }
    }

    public boolean todosValoresZerados() {
        return this.rendRecebidoPJ.isVazio() && this.contribuicaoPrevOficial.isVazio() && this.impostoRetidoFonte.isVazio() && this.decimoTerceiro.isVazio() && this.IRRFDecimoTerceiro.isVazio();
    }

    public void addObservador(Observador observador) {
        this.rendRecebidoPJ.addObservador(observador);
        this.contribuicaoPrevOficial.addObservador(observador);
        this.impostoRetidoFonte.addObservador(observador);
        this.decimoTerceiro.addObservador(observador);
        this.NIFontePagadora.addObservador(observador);
        this.IRRFDecimoTerceiro.addObservador(observador);
    }

    public void removeObservador(Observador observador) {
        this.rendRecebidoPJ.removeObservador(observador);
        this.contribuicaoPrevOficial.removeObservador(observador);
        this.impostoRetidoFonte.removeObservador(observador);
        this.decimoTerceiro.removeObservador(observador);
        this.NIFontePagadora.removeObservador(observador);
        this.IRRFDecimoTerceiro.removeObservador(observador);
    }

    public Valor getContribuicaoPrevOficial() {
        return this.contribuicaoPrevOficial;
    }

    public Valor getDecimoTerceiro() {
        return this.decimoTerceiro;
    }

    public ai getIRRFDecimoTerceiro() {
        return this.IRRFDecimoTerceiro;
    }

    public Valor getImpostoRetidoFonte() {
        return this.impostoRetidoFonte;
    }

    public NI getNIFontePagadora() {
        return this.NIFontePagadora;
    }

    public Alfa getNomeFontePagadora() {
        return this.nomeFontePagadora;
    }

    public Valor getRendRecebidoPJ() {
        return this.rendRecebidoPJ;
    }

    public Data getDataComunicacaoSaida() {
        return this.dataComunicacaoSaida;
    }

    public Pendencia verificaValores(int n2) {
        Pendencia pendencia = null;
        if (this.getImpostoRetidoFonte().isVazio() && this.getContribuicaoPrevOficial().isVazio() && this.getDecimoTerceiro().isVazio() && this.getRendRecebidoPJ().isVazio()) {
            pendencia = new Pendencia(3, (Informacao)this.getRendRecebidoPJ(), "Valores RendPJ", dL.a("rendpj_faltam_valores"), n2);
            pendencia.setNomeAba(this.getNomeAba());
        }
        return pendencia;
    }

    public List<Pendencia> verificarPendencias(int n2) {
        List list = super.verificarPendencias(n2);
        Pendencia pendencia = this.verificaValores(n2);
        if (pendencia != null) {
            pendencia.setClassePainel(this.getClasseFicha());
            list.add(pendencia);
        }
        return list;
    }

    protected List<Informacao> recuperarListaCamposPendencia() {
        List list = this.recuperarCamposInformacao();
        return list;
    }

    public boolean isVazio() {
        for (Informacao informacao : this.recuperarCamposInformacao()) {
            if (informacao.isVazio()) continue;
            return false;
        }
        return true;
    }

    public String getClasseFicha() {
        return PainelDadosRendPJ.class.getName();
    }

    public String getNomeAba() {
        return "Titular";
    }

    public String getTituloFichaDashboard() {
        return "Rendimentos Tribut\u00e1veis Recebidos de PJ pelo Titular";
    }
}

