/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.util.scriptlet;

import classes.dc;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import javax.swing.text.MaskFormatter;
import net.sf.jasperreports.engine.JRDefaultScriptlet;
import serpro.ppgd.negocio.ElementoTabela;

public class FuncoesFormatacao
extends JRDefaultScriptlet {
    private static String corrigirString(String string) {
        if (string == null) {
            string = "";
        }
        return string.replaceAll("(\\A(\\n|\\s|\\t)+)|((\\n|\\s|\\t)+\\z)", "");
    }

    public static String formatarCPF(String string) {
        string = FuncoesFormatacao.corrigirString(string);
        try {
            MaskFormatter maskFormatter = new MaskFormatter("###.###.###-##");
            maskFormatter.setValueContainsLiteralCharacters(false);
            return maskFormatter.valueToString(string);
        }
        catch (ParseException parseException) {
            ParseException parseException2 = parseException;
            parseException.printStackTrace();
            throw new RuntimeException(parseException2);
        }
    }

    public static String formatarCNPJ(String string) {
        string = FuncoesFormatacao.corrigirString(string);
        try {
            MaskFormatter maskFormatter = new MaskFormatter("##.###.###/####-##");
            maskFormatter.setValueContainsLiteralCharacters(false);
            return maskFormatter.valueToString(string);
        }
        catch (ParseException parseException) {
            throw new RuntimeException(parseException);
        }
    }

    public static String formatarNI(String string) {
        if ((string = FuncoesFormatacao.corrigirString(string)).length() < 12) {
            return FuncoesFormatacao.formatarCPF(string);
        }
        return FuncoesFormatacao.formatarCNPJ(string);
    }

    public static String formatarMoeda(String string) {
        string = FuncoesFormatacao.corrigirString(string);
        NumberFormat numberFormat = NumberFormat.getInstance(new Locale("pt", "BR"));
        numberFormat.setMinimumFractionDigits(2);
        return "R$ " + numberFormat.format(new Double(string.replace(',', '.')));
    }

    public static String formatarNome(String string) {
        string = FuncoesFormatacao.corrigirString(string);
        return string.replaceAll("(\\n|\\s|\\t)+", " ");
    }

    public static String getDescricaoPagamentoPrevidenciaPorCodigo(String string) {
        string = FuncoesFormatacao.corrigirString(string);
        int n2 = 0;
        String string2 = "";
        try {
            n2 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {}
        switch (n2) {
            case 1: {
                string2 = "Previd\u00eancia Complementar";
                break;
            }
            case 2: {
                string2 = "Fapi - Fundo de Aposentadoria Programada Individual";
                break;
            }
            case 3: {
                string2 = "Contribui\u00e7\u00f5es para as entidades de previd\u00eancia complementar fechadas de natureza p\u00fablica";
            }
        }
        return string2;
    }

    public static String getDescricaoRendimentoIsento(String string) {
        string = FuncoesFormatacao.corrigirString(string);
        int n2 = 0;
        String string2 = "";
        try {
            n2 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {}
        switch (n2) {
            case 1: {
                string2 = FuncoesFormatacao.obterDescricaoRendIsentos("10");
                break;
            }
            case 2: {
                string2 = FuncoesFormatacao.obterDescricaoRendIsentos("11");
                break;
            }
            case 3: {
                string2 = FuncoesFormatacao.obterDescricaoRendIsentos("09");
                break;
            }
            case 4: {
                string2 = FuncoesFormatacao.obterDescricaoRendIsentos("13");
                break;
            }
            case 5: {
                string2 = FuncoesFormatacao.obterDescricaoRendIsentos("04");
                break;
            }
            case 6: {
                string2 = "Benef\u00edcios indiretos e reembolso de despesas recebidos por volunt\u00e1rio da Fifa.";
                break;
            }
            case 7: {
                string2 = FuncoesFormatacao.obterDescricaoRendIsentos("02");
                break;
            }
            case 8: {
                string2 = FuncoesFormatacao.obterDescricaoRendIsentos("01");
                break;
            }
            case 9: {
                string2 = FuncoesFormatacao.obterDescricaoRendIsentos("16");
                break;
            }
            case 10: {
                string2 = "Di\u00e1rias e ajuda de custo.";
                break;
            }
            case 11: {
                string2 = "Abono pecuni\u00e1rio.";
            }
        }
        return string2;
    }

    private static String obterDescricaoRendIsentos(String string) {
        String string2 = "";
        for (ElementoTabela elementoTabela : dc.N()) {
            if (!elementoTabela.getConteudo(0).equals(string)) continue;
            string2 = elementoTabela.getConteudo(2);
            break;
        }
        return string2;
    }

    public static String getDescricaoRendTribExclusiva(String string) {
        string = FuncoesFormatacao.corrigirString(string);
        int n2 = 0;
        String string2 = "";
        try {
            n2 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {}
        switch (n2) {
            case 1: {
                string2 = FuncoesFormatacao.obterDescricaoRendTribExclusiva("10");
                break;
            }
            case 2: {
                string2 = FuncoesFormatacao.obterDescricaoRendTribExclusiva("11");
            }
        }
        return string2;
    }

    private static String obterDescricaoRendTribExclusiva(String string) {
        String string2 = "";
        for (ElementoTabela elementoTabela : dc.O()) {
            if (!elementoTabela.getConteudo(0).equals(string)) continue;
            string2 = elementoTabela.getConteudo(2);
            break;
        }
        return string2;
    }

    public static String getMesExtenso(String string) {
        string = FuncoesFormatacao.corrigirString(string);
        String string2 = "";
        try {
            int n2 = Integer.parseInt(string) - 1;
            Calendar calendar = Calendar.getInstance(new Locale("pt", "BR"));
            calendar.set(2000, n2, 1);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMMM", new Locale("pt", "BR"));
            string2 = simpleDateFormat.format(calendar.getTime());
        }
        catch (Exception exception) {}
        return string2;
    }

    public static void main(String[] stringArray) {
        System.out.println("M\u00eas-1: " + FuncoesFormatacao.formatarNome("\n\n00000\n11111\n\n\n22222\n    \n  33333        "));
    }
}

