/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.util.update;

import br.gov.serpro.updater.AtualizacaoException;
import br.gov.serpro.updater.PgdUpdater;
import br.gov.serpro.updater.ReleaseUpdateProperties;
import classes.bK;
import classes.dD;
import classes.dF;
import com.google.gson.Gson;
import java.io.File;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import jupar.Downloader;
import jupar.objects.Release;
import org.apache.commons.io.FileUtils;
import serpro.ppgd.irpf.util.update.IRPFUpdateProperties;
import serpro.ppgd.irpf.util.update.IRPFUpdateProperties$TipoAtualizacao;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.util.FabricaUtilitarios;
import serpro.ppgd.negocio.util.UtilitariosArquivo;

public class IRPFUpdater {
    public final String NOME_ARQ_LATEST = "latest.xml";
    public final String NOME_ARQ_PROPRIEDADES = "release_properties.xml";
    public final String NOME_ARQ_UPDATE_JAR = "pgd-updater.jar";
    public final String PATH_PASTA_UPDATE_DESENVOLVIMENTO = "http://webdesdr.sdr.serpro/de5ps/irpf-update-desenvolvimento/" + ConstantesGlobais.EXERCICIO + "/update/";
    public final String PATH_PASTA_UPDATE_HOMOLOGACAO = "http://downloadirpf.receita.fazenda.gov.br/irpf/HOM/" + ConstantesGlobais.EXERCICIO + "/update/";
    public final String PATH_PASTA_UPDATE_PRODUCAO = "http://downloadirpf.receita.fazenda.gov.br/irpf/" + ConstantesGlobais.EXERCICIO + "/irpf/update/";
    public final String PATH_ENDERECO_UPDATE_DESENVOLVIMENTO = String.valueOf(this.PATH_PASTA_UPDATE_DESENVOLVIMENTO) + "latest.xml";
    public final String PATH_ENDERECO_UPDATE_HOMOLOGACAO = String.valueOf(this.PATH_PASTA_UPDATE_HOMOLOGACAO) + "latest.xml";
    public final String PATH_ENDERECO_UPDATE_PRODUCAO = String.valueOf(this.PATH_PASTA_UPDATE_PRODUCAO) + "latest.xml";
    public final String NOME_PASTA_TEMP = "tmp_IRPF" + ConstantesGlobais.EXERCICIO;
    public final String NOME_PASTA_APLICATIVO = ".irpf";
    public final String NOME_IRPF_APP_MAC = "IRPF" + ConstantesGlobais.EXERCICIO + ".app";
    public final String NOME_IRPF_EXE_WIN = "IRPF" + ConstantesGlobais.EXERCICIO + ".exe";
    public static int TIPO_AMBIENTE_UPDATER_DESENVOLVIMENTO = 1;
    public static int TIPO_AMBIENTE_UPDATER_HOMOLOGACAO = 2;
    public static int TIPO_AMBIENTE_UPDATER_PRODUCAO = 3;
    private int ambienteUpdater = TIPO_AMBIENTE_UPDATER_PRODUCAO;
    private PgdUpdater updater = null;
    private File pastaBase = null;
    private static IRPFUpdater instance = null;

    protected IRPFUpdater() {
    }

    public static IRPFUpdater getInstance() {
        if (instance == null) {
            instance = new IRPFUpdater();
        }
        return instance;
    }

    protected PgdUpdater getPgdUpdater() {
        if (this.updater == null) {
            this.updater = new PgdUpdater();
            this.updater.setReleasePropertiesPath(new File(String.valueOf(UtilitariosArquivo.getPathDados()) + File.separator + "release_properties.xml").getAbsolutePath());
            try {
                this.updater.setLogFile(new File(String.valueOf(UtilitariosArquivo.getPathUsuario()) + File.separator + "updater.log"));
            }
            catch (AtualizacaoException atualizacaoException) {
                AtualizacaoException atualizacaoException2 = atualizacaoException;
                atualizacaoException.printStackTrace();
            }
        }
        return this.updater;
    }

    protected String obterIdentificadorVersao(String string, String string2) {
        try {
            if (string2 != null && string2.trim().length() > 0 && Integer.parseInt(string2) > 0) {
                string = String.valueOf(string) + "_Testes_" + string2;
            }
        }
        catch (Exception exception) {}
        return string;
    }

    protected IRPFUpdateProperties obterUpdateProperties(Release release) {
        try {
            String string = this.obterIdentificadorVersao(release.getpkgver(), release.getPkgrel());
            String[] stringArray = this.obterIdentificadorVersao(dD.g(), dF.f ? dD.h() : null);
            Object object = new Gson();
            object = (IRPFUpdateProperties)object.fromJson(release.getMessage(), IRPFUpdateProperties.class);
            ((IRPFUpdateProperties)object).setUltimaVersao(string);
            ((IRPFUpdateProperties)object).setVersaoAtual((String)stringArray);
            ((IRPFUpdateProperties)object).setTipoAtualizacao(IRPFUpdateProperties$TipoAtualizacao.valueOf(release.getseverity()));
            if (((IRPFUpdateProperties)object).getArquivoZip() != null && ((IRPFUpdateProperties)object).getArquivoZip().trim().length() > 0) {
                ((IRPFUpdateProperties)object).setArquivoZip(((IRPFUpdateProperties)object).getArquivoZip().replaceAll("\\@", String.valueOf(((IRPFUpdateProperties)object).getVersaoAtual()) + "_update_" + ((IRPFUpdateProperties)object).getUltimaVersao()));
            }
            if (((IRPFUpdateProperties)object).getUltimaVersaoManual() != null && !((IRPFUpdateProperties)object).getUltimaVersaoManual().trim().isEmpty()) {
                release = new Release();
                string = new Release();
                string.setpkgver(dD.g());
                string.setPkgrel(dD.h());
                stringArray = ((IRPFUpdateProperties)object).getUltimaVersaoManual().split("_");
                release.setpkgver(stringArray[0]);
                if (stringArray.length > 1) {
                    release.setPkgrel(stringArray[1]);
                }
                ((IRPFUpdateProperties)object).setDownloadManual(release.compareTo((Object)string) > 0);
            }
            return object;
        }
        catch (Exception exception) {
            throw new bK("atualizar.erro.generico", exception);
        }
    }

    public IRPFUpdateProperties temAtualizacaoCompletada() {
        PgdUpdater pgdUpdater = this.getPgdUpdater();
        IRPFUpdateProperties iRPFUpdateProperties = null;
        try {
            pgdUpdater = pgdUpdater.getReleaseUpdateProperties();
            if (pgdUpdater != null && pgdUpdater.getUpdateStatus() == ReleaseUpdateProperties.UpdateStatus.UpdateCompleted) {
                iRPFUpdateProperties = this.obterUpdateProperties(pgdUpdater.getLatestRelease());
            }
        }
        catch (AtualizacaoException atualizacaoException) {
            throw new bK("atualizar.erro.generico", atualizacaoException);
        }
        return iRPFUpdateProperties;
    }

    public IRPFUpdateProperties atualizacaoPendente() {
        PgdUpdater pgdUpdater = this.getPgdUpdater();
        IRPFUpdateProperties iRPFUpdateProperties = null;
        try {
            pgdUpdater = pgdUpdater.registerUpdateStatusUpdateNotStarted();
            if (pgdUpdater != null) {
                iRPFUpdateProperties = this.obterUpdateProperties(pgdUpdater.getLatestRelease());
            }
        }
        catch (AtualizacaoException atualizacaoException) {
            throw new bK("atualizar.erro.generico", atualizacaoException);
        }
        return iRPFUpdateProperties;
    }

    public boolean verificarUltimaVersaoAposPeriodo() {
        PgdUpdater pgdUpdater = this.getPgdUpdater();
        try {
            Object object = pgdUpdater.getReleaseUpdateProperties();
            if (object != null && object.getUpdateStatus() != ReleaseUpdateProperties.UpdateStatus.UpdateCompleted) {
                IRPFUpdateProperties iRPFUpdateProperties = this.obterUpdateProperties(object.getLatestRelease());
                object = object.getQueryDate();
                Calendar calendar = Calendar.getInstance();
                calendar.setLenient(false);
                calendar.clear();
                calendar.set(Integer.parseInt(((String)object).substring(0, 4)), Integer.parseInt(((String)object).substring(4, 6)) - 1, Integer.parseInt(((String)object).substring(6, 8)), Integer.parseInt(((String)object).substring(8, 10)), Integer.parseInt(((String)object).substring(10, 12)));
                calendar.add(12, iRPFUpdateProperties.getPeriodoEspera());
                long l2 = Long.parseLong(pgdUpdater.getDateTime(calendar.getTime()));
                long l3 = Long.parseLong(pgdUpdater.getDateTime(new Date()));
                if (l3 <= l2) {
                    return false;
                }
            }
        }
        catch (AtualizacaoException | NumberFormatException throwable) {
            throw new bK("atualizar.erro.generico", throwable);
        }
        return true;
    }

    public IRPFUpdateProperties verificarUltimaVersaoOnline() {
        IRPFUpdateProperties iRPFUpdateProperties = null;
        PgdUpdater pgdUpdater = this.getPgdUpdater();
        try {
            pgdUpdater = pgdUpdater.verificarVersao(this.getEnderecoArqUltimaVersao(), dD.g(), dD.h());
            if (pgdUpdater != null) {
                iRPFUpdateProperties = this.obterUpdateProperties((Release)pgdUpdater);
            }
        }
        catch (Exception exception) {
            throw new bK("atualizar.erro.verificacao", exception);
        }
        return iRPFUpdateProperties;
    }

    public String getJavaCommand() {
        String string = "java";
        File file = new File(String.valueOf(System.getProperty("java.home")) + File.separator + "bin");
        if (file.exists() && file.isDirectory()) {
            string = String.valueOf(file.getAbsolutePath()) + File.separator + string;
        }
        return string;
    }

    public void execNavegador(String string) {
        File file = this.obterPastaBase();
        File file2 = new File(file, "pgd-updater.jar");
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.getJavaCommand());
        arrayList.add("-jar");
        arrayList.add(file2.getAbsolutePath());
        arrayList.add("-B");
        arrayList.add("-appName");
        arrayList.add("IRPF" + ConstantesGlobais.EXERCICIO);
        arrayList.add("-url");
        arrayList.add(string);
        System.err.println("cmdDir=" + file);
        System.err.println("cmd=" + arrayList.toString());
        try {
            Runtime.getRuntime().exec(arrayList.toArray(new String[0]), null, file);
            return;
        }
        catch (Throwable throwable) {
            throw new bK("atualizar.erro.navegador", new String[]{string, ConstantesGlobais.EXERCICIO}, throwable);
        }
    }

    public void execUpdate(IRPFUpdateProperties object) {
        Object object2;
        File file = this.obterPastaBase();
        String string = this.getPgdUpdater().getReleasePropertiesPath();
        File file2 = new File(file, "pgd-updater.jar");
        File file3 = this.obterPastaTemp();
        File file4 = this.getPgdUpdater().getLogFile();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        String string2 = this.getJavaCommand();
        object2 = FabricaUtilitarios.isWindows() && ((File)(object2 = new File(file, this.NOME_IRPF_EXE_WIN))).exists() ? ((File)object2).getAbsolutePath() : (FabricaUtilitarios.isMac() && ((File)(object2 = new File(file.getParentFile().getParentFile().getParentFile(), this.NOME_IRPF_APP_MAC))).exists() ? "open#" + ((File)object2).getAbsolutePath() : String.valueOf(string2) + "#-jar#irpf.jar");
        arrayList.add(string2);
        arrayList.add("-jar");
        arrayList.add(file2.getAbsolutePath());
        arrayList.add("-U");
        arrayList.add("-W");
        arrayList.add("-appName");
        arrayList.add("IRPF" + ConstantesGlobais.EXERCICIO);
        arrayList.add("-tempDir");
        arrayList.add(file3.getAbsolutePath());
        arrayList.add("-destDir");
        arrayList.add(file.getAbsolutePath());
        arrayList.add("-zipFile");
        arrayList.add(((IRPFUpdateProperties)object).getArquivoZip());
        arrayList.add("-releaseUpdateProperties");
        arrayList.add(string);
        arrayList.add("-logFile");
        arrayList.add(file4.getAbsolutePath());
        arrayList.add("-appComandSeparator");
        arrayList.add("#");
        arrayList.add("-appComand");
        arrayList.add(object2);
        System.err.println("cmdDir=" + file);
        System.err.println("cmd=" + arrayList.toString());
        try {
            Runtime.getRuntime().exec(arrayList.toArray(new String[0]), null, file);
            return;
        }
        catch (IOException iOException) {
            object = iOException;
            iOException.printStackTrace();
            throw new bK("atualizar.erro.update", (Throwable)object);
        }
        catch (Throwable throwable) {
            object = throwable;
            throwable.printStackTrace();
            throw new bK("atualizar.erro.update", (Throwable)object);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void download(IRPFUpdateProperties var1_1, Downloader.DownloadProgress var2_2) {
        var3_3 = this.getPgdUpdater();
        var3_3.setDownloadProgress((Downloader.DownloadProgress)var2_2);
        var2_2 = this.obterPastaTemp();
        try {
            if (var2_2.exists()) {
                FileUtils.deleteDirectory((File)var2_2);
            }
            FileUtils.forceMkdir((File)var2_2);
        }
        catch (IOException v0) {
            var1_1 = v0;
            v0.printStackTrace();
            throw new bK("atualizar.erro.download", (Throwable)var1_1);
        }
        try {
            var3_3.getLogger().info("Iniciando download da vers\u00e3o: " + var1_1.getUltimaVersao() + " (" + (Object)var1_1.getTipoAtualizacao() + "). Vers\u00e3o Atual: " + var1_1.getVersaoAtual() + ".");
            var3_3.executarDownload(var1_1.getEnderecoServidor(), var2_2.getAbsolutePath(), var1_1.getArquivoZip());
            return;
        }
        catch (AtualizacaoException v1) {
            var1_1 = v1;
            var2_2 = v1;
            ** while (var2_2.getCause() != null)
        }
lbl-1000:
        // 1 sources

        {
            var2_2 = var2_2.getCause();
            continue;
        }
lbl23:
        // 1 sources

        if (var2_2 instanceof SocketTimeoutException) {
            throw new bK("atualizar.erro.download.timeout", (Throwable)var1_1);
        }
        throw new bK("atualizar.erro.download", (Throwable)var1_1);
    }

    public boolean temPermissaoEscritaPastaBase() {
        try {
            return this.obterPastaBase() != null;
        }
        catch (bK bK2) {
            return false;
        }
    }

    public boolean temPermissaoEscritaPasta(File file) {
        try {
            file = new File(file, "test.txt");
            file.createNewFile();
            file.delete();
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public File obterPastaTemp() {
        return new File(this.obterPastaAplicativo(), this.NOME_PASTA_TEMP);
    }

    public File obterPastaAplicativo() {
        File file;
        try {
            file = new File(new File(System.getProperty("user.home")), ".irpf");
            if (!file.exists()) {
                FileUtils.forceMkdir((File)file);
            }
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            throw new bK("atualizar.erro.generico", exception2);
        }
        return file;
    }

    public File obterPastaBase() {
        if (this.pastaBase == null) {
            try {
                this.pastaBase = new File(IRPFUpdater.class.getProtectionDomain().getCodeSource().getLocation().toURI());
            }
            catch (Exception exception) {
                Exception exception2 = exception;
                exception.printStackTrace();
                throw new bK("atualizar.erro.generico", exception2);
            }
            if (this.pastaBase.isFile()) {
                this.pastaBase = this.pastaBase.getParentFile();
            }
            if (!this.temPermissaoEscritaPasta(this.pastaBase)) {
                throw new bK("atualizar.erro.generico");
            }
        }
        return this.pastaBase;
    }

    public String getEnderecoArqUltimaVersao() {
        if (dF.f) {
            if (this.getAmbienteUpdater() == TIPO_AMBIENTE_UPDATER_DESENVOLVIMENTO) {
                return this.PATH_ENDERECO_UPDATE_DESENVOLVIMENTO;
            }
            return this.PATH_ENDERECO_UPDATE_HOMOLOGACAO;
        }
        return this.PATH_ENDERECO_UPDATE_PRODUCAO;
    }

    public int getAmbienteUpdater() {
        return this.ambienteUpdater;
    }

    public void setAmbienteUpdater(int n2) {
        this.ambienteUpdater = n2;
    }
}

