/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.midas.config;

import br.gov.serpro.midas.exception.AmbienteException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public final class Config {
    private static final String AMBIENTE_KEY = "ambiente";
    private static final String TEST_AMBIENTE_KEY = "teste";
    private static final String VERSAO = "versao";
    private static final String RUNTIME = "runtime";
    private static final String JBOSS_RUNTIME = "jboss";
    private static Properties propriedades = null;
    private static boolean jbossRuntime;
    private static boolean runtimeConfigured;
    private static boolean runningTest;

    static {
        runtimeConfigured = false;
    }

    private Config() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties getPropriedades() throws AmbienteException {
        Class<Config> clazz = Config.class;
        synchronized (Config.class) {
            if (propriedades == null) {
                propriedades = new Properties();
                InputStream is = null;
                try {
                    is = new Config().getClass().getResourceAsStream("/resources/config.properties");
                    propriedades.load(is);
                    is.close();
                }
                catch (IOException e) {
                    throw new AmbienteException("erro.leitura.arquivo", Config.class.getName(), "getPropriedades", e, "de propriedades");
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return propriedades;
        }
    }

    public static void override(String property, String value) throws AmbienteException {
        Config.getPropriedades().put(property, value);
    }

    public static String getAmbiente() {
        if (Config.isRunningTest()) {
            return TEST_AMBIENTE_KEY;
        }
        return Config.getPropriedades().getProperty(AMBIENTE_KEY);
    }

    public static String getVersao() {
        return Config.getPropriedades().getProperty(VERSAO);
    }

    public static String getIp() {
        return Config.getPropriedades().getProperty(String.valueOf(Config.getAmbiente()) + ".ip");
    }

    public static String getLogin() {
        return Config.getPropriedades().getProperty(String.valueOf(Config.getAmbiente()) + ".login");
    }

    public static String getPathLayouts() {
        return Config.getPropriedades().getProperty(String.valueOf(Config.getAmbiente()) + ".pathLayouts");
    }

    public static String getPerfil() {
        return Config.getPropriedades().getProperty(String.valueOf(Config.getAmbiente()) + ".perfil");
    }

    public static String getSenha() throws AmbienteException {
        return Config.getPropriedades().getProperty(String.valueOf(Config.getAmbiente()) + ".senha");
    }

    public static String getPathTemporario() throws AmbienteException {
        return Config.getPropriedades().getProperty(String.valueOf(Config.getAmbiente()) + ".pathTemporario");
    }

    public static String getStringConexao() throws AmbienteException {
        return Config.getPropriedades().getProperty(String.valueOf(Config.getAmbiente()) + ".stringConexao");
    }

    public static String getUsuarioConexao() throws AmbienteException {
        return Config.getPropriedades().getProperty(String.valueOf(Config.getAmbiente()) + ".usuarioConexao");
    }

    public static String getSenhaConexao() throws AmbienteException {
        return Config.getPropriedades().getProperty(String.valueOf(Config.getAmbiente()) + ".senhaConexao");
    }

    public static String getDataSource() throws AmbienteException {
        return Config.getPropriedades().getProperty(String.valueOf(Config.getAmbiente()) + ".dataSource");
    }

    public static String getTipoStream() throws AmbienteException {
        return Config.getPropriedades().getProperty("tipoStream");
    }

    public static boolean getRemocaoArquivos() throws AmbienteException {
        return Boolean.valueOf(Config.getPropriedades().getProperty("removerTemporarios"));
    }

    public static String getLogonRotinaBloqueio() throws AmbienteException {
        return Config.getPropriedades().getProperty(String.valueOf(Config.getAmbiente()) + ".logon.rotina.bloqueio");
    }

    public static String getLogonRotinaHash() throws AmbienteException {
        return Config.getPropriedades().getProperty(String.valueOf(Config.getAmbiente()) + ".logon.rotina.hash");
    }

    public static String getRuntime() throws AmbienteException {
        return Config.getPropriedades().getProperty(RUNTIME);
    }

    public static boolean isJbossRuntime() throws AmbienteException {
        if (!runtimeConfigured) {
            jbossRuntime = Config.getRuntime().equals(JBOSS_RUNTIME);
            runtimeConfigured = true;
        }
        return jbossRuntime;
    }

    public static void setJbossRuntime(boolean flag) {
        jbossRuntime = flag;
    }

    public static String getContextBindingName() throws AmbienteException {
        String contextName = Config.getContextName();
        String dataSource = Config.getDataSource();
        return String.valueOf(contextName) + dataSource;
    }

    public static String getContextName() throws AmbienteException {
        String contextName = Config.isJbossRuntime() ? "java:jboss/datasources/" : "java:/comp/env/";
        return contextName;
    }

    public static String getAsyncStorePath() throws AmbienteException {
        return Config.getPropriedades().getProperty(Config.getAsyncStorePathKey());
    }

    private static String getAsyncStorePathKey() {
        String asyncStorePathKey = String.valueOf(Config.getAmbiente()) + ".asyncStorePath";
        return asyncStorePathKey;
    }

    public static String getPersistenceUnit() throws AmbienteException {
        String persistenceUnitName = Config.getPropriedades().getProperty(String.valueOf(Config.getAmbiente()) + ".persistence.unit.name");
        return persistenceUnitName;
    }

    public static void setRunningTest(boolean b) {
        runningTest = b;
    }

    public static boolean isRunningTest() {
        return runningTest;
    }

    public static String getAsyncTimeout() throws AmbienteException {
        return Config.getPropriedades().getProperty(Config.getAsyncTimeoutKey());
    }

    private static String getAsyncTimeoutKey() {
        String asyncTimeoutKey = String.valueOf(Config.getAmbiente()) + ".asyncTimeout";
        return asyncTimeoutKey;
    }

    public static String getAsyncTimeoutUnit() throws AmbienteException {
        return Config.getPropriedades().getProperty(Config.getAsyncTimeoutUnitKey());
    }

    private static String getAsyncTimeoutUnitKey() {
        String asyncTimeoutKey = String.valueOf(Config.getAmbiente()) + ".asyncTimeoutUnit";
        return asyncTimeoutKey;
    }

    public static String getAsyncPrintersCount() throws AmbienteException {
        return Config.getPropriedades().getProperty(Config.getAsyncPrintersCountKey());
    }

    private static String getAsyncPrintersCountKey() {
        String asyncTimeoutKey = String.valueOf(Config.getAmbiente()) + ".asyncPrintersCount";
        return asyncTimeoutKey;
    }

    public static String getMassaDados() throws AmbienteException {
        return Config.getPropriedades().getProperty(Config.getMassaDadosKey());
    }

    private static String getMassaDadosKey() {
        return "massaDados";
    }

    public static String getJasperDataSource() throws AmbienteException {
        return Config.getPropriedades().getProperty(Config.getJasperDataSourceKey());
    }

    private static String getJasperDataSourceKey() {
        return "jasper.datasource";
    }
}

