/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.midas.exception;

import br.gov.serpro.midas.model.AplicacaoDTO;
import br.gov.serpro.midas.negocio.Solicitacao;
import br.gov.serpro.midas.util.Dicionario;
import org.apache.commons.lang.StringUtils;

public class MidasException
extends RuntimeException {
    private static final long serialVersionUID = 9115284822442887450L;
    private String codigoErro;
    private String nomeClasse;
    private String nomeMetodo;
    private Solicitacao solicitacao;
    private String tipoDeclaracao;
    private String exercicio;
    private String aplicacao;

    public MidasException() {
    }

    public MidasException(Throwable cause) {
        super(cause);
    }

    public MidasException(String mensagem) {
        super(mensagem);
    }

    public MidasException(String mensagem, Throwable cause) {
        super(mensagem, cause);
    }

    public MidasException(String codigoErro, String ... params) {
        super(Dicionario.getMensagem(codigoErro, params));
        this.codigoErro = codigoErro;
    }

    public MidasException(String codigoErro, String nomeClasse, String nomeMetodo, String ... params) {
        this(codigoErro, params);
        this.nomeClasse = nomeClasse;
        this.nomeMetodo = nomeMetodo;
    }

    public MidasException(String codigoErro, String nomeClasse, String nomeMetodo, Throwable cause, String ... params) {
        this(codigoErro, cause, params);
        this.codigoErro = codigoErro;
        this.nomeClasse = nomeClasse;
        this.nomeMetodo = nomeMetodo;
    }

    public MidasException(String codigoErro, Throwable cause, String ... params) {
        super(Dicionario.getMensagem(codigoErro, params), cause);
    }

    public MidasException(String codigoErro, String nomeDaClasse, Throwable cause) {
        super("Exception. CodigoErro[" + codigoErro + "], nomeClasse[" + nomeDaClasse + "]: " + cause.getMessage(), cause);
    }

    public String getCodigoErro() {
        return this.codigoErro;
    }

    public String getNomeClasse() {
        return this.nomeClasse;
    }

    public String getNomeMetodo() {
        return this.nomeMetodo;
    }

    public void setSolicitacao(Solicitacao solicitacao) {
        this.solicitacao = solicitacao;
        if (this.solicitacao != null) {
            String login;
            AplicacaoDTO aplicacao = solicitacao.getAplicacao();
            this.aplicacao = login = aplicacao != null ? aplicacao.getLogin() : "?";
            this.tipoDeclaracao = solicitacao.getTipoDeclaracao();
            if (solicitacao.getExercicio() != null) {
                this.exercicio = solicitacao.getExercicio().toString();
            }
        }
    }

    public Solicitacao getSolicitacao() {
        return this.solicitacao;
    }

    public String getLocalizedMessage() {
        String str = super.getLocalizedMessage();
        String requisicao = "";
        if (StringUtils.isNotEmpty(this.aplicacao)) {
            requisicao = String.valueOf(requisicao) + " [" + this.aplicacao;
        }
        if (StringUtils.isNotEmpty(this.tipoDeclaracao)) {
            requisicao = String.valueOf(requisicao) + " - " + this.tipoDeclaracao;
        }
        if (StringUtils.isNotEmpty(this.exercicio)) {
            requisicao = String.valueOf(requisicao) + " - " + this.exercicio;
        }
        if (StringUtils.contains(str, requisicao = StringUtils.isEmpty(requisicao) ? ". (No Info)" : String.valueOf(requisicao) + "]")) {
            return str;
        }
        return String.valueOf(StringUtils.trim(str)) + "." + requisicao;
    }

    public String getTipoDeclaracao() {
        return this.tipoDeclaracao;
    }

    public void setTipoDeclaracao(String tipoDeclaracao) {
        this.tipoDeclaracao = tipoDeclaracao;
    }

    public String getExercicio() {
        return this.exercicio;
    }

    public void setExercicio(String exercicio) {
        this.exercicio = exercicio;
    }

    public void setExercicio(Integer exercicio) {
        if (exercicio != null) {
            this.setExercicio(exercicio.toString());
        }
    }

    public String getAplicacao() {
        return this.aplicacao;
    }

    public void setAplicacao(String aplicacao) {
        this.aplicacao = aplicacao;
    }
}

