/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.midas.negocio;

import br.gov.serpro.midas.exception.AplicacaoException;
import br.gov.serpro.midas.model.AplicacaoDTO;
import br.gov.serpro.midas.model.LayoutDTO;
import br.gov.serpro.midas.model.tipo.TipoNI;
import java.util.Arrays;
import org.apache.commons.lang.StringUtils;

public class Solicitacao {
    private AplicacaoDTO aplicacao;
    private String nomeUsuario;
    private String cpfUsuario;
    private String ipUsuario;
    private String uaUsuario;
    private String identificacaoUsuario;
    private String tipoDeclaracao;
    private String niPesquisado;
    private TipoNI indicadorNi;
    private Integer exercicio;
    private Integer indiceTipo;
    private String tipoLayout;
    private String ativas;
    private String parametroFichas;
    private LayoutDTO layoutAtual;
    private String comandoGP;
    private String[] parametrosIdentificadores;
    private String[] parametrosFiltro;
    private String parametrosGP = null;
    private String parametrosWS = null;
    private String[] todosParametros = null;
    private String numeroOficial;
    private String parametrosRequisicao;
    private boolean parametroFichasAfirmativo = false;
    private boolean requisicaoWebService = false;
    private String textoDeclaracao;
    private String textoRecibo;

    public Solicitacao(String parametrosRequisicao, String[] params, AplicacaoDTO aplicacao, String nomeUsuario, String cpfUsuario, String ipUsuario) throws AplicacaoException {
        this.parametrosRequisicao = parametrosRequisicao;
        this.aplicacao = aplicacao;
        this.nomeUsuario = nomeUsuario;
        this.cpfUsuario = cpfUsuario;
        this.ipUsuario = ipUsuario;
        this.todosParametros = parametrosRequisicao.split("[,;]");
    }

    public String[] getParametrosIdentificadores() {
        return this.parametrosIdentificadores;
    }

    public String[] getParametrosFiltro() {
        return this.parametrosFiltro;
    }

    public String getParametrosGP() {
        return this.parametrosGP;
    }

    public void setParametrosGP(String parametrosGP) {
        this.parametrosGP = parametrosGP;
    }

    public String[] getTodosParametros() {
        return this.todosParametros;
    }

    public String getNomeUsuario() {
        return this.nomeUsuario;
    }

    public String getCpfUsuario() {
        return this.cpfUsuario;
    }

    public String getIpUsuario() {
        return StringUtils.rightPad(this.ipUsuario, 15, " ");
    }

    public AplicacaoDTO getAplicacao() {
        return this.aplicacao;
    }

    public String getNiPesquisado() {
        return this.niPesquisado;
    }

    public void setNiPesquisado(String niPesquisado) {
        this.niPesquisado = niPesquisado;
    }

    public Integer getExercicio() {
        return this.exercicio;
    }

    public void setExercicio(Integer exercicio) {
        this.exercicio = exercicio;
    }

    public String getComandoGP() {
        return this.comandoGP;
    }

    public void setComandoGP(String comandoGP) {
        this.comandoGP = comandoGP;
    }

    public String getParametrosWS() {
        return this.parametrosWS;
    }

    public void setParametrosWS(String parametrosWS) {
        this.parametrosWS = parametrosWS;
    }

    public Integer getIndiceTipo() {
        return this.indiceTipo;
    }

    public void setIndiceTipo(Integer indiceTipo) {
        this.indiceTipo = indiceTipo;
    }

    public String getParametroFichas() {
        return this.parametroFichas;
    }

    public void setParametroFichas(String parametroFichas) {
        this.parametroFichas = parametroFichas;
    }

    public LayoutDTO getLayoutAtual() {
        return this.layoutAtual;
    }

    public void setLayoutAtual(LayoutDTO layoutAtual) {
        this.layoutAtual = layoutAtual;
    }

    public String getTipoLayout() {
        return this.tipoLayout;
    }

    public void setTipoLayout(String tipoLayout) {
        this.tipoLayout = tipoLayout;
    }

    public TipoNI getIndicadorNi() {
        return this.indicadorNi;
    }

    public void setIndicadorNi(TipoNI indicadorNi) {
        this.indicadorNi = indicadorNi;
    }

    public String getTipoDeclaracao() {
        return this.tipoDeclaracao;
    }

    public void setTipoDeclaracao(String tipoDeclaracao) {
        this.tipoDeclaracao = tipoDeclaracao;
    }

    public String getNumeroOficial() {
        return this.numeroOficial;
    }

    public void setNumeroOficial(String hashCode) {
        this.numeroOficial = hashCode;
    }

    public void setParametrosRequisicao(String parametrosRequisicao) {
        this.parametrosRequisicao = parametrosRequisicao;
    }

    public String getParametrosRequisicao() {
        return this.parametrosRequisicao;
    }

    public boolean getParametroFichasAfirmativo() {
        return this.parametroFichasAfirmativo;
    }

    public void setParametroFichasAfirmativo(boolean parametroFichasAfirmativo) {
        this.parametroFichasAfirmativo = parametroFichasAfirmativo;
    }

    public void setAtivas(String ativas) {
        this.ativas = ativas;
    }

    public String getAtivas() {
        return this.ativas;
    }

    public boolean isRequisicaoWebService() {
        return this.requisicaoWebService;
    }

    public boolean isViaArquivoDEC() {
        return this.parametrosFiltro.length > 0 && "FILE".equals(this.parametrosFiltro[1]);
    }

    public String getCaminhoArquivoDEC() {
        return this.parametrosFiltro.length > 1 ? this.parametrosFiltro[2] : null;
    }

    public void setRequisicaoWebService(boolean requisicaoWebService) {
        this.requisicaoWebService = requisicaoWebService;
    }

    public String getTextoDeclaracao() {
        return this.textoDeclaracao;
    }

    public void setTextoDeclaracao(String textoDeclaracao) {
        this.textoDeclaracao = textoDeclaracao;
    }

    public String getTextoRecibo() {
        return this.textoRecibo;
    }

    public void setTextoRecibo(String textoRecibo) {
        this.textoRecibo = textoRecibo;
    }

    public String getUaUsuario() {
        return this.uaUsuario;
    }

    public void setUaUsuario(String uaUsuario) {
        this.uaUsuario = uaUsuario;
    }

    public String toString() {
        return "Solicitacao [aplicacao=" + this.aplicacao + ", nomeUsuario=" + this.nomeUsuario + ", cpfUsuario=" + this.cpfUsuario + ", ipUsuario=" + this.ipUsuario + ", uaUsuario=" + this.uaUsuario + ", tipoDeclaracao=" + this.tipoDeclaracao + ", niPesquisado=" + this.niPesquisado + ", indicadorNi=" + (Object)((Object)this.indicadorNi) + ", exercicio=" + this.exercicio + ", indiceTipo=" + this.indiceTipo + ", tipoLayout=" + this.tipoLayout + ", ativas=" + this.ativas + ", parametroFichas=" + this.parametroFichas + ", layoutAtual=" + this.layoutAtual + ", comandoGP=" + this.comandoGP + ", parametrosIdentificadores=" + Arrays.toString(this.parametrosIdentificadores) + ", parametrosFiltro=" + Arrays.toString(this.parametrosFiltro) + ", parametrosGP=" + this.parametrosGP + ", parametrosWS=" + this.parametrosWS + ", todosParametros=" + Arrays.toString(this.todosParametros) + ", numeroOficial=" + this.numeroOficial + ", parametrosRequisicao=" + this.parametrosRequisicao + ", parametroFichasAfirmativo=" + this.parametroFichasAfirmativo + ", requisicaoWebService=" + this.requisicaoWebService + ", textoDeclaracao=" + this.textoDeclaracao + ", textoRecibo=" + this.textoRecibo + "]";
    }

    public String getIdentificacaoUsuario() {
        return this.identificacaoUsuario;
    }

    public void setIdentificacaoUsuario(String identificacaoUsuario) {
        this.identificacaoUsuario = identificacaoUsuario;
    }
}

