/*
 * Decompiled with CFR 0.152.
 */
package net.glxn.qrgen.core.scheme;

import java.util.Map;
import net.glxn.qrgen.core.scheme.SchemeUtil;
import net.glxn.qrgen.core.scheme.Wifi;

public class EnterpriseWifi
extends Wifi {
    public static final String USER = "U";
    public static final String EAP = "E";
    public static final String PHASE = "PH";
    private String user;
    private String eap;
    private String phase;

    public static EnterpriseWifi parse(String wifiCode) {
        if (wifiCode == null || !wifiCode.startsWith("WIFI:")) {
            throw new IllegalArgumentException("this is not a valid WIFI code: " + wifiCode);
        }
        EnterpriseWifi wifi = new EnterpriseWifi();
        Map<String, String> parameters = SchemeUtil.getParameters(wifiCode.substring("WIFI:".length()), "(?<!\\\\);");
        if (parameters.containsKey("S")) {
            wifi.setSsid(EnterpriseWifi.unescape(parameters.get("S")));
        }
        if (parameters.containsKey("P")) {
            wifi.setPsk(EnterpriseWifi.unescape(parameters.get("P")));
        }
        if (parameters.containsKey(USER)) {
            wifi.setUser(EnterpriseWifi.unescape(parameters.get(USER)));
        }
        if (parameters.containsKey(EAP)) {
            wifi.setEap(EnterpriseWifi.unescape(parameters.get(EAP)));
        }
        if (parameters.containsKey(PHASE)) {
            wifi.setPhase(EnterpriseWifi.unescape(parameters.get(PHASE)));
        }
        if (parameters.containsKey("H")) {
            wifi.setHidden(parameters.get("H"));
        }
        return wifi;
    }

    public static String escape(String text) {
        return text.replace("\\", "\\\\").replace(",", "\\,").replace(";", "\\;").replace(".", "\\.").replace("\"", "\\\"").replace("'", "\\'");
    }

    public static String unescape(String text) {
        return text.replace("\\\\", "\\").replace("\\,", ",").replace("\\;", ";").replace("\\.", ".").replace("\\\"", "\"").replace("\\'", "'");
    }

    public EnterpriseWifi withUser(String user) {
        this.user = user;
        return this;
    }

    public void setUser(String user) {
        this.withUser(user);
    }

    public String getUser() {
        return this.user;
    }

    public EnterpriseWifi withEap(String eap) {
        this.eap = eap;
        return this;
    }

    public void setEap(String eap) {
        this.withEap(eap);
    }

    public String getEap() {
        return this.eap;
    }

    public EnterpriseWifi withPhase(String phase) {
        this.phase = phase;
        return this;
    }

    public void setPhase(String phase) {
        this.withPhase(phase);
    }

    public String getPhase() {
        return this.phase;
    }

    @Override
    public String toString() {
        StringBuilder bob = new StringBuilder("WIFI:");
        if (this.getSsid() != null) {
            bob.append("S").append(":").append(EnterpriseWifi.escape(this.getSsid())).append(";");
        }
        if (this.getUser() != null) {
            bob.append(USER).append(":").append(EnterpriseWifi.escape(this.getUser())).append(";");
        }
        if (this.getPsk() != null) {
            bob.append("P").append(":").append(EnterpriseWifi.escape(this.getPsk())).append(";");
        }
        if (this.getEap() != null) {
            bob.append(EAP).append(":").append(EnterpriseWifi.escape(this.getEap())).append(";");
        }
        if (this.getPhase() != null) {
            bob.append(PHASE).append(":").append(EnterpriseWifi.escape(this.getPhase())).append(";");
        }
        bob.append("H").append(":").append(this.isHidden()).append(";");
        return bob.toString();
    }
}

