/*
 * Decompiled with CFR 0.152.
 */
package net.glxn.qrgen.core.scheme;

import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Set;
import net.glxn.qrgen.core.scheme.Girocode;
import net.glxn.qrgen.core.scheme.QRCodeSchemeParser;
import net.glxn.qrgen.core.scheme.VCard;
import net.glxn.qrgen.core.scheme.Wifi;

public class ExtendableQRCodeSchemeParser
implements QRCodeSchemeParser {
    private Set<QRCodeSchemeParser> parser;

    @Override
    public Set<Class<?>> getSupportedSchemes() {
        LinkedHashSet supportedSchemes = new LinkedHashSet();
        for (QRCodeSchemeParser parser : this.getParser()) {
            supportedSchemes.addAll(parser.getSupportedSchemes());
        }
        return supportedSchemes;
    }

    @Override
    public Object parse(String qrCodeText) throws UnsupportedEncodingException {
        for (QRCodeSchemeParser parser : this.getParser()) {
            try {
                return parser.parse(qrCodeText);
            }
            catch (UnsupportedEncodingException e) {
            }
        }
        throw new UnsupportedEncodingException("unkonwn QR code scheme: " + qrCodeText);
    }

    protected Set<QRCodeSchemeParser> getParser() {
        if (this.parser == null) {
            this.parser = this.loadParser();
        }
        return this.parser;
    }

    protected Set<QRCodeSchemeParser> loadParser() {
        LinkedHashSet<QRCodeSchemeParser> result = new LinkedHashSet<QRCodeSchemeParser>();
        try {
            Enumeration<URL> resources = this.getClass().getClassLoader().getResources("META-INF/qrcode.meta");
            for (URL url : Collections.list(resources)) {
                Properties properties = new Properties();
                InputStream is = url.openStream();
                Throwable throwable = null;
                try {
                    String[] parserNames;
                    properties.load(is);
                    String prop = properties.getProperty(QRCodeSchemeParser.class.getName());
                    for (String className : parserNames = prop.split(",")) {
                        result.add(this.createParserInstance(className));
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (is == null) continue;
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    is.close();
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("failed to load schemes", e);
        }
        result.add(new QRCodeSchemeParserImpl());
        return result;
    }

    protected QRCodeSchemeParser createParserInstance(String className) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        Class<?> clazz = Class.forName(className.trim());
        return (QRCodeSchemeParser)clazz.newInstance();
    }

    static class QRCodeSchemeParserImpl
    implements QRCodeSchemeParser {
        QRCodeSchemeParserImpl() {
        }

        @Override
        public Object parse(String qrCodeText) throws UnsupportedEncodingException {
            for (Class<?> type : this.getSupportedSchemes()) {
                Object instance = this.createInstance(qrCodeText, type);
                if (instance == null) continue;
                return instance;
            }
            throw new UnsupportedEncodingException("unkonwn QR code scheme: " + qrCodeText);
        }

        protected Object createInstance(String qrCodeText, Class<?> type) {
            try {
                if (VCard.class.equals(type)) {
                    return VCard.parse(qrCodeText);
                }
                if (Girocode.class.equals(type)) {
                    return Girocode.parse(qrCodeText);
                }
                if (Wifi.class.equals(type)) {
                    return Wifi.parse(qrCodeText);
                }
                if (URL.class.equals(type)) {
                    return new URL(qrCodeText);
                }
                return null;
            }
            catch (Exception e) {
                return null;
            }
        }

        @Override
        public Set<Class<?>> getSupportedSchemes() {
            LinkedHashSet supportedSchemes = new LinkedHashSet();
            supportedSchemes.add(Girocode.class);
            supportedSchemes.add(VCard.class);
            supportedSchemes.add(Wifi.class);
            supportedSchemes.add(URL.class);
            return supportedSchemes;
        }
    }
}

