/*
 * Decompiled with CFR 0.152.
 */
package net.glxn.qrgen.core.scheme;

import java.util.Map;
import net.glxn.qrgen.core.scheme.SchemeUtil;

public class Wifi {
    public static final String WIFI_PROTOCOL_HEADER = "WIFI:";
    public static final String AUTHENTICATION = "T";
    public static final String SSID = "S";
    public static final String PSK = "P";
    public static final String HIDDEN = "H";
    private String authentication;
    private String ssid;
    private String psk;
    private boolean hidden = false;

    public static Wifi parse(String wifiCode) {
        if (wifiCode == null || !wifiCode.startsWith(WIFI_PROTOCOL_HEADER)) {
            throw new IllegalArgumentException("this is not a valid WIFI code: " + wifiCode);
        }
        Wifi wifi = new Wifi();
        Map<String, String> parameters = SchemeUtil.getParameters(wifiCode.substring(WIFI_PROTOCOL_HEADER.length()), "(?<!\\\\);");
        if (parameters.containsKey(SSID)) {
            wifi.setSsid(Wifi.unescape(parameters.get(SSID)));
        }
        if (parameters.containsKey(AUTHENTICATION)) {
            wifi.setAuthentication(parameters.get(AUTHENTICATION));
        }
        if (parameters.containsKey(PSK)) {
            wifi.setPsk(Wifi.unescape(parameters.get(PSK)));
        }
        if (parameters.containsKey(HIDDEN)) {
            wifi.setHidden(parameters.get(HIDDEN));
        }
        return wifi;
    }

    public static String escape(String text) {
        return text.replace("\\", "\\\\").replace(",", "\\,").replace(";", "\\;").replace(".", "\\.").replace("\"", "\\\"").replace("'", "\\'");
    }

    public static String unescape(String text) {
        return text.replace("\\\\", "\\").replace("\\,", ",").replace("\\;", ";").replace("\\.", ".").replace("\\\"", "\"").replace("\\'", "'");
    }

    public String getAuthentication() {
        return this.authentication;
    }

    public void setAuthentication(Authentication authentication) {
        this.setAuthentication(authentication.toString());
    }

    public void setAuthentication(String authentication) {
        this.authentication = authentication;
    }

    public Wifi withAuthentication(Authentication authentication) {
        this.setAuthentication(authentication);
        return this;
    }

    public String getSsid() {
        return this.ssid;
    }

    public void setSsid(String ssid) {
        this.ssid = ssid;
    }

    public Wifi withSsid(String ssid) {
        this.setSsid(ssid);
        return this;
    }

    public String getPsk() {
        return this.psk;
    }

    public void setPsk(String psk) {
        this.psk = psk;
    }

    public Wifi withPsk(String psk) {
        this.setPsk(psk);
        return this;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(String value) {
        this.setHidden(Boolean.valueOf(value));
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public Wifi withHidden(boolean hidden) {
        this.setHidden(hidden);
        return this;
    }

    public String toString() {
        StringBuilder bob = new StringBuilder(WIFI_PROTOCOL_HEADER);
        if (this.getSsid() != null) {
            bob.append(SSID).append(":").append(Wifi.escape(this.getSsid())).append(";");
        }
        if (this.getAuthentication() != null) {
            bob.append(AUTHENTICATION).append(":").append(this.getAuthentication()).append(";");
        }
        if (this.getPsk() != null) {
            bob.append(PSK).append(":").append(Wifi.escape(this.getPsk())).append(";");
        }
        bob.append(HIDDEN).append(":").append(this.isHidden()).append(";");
        return bob.toString();
    }

    public static enum Authentication {
        WEP,
        WPA,
        nopass;

    }
}

