/*
 * Decompiled with CFR 0.152.
 */
package jsignnet.gui;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.text.DateFormat;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import jsignnet.aplicacao.JSignNet;
import jsignnet.crypto.X509CertificadoWrapper;
import jsignnet.erro.ErroDeES;
import jsignnet.erro.JSignException;
import jsignnet.gui.ViewCertificadoPropriedadeTreeNode;
import jsignnet.gui.ViewCertificadoTreeNode;
import jsignnet.infra.FormataUtil;
import jsignnet.infra.Recursos;

public class ViewCertificado
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JPanel painelBotaoOk;
    private JButton botaoOk;
    private JTabbedPane jtp;
    private X509CertificadoWrapper listaCertificados;
    private JScrollPane painelPropriedade;
    private JTextArea valorPropriedade;
    private JTree arvorePropriedades;

    public ViewCertificado(Dialog parent, String titulo, boolean isModal, X509CertificadoWrapper certificado) {
        super(parent, titulo, isModal);
        this.listaCertificados = certificado;
        this.inicializaComponentes();
    }

    public ViewCertificado(Frame parent, String titulo, boolean isModal, X509CertificadoWrapper certificado) {
        super(parent, titulo, isModal);
        this.listaCertificados = certificado;
        this.inicializaComponentes();
    }

    private void inicializaComponentes() {
        int largura = 500;
        int altura = 300;
        Dimension tamanhoPainelScroll = new Dimension(largura, altura / 4);
        JPanel painelDadosCertificado = new JPanel();
        GridBagLayout layoutDadosCertificado = new GridBagLayout();
        painelDadosCertificado.setLayout(layoutDadosCertificado);
        GridBagConstraints constraintDadosCertificado = new GridBagConstraints();
        constraintDadosCertificado.gridx = 0;
        constraintDadosCertificado.gridy = 0;
        constraintDadosCertificado.gridwidth = 3;
        constraintDadosCertificado.gridheight = 1;
        constraintDadosCertificado.insets = new Insets(14, 8, 2, 8);
        constraintDadosCertificado.anchor = 18;
        painelDadosCertificado.add((Component)new JLabel(Recursos.getString("MostraCertificado.labelEmitidoPara.texto")), constraintDadosCertificado);
        String[] campos = new String[]{Recursos.getString("MostraCertificado.campoNome.texto"), Recursos.getString("MostraCertificado.campoOrganizacao.texto"), Recursos.getString("MostraCertificado.campoUnidadeOrganizacional.texto"), Recursos.getString("MostraCertificado.campoSerie.texto"), Recursos.getString("MostraCertificado.campoKeystore.texto")};
        String[] valores = new String[]{this.listaCertificados.getEmitidoPara(), this.listaCertificados.getOrganizacao(), this.listaCertificados.getUnidadeOrganizacional(), this.listaCertificados.getSerie(), this.listaCertificados.getTipoKeyStore()};
        String[] tooltips = new String[]{Recursos.getString("MostraCertificado.campoNome.tooltip"), Recursos.getString("MostraCertificado.campoOrganizacao.tooltip"), Recursos.getString("MostraCertificado.campoUnidadeOrganizacional.tooltip"), Recursos.getString("MostraCertificado.campoSerie.tooltip")};
        this.formataFormulario(painelDadosCertificado, constraintDadosCertificado, campos, valores, tooltips);
        constraintDadosCertificado.gridx = 0;
        ++constraintDadosCertificado.gridy;
        constraintDadosCertificado.gridwidth = 3;
        constraintDadosCertificado.gridheight = 1;
        constraintDadosCertificado.insets = new Insets(14, 8, 2, 8);
        constraintDadosCertificado.anchor = 18;
        painelDadosCertificado.add((Component)new JLabel(Recursos.getString("MostraCertificado.labelEmitidoPor.texto")), constraintDadosCertificado);
        campos = new String[]{Recursos.getString("MostraCertificado.campoNome.texto"), Recursos.getString("MostraCertificado.campoOrganizacao.texto"), Recursos.getString("MostraCertificado.campoUnidadeOrganizacional.texto")};
        valores = new String[]{this.listaCertificados.getEmitidoPor(), this.listaCertificados.getOrganizacaoEmissora(), this.listaCertificados.getUnidadeOrganizacionalEmissora()};
        tooltips = new String[]{Recursos.getString("MostraCertificado.campoNome.tooltip"), Recursos.getString("MostraCertificado.campoOrganizacao.tooltip"), Recursos.getString("MostraCertificado.campoUnidadeOrganizacional.tooltip")};
        this.formataFormulario(painelDadosCertificado, constraintDadosCertificado, campos, valores, tooltips);
        constraintDadosCertificado.gridx = 0;
        ++constraintDadosCertificado.gridy;
        constraintDadosCertificado.gridwidth = 3;
        constraintDadosCertificado.gridheight = 1;
        constraintDadosCertificado.insets = new Insets(14, 8, 2, 8);
        constraintDadosCertificado.anchor = 18;
        painelDadosCertificado.add((Component)new JLabel(Recursos.getString("MostraCertificado.labelValidade.texto")), constraintDadosCertificado);
        campos = new String[]{Recursos.getString("MostraCertificado.campoDataEmissao.texto"), Recursos.getString("MostraCertificado.campoDataExpiracao.texto")};
        valores = new String[]{DateFormat.getDateInstance(2).format(this.listaCertificados.getDataEmissao()), DateFormat.getDateInstance(2).format(this.listaCertificados.getDataVencimento())};
        tooltips = new String[]{Recursos.getString("MostraCertificado.campoDataEmissao.tooltip"), Recursos.getString("MostraCertificado.campoDataExpiracao.tooltip")};
        this.formataFormulario(painelDadosCertificado, constraintDadosCertificado, campos, valores, tooltips);
        constraintDadosCertificado.gridx = 0;
        ++constraintDadosCertificado.gridy;
        constraintDadosCertificado.gridwidth = 3;
        constraintDadosCertificado.gridheight = 1;
        constraintDadosCertificado.insets = new Insets(14, 8, 2, 8);
        constraintDadosCertificado.anchor = 18;
        painelDadosCertificado.add((Component)new JLabel(Recursos.getString("MostraCertificado.labelImpressao.texto")), constraintDadosCertificado);
        campos = new String[]{Recursos.getString("MostraCertificado.campoImpressaoDigitalSHA.texto"), Recursos.getString("MostraCertificado.campoImpressaoDigitalMD5.texto")};
        try {
            valores = new String[]{this.listaCertificados.getSHA1FingerPrint(), this.listaCertificados.getMD5FingerPrint()};
        }
        catch (JSignException e) {
            JSignNet.logger.warning("Erro calculando o thumbprint do certificado " + this.listaCertificados.getAlias());
        }
        tooltips = new String[]{Recursos.getString("MostraCertificado.campoImpressaoDigitalSHA.tooltip"), Recursos.getString("MostraCertificado.campoImpressaoDigitalMD5.tooltip")};
        this.formataFormulario(painelDadosCertificado, constraintDadosCertificado, campos, valores, tooltips);
        this.painelBotaoOk = new JPanel(new FlowLayout(2));
        this.botaoOk = new JButton(Recursos.getString("MostraCertificado.botaoOK.texto"));
        this.botaoOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ViewCertificado.this.fechaJanela();
            }
        });
        JTree arvoreHierarquia = null;
        ViewCertificadoTreeNode folha = null;
        ViewCertificadoTreeNode temp = null;
        X509CertificadoWrapper[] lista = this.listaCertificados.getCadeiaCertificadosWrapper();
        for (int i = 0; i < lista.length; ++i) {
            folha = new ViewCertificadoTreeNode(lista[i]);
            if (temp != null) {
                folha.add(temp);
            }
            temp = folha;
        }
        arvoreHierarquia = new JTree(temp);
        arvoreHierarquia.getSelectionModel().setSelectionMode(1);
        arvoreHierarquia.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent tse) {
                TreePath tp = tse.getNewLeadSelectionPath();
                if (tp.getLastPathComponent() instanceof ViewCertificadoTreeNode) {
                    int[] selecao = ViewCertificado.this.arvorePropriedades.getSelectionRows();
                    ViewCertificado.this.populaPropriedades((ViewCertificadoTreeNode)tp.getLastPathComponent());
                    ViewCertificado.this.arvorePropriedades.setSelectionRows(selecao);
                }
            }
        });
        JScrollPane painelHierarquia = new JScrollPane(arvoreHierarquia, 20, 30);
        painelHierarquia.setPreferredSize(tamanhoPainelScroll);
        DefaultMutableTreeNode rootPropriedades = new DefaultMutableTreeNode("Certificado");
        DefaultTreeModel model = new DefaultTreeModel(rootPropriedades);
        this.arvorePropriedades = new JTree(model);
        this.arvorePropriedades.getSelectionModel().setSelectionMode(1);
        this.arvorePropriedades.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent tse) {
                TreePath tp = tse.getNewLeadSelectionPath();
                if (tp != null && tp.getLastPathComponent() instanceof ViewCertificadoPropriedadeTreeNode) {
                    ViewCertificado.this.valorPropriedade.setText(((ViewCertificadoPropriedadeTreeNode)tp.getLastPathComponent()).getValor());
                }
            }
        });
        this.arvorePropriedades.setRootVisible(false);
        this.painelPropriedade = new JScrollPane(this.arvorePropriedades);
        this.painelPropriedade.setPreferredSize(tamanhoPainelScroll);
        this.painelPropriedade.setAutoscrolls(true);
        this.valorPropriedade = new JTextArea();
        this.valorPropriedade.setEditable(false);
        JScrollPane painelValorPropriedade = new JScrollPane(this.valorPropriedade);
        painelValorPropriedade.setPreferredSize(tamanhoPainelScroll);
        painelValorPropriedade.setAutoscrolls(true);
        JPanel painelDadosPropriedades = new JPanel();
        GridBagLayout layoutDadosPropriedade = new GridBagLayout();
        painelDadosPropriedades.setLayout(layoutDadosPropriedade);
        GridBagConstraints constraintDadosPropriedade = new GridBagConstraints();
        constraintDadosPropriedade.gridx = 0;
        constraintDadosPropriedade.gridy = 0;
        constraintDadosPropriedade.gridwidth = 1;
        constraintDadosPropriedade.gridheight = 1;
        constraintDadosPropriedade.weightx = 0.0;
        constraintDadosPropriedade.weighty = 0.0;
        constraintDadosPropriedade.insets = new Insets(14, 8, 2, 8);
        constraintDadosPropriedade.fill = 1;
        constraintDadosPropriedade.anchor = 10;
        painelDadosPropriedades.add((Component)new JLabel(Recursos.getString("MostraCertificado.labelHierarquiaCertificado.texto")), constraintDadosPropriedade);
        constraintDadosPropriedade.gridx = 0;
        constraintDadosPropriedade.gridy = 1;
        constraintDadosPropriedade.gridwidth = 1;
        constraintDadosPropriedade.gridheight = 1;
        constraintDadosPropriedade.weightx = 1.0;
        constraintDadosPropriedade.weighty = 1.0;
        constraintDadosPropriedade.insets = new Insets(2, 8, 2, 8);
        constraintDadosPropriedade.fill = 1;
        constraintDadosPropriedade.anchor = 10;
        painelDadosPropriedades.add((Component)painelHierarquia, constraintDadosPropriedade);
        constraintDadosPropriedade.gridx = 0;
        constraintDadosPropriedade.gridy = 2;
        constraintDadosPropriedade.weightx = 1.0;
        constraintDadosPropriedade.weighty = 1.0;
        constraintDadosPropriedade.weightx = 0.0;
        constraintDadosPropriedade.weighty = 0.0;
        constraintDadosPropriedade.insets = new Insets(14, 8, 2, 8);
        constraintDadosPropriedade.fill = 1;
        constraintDadosPropriedade.anchor = 10;
        painelDadosPropriedades.add((Component)new JLabel(Recursos.getString("MostraCertificado.labelPropriedadeCertificado.texto")), constraintDadosPropriedade);
        constraintDadosPropriedade.gridx = 0;
        constraintDadosPropriedade.gridy = 3;
        constraintDadosPropriedade.gridwidth = 1;
        constraintDadosPropriedade.gridheight = 1;
        constraintDadosPropriedade.weightx = 1.0;
        constraintDadosPropriedade.weighty = 1.0;
        constraintDadosPropriedade.insets = new Insets(2, 8, 2, 8);
        constraintDadosPropriedade.anchor = 10;
        painelDadosPropriedades.add((Component)this.painelPropriedade, constraintDadosPropriedade);
        constraintDadosPropriedade.gridx = 0;
        constraintDadosPropriedade.gridy = 4;
        constraintDadosPropriedade.gridwidth = 1;
        constraintDadosPropriedade.gridheight = 1;
        constraintDadosPropriedade.weightx = 0.0;
        constraintDadosPropriedade.weighty = 0.0;
        constraintDadosPropriedade.insets = new Insets(14, 8, 2, 8);
        constraintDadosPropriedade.fill = 1;
        constraintDadosPropriedade.anchor = 10;
        painelDadosPropriedades.add((Component)new JLabel(Recursos.getString("MostraCertificado.labelValorCertificado.texto")), constraintDadosPropriedade);
        constraintDadosPropriedade.gridx = 0;
        constraintDadosPropriedade.gridy = 5;
        constraintDadosPropriedade.gridwidth = 1;
        constraintDadosPropriedade.gridheight = 1;
        constraintDadosPropriedade.weightx = 1.0;
        constraintDadosPropriedade.weighty = 1.0;
        constraintDadosPropriedade.insets = new Insets(2, 8, 2, 8);
        constraintDadosPropriedade.fill = 1;
        constraintDadosPropriedade.anchor = 10;
        painelDadosPropriedades.add((Component)painelValorPropriedade, constraintDadosPropriedade);
        this.painelBotaoOk.add(this.botaoOk);
        this.jtp = new JTabbedPane();
        this.jtp.addTab(Recursos.getString("MostraCertificado.tab1.label"), painelDadosCertificado);
        this.jtp.addTab(Recursos.getString("MostraCertificado.tab2.label"), painelDadosPropriedades);
        this.getContentPane().add((Component)this.jtp, "Center");
        this.getContentPane().add((Component)this.painelBotaoOk, "South");
        this.setResizable(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ViewCertificado.this.fechaJanela();
            }
        });
        this.getRootPane().setDefaultButton(this.botaoOk);
        this.pack();
        this.setDefaultCloseOperation(0);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ViewCertificado.this.botaoOk.requestFocus();
            }
        });
    }

    public void formataFormulario(JPanel painel, GridBagConstraints gridBagConstraints, String[] labels, String[] valores, String[] tootips) {
        if (labels.length != valores.length) {
            throw new RuntimeException("Erro de parametros.");
        }
        int valorY = gridBagConstraints.gridy + 1;
        for (int i = 0; i < labels.length; ++i) {
            JLabel lab = new JLabel(labels[i], 2);
            if (i < tootips.length) {
                lab.setToolTipText(tootips[i]);
            }
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = valorY + i;
            gridBagConstraints.insets = new Insets(0, 8, 2, 8);
            painel.add((Component)lab, gridBagConstraints);
            JLabel valor = new JLabel(valores[i], 2);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.insets = new Insets(0, 8, 2, 8);
            painel.add((Component)valor, gridBagConstraints);
        }
    }

    private void fechaJanela() {
        this.setVisible(false);
        this.dispose();
    }

    private void populaPropriedades(ViewCertificadoTreeNode node) {
        TreePath path = this.arvorePropriedades.getSelectionPath();
        DefaultTreeModel model = (DefaultTreeModel)this.arvorePropriedades.getModel();
        DefaultMutableTreeNode rootPropriedades = (DefaultMutableTreeNode)model.getRoot();
        rootPropriedades.removeAllChildren();
        rootPropriedades.insert(new ViewCertificadoPropriedadeTreeNode("Vers\u00e3o", node.getCertificado().getVersao()), 0);
        rootPropriedades.insert(new ViewCertificadoPropriedadeTreeNode("N\u00famero de S\u00e9rie", node.getCertificado().getSerie()), 1);
        rootPropriedades.insert(new ViewCertificadoPropriedadeTreeNode("Algoritmo de Assinatura", node.getCertificado().getAlgoritmo()), 2);
        rootPropriedades.insert(new ViewCertificadoPropriedadeTreeNode("Emissor", node.getCertificado().getEmitidoPor()), 3);
        ViewCertificadoPropriedadeTreeNode validade = new ViewCertificadoPropriedadeTreeNode("Validade", "");
        validade.add(new ViewCertificadoPropriedadeTreeNode("Data de Emiss\u00e3o", FormataUtil.formataData(node.getCertificado().getDataEmissao())));
        validade.add(new ViewCertificadoPropriedadeTreeNode("Data de Vencimento", FormataUtil.formataData(node.getCertificado().getDataVencimento())));
        rootPropriedades.insert(validade, 4);
        rootPropriedades.insert(new ViewCertificadoPropriedadeTreeNode("Assunto", node.getCertificado().getAssuntoPrincipal()), 5);
        ViewCertificadoPropriedadeTreeNode informacoesChavePublica = new ViewCertificadoPropriedadeTreeNode("Informa\u00e7\u00f5es de Chave P\u00fablica", "");
        informacoesChavePublica.add(new ViewCertificadoPropriedadeTreeNode("Algoritmo de Chave P\u00fablica", node.getCertificado().getChavePublica().getAlgorithm()));
        informacoesChavePublica.add(new ViewCertificadoPropriedadeTreeNode("Chave P\u00fablica", node.getCertificado().getChavePublica().toString()));
        rootPropriedades.insert(informacoesChavePublica, 6);
        try {
            ViewCertificadoPropriedadeTreeNode informacoesExtensao = new ViewCertificadoPropriedadeTreeNode("Extens\u00f5es", "");
            informacoesExtensao.add(new ViewCertificadoPropriedadeTreeNode("Identificador da Chave da Autoridade", node.getCertificado().getIdentificadorChaveAutoridade()));
            informacoesExtensao.add(new ViewCertificadoPropriedadeTreeNode("Uso da chave", node.getCertificado().getUsoChave()));
            informacoesExtensao.add(new ViewCertificadoPropriedadeTreeNode("Nome alternativo para assunto", node.getCertificado().getNomesAlternativos()));
            rootPropriedades.insert(informacoesExtensao, 7);
            ViewCertificadoPropriedadeTreeNode diretivasCertificados = new ViewCertificadoPropriedadeTreeNode("Diretivas dos Certificados", "");
            diretivasCertificados.add(new ViewCertificadoPropriedadeTreeNode("Ponto de Distribui\u00e7\u00e3o da Lista de Certificados Revogados", node.getCertificado().getPontoDistribuicaoCRL()));
            diretivasCertificados.add(new ViewCertificadoPropriedadeTreeNode("Uso Avan\u00e7ado da Chave", node.getCertificado().getUsoAvancadoChave()));
            rootPropriedades.insert(diretivasCertificados, 8);
        }
        catch (IOException e) {
            JSignNet.logger.warning("Exce\u00e7\u00e3o de IO acessando propriedades do certficado " + node.getCertificado().getAlias());
        }
        catch (ErroDeES e) {
            JSignNet.logger.warning("Exce\u00e7\u00e3o de IO acessando propriedades do certficado " + node.getCertificado().getAlias());
        }
        model.reload();
        this.arvorePropriedades.setRootVisible(true);
        this.expandAll(this.arvorePropriedades);
        this.arvorePropriedades.addSelectionPath(path);
        this.arvorePropriedades.setLeadSelectionPath(path);
    }

    public void expandAll(JTree tree) {
        for (int row = 0; row < tree.getRowCount(); ++row) {
            tree.expandRow(row);
        }
    }
}

