/*
 * Decompiled with CFR 0.152.
 */
package jsignnet.infra;

import java.util.StringTokenizer;
import jsignnet.erro.ErroParserVersaoJava;

public class VersaoJava
implements Comparable<Object> {
    private String versaoJava;
    private int numeroVersaoMaior;
    private int numeroVersaoIntermediaria;
    private int numeroVersaoMenor;
    private int numeroVersaoAtualizacao;
    private String numeroIdentificadorVersao;
    private char DELIMITADOR_VERSAO = (char)46;
    private char DELIMITADOR_INICIO_ATUALIZACAO = (char)95;
    private char DELIMITADOR_INICIO_IDENTIFICADOR = (char)45;

    public VersaoJava() throws ErroParserVersaoJava {
        this(System.getProperty("java.version"));
    }

    public VersaoJava(String verJava) throws ErroParserVersaoJava {
        this.versaoJava = verJava;
        int indiceAtualizacao = this.versaoJava.indexOf(this.DELIMITADOR_INICIO_ATUALIZACAO);
        int indiceIdentificador = this.versaoJava.indexOf(this.DELIMITADOR_INICIO_IDENTIFICADOR);
        String versao = null;
        String atualizacao = "0";
        String identificador = null;
        if (indiceAtualizacao == -1 && indiceIdentificador == -1) {
            versao = this.versaoJava;
        } else if (indiceAtualizacao != -1 && indiceIdentificador == -1) {
            versao = this.versaoJava.substring(0, indiceAtualizacao);
            atualizacao = this.versaoJava.substring(indiceAtualizacao + 1);
        } else if (indiceAtualizacao == -1 && indiceIdentificador != -1) {
            versao = this.versaoJava.substring(0, indiceIdentificador);
            identificador = this.versaoJava.substring(indiceIdentificador + 1);
        } else {
            versao = this.versaoJava.substring(0, indiceAtualizacao);
            atualizacao = this.versaoJava.substring(indiceAtualizacao + 1, indiceIdentificador);
            identificador = this.versaoJava.substring(indiceIdentificador + 1);
        }
        StringTokenizer token = new StringTokenizer(versao, "" + this.DELIMITADOR_VERSAO);
        if (token.countTokens() != 3) {
            throw new ErroParserVersaoJava();
        }
        try {
            String versaoMaior = token.nextToken();
            this.numeroVersaoMaior = Integer.parseInt(versaoMaior);
            if (this.numeroVersaoMaior < 0) {
                throw new ErroParserVersaoJava();
            }
            String versaoIntermediaria = token.nextToken();
            this.numeroVersaoIntermediaria = Integer.parseInt(versaoIntermediaria);
            if (this.numeroVersaoIntermediaria < 0) {
                throw new ErroParserVersaoJava();
            }
            String versaoMenor = token.nextToken();
            this.numeroVersaoMenor = Integer.parseInt(versaoMenor);
            if (this.numeroVersaoMenor < 0) {
                throw new ErroParserVersaoJava();
            }
            this.numeroVersaoAtualizacao = Integer.parseInt(atualizacao);
        }
        catch (NumberFormatException ex) {
            throw new ErroParserVersaoJava(ex);
        }
        if (this.numeroVersaoAtualizacao < 0) {
            throw new ErroParserVersaoJava();
        }
        this.numeroIdentificadorVersao = identificador;
    }

    public int getNumeroVersaoMaior() {
        return this.numeroVersaoMaior;
    }

    public int getNumeroVersaoIntermediaria() {
        return this.numeroVersaoIntermediaria;
    }

    public int getNumeroVersaoMenor() {
        return this.numeroVersaoMenor;
    }

    public int getNumeroAtualizacao() {
        return this.numeroVersaoAtualizacao;
    }

    @Override
    public int compareTo(Object objetoComparacao) {
        VersaoJava cmpJavaVersion = (VersaoJava)objetoComparacao;
        if (this.numeroVersaoMaior > cmpJavaVersion.getNumeroVersaoMaior()) {
            return 1;
        }
        if (this.numeroVersaoMaior < cmpJavaVersion.getNumeroVersaoMaior()) {
            return -1;
        }
        if (this.numeroVersaoIntermediaria > cmpJavaVersion.getNumeroVersaoIntermediaria()) {
            return 1;
        }
        if (this.numeroVersaoIntermediaria < cmpJavaVersion.getNumeroVersaoIntermediaria()) {
            return -1;
        }
        if (this.numeroVersaoMenor > cmpJavaVersion.getNumeroVersaoMenor()) {
            return 1;
        }
        if (this.numeroVersaoMenor < cmpJavaVersion.getNumeroVersaoMenor()) {
            return -1;
        }
        if (this.numeroVersaoAtualizacao > cmpJavaVersion.getNumeroAtualizacao()) {
            return 1;
        }
        if (this.numeroVersaoAtualizacao < cmpJavaVersion.getNumeroAtualizacao()) {
            return -1;
        }
        String sCmpIdentifier = cmpJavaVersion.getNumeroIdentificadorVersao();
        if (this.numeroIdentificadorVersao == null && sCmpIdentifier != null) {
            return 1;
        }
        if (this.numeroIdentificadorVersao != null && sCmpIdentifier == null) {
            return -1;
        }
        return 0;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof VersaoJava)) {
            return false;
        }
        return this.compareTo(object) == 0;
    }

    public int hashCode() {
        int resultado = 27;
        resultado = 53 * resultado + this.numeroVersaoMaior;
        resultado = 53 * resultado + this.numeroVersaoIntermediaria;
        resultado = 53 * resultado + this.numeroVersaoMenor;
        resultado = 53 * resultado + this.numeroVersaoAtualizacao;
        resultado = 53 * resultado + (this.numeroIdentificadorVersao == null ? 0 : 1);
        return resultado;
    }

    public String toString() {
        return this.versaoJava;
    }

    public String getNumeroIdentificadorVersao() {
        return this.numeroIdentificadorVersao;
    }
}

