/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.sqladaj;

import br.gov.serpro.sqladaj.SQLAda;
import br.gov.serpro.sqladaj.SQLAdaErrorEnum;
import br.gov.serpro.sqladaj.SQLAdaException;
import br.gov.serpro.sqladaj.SQLAdaSocketImpl;

public class SQLAdaFactory {
    private static final String FACTORY_CLASS_PROPERTY = "br.gov.serpro.sqladaj.className";

    private SQLAdaFactory() {
    }

    public static SQLAda getInstance() throws SQLAdaException {
        String className = System.getProperty(FACTORY_CLASS_PROPERTY);
        if (className == null || className.length() == 0) {
            return new SQLAdaSocketImpl();
        }
        return SQLAdaFactory.getInstance(className);
    }

    public static SQLAda getInstance(String className) throws SQLAdaException {
        try {
            Class<?> sqladaClass = Class.forName(className);
            if (SQLAda.class.isAssignableFrom(sqladaClass)) {
                return (SQLAda)sqladaClass.newInstance();
            }
            throw new SQLAdaException(SQLAdaErrorEnum.SSA616, "A classe precisa implementar a interface br.gov.serpro.sqladaj.SQLAda");
        }
        catch (Exception e) {
            throw new SQLAdaException(SQLAdaErrorEnum.SSA616, (Throwable)e);
        }
    }
}

