/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.datatype;

import com.siemens.ct.exi.context.QNameContext;
import com.siemens.ct.exi.datatype.AbstractDatatype;
import com.siemens.ct.exi.datatype.DatatypeID;
import com.siemens.ct.exi.datatype.strings.StringDecoder;
import com.siemens.ct.exi.datatype.strings.StringEncoder;
import com.siemens.ct.exi.io.channel.DecoderChannel;
import com.siemens.ct.exi.io.channel.EncoderChannel;
import com.siemens.ct.exi.types.BuiltInType;
import com.siemens.ct.exi.values.BooleanValue;
import com.siemens.ct.exi.values.Value;
import java.io.IOException;

public class BooleanDatatype
extends AbstractDatatype {
    protected BooleanValue bool;

    public BooleanDatatype(QNameContext schemaType) {
        super(BuiltInType.BOOLEAN, schemaType);
    }

    public DatatypeID getDatatypeID() {
        return DatatypeID.exi_boolean;
    }

    public boolean isValidString(String value) {
        this.bool = BooleanValue.parse(value);
        return this.bool != null;
    }

    public boolean isValid(Value value) {
        if (value instanceof BooleanValue) {
            this.bool = (BooleanValue)value;
            return true;
        }
        return this.isValidString(value.toString());
    }

    public boolean getBoolean() {
        return this.bool.toBoolean();
    }

    public void writeValue(QNameContext qnContext, EncoderChannel valueChannel, StringEncoder stringEncoder) throws IOException {
        valueChannel.encodeBoolean(this.bool.toBoolean());
    }

    public Value readValue(QNameContext qnContext, DecoderChannel valueChannel, StringDecoder stringDecoder) throws IOException {
        return valueChannel.decodeBooleanValue();
    }
}

