/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.values;

import com.siemens.ct.exi.util.MethodsBag;
import com.siemens.ct.exi.values.AbstractValue;
import com.siemens.ct.exi.values.IntegerValue;
import com.siemens.ct.exi.values.ValueType;
import java.math.BigDecimal;

public class DecimalValue
extends AbstractValue {
    protected final boolean negative;
    protected final IntegerValue integral;
    protected final IntegerValue revFractional;
    protected BigDecimal bd;
    protected StringBuilder sbHelper;

    public DecimalValue(boolean negative, IntegerValue integral, IntegerValue revFractional) {
        super(ValueType.DECIMAL);
        if (negative && IntegerValue.ZERO.equals(integral) && IntegerValue.ZERO.equals(revFractional)) {
            negative = false;
        }
        this.negative = negative;
        this.integral = integral;
        this.revFractional = revFractional;
    }

    public boolean isNegative() {
        return this.negative;
    }

    public IntegerValue getIntegral() {
        return this.integral;
    }

    public IntegerValue getRevFractional() {
        return this.revFractional;
    }

    public static DecimalValue parse(String decimal) {
        try {
            IntegerValue sRevFractional;
            IntegerValue sIntegral;
            decimal = decimal.trim();
            boolean sNegative = false;
            if (decimal.charAt(0) == '-') {
                sNegative = true;
                decimal = decimal.substring(1);
            } else if (decimal.charAt(0) == '+') {
                decimal = decimal.substring(1);
            }
            int decPoint = decimal.indexOf(46);
            if (decPoint == -1) {
                sIntegral = IntegerValue.parse(decimal);
                sRevFractional = IntegerValue.ZERO;
            } else if (decPoint == 0) {
                sIntegral = IntegerValue.ZERO;
                sRevFractional = IntegerValue.parse(new StringBuilder(decimal.substring(decPoint + 1, decimal.length())).reverse().toString());
            } else {
                sIntegral = IntegerValue.parse(decimal.substring(0, decPoint));
                sRevFractional = IntegerValue.parse(new StringBuilder(decimal.substring(decPoint + 1, decimal.length())).reverse().toString());
            }
            if (sIntegral == null || sRevFractional == null) {
                return null;
            }
            return new DecimalValue(sNegative, sIntegral, sRevFractional);
        }
        catch (Exception e) {
            return null;
        }
    }

    public BigDecimal toBigDecimal() {
        if (this.bd == null) {
            char[] characters = new char[this.getCharactersLength()];
            this.getCharacters(characters, 0);
            this.bd = new BigDecimal(characters);
        }
        return this.bd;
    }

    public int getCharactersLength() {
        if (this.slen == -1) {
            this.slen = (this.negative ? 1 : 0) + this.integral.getCharactersLength() + 1 + this.revFractional.getCharactersLength();
        }
        return this.slen;
    }

    public void getCharacters(char[] cbuffer, int offset) {
        if (this.negative) {
            cbuffer[offset++] = 45;
        }
        this.integral.getCharacters(cbuffer, offset);
        offset += this.integral.getCharactersLength();
        cbuffer[offset++] = 46;
        switch (this.revFractional.getIntegerValueType()) {
            case INT: {
                MethodsBag.itosReverse(this.revFractional.ival, offset, cbuffer);
                break;
            }
            case LONG: {
                MethodsBag.itosReverse(this.revFractional.lval, offset, cbuffer);
                break;
            }
            case BIG: {
                if (this.sbHelper == null) {
                    this.sbHelper = new StringBuilder(this.revFractional.bval.toString());
                } else {
                    this.sbHelper.setLength(0);
                    this.sbHelper.append(this.revFractional.bval.toString());
                }
                this.sbHelper = this.sbHelper.reverse();
                int len = this.sbHelper.length();
                this.sbHelper.getChars(0, len, cbuffer, offset);
                break;
            }
            default: {
                throw new RuntimeException("Unknown Int Type: " + (Object)((Object)this.revFractional.valueType));
            }
        }
    }

    private final boolean _equals(DecimalValue o) {
        return this.negative == o.negative && this.integral.equals(o.integral) && this.revFractional.equals(o.revFractional);
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof DecimalValue) {
            return this._equals((DecimalValue)o);
        }
        DecimalValue dv = DecimalValue.parse(o.toString());
        return dv == null ? false : this._equals(dv);
    }

    public int hashCode() {
        return (this.negative ? 1 : 0) ^ this.integral.hashCode() ^ this.revFractional.hashCode();
    }
}

