
/*

pam_nw_auth  - PAM Netware Bindery Authentication module.
version 1.0.0

This code is based off of the pam_unix_auth module and has the same copyright and warrenty.

*/

/*
   Original concept and code by      Brian Hammond    (hammond@cba.uga.edu)
   Enhancements                      John Taylor      (john@www.cviog.uga.edu)
    
   Changes made on March 24-31, 1997   - Brian  (bh)
   Changes made on October 2-3 1997    - John   (jt)
   
*/

/*
 * Copyright Alexander O. Yuriev, 1996.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, and the entire permission notice in its entirety,
 *    including the disclaimer of warranties.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote
 *    products derived from this software without specific prior
 *    written permission.
 * 
 * ALTERNATIVELY, this product may be distributed under the terms of
 * the GNU Public License, in which case the provisions of the GPL are
 * required INSTEAD OF the above restrictions.  (This clause is
 * necessary due to a potential bad interaction between the GPL and
 * the restrictions contained in a BSD-style copyright.)
 * 
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */


#include <stdlib.h>
#include <stdio.h>
#include <pwd.h> 
#include "ncplib.h"


#ifndef NDEBUG

	#include <syslog.h>

#endif	/* NDEBUG */

#ifdef HAVE_SHADOW_H

	#include <shadow.h>
	
#endif	/* HAVE_SHADOW_H */

#ifndef LINUX 

	#include <security/pam_appl.h>

#endif  /* LINUX */

#define _PAM_EXTERN_FUNCTIONS
#include <security/pam_modules.h>
#include <unistd.h>


/* Define function prototypes */

extern char *crypt(const char *key, const char *salt);	/* This should have 
							   been in unistd.h
							   but it is not */
extern	int converse(   pam_handle_t *pamh, 
			int nargs, 
			struct pam_message **message,
                        struct pam_response **response  ); 
                        
extern 	int _set_auth_tok(	pam_handle_t *pamh, 
				int flags, int argc, 
				const char **argv	);

static	int _pam_auth_nw(	pam_handle_t *pamh, 
				int flags, int argc, 
				const char **argv	);

static	int _pam_set_credentials_nw (	pam_handle_t *pamh, 
					int flags, 
					int argc,
					const char ** argv ) ;


/* Fun starts here :)
 * 
 * _pam_auth_nw() actually performs UNIX/shadow authentication
 *
 *	First, if shadow support is available, attempt to perform
 *	authentication using shadow passwords. If shadow is not
 *	available, or user does not have a shadow password, fallback
 *	onto a normal UNIX authentication
 */

/* ======================================== Begin of Netware Modifications */


static int pamnw_usage() {

	printf("\n");
	printf("pam_nw_auth.so is not correctly used in the pam config file.\n\n");
	printf("example syntax:\n");
	printf("auth   required   /lib/security/pam_nw_auth.so nw_server1 nw_server2 ...\n\n");
	printf("the netware server must allow bindery logins, not NDS!\n\n");

	return PAM_AUTH_ERR;
}

static int _pam_auth_nw(	pam_handle_t *pamh,
				int flags, 
				int argc,
				const char *argv[]	) 
{
        int retval;
	const char *name;
	char *p;
	int server_num;
	
/* bh: these are the ncpfs variables... */

        struct ncp_conn_spec *spec;
        struct ncp_conn *conn;
        char *object_name = NULL;
        int object_type = NCP_BINDERY_USER;
        unsigned char buf_obj_name[50];
        long err;

	if (argc < 1) {
		return pamnw_usage();
	}

        if ( (retval = pam_get_user( pamh, &name, "login: ") ) != PAM_SUCCESS )
                return retval;

        pam_get_item( pamh, PAM_AUTHTOK, (void*) &p );

        if ( !p ) 
                {
                        retval = _set_auth_tok( pamh, flags, argc, argv );
                        if ( retval != PAM_SUCCESS ) 
                                return retval;
                }
        
        pam_get_item( pamh, PAM_AUTHTOK, (void*) &p );

/* jt: for debugging */
/*
	if (name) printf("the username is %s\n",name);
	if (p)	  printf("the password is %s\n",p);
*/

	/* here is the part to do Netware Bindery Password Authentication */
	
	server_num = 0;
	while (argv[server_num]) {
			

		if ( server_num == argc )
			return PAM_AUTH_ERR;

/* jt: for debugging */
/*
		printf("the server is %s\n",argv[server_num]);
*/
	        spec = ncp_find_conn_spec(argv[server_num], name, "", 1, getuid(), &err);
		
		if (spec == NULL) {
			printf("Error:  ncp_find_conn_spec() failed.\n");
			continue;
			/* return PAM_AUTH_ERR; */
		}

		if (!object_name) {
			object_name = spec->user;
		} else {
			strcpy(buf_obj_name, object_name);
			object_name = buf_obj_name;
			str_upper(object_name);
		}
		spec->login_type = object_type;

		str_upper(p);
		strcpy(spec->password, p);
	
		if ((conn = ncp_open(spec, &err)) != NULL)
		{
			ncp_close(conn);
			return PAM_SUCCESS;
		}
		server_num++;
	} /* while loop */

	return PAM_AUTH_ERR;
};

/* ======================================== End of Netware Modifications */

/* 
 * The only thing _pam_set_credentials_nw() does is initialization of
 * UNIX group IDs.
 *
 * Well, everybody but me on linux-pam is convinced that it should not
 * initialize group IDs, so I am not doing it but don't say that I haven't
 * warned you. -- AOY
 */

static	int _pam_set_credentials_nw (	pam_handle_t *pamh, 
					int flags, 
					int argc,
					const char **argv )

{	/* FIX ME: incorrect error code */

	return	PAM_SUCCESS;	/* This is a wrong result code. From what I
				   remember from reafing one of the guides
				   there's an error-level saying 'N/A func'
				   	-- AOY
				 */
}

/*
 * PAM framework looks for these entry-points to pass control to the
 * authentication module.
 */
 
PAM_EXTERN
int pam_sm_authenticate(	pam_handle_t *pamh, 
				int flags,
				int argc, 
				const char **argv	)
{
	return _pam_auth_nw( pamh, flags, argc, argv	);
}

PAM_EXTERN
int pam_sm_setcred( pam_handle_t *pamh, 
		    int flags,
		    int argc, 
		    const char **argv)
{
	return _pam_set_credentials_nw ( pamh, flags, argc, argv ) ;
}


/* static module data */
#ifdef PAM_STATIC
struct pam_module _pam_nw_auth_modstruct = {
    "pam_nw_auth",
    pam_sm_authenticate,
    pam_sm_setcred,
    NULL,
    NULL,
    NULL,
    NULL,
};
#endif
