// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package workmail

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opAssociateDelegateToResource = "AssociateDelegateToResource"

// AssociateDelegateToResourceRequest generates a "aws/request.Request" representing the
// client's request for the AssociateDelegateToResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateDelegateToResource for more information on using the AssociateDelegateToResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AssociateDelegateToResourceRequest method.
//    req, resp := client.AssociateDelegateToResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/AssociateDelegateToResource
func (c *WorkMail) AssociateDelegateToResourceRequest(input *AssociateDelegateToResourceInput) (req *request.Request, output *AssociateDelegateToResourceOutput) {
	op := &request.Operation{
		Name:       opAssociateDelegateToResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateDelegateToResourceInput{}
	}

	output = &AssociateDelegateToResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AssociateDelegateToResource API operation for Amazon WorkMail.
//
// Adds a member (user or group) to the resource's set of delegates.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkMail's
// API operation AssociateDelegateToResource for usage and error information.
//
// Returned Error Types:
//   * EntityNotFoundException
//   The identifier supplied for the user, group, or resource does not exist in
//   your organization.
//
//   * EntityStateException
//   You are performing an operation on a user, group, or resource that isn't
//   in the expected state, such as trying to delete an active user.
//
//   * InvalidParameterException
//   One or more of the input parameters don't match the service's restrictions.
//
//   * OrganizationNotFoundException
//   An operation received a valid organization identifier that either doesn't
//   belong or exist in the system.
//
//   * OrganizationStateException
//   The organization must have a valid state to perform certain operations on
//   the organization or its members.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/AssociateDelegateToResource
func (c *WorkMail) AssociateDelegateToResource(input *AssociateDelegateToResourceInput) (*AssociateDelegateToResourceOutput, error) {
	req, out := c.AssociateDelegateToResourceRequest(input)
	return out, req.Send()
}

// AssociateDelegateToResourceWithContext is the same as AssociateDelegateToResource with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateDelegateToResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkMail) AssociateDelegateToResourceWithContext(ctx aws.Context, input *AssociateDelegateToResourceInput, opts ...request.Option) (*AssociateDelegateToResourceOutput, error) {
	req, out := c.AssociateDelegateToResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssociateMemberToGroup = "AssociateMemberToGroup"

// AssociateMemberToGroupRequest generates a "aws/request.Request" representing the
// client's request for the AssociateMemberToGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateMemberToGroup for more information on using the AssociateMemberToGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AssociateMemberToGroupRequest method.
//    req, resp := client.AssociateMemberToGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/AssociateMemberToGroup
func (c *WorkMail) AssociateMemberToGroupRequest(input *AssociateMemberToGroupInput) (req *request.Request, output *AssociateMemberToGroupOutput) {
	op := &request.Operation{
		Name:       opAssociateMemberToGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateMemberToGroupInput{}
	}

	output = &AssociateMemberToGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AssociateMemberToGroup API operation for Amazon WorkMail.
//
// Adds a member (user or group) to the group's set.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkMail's
// API operation AssociateMemberToGroup for usage and error information.
//
// Returned Error Types:
//   * DirectoryServiceAuthenticationFailedException
//   The directory service doesn't recognize the credentials supplied by WorkMail.
//
//   * DirectoryUnavailableException
//   The directory is unavailable. It might be located in another Region or deleted.
//
//   * EntityNotFoundException
//   The identifier supplied for the user, group, or resource does not exist in
//   your organization.
//
//   * EntityStateException
//   You are performing an operation on a user, group, or resource that isn't
//   in the expected state, such as trying to delete an active user.
//
//   * InvalidParameterException
//   One or more of the input parameters don't match the service's restrictions.
//
//   * OrganizationNotFoundException
//   An operation received a valid organization identifier that either doesn't
//   belong or exist in the system.
//
//   * OrganizationStateException
//   The organization must have a valid state to perform certain operations on
//   the organization or its members.
//
//   * UnsupportedOperationException
//   You can't perform a write operation against a read-only directory.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/AssociateMemberToGroup
func (c *WorkMail) AssociateMemberToGroup(input *AssociateMemberToGroupInput) (*AssociateMemberToGroupOutput, error) {
	req, out := c.AssociateMemberToGroupRequest(input)
	return out, req.Send()
}

// AssociateMemberToGroupWithContext is the same as AssociateMemberToGroup with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateMemberToGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkMail) AssociateMemberToGroupWithContext(ctx aws.Context, input *AssociateMemberToGroupInput, opts ...request.Option) (*AssociateMemberToGroupOutput, error) {
	req, out := c.AssociateMemberToGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCancelMailboxExportJob = "CancelMailboxExportJob"

// CancelMailboxExportJobRequest generates a "aws/request.Request" representing the
// client's request for the CancelMailboxExportJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CancelMailboxExportJob for more information on using the CancelMailboxExportJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CancelMailboxExportJobRequest method.
//    req, resp := client.CancelMailboxExportJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/CancelMailboxExportJob
func (c *WorkMail) CancelMailboxExportJobRequest(input *CancelMailboxExportJobInput) (req *request.Request, output *CancelMailboxExportJobOutput) {
	op := &request.Operation{
		Name:       opCancelMailboxExportJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CancelMailboxExportJobInput{}
	}

	output = &CancelMailboxExportJobOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CancelMailboxExportJob API operation for Amazon WorkMail.
//
// Cancels a mailbox export job.
//
// If the mailbox export job is near completion, it might not be possible to
// cancel it.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkMail's
// API operation CancelMailboxExportJob for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   One or more of the input parameters don't match the service's restrictions.
//
//   * OrganizationNotFoundException
//   An operation received a valid organization identifier that either doesn't
//   belong or exist in the system.
//
//   * OrganizationStateException
//   The organization must have a valid state to perform certain operations on
//   the organization or its members.
//
//   * EntityNotFoundException
//   The identifier supplied for the user, group, or resource does not exist in
//   your organization.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/CancelMailboxExportJob
func (c *WorkMail) CancelMailboxExportJob(input *CancelMailboxExportJobInput) (*CancelMailboxExportJobOutput, error) {
	req, out := c.CancelMailboxExportJobRequest(input)
	return out, req.Send()
}

// CancelMailboxExportJobWithContext is the same as CancelMailboxExportJob with the addition of
// the ability to pass a context and additional request options.
//
// See CancelMailboxExportJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkMail) CancelMailboxExportJobWithContext(ctx aws.Context, input *CancelMailboxExportJobInput, opts ...request.Option) (*CancelMailboxExportJobOutput, error) {
	req, out := c.CancelMailboxExportJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateAlias = "CreateAlias"

// CreateAliasRequest generates a "aws/request.Request" representing the
// client's request for the CreateAlias operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAlias for more information on using the CreateAlias
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateAliasRequest method.
//    req, resp := client.CreateAliasRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/CreateAlias
func (c *WorkMail) CreateAliasRequest(input *CreateAliasInput) (req *request.Request, output *CreateAliasOutput) {
	op := &request.Operation{
		Name:       opCreateAlias,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateAliasInput{}
	}

	output = &CreateAliasOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CreateAlias API operation for Amazon WorkMail.
//
// Adds an alias to the set of a given member (user or group) of Amazon WorkMail.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkMail's
// API operation CreateAlias for usage and error information.
//
// Returned Error Types:
//   * EmailAddressInUseException
//   The email address that you're trying to assign is already created for a different
//   user, group, or resource.
//
//   * EntityNotFoundException
//   The identifier supplied for the user, group, or resource does not exist in
//   your organization.
//
//   * EntityStateException
//   You are performing an operation on a user, group, or resource that isn't
//   in the expected state, such as trying to delete an active user.
//
//   * InvalidParameterException
//   One or more of the input parameters don't match the service's restrictions.
//
//   * MailDomainNotFoundException
//   For an email or alias to be created in Amazon WorkMail, the included domain
//   must be defined in the organization.
//
//   * MailDomainStateException
//   After a domain has been added to the organization, it must be verified. The
//   domain is not yet verified.
//
//   * OrganizationNotFoundException
//   An operation received a valid organization identifier that either doesn't
//   belong or exist in the system.
//
//   * OrganizationStateException
//   The organization must have a valid state to perform certain operations on
//   the organization or its members.
//
//   * LimitExceededException
//   The request exceeds the limit of the resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/CreateAlias
func (c *WorkMail) CreateAlias(input *CreateAliasInput) (*CreateAliasOutput, error) {
	req, out := c.CreateAliasRequest(input)
	return out, req.Send()
}

// CreateAliasWithContext is the same as CreateAlias with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAlias for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkMail) CreateAliasWithContext(ctx aws.Context, input *CreateAliasInput, opts ...request.Option) (*CreateAliasOutput, error) {
	req, out := c.CreateAliasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateGroup = "CreateGroup"

// CreateGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateGroup for more information on using the CreateGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateGroupRequest method.
//    req, resp := client.CreateGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/CreateGroup
func (c *WorkMail) CreateGroupRequest(input *CreateGroupInput) (req *request.Request, output *CreateGroupOutput) {
	op := &request.Operation{
		Name:       opCreateGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateGroupInput{}
	}

	output = &CreateGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateGroup API operation for Amazon WorkMail.
//
// Creates a group that can be used in Amazon WorkMail by calling the RegisterToWorkMail
// operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkMail's
// API operation CreateGroup for usage and error information.
//
// Returned Error Types:
//   * DirectoryServiceAuthenticationFailedException
//   The directory service doesn't recognize the credentials supplied by WorkMail.
//
//   * DirectoryUnavailableException
//   The directory is unavailable. It might be located in another Region or deleted.
//
//   * InvalidParameterException
//   One or more of the input parameters don't match the service's restrictions.
//
//   * NameAvailabilityException
//   The user, group, or resource name isn't unique in Amazon WorkMail.
//
//   * OrganizationNotFoundException
//   An operation received a valid organization identifier that either doesn't
//   belong or exist in the system.
//
//   * OrganizationStateException
//   The organization must have a valid state to perform certain operations on
//   the organization or its members.
//
//   * ReservedNameException
//   This user, group, or resource name is not allowed in Amazon WorkMail.
//
//   * UnsupportedOperationException
//   You can't perform a write operation against a read-only directory.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/CreateGroup
func (c *WorkMail) CreateGroup(input *CreateGroupInput) (*CreateGroupOutput, error) {
	req, out := c.CreateGroupRequest(input)
	return out, req.Send()
}

// CreateGroupWithContext is the same as CreateGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkMail) CreateGroupWithContext(ctx aws.Context, input *CreateGroupInput, opts ...request.Option) (*CreateGroupOutput, error) {
	req, out := c.CreateGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateOrganization = "CreateOrganization"

// CreateOrganizationRequest generates a "aws/request.Request" representing the
// client's request for the CreateOrganization operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateOrganization for more information on using the CreateOrganization
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateOrganizationRequest method.
//    req, resp := client.CreateOrganizationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/CreateOrganization
func (c *WorkMail) CreateOrganizationRequest(input *CreateOrganizationInput) (req *request.Request, output *CreateOrganizationOutput) {
	op := &request.Operation{
		Name:       opCreateOrganization,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateOrganizationInput{}
	}

	output = &CreateOrganizationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateOrganization API operation for Amazon WorkMail.
//
// Creates a new Amazon WorkMail organization. Optionally, you can choose to
// associate an existing AWS Directory Service directory with your organization.
// If an AWS Directory Service directory ID is specified, the organization alias
// must match the directory alias. If you choose not to associate an existing
// directory with your organization, then we create a new Amazon WorkMail directory
// for you. For more information, see Adding an organization (https://docs.aws.amazon.com/workmail/latest/adminguide/add_new_organization.html)
// in the Amazon WorkMail Administrator Guide.
//
// You can associate multiple email domains with an organization, then set your
// default email domain from the Amazon WorkMail console. You can also associate
// a domain that is managed in an Amazon Route 53 public hosted zone. For more
// information, see Adding a domain (https://docs.aws.amazon.com/workmail/latest/adminguide/add_domain.html)
// and Choosing the default domain (https://docs.aws.amazon.com/workmail/latest/adminguide/default_domain.html)
// in the Amazon WorkMail Administrator Guide.
//
// Optionally, you can use a customer managed master key from AWS Key Management
// Service (AWS KMS) to encrypt email for your organization. If you don't associate
// an AWS KMS key, Amazon WorkMail creates a default AWS managed master key
// for you.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkMail's
// API operation CreateOrganization for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   One or more of the input parameters don't match the service's restrictions.
//
//   * DirectoryInUseException
//   The directory is already in use by another WorkMail organization in the same
//   account and Region.
//
//   * DirectoryUnavailableException
//   The directory is unavailable. It might be located in another Region or deleted.
//
//   * LimitExceededException
//   The request exceeds the limit of the resource.
//
//   * NameAvailabilityException
//   The user, group, or resource name isn't unique in Amazon WorkMail.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/CreateOrganization
func (c *WorkMail) CreateOrganization(input *CreateOrganizationInput) (*CreateOrganizationOutput, error) {
	req, out := c.CreateOrganizationRequest(input)
	return out, req.Send()
}

// CreateOrganizationWithContext is the same as CreateOrganization with the addition of
// the ability to pass a context and additional request options.
//
// See CreateOrganization for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkMail) CreateOrganizationWithContext(ctx aws.Context, input *CreateOrganizationInput, opts ...request.Option) (*CreateOrganizationOutput, error) {
	req, out := c.CreateOrganizationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateResource = "CreateResource"

// CreateResourceRequest generates a "aws/request.Request" representing the
// client's request for the CreateResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateResource for more information on using the CreateResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateResourceRequest method.
//    req, resp := client.CreateResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/CreateResource
func (c *WorkMail) CreateResourceRequest(input *CreateResourceInput) (req *request.Request, output *CreateResourceOutput) {
	op := &request.Operation{
		Name:       opCreateResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateResourceInput{}
	}

	output = &CreateResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateResource API operation for Amazon WorkMail.
//
// Creates a new Amazon WorkMail resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkMail's
// API operation CreateResource for usage and error information.
//
// Returned Error Types:
//   * DirectoryServiceAuthenticationFailedException
//   The directory service doesn't recognize the credentials supplied by WorkMail.
//
//   * DirectoryUnavailableException
//   The directory is unavailable. It might be located in another Region or deleted.
//
//   * InvalidParameterException
//   One or more of the input parameters don't match the service's restrictions.
//
//   * NameAvailabilityException
//   The user, group, or resource name isn't unique in Amazon WorkMail.
//
//   * OrganizationNotFoundException
//   An operation received a valid organization identifier that either doesn't
//   belong or exist in the system.
//
//   * OrganizationStateException
//   The organization must have a valid state to perform certain operations on
//   the organization or its members.
//
//   * ReservedNameException
//   This user, group, or resource name is not allowed in Amazon WorkMail.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/CreateResource
func (c *WorkMail) CreateResource(input *CreateResourceInput) (*CreateResourceOutput, error) {
	req, out := c.CreateResourceRequest(input)
	return out, req.Send()
}

// CreateResourceWithContext is the same as CreateResource with the addition of
// the ability to pass a context and additional request options.
//
// See CreateResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkMail) CreateResourceWithContext(ctx aws.Context, input *CreateResourceInput, opts ...request.Option) (*CreateResourceOutput, error) {
	req, out := c.CreateResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateUser = "CreateUser"

// CreateUserRequest generates a "aws/request.Request" representing the
// client's request for the CreateUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateUser for more information on using the CreateUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateUserRequest method.
//    req, resp := client.CreateUserRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/CreateUser
func (c *WorkMail) CreateUserRequest(input *CreateUserInput) (req *request.Request, output *CreateUserOutput) {
	op := &request.Operation{
		Name:       opCreateUser,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateUserInput{}
	}

	output = &CreateUserOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateUser API operation for Amazon WorkMail.
//
// Creates a user who can be used in Amazon WorkMail by calling the RegisterToWorkMail
// operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkMail's
// API operation CreateUser for usage and error information.
//
// Returned Error Types:
//   * DirectoryServiceAuthenticationFailedException
//   The directory service doesn't recognize the credentials supplied by WorkMail.
//
//   * DirectoryUnavailableException
//   The directory is unavailable. It might be located in another Region or deleted.
//
//   * InvalidParameterException
//   One or more of the input parameters don't match the service's restrictions.
//
//   * InvalidPasswordException
//   The supplied password doesn't match the minimum security constraints, such
//   as length or use of special characters.
//
//   * NameAvailabilityException
//   The user, group, or resource name isn't unique in Amazon WorkMail.
//
//   * OrganizationNotFoundException
//   An operation received a valid organization identifier that either doesn't
//   belong or exist in the system.
//
//   * OrganizationStateException
//   The organization must have a valid state to perform certain operations on
//   the organization or its members.
//
//   * ReservedNameException
//   This user, group, or resource name is not allowed in Amazon WorkMail.
//
//   * UnsupportedOperationException
//   You can't perform a write operation against a read-only directory.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/CreateUser
func (c *WorkMail) CreateUser(input *CreateUserInput) (*CreateUserOutput, error) {
	req, out := c.CreateUserRequest(input)
	return out, req.Send()
}

// CreateUserWithContext is the same as CreateUser with the addition of
// the ability to pass a context and additional request options.
//
// See CreateUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkMail) CreateUserWithContext(ctx aws.Context, input *CreateUserInput, opts ...request.Option) (*CreateUserOutput, error) {
	req, out := c.CreateUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAccessControlRule = "DeleteAccessControlRule"

// DeleteAccessControlRuleRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAccessControlRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAccessControlRule for more information on using the DeleteAccessControlRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteAccessControlRuleRequest method.
//    req, resp := client.DeleteAccessControlRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeleteAccessControlRule
func (c *WorkMail) DeleteAccessControlRuleRequest(input *DeleteAccessControlRuleInput) (req *request.Request, output *DeleteAccessControlRuleOutput) {
	op := &request.Operation{
		Name:       opDeleteAccessControlRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteAccessControlRuleInput{}
	}

	output = &DeleteAccessControlRuleOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteAccessControlRule API operation for Amazon WorkMail.
//
// Deletes an access control rule for the specified WorkMail organization.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkMail's
// API operation DeleteAccessControlRule for usage and error information.
//
// Returned Error Types:
//   * OrganizationNotFoundException
//   An operation received a valid organization identifier that either doesn't
//   belong or exist in the system.
//
//   * OrganizationStateException
//   The organization must have a valid state to perform certain operations on
//   the organization or its members.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeleteAccessControlRule
func (c *WorkMail) DeleteAccessControlRule(input *DeleteAccessControlRuleInput) (*DeleteAccessControlRuleOutput, error) {
	req, out := c.DeleteAccessControlRuleRequest(input)
	return out, req.Send()
}

// DeleteAccessControlRuleWithContext is the same as DeleteAccessControlRule with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAccessControlRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkMail) DeleteAccessControlRuleWithContext(ctx aws.Context, input *DeleteAccessControlRuleInput, opts ...request.Option) (*DeleteAccessControlRuleOutput, error) {
	req, out := c.DeleteAccessControlRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAlias = "DeleteAlias"

// DeleteAliasRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAlias operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAlias for more information on using the DeleteAlias
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteAliasRequest method.
//    req, resp := client.DeleteAliasRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeleteAlias
func (c *WorkMail) DeleteAliasRequest(input *DeleteAliasInput) (req *request.Request, output *DeleteAliasOutput) {
	op := &request.Operation{
		Name:       opDeleteAlias,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteAliasInput{}
	}

	output = &DeleteAliasOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteAlias API operation for Amazon WorkMail.
//
// Remove one or more specified aliases from a set of aliases for a given user.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkMail's
// API operation DeleteAlias for usage and error information.
//
// Returned Error Types:
//   * EntityNotFoundException
//   The identifier supplied for the user, group, or resource does not exist in
//   your organization.
//
//   * EntityStateException
//   You are performing an operation on a user, group, or resource that isn't
//   in the expected state, such as trying to delete an active user.
//
//   * InvalidParameterException
//   One or more of the input parameters don't match the service's restrictions.
//
//   * OrganizationNotFoundException
//   An operation received a valid organization identifier that either doesn't
//   belong or exist in the system.
//
//   * OrganizationStateException
//   The organization must have a valid state to perform certain operations on
//   the organization or its members.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeleteAlias
func (c *WorkMail) DeleteAlias(input *DeleteAliasInput) (*DeleteAliasOutput, error) {
	req, out := c.DeleteAliasRequest(input)
	return out, req.Send()
}

// DeleteAliasWithContext is the same as DeleteAlias with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAlias for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkMail) DeleteAliasWithContext(ctx aws.Context, input *DeleteAliasInput, opts ...request.Option) (*DeleteAliasOutput, error) {
	req, out := c.DeleteAliasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteGroup = "DeleteGroup"

// DeleteGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteGroup for more information on using the DeleteGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteGroupRequest method.
//    req, resp := client.DeleteGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeleteGroup
func (c *WorkMail) DeleteGroupRequest(input *DeleteGroupInput) (req *request.Request, output *DeleteGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteGroupInput{}
	}

	output = &DeleteGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteGroup API operation for Amazon WorkMail.
//
// Deletes a group from Amazon WorkMail.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkMail's
// API operation DeleteGroup for usage and error information.
//
// Returned Error Types:
//   * DirectoryServiceAuthenticationFailedException
//   The directory service doesn't recognize the credentials supplied by WorkMail.
//
//   * DirectoryUnavailableException
//   The directory is unavailable. It might be located in another Region or deleted.
//
//   * EntityStateException
//   You are performing an operation on a user, group, or resource that isn't
//   in the expected state, such as trying to delete an active user.
//
//   * InvalidParameterException
//   One or more of the input parameters don't match the service's restrictions.
//
//   * OrganizationNotFoundException
//   An operation received a valid organization identifier that either doesn't
//   belong or exist in the system.
//
//   * OrganizationStateException
//   The organization must have a valid state to perform certain operations on
//   the organization or its members.
//
//   * UnsupportedOperationException
//   You can't perform a write operation against a read-only directory.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeleteGroup
func (c *WorkMail) DeleteGroup(input *DeleteGroupInput) (*DeleteGroupOutput, error) {
	req, out := c.DeleteGroupRequest(input)
	return out, req.Send()
}

// DeleteGroupWithContext is the same as DeleteGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkMail) DeleteGroupWithContext(ctx aws.Context, input *DeleteGroupInput, opts ...request.Option) (*DeleteGroupOutput, error) {
	req, out := c.DeleteGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteMailboxPermissions = "DeleteMailboxPermissions"

// DeleteMailboxPermissionsRequest generates a "aws/request.Request" representing the
// client's request for the DeleteMailboxPermissions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteMailboxPermissions for more information on using the DeleteMailboxPermissions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteMailboxPermissionsRequest method.
//    req, resp := client.DeleteMailboxPermissionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeleteMailboxPermissions
func (c *WorkMail) DeleteMailboxPermissionsRequest(input *DeleteMailboxPermissionsInput) (req *request.Request, output *DeleteMailboxPermissionsOutput) {
	op := &request.Operation{
		Name:       opDeleteMailboxPermissions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteMailboxPermissionsInput{}
	}

	output = &DeleteMailboxPermissionsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteMailboxPermissions API operation for Amazon WorkMail.
//
// Deletes permissions granted to a member (user or group).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkMail's
// API operation DeleteMailboxPermissions for usage and error information.
//
// Returned Error Types:
//   * EntityNotFoundException
//   The identifier supplied for the user, group, or resource does not exist in
//   your organization.
//
//   * EntityStateException
//   You are performing an operation on a user, group, or resource that isn't
//   in the expected state, such as trying to delete an active user.
//
//   * InvalidParameterException
//   One or more of the input parameters don't match the service's restrictions.
//
//   * OrganizationNotFoundException
//   An operation received a valid organization identifier that either doesn't
//   belong or exist in the system.
//
//   * OrganizationStateException
//   The organization must have a valid state to perform certain operations on
//   the organization or its members.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeleteMailboxPermissions
func (c *WorkMail) DeleteMailboxPermissions(input *DeleteMailboxPermissionsInput) (*DeleteMailboxPermissionsOutput, error) {
	req, out := c.DeleteMailboxPermissionsRequest(input)
	return out, req.Send()
}

// DeleteMailboxPermissionsWithContext is the same as DeleteMailboxPermissions with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteMailboxPermissions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkMail) DeleteMailboxPermissionsWithContext(ctx aws.Context, input *DeleteMailboxPermissionsInput, opts ...request.Option) (*DeleteMailboxPermissionsOutput, error) {
	req, out := c.DeleteMailboxPermissionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteOrganization = "DeleteOrganization"

// DeleteOrganizationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteOrganization operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteOrganization for more information on using the DeleteOrganization
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteOrganizationRequest method.
//    req, resp := client.DeleteOrganizationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeleteOrganization
func (c *WorkMail) DeleteOrganizationRequest(input *DeleteOrganizationInput) (req *request.Request, output *DeleteOrganizationOutput) {
	op := &request.Operation{
		Name:       opDeleteOrganization,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteOrganizationInput{}
	}

	output = &DeleteOrganizationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteOrganization API operation for Amazon WorkMail.
//
// Deletes an Amazon WorkMail organization and all underlying AWS resources
// managed by Amazon WorkMail as part of the organization. You can choose whether
// to delete the associated directory. For more information, see Removing an
// organization (https://docs.aws.amazon.com/workmail/latest/adminguide/remove_organization.html)
// in the Amazon WorkMail Administrator Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkMail's
// API operation DeleteOrganization for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   One or more of the input parameters don't match the service's restrictions.
//
//   * OrganizationNotFoundException
//   An operation received a valid organization identifier that either doesn't
//   belong or exist in the system.
//
//   * OrganizationStateException
//   The organization must have a valid state to perform certain operations on
//   the organization or its members.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeleteOrganization
func (c *WorkMail) DeleteOrganization(input *DeleteOrganizationInput) (*DeleteOrganizationOutput, error) {
	req, out := c.DeleteOrganizationRequest(input)
	return out, req.Send()
}

// DeleteOrganizationWithContext is the same as DeleteOrganization with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteOrganization for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkMail) DeleteOrganizationWithContext(ctx aws.Context, input *DeleteOrganizationInput, opts ...request.Option) (*DeleteOrganizationOutput, error) {
	req, out := c.DeleteOrganizationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteResource = "DeleteResource"

// DeleteResourceRequest generates a "aws/request.Request" representing the
// client's request for the DeleteResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteResource for more information on using the DeleteResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteResourceRequest method.
//    req, resp := client.DeleteResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeleteResource
func (c *WorkMail) DeleteResourceRequest(input *DeleteResourceInput) (req *request.Request, output *DeleteResourceOutput) {
	op := &request.Operation{
		Name:       opDeleteResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteResourceInput{}
	}

	output = &DeleteResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteResource API operation for Amazon WorkMail.
//
// Deletes the specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkMail's
// API operation DeleteResource for usage and error information.
//
// Returned Error Types:
//   * EntityStateException
//   You are performing an operation on a user, group, or resource that isn't
//   in the expected state, such as trying to delete an active user.
//
//   * InvalidParameterException
//   One or more of the input parameters don't match the service's restrictions.
//
//   * OrganizationNotFoundException
//   An operation received a valid organization identifier that either doesn't
//   belong or exist in the system.
//
//   * OrganizationStateException
//   The organization must have a valid state to perform certain operations on
//   the organization or its members.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeleteResource
func (c *WorkMail) DeleteResource(input *DeleteResourceInput) (*DeleteResourceOutput, error) {
	req, out := c.DeleteResourceRequest(input)
	return out, req.Send()
}

// DeleteResourceWithContext is the same as DeleteResource with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkMail) DeleteResourceWithContext(ctx aws.Context, input *DeleteResourceInput, opts ...request.Option) (*DeleteResourceOutput, error) {
	req, out := c.DeleteResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteRetentionPolicy = "DeleteRetentionPolicy"

// DeleteRetentionPolicyRequest generates a "aws/request.Request" representing the
// client's request for the DeleteRetentionPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteRetentionPolicy for more information on using the DeleteRetentionPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteRetentionPolicyRequest method.
//    req, resp := client.DeleteRetentionPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeleteRetentionPolicy
func (c *WorkMail) DeleteRetentionPolicyRequest(input *DeleteRetentionPolicyInput) (req *request.Request, output *DeleteRetentionPolicyOutput) {
	op := &request.Operation{
		Name:       opDeleteRetentionPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteRetentionPolicyInput{}
	}

	output = &DeleteRetentionPolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteRetentionPolicy API operation for Amazon WorkMail.
//
// Deletes the specified retention policy from the specified organization.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkMail's
// API operation DeleteRetentionPolicy for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   One or more of the input parameters don't match the service's restrictions.
//
//   * OrganizationNotFoundException
//   An operation received a valid organization identifier that either doesn't
//   belong or exist in the system.
//
//   * OrganizationStateException
//   The organization must have a valid state to perform certain operations on
//   the organization or its members.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeleteRetentionPolicy
func (c *WorkMail) DeleteRetentionPolicy(input *DeleteRetentionPolicyInput) (*DeleteRetentionPolicyOutput, error) {
	req, out := c.DeleteRetentionPolicyRequest(input)
	return out, req.Send()
}

// DeleteRetentionPolicyWithContext is the same as DeleteRetentionPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteRetentionPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkMail) DeleteRetentionPolicyWithContext(ctx aws.Context, input *DeleteRetentionPolicyInput, opts ...request.Option) (*DeleteRetentionPolicyOutput, error) {
	req, out := c.DeleteRetentionPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteUser = "DeleteUser"

// DeleteUserRequest generates a "aws/request.Request" representing the
// client's request for the DeleteUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteUser for more information on using the DeleteUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteUserRequest method.
//    req, resp := client.DeleteUserRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeleteUser
func (c *WorkMail) DeleteUserRequest(input *DeleteUserInput) (req *request.Request, output *DeleteUserOutput) {
	op := &request.Operation{
		Name:       opDeleteUser,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteUserInput{}
	}

	output = &DeleteUserOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteUser API operation for Amazon WorkMail.
//
// Deletes a user from Amazon WorkMail and all subsequent systems. Before you
// can delete a user, the user state must be DISABLED. Use the DescribeUser
// action to confirm the user state.
//
// Deleting a user is permanent and cannot be undone. WorkMail archives user
// mailboxes for 30 days before they are permanently removed.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkMail's
// API operation DeleteUser for usage and error information.
//
// Returned Error Types:
//   * DirectoryServiceAuthenticationFailedException
//   The directory service doesn't recognize the credentials supplied by WorkMail.
//
//   * DirectoryUnavailableException
//   The directory is unavailable. It might be located in another Region or deleted.
//
//   * EntityStateException
//   You are performing an operation on a user, group, or resource that isn't
//   in the expected state, such as trying to delete an active user.
//
//   * InvalidParameterException
//   One or more of the input parameters don't match the service's restrictions.
//
//   * OrganizationNotFoundException
//   An operation received a valid organization identifier that either doesn't
//   belong or exist in the system.
//
//   * OrganizationStateException
//   The organization must have a valid state to perform certain operations on
//   the organization or its members.
//
//   * UnsupportedOperationException
//   You can't perform a write operation against a read-only directory.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeleteUser
func (c *WorkMail) DeleteUser(input *DeleteUserInput) (*DeleteUserOutput, error) {
	req, out := c.DeleteUserRequest(input)
	return out, req.Send()
}

// DeleteUserWithContext is the same as DeleteUser with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkMail) DeleteUserWithContext(ctx aws.Context, input *DeleteUserInput, opts ...request.Option) (*DeleteUserOutput, error) {
	req, out := c.DeleteUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeregisterFromWorkMail = "DeregisterFromWorkMail"

// DeregisterFromWorkMailRequest generates a "aws/request.Request" representing the
// client's request for the DeregisterFromWorkMail operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeregisterFromWorkMail for more information on using the DeregisterFromWorkMail
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeregisterFromWorkMailRequest method.
//    req, resp := client.DeregisterFromWorkMailRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeregisterFromWorkMail
func (c *WorkMail) DeregisterFromWorkMailRequest(input *DeregisterFromWorkMailInput) (req *request.Request, output *DeregisterFromWorkMailOutput) {
	op := &request.Operation{
		Name:       opDeregisterFromWorkMail,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeregisterFromWorkMailInput{}
	}

	output = &DeregisterFromWorkMailOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeregisterFromWorkMail API operation for Amazon WorkMail.
//
// Mark a user, group, or resource as no longer used in Amazon WorkMail. This
// action disassociates the mailbox and schedules it for clean-up. WorkMail
// keeps mailboxes for 30 days before they are permanently removed. The functionality
// in the console is Disable.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkMail's
// API operation DeregisterFromWorkMail for usage and error information.
//
// Returned Error Types:
//   * EntityNotFoundException
//   The identifier supplied for the user, group, or resource does not exist in
//   your organization.
//
//   * EntityStateException
//   You are performing an operation on a user, group, or resource that isn't
//   in the expected state, such as trying to delete an active user.
//
//   * InvalidParameterException
//   One or more of the input parameters don't match the service's restrictions.
//
//   * OrganizationNotFoundException
//   An operation received a valid organization identifier that either doesn't
//   belong or exist in the system.
//
//   * OrganizationStateException
//   The organization must have a valid state to perform certain operations on
//   the organization or its members.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeregisterFromWorkMail
func (c *WorkMail) DeregisterFromWorkMail(input *DeregisterFromWorkMailInput) (*DeregisterFromWorkMailOutput, error) {
	req, out := c.DeregisterFromWorkMailRequest(input)
	return out, req.Send()
}

// DeregisterFromWorkMailWithContext is the same as DeregisterFromWorkMail with the addition of
// the ability to pass a context and additional request options.
//
// See DeregisterFromWorkMail for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkMail) DeregisterFromWorkMailWithContext(ctx aws.Context, input *DeregisterFromWorkMailInput, opts ...request.Option) (*DeregisterFromWorkMailOutput, error) {
	req, out := c.DeregisterFromWorkMailRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeGroup = "DescribeGroup"

// DescribeGroupRequest generates a "aws/request.Request" representing the
// client's request for the DescribeGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeGroup for more information on using the DescribeGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeGroupRequest method.
//    req, resp := client.DescribeGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DescribeGroup
func (c *WorkMail) DescribeGroupRequest(input *DescribeGroupInput) (req *request.Request, output *DescribeGroupOutput) {
	op := &request.Operation{
		Name:       opDescribeGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeGroupInput{}
	}

	output = &DescribeGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeGroup API operation for Amazon WorkMail.
//
// Returns the data available for the group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkMail's
// API operation DescribeGroup for usage and error information.
//
// Returned Error Types:
//   * EntityNotFoundException
//   The identifier supplied for the user, group, or resource does not exist in
//   your organization.
//
//   * InvalidParameterException
//   One or more of the input parameters don't match the service's restrictions.
//
//   * OrganizationNotFoundException
//   An operation received a valid organization identifier that either doesn't
//   belong or exist in the system.
//
//   * OrganizationStateException
//   The organization must have a valid state to perform certain operations on
//   the organization or its members.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DescribeGroup
func (c *WorkMail) DescribeGroup(input *DescribeGroupInput) (*DescribeGroupOutput, error) {
	req, out := c.DescribeGroupRequest(input)
	return out, req.Send()
}

// DescribeGroupWithContext is the same as DescribeGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkMail) DescribeGroupWithContext(ctx aws.Context, input *DescribeGroupInput, opts ...request.Option) (*DescribeGroupOutput, error) {
	req, out := c.DescribeGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeMailboxExportJob = "DescribeMailboxExportJob"

// DescribeMailboxExportJobRequest generates a "aws/request.Request" representing the
// client's request for the DescribeMailboxExportJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeMailboxExportJob for more information on using the DescribeMailboxExportJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeMailboxExportJobRequest method.
//    req, resp := client.DescribeMailboxExportJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DescribeMailboxExportJob
func (c *WorkMail) DescribeMailboxExportJobRequest(input *DescribeMailboxExportJobInput) (req *request.Request, output *DescribeMailboxExportJobOutput) {
	op := &request.Operation{
		Name:       opDescribeMailboxExportJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeMailboxExportJobInput{}
	}

	output = &DescribeMailboxExportJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeMailboxExportJob API operation for Amazon WorkMail.
//
// Describes the current status of a mailbox export job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkMail's
// API operation DescribeMailboxExportJob for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   One or more of the input parameters don't match the service's restrictions.
//
//   * OrganizationNotFoundException
//   An operation received a valid organization identifier that either doesn't
//   belong or exist in the system.
//
//   * OrganizationStateException
//   The organization must have a valid state to perform certain operations on
//   the organization or its members.
//
//   * EntityNotFoundException
//   The identifier supplied for the user, group, or resource does not exist in
//   your organization.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DescribeMailboxExportJob
func (c *WorkMail) DescribeMailboxExportJob(input *DescribeMailboxExportJobInput) (*DescribeMailboxExportJobOutput, error) {
	req, out := c.DescribeMailboxExportJobRequest(input)
	return out, req.Send()
}

// DescribeMailboxExportJobWithContext is the same as DescribeMailboxExportJob with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeMailboxExportJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkMail) DescribeMailboxExportJobWithContext(ctx aws.Context, input *DescribeMailboxExportJobInput, opts ...request.Option) (*DescribeMailboxExportJobOutput, error) {
	req, out := c.DescribeMailboxExportJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeOrganization = "DescribeOrganization"

// DescribeOrganizationRequest generates a "aws/request.Request" representing the
// client's request for the DescribeOrganization operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeOrganization for more information on using the DescribeOrganization
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeOrganizationRequest method.
//    req, resp := client.DescribeOrganizationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DescribeOrganization
func (c *WorkMail) DescribeOrganizationRequest(input *DescribeOrganizationInput) (req *request.Request, output *DescribeOrganizationOutput) {
	op := &request.Operation{
		Name:       opDescribeOrganization,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeOrganizationInput{}
	}

	output = &DescribeOrganizationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeOrganization API operation for Amazon WorkMail.
//
// Provides more information regarding a given organization based on its identifier.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkMail's
// API operation DescribeOrganization for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   One or more of the input parameters don't match the service's restrictions.
//
//   * OrganizationNotFoundException
//   An operation received a valid organization identifier that either doesn't
//   belong or exist in the system.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DescribeOrganization
func (c *WorkMail) DescribeOrganization(input *DescribeOrganizationInput) (*DescribeOrganizationOutput, error) {
	req, out := c.DescribeOrganizationRequest(input)
	return out, req.Send()
}

// DescribeOrganizationWithContext is the same as DescribeOrganization with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeOrganization for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkMail) DescribeOrganizationWithContext(ctx aws.Context, input *DescribeOrganizationInput, opts ...request.Option) (*DescribeOrganizationOutput, error) {
	req, out := c.DescribeOrganizationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeResource = "DescribeResource"

// DescribeResourceRequest generates a "aws/request.Request" representing the
// client's request for the DescribeResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeResource for more information on using the DescribeResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeResourceRequest method.
//    req, resp := client.DescribeResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DescribeResource
func (c *WorkMail) DescribeResourceRequest(input *DescribeResourceInput) (req *request.Request, output *DescribeResourceOutput) {
	op := &request.Operation{
		Name:       opDescribeResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeResourceInput{}
	}

	output = &DescribeResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeResource API operation for Amazon WorkMail.
//
// Returns the data available for the resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkMail's
// API operation DescribeResource for usage and error information.
//
// Returned Error Types:
//   * EntityNotFoundException
//   The identifier supplied for the user, group, or resource does not exist in
//   your organization.
//
//   * InvalidParameterException
//   One or more of the input parameters don't match the service's restrictions.
//
//   * OrganizationNotFoundException
//   An operation received a valid organization identifier that either doesn't
//   belong or exist in the system.
//
//   * OrganizationStateException
//   The organization must have a valid state to perform certain operations on
//   the organization or its members.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DescribeResource
func (c *WorkMail) DescribeResource(input *DescribeResourceInput) (*DescribeResourceOutput, error) {
	req, out := c.DescribeResourceRequest(input)
	return out, req.Send()
}

// DescribeResourceWithContext is the same as DescribeResource with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkMail) DescribeResourceWithContext(ctx aws.Context, input *DescribeResourceInput, opts ...request.Option) (*DescribeResourceOutput, error) {
	req, out := c.DescribeResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeUser = "DescribeUser"

// DescribeUserRequest generates a "aws/request.Request" representing the
// client's request for the DescribeUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeUser for more information on using the DescribeUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeUserRequest method.
//    req, resp := client.DescribeUserRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DescribeUser
func (c *WorkMail) DescribeUserRequest(input *DescribeUserInput) (req *request.Request, output *DescribeUserOutput) {
	op := &request.Operation{
		Name:       opDescribeUser,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeUserInput{}
	}

	output = &DescribeUserOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeUser API operation for Amazon WorkMail.
//
// Provides information regarding the user.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkMail's
// API operation DescribeUser for usage and error information.
//
// Returned Error Types:
//   * EntityNotFoundException
//   The identifier supplied for the user, group, or resource does not exist in
//   your organization.
//
//   * InvalidParameterException
//   One or more of the input parameters don't match the service's restrictions.
//
//   * OrganizationNotFoundException
//   An operation received a valid organization identifier that either doesn't
//   belong or exist in the system.
//
//   * OrganizationStateException
//   The organization must have a valid state to perform certain operations on
//   the organization or its members.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DescribeUser
func (c *WorkMail) DescribeUser(input *DescribeUserInput) (*DescribeUserOutput, error) {
	req, out := c.DescribeUserRequest(input)
	return out, req.Send()
}

// DescribeUserWithContext is the same as DescribeUser with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkMail) DescribeUserWithContext(ctx aws.Context, input *DescribeUserInput, opts ...request.Option) (*DescribeUserOutput, error) {
	req, out := c.DescribeUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateDelegateFromResource = "DisassociateDelegateFromResource"

// DisassociateDelegateFromResourceRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateDelegateFromResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateDelegateFromResource for more information on using the DisassociateDelegateFromResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisassociateDelegateFromResourceRequest method.
//    req, resp := client.DisassociateDelegateFromResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DisassociateDelegateFromResource
func (c *WorkMail) DisassociateDelegateFromResourceRequest(input *DisassociateDelegateFromResourceInput) (req *request.Request, output *DisassociateDelegateFromResourceOutput) {
	op := &request.Operation{
		Name:       opDisassociateDelegateFromResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisassociateDelegateFromResourceInput{}
	}

	output = &DisassociateDelegateFromResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisassociateDelegateFromResource API operation for Amazon WorkMail.
//
// Removes a member from the resource's set of delegates.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkMail's
// API operation DisassociateDelegateFromResource for usage and error information.
//
// Returned Error Types:
//   * EntityNotFoundException
//   The identifier supplied for the user, group, or resource does not exist in
//   your organization.
//
//   * EntityStateException
//   You are performing an operation on a user, group, or resource that isn't
//   in the expected state, such as trying to delete an active user.
//
//   * InvalidParameterException
//   One or more of the input parameters don't match the service's restrictions.
//
//   * OrganizationNotFoundException
//   An operation received a valid organization identifier that either doesn't
//   belong or exist in the system.
//
//   * OrganizationStateException
//   The organization must have a valid state to perform certain operations on
//   the organization or its members.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DisassociateDelegateFromResource
func (c *WorkMail) DisassociateDelegateFromResource(input *DisassociateDelegateFromResourceInput) (*DisassociateDelegateFromResourceOutput, error) {
	req, out := c.DisassociateDelegateFromResourceRequest(input)
	return out, req.Send()
}

// DisassociateDelegateFromResourceWithContext is the same as DisassociateDelegateFromResource with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateDelegateFromResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkMail) DisassociateDelegateFromResourceWithContext(ctx aws.Context, input *DisassociateDelegateFromResourceInput, opts ...request.Option) (*DisassociateDelegateFromResourceOutput, error) {
	req, out := c.DisassociateDelegateFromResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateMemberFromGroup = "DisassociateMemberFromGroup"

// DisassociateMemberFromGroupRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateMemberFromGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateMemberFromGroup for more information on using the DisassociateMemberFromGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisassociateMemberFromGroupRequest method.
//    req, resp := client.DisassociateMemberFromGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DisassociateMemberFromGroup
func (c *WorkMail) DisassociateMemberFromGroupRequest(input *DisassociateMemberFromGroupInput) (req *request.Request, output *DisassociateMemberFromGroupOutput) {
	op := &request.Operation{
		Name:       opDisassociateMemberFromGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisassociateMemberFromGroupInput{}
	}

	output = &DisassociateMemberFromGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisassociateMemberFromGroup API operation for Amazon WorkMail.
//
// Removes a member from a group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkMail's
// API operation DisassociateMemberFromGroup for usage and error information.
//
// Returned Error Types:
//   * DirectoryServiceAuthenticationFailedException
//   The directory service doesn't recognize the credentials supplied by WorkMail.
//
//   * DirectoryUnavailableException
//   The directory is unavailable. It might be located in another Region or deleted.
//
//   * EntityNotFoundException
//   The identifier supplied for the user, group, or resource does not exist in
//   your organization.
//
//   * EntityStateException
//   You are performing an operation on a user, group, or resource that isn't
//   in the expected state, such as trying to delete an active user.
//
//   * InvalidParameterException
//   One or more of the input parameters don't match the service's restrictions.
//
//   * OrganizationNotFoundException
//   An operation received a valid organization identifier that either doesn't
//   belong or exist in the system.
//
//   * OrganizationStateException
//   The organization must have a valid state to perform certain operations on
//   the organization or its members.
//
//   * UnsupportedOperationException
//   You can't perform a write operation against a read-only directory.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DisassociateMemberFromGroup
func (c *WorkMail) DisassociateMemberFromGroup(input *DisassociateMemberFromGroupInput) (*DisassociateMemberFromGroupOutput, error) {
	req, out := c.DisassociateMemberFromGroupRequest(input)
	return out, req.Send()
}

// DisassociateMemberFromGroupWithContext is the same as DisassociateMemberFromGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateMemberFromGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkMail) DisassociateMemberFromGroupWithContext(ctx aws.Context, input *DisassociateMemberFromGroupInput, opts ...request.Option) (*DisassociateMemberFromGroupOutput, error) {
	req, out := c.DisassociateMemberFromGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAccessControlEffect = "GetAccessControlEffect"

// GetAccessControlEffectRequest generates a "aws/request.Request" representing the
// client's request for the GetAccessControlEffect operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAccessControlEffect for more information on using the GetAccessControlEffect
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetAccessControlEffectRequest method.
//    req, resp := client.GetAccessControlEffectRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/GetAccessControlEffect
func (c *WorkMail) GetAccessControlEffectRequest(input *GetAccessControlEffectInput) (req *request.Request, output *GetAccessControlEffectOutput) {
	op := &request.Operation{
		Name:       opGetAccessControlEffect,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetAccessControlEffectInput{}
	}

	output = &GetAccessControlEffectOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAccessControlEffect API operation for Amazon WorkMail.
//
// Gets the effects of an organization's access control rules as they apply
// to a specified IPv4 address, access protocol action, or user ID.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkMail's
// API operation GetAccessControlEffect for usage and error information.
//
// Returned Error Types:
//   * EntityNotFoundException
//   The identifier supplied for the user, group, or resource does not exist in
//   your organization.
//
//   * InvalidParameterException
//   One or more of the input parameters don't match the service's restrictions.
//
//   * OrganizationNotFoundException
//   An operation received a valid organization identifier that either doesn't
//   belong or exist in the system.
//
//   * OrganizationStateException
//   The organization must have a valid state to perform certain operations on
//   the organization or its members.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/GetAccessControlEffect
func (c *WorkMail) GetAccessControlEffect(input *GetAccessControlEffectInput) (*GetAccessControlEffectOutput, error) {
	req, out := c.GetAccessControlEffectRequest(input)
	return out, req.Send()
}

// GetAccessControlEffectWithContext is the same as GetAccessControlEffect with the addition of
// the ability to pass a context and additional request options.
//
// See GetAccessControlEffect for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkMail) GetAccessControlEffectWithContext(ctx aws.Context, input *GetAccessControlEffectInput, opts ...request.Option) (*GetAccessControlEffectOutput, error) {
	req, out := c.GetAccessControlEffectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDefaultRetentionPolicy = "GetDefaultRetentionPolicy"

// GetDefaultRetentionPolicyRequest generates a "aws/request.Request" representing the
// client's request for the GetDefaultRetentionPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDefaultRetentionPolicy for more information on using the GetDefaultRetentionPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDefaultRetentionPolicyRequest method.
//    req, resp := client.GetDefaultRetentionPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/GetDefaultRetentionPolicy
func (c *WorkMail) GetDefaultRetentionPolicyRequest(input *GetDefaultRetentionPolicyInput) (req *request.Request, output *GetDefaultRetentionPolicyOutput) {
	op := &request.Operation{
		Name:       opGetDefaultRetentionPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetDefaultRetentionPolicyInput{}
	}

	output = &GetDefaultRetentionPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDefaultRetentionPolicy API operation for Amazon WorkMail.
//
// Gets the default retention policy details for the specified organization.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkMail's
// API operation GetDefaultRetentionPolicy for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   One or more of the input parameters don't match the service's restrictions.
//
//   * OrganizationNotFoundException
//   An operation received a valid organization identifier that either doesn't
//   belong or exist in the system.
//
//   * OrganizationStateException
//   The organization must have a valid state to perform certain operations on
//   the organization or its members.
//
//   * EntityNotFoundException
//   The identifier supplied for the user, group, or resource does not exist in
//   your organization.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/GetDefaultRetentionPolicy
func (c *WorkMail) GetDefaultRetentionPolicy(input *GetDefaultRetentionPolicyInput) (*GetDefaultRetentionPolicyOutput, error) {
	req, out := c.GetDefaultRetentionPolicyRequest(input)
	return out, req.Send()
}

// GetDefaultRetentionPolicyWithContext is the same as GetDefaultRetentionPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See GetDefaultRetentionPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkMail) GetDefaultRetentionPolicyWithContext(ctx aws.Context, input *GetDefaultRetentionPolicyInput, opts ...request.Option) (*GetDefaultRetentionPolicyOutput, error) {
	req, out := c.GetDefaultRetentionPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetMailboxDetails = "GetMailboxDetails"

// GetMailboxDetailsRequest generates a "aws/request.Request" representing the
// client's request for the GetMailboxDetails operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetMailboxDetails for more information on using the GetMailboxDetails
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetMailboxDetailsRequest method.
//    req, resp := client.GetMailboxDetailsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/GetMailboxDetails
func (c *WorkMail) GetMailboxDetailsRequest(input *GetMailboxDetailsInput) (req *request.Request, output *GetMailboxDetailsOutput) {
	op := &request.Operation{
		Name:       opGetMailboxDetails,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetMailboxDetailsInput{}
	}

	output = &GetMailboxDetailsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetMailboxDetails API operation for Amazon WorkMail.
//
// Requests a user's mailbox details for a specified organization and user.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkMail's
// API operation GetMailboxDetails for usage and error information.
//
// Returned Error Types:
//   * OrganizationNotFoundException
//   An operation received a valid organization identifier that either doesn't
//   belong or exist in the system.
//
//   * OrganizationStateException
//   The organization must have a valid state to perform certain operations on
//   the organization or its members.
//
//   * EntityNotFoundException
//   The identifier supplied for the user, group, or resource does not exist in
//   your organization.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/GetMailboxDetails
func (c *WorkMail) GetMailboxDetails(input *GetMailboxDetailsInput) (*GetMailboxDetailsOutput, error) {
	req, out := c.GetMailboxDetailsRequest(input)
	return out, req.Send()
}

// GetMailboxDetailsWithContext is the same as GetMailboxDetails with the addition of
// the ability to pass a context and additional request options.
//
// See GetMailboxDetails for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkMail) GetMailboxDetailsWithContext(ctx aws.Context, input *GetMailboxDetailsInput, opts ...request.Option) (*GetMailboxDetailsOutput, error) {
	req, out := c.GetMailboxDetailsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListAccessControlRules = "ListAccessControlRules"

// ListAccessControlRulesRequest generates a "aws/request.Request" representing the
// client's request for the ListAccessControlRules operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAccessControlRules for more information on using the ListAccessControlRules
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListAccessControlRulesRequest method.
//    req, resp := client.ListAccessControlRulesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListAccessControlRules
func (c *WorkMail) ListAccessControlRulesRequest(input *ListAccessControlRulesInput) (req *request.Request, output *ListAccessControlRulesOutput) {
	op := &request.Operation{
		Name:       opListAccessControlRules,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListAccessControlRulesInput{}
	}

	output = &ListAccessControlRulesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAccessControlRules API operation for Amazon WorkMail.
//
// Lists the access control rules for the specified organization.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkMail's
// API operation ListAccessControlRules for usage and error information.
//
// Returned Error Types:
//   * OrganizationNotFoundException
//   An operation received a valid organization identifier that either doesn't
//   belong or exist in the system.
//
//   * OrganizationStateException
//   The organization must have a valid state to perform certain operations on
//   the organization or its members.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListAccessControlRules
func (c *WorkMail) ListAccessControlRules(input *ListAccessControlRulesInput) (*ListAccessControlRulesOutput, error) {
	req, out := c.ListAccessControlRulesRequest(input)
	return out, req.Send()
}

// ListAccessControlRulesWithContext is the same as ListAccessControlRules with the addition of
// the ability to pass a context and additional request options.
//
// See ListAccessControlRules for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkMail) ListAccessControlRulesWithContext(ctx aws.Context, input *ListAccessControlRulesInput, opts ...request.Option) (*ListAccessControlRulesOutput, error) {
	req, out := c.ListAccessControlRulesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListAliases = "ListAliases"

// ListAliasesRequest generates a "aws/request.Request" representing the
// client's request for the ListAliases operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAliases for more information on using the ListAliases
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListAliasesRequest method.
//    req, resp := client.ListAliasesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListAliases
func (c *WorkMail) ListAliasesRequest(input *ListAliasesInput) (req *request.Request, output *ListAliasesOutput) {
	op := &request.Operation{
		Name:       opListAliases,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAliasesInput{}
	}

	output = &ListAliasesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAliases API operation for Amazon WorkMail.
//
// Creates a paginated call to list the aliases associated with a given entity.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkMail's
// API operation ListAliases for usage and error information.
//
// Returned Error Types:
//   * EntityNotFoundException
//   The identifier supplied for the user, group, or resource does not exist in
//   your organization.
//
//   * EntityStateException
//   You are performing an operation on a user, group, or resource that isn't
//   in the expected state, such as trying to delete an active user.
//
//   * InvalidParameterException
//   One or more of the input parameters don't match the service's restrictions.
//
//   * OrganizationNotFoundException
//   An operation received a valid organization identifier that either doesn't
//   belong or exist in the system.
//
//   * OrganizationStateException
//   The organization must have a valid state to perform certain operations on
//   the organization or its members.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListAliases
func (c *WorkMail) ListAliases(input *ListAliasesInput) (*ListAliasesOutput, error) {
	req, out := c.ListAliasesRequest(input)
	return out, req.Send()
}

// ListAliasesWithContext is the same as ListAliases with the addition of
// the ability to pass a context and additional request options.
//
// See ListAliases for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkMail) ListAliasesWithContext(ctx aws.Context, input *ListAliasesInput, opts ...request.Option) (*ListAliasesOutput, error) {
	req, out := c.ListAliasesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAliasesPages iterates over the pages of a ListAliases operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAliases method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListAliases operation.
//    pageNum := 0
//    err := client.ListAliasesPages(params,
//        func(page *workmail.ListAliasesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *WorkMail) ListAliasesPages(input *ListAliasesInput, fn func(*ListAliasesOutput, bool) bool) error {
	return c.ListAliasesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAliasesPagesWithContext same as ListAliasesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkMail) ListAliasesPagesWithContext(ctx aws.Context, input *ListAliasesInput, fn func(*ListAliasesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAliasesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAliasesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAliasesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListGroupMembers = "ListGroupMembers"

// ListGroupMembersRequest generates a "aws/request.Request" representing the
// client's request for the ListGroupMembers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListGroupMembers for more information on using the ListGroupMembers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListGroupMembersRequest method.
//    req, resp := client.ListGroupMembersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListGroupMembers
func (c *WorkMail) ListGroupMembersRequest(input *ListGroupMembersInput) (req *request.Request, output *ListGroupMembersOutput) {
	op := &request.Operation{
		Name:       opListGroupMembers,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListGroupMembersInput{}
	}

	output = &ListGroupMembersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListGroupMembers API operation for Amazon WorkMail.
//
// Returns an overview of the members of a group. Users and groups can be members
// of a group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkMail's
// API operation ListGroupMembers for usage and error information.
//
// Returned Error Types:
//   * EntityNotFoundException
//   The identifier supplied for the user, group, or resource does not exist in
//   your organization.
//
//   * EntityStateException
//   You are performing an operation on a user, group, or resource that isn't
//   in the expected state, such as trying to delete an active user.
//
//   * InvalidParameterException
//   One or more of the input parameters don't match the service's restrictions.
//
//   * OrganizationNotFoundException
//   An operation received a valid organization identifier that either doesn't
//   belong or exist in the system.
//
//   * OrganizationStateException
//   The organization must have a valid state to perform certain operations on
//   the organization or its members.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListGroupMembers
func (c *WorkMail) ListGroupMembers(input *ListGroupMembersInput) (*ListGroupMembersOutput, error) {
	req, out := c.ListGroupMembersRequest(input)
	return out, req.Send()
}

// ListGroupMembersWithContext is the same as ListGroupMembers with the addition of
// the ability to pass a context and additional request options.
//
// See ListGroupMembers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkMail) ListGroupMembersWithContext(ctx aws.Context, input *ListGroupMembersInput, opts ...request.Option) (*ListGroupMembersOutput, error) {
	req, out := c.ListGroupMembersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListGroupMembersPages iterates over the pages of a ListGroupMembers operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListGroupMembers method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListGroupMembers operation.
//    pageNum := 0
//    err := client.ListGroupMembersPages(params,
//        func(page *workmail.ListGroupMembersOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *WorkMail) ListGroupMembersPages(input *ListGroupMembersInput, fn func(*ListGroupMembersOutput, bool) bool) error {
	return c.ListGroupMembersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListGroupMembersPagesWithContext same as ListGroupMembersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkMail) ListGroupMembersPagesWithContext(ctx aws.Context, input *ListGroupMembersInput, fn func(*ListGroupMembersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListGroupMembersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListGroupMembersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListGroupMembersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListGroups = "ListGroups"

// ListGroupsRequest generates a "aws/request.Request" representing the
// client's request for the ListGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListGroups for more information on using the ListGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListGroupsRequest method.
//    req, resp := client.ListGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListGroups
func (c *WorkMail) ListGroupsRequest(input *ListGroupsInput) (req *request.Request, output *ListGroupsOutput) {
	op := &request.Operation{
		Name:       opListGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListGroupsInput{}
	}

	output = &ListGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListGroups API operation for Amazon WorkMail.
//
// Returns summaries of the organization's groups.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkMail's
// API operation ListGroups for usage and error information.
//
// Returned Error Types:
//   * EntityNotFoundException
//   The identifier supplied for the user, group, or resource does not exist in
//   your organization.
//
//   * InvalidParameterException
//   One or more of the input parameters don't match the service's restrictions.
//
//   * OrganizationNotFoundException
//   An operation received a valid organization identifier that either doesn't
//   belong or exist in the system.
//
//   * OrganizationStateException
//   The organization must have a valid state to perform certain operations on
//   the organization or its members.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListGroups
func (c *WorkMail) ListGroups(input *ListGroupsInput) (*ListGroupsOutput, error) {
	req, out := c.ListGroupsRequest(input)
	return out, req.Send()
}

// ListGroupsWithContext is the same as ListGroups with the addition of
// the ability to pass a context and additional request options.
//
// See ListGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkMail) ListGroupsWithContext(ctx aws.Context, input *ListGroupsInput, opts ...request.Option) (*ListGroupsOutput, error) {
	req, out := c.ListGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListGroupsPages iterates over the pages of a ListGroups operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListGroups method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListGroups operation.
//    pageNum := 0
//    err := client.ListGroupsPages(params,
//        func(page *workmail.ListGroupsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *WorkMail) ListGroupsPages(input *ListGroupsInput, fn func(*ListGroupsOutput, bool) bool) error {
	return c.ListGroupsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListGroupsPagesWithContext same as ListGroupsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkMail) ListGroupsPagesWithContext(ctx aws.Context, input *ListGroupsInput, fn func(*ListGroupsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListGroupsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListGroupsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListGroupsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListMailboxExportJobs = "ListMailboxExportJobs"

// ListMailboxExportJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListMailboxExportJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListMailboxExportJobs for more information on using the ListMailboxExportJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListMailboxExportJobsRequest method.
//    req, resp := client.ListMailboxExportJobsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListMailboxExportJobs
func (c *WorkMail) ListMailboxExportJobsRequest(input *ListMailboxExportJobsInput) (req *request.Request, output *ListMailboxExportJobsOutput) {
	op := &request.Operation{
		Name:       opListMailboxExportJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListMailboxExportJobsInput{}
	}

	output = &ListMailboxExportJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListMailboxExportJobs API operation for Amazon WorkMail.
//
// Lists the mailbox export jobs started for the specified organization within
// the last seven days.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkMail's
// API operation ListMailboxExportJobs for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   One or more of the input parameters don't match the service's restrictions.
//
//   * OrganizationNotFoundException
//   An operation received a valid organization identifier that either doesn't
//   belong or exist in the system.
//
//   * OrganizationStateException
//   The organization must have a valid state to perform certain operations on
//   the organization or its members.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListMailboxExportJobs
func (c *WorkMail) ListMailboxExportJobs(input *ListMailboxExportJobsInput) (*ListMailboxExportJobsOutput, error) {
	req, out := c.ListMailboxExportJobsRequest(input)
	return out, req.Send()
}

// ListMailboxExportJobsWithContext is the same as ListMailboxExportJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListMailboxExportJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkMail) ListMailboxExportJobsWithContext(ctx aws.Context, input *ListMailboxExportJobsInput, opts ...request.Option) (*ListMailboxExportJobsOutput, error) {
	req, out := c.ListMailboxExportJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListMailboxExportJobsPages iterates over the pages of a ListMailboxExportJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListMailboxExportJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListMailboxExportJobs operation.
//    pageNum := 0
//    err := client.ListMailboxExportJobsPages(params,
//        func(page *workmail.ListMailboxExportJobsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *WorkMail) ListMailboxExportJobsPages(input *ListMailboxExportJobsInput, fn func(*ListMailboxExportJobsOutput, bool) bool) error {
	return c.ListMailboxExportJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListMailboxExportJobsPagesWithContext same as ListMailboxExportJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkMail) ListMailboxExportJobsPagesWithContext(ctx aws.Context, input *ListMailboxExportJobsInput, fn func(*ListMailboxExportJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListMailboxExportJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListMailboxExportJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListMailboxExportJobsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListMailboxPermissions = "ListMailboxPermissions"

// ListMailboxPermissionsRequest generates a "aws/request.Request" representing the
// client's request for the ListMailboxPermissions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListMailboxPermissions for more information on using the ListMailboxPermissions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListMailboxPermissionsRequest method.
//    req, resp := client.ListMailboxPermissionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListMailboxPermissions
func (c *WorkMail) ListMailboxPermissionsRequest(input *ListMailboxPermissionsInput) (req *request.Request, output *ListMailboxPermissionsOutput) {
	op := &request.Operation{
		Name:       opListMailboxPermissions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListMailboxPermissionsInput{}
	}

	output = &ListMailboxPermissionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListMailboxPermissions API operation for Amazon WorkMail.
//
// Lists the mailbox permissions associated with a user, group, or resource
// mailbox.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkMail's
// API operation ListMailboxPermissions for usage and error information.
//
// Returned Error Types:
//   * EntityNotFoundException
//   The identifier supplied for the user, group, or resource does not exist in
//   your organization.
//
//   * InvalidParameterException
//   One or more of the input parameters don't match the service's restrictions.
//
//   * OrganizationNotFoundException
//   An operation received a valid organization identifier that either doesn't
//   belong or exist in the system.
//
//   * OrganizationStateException
//   The organization must have a valid state to perform certain operations on
//   the organization or its members.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListMailboxPermissions
func (c *WorkMail) ListMailboxPermissions(input *ListMailboxPermissionsInput) (*ListMailboxPermissionsOutput, error) {
	req, out := c.ListMailboxPermissionsRequest(input)
	return out, req.Send()
}

// ListMailboxPermissionsWithContext is the same as ListMailboxPermissions with the addition of
// the ability to pass a context and additional request options.
//
// See ListMailboxPermissions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkMail) ListMailboxPermissionsWithContext(ctx aws.Context, input *ListMailboxPermissionsInput, opts ...request.Option) (*ListMailboxPermissionsOutput, error) {
	req, out := c.ListMailboxPermissionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListMailboxPermissionsPages iterates over the pages of a ListMailboxPermissions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListMailboxPermissions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListMailboxPermissions operation.
//    pageNum := 0
//    err := client.ListMailboxPermissionsPages(params,
//        func(page *workmail.ListMailboxPermissionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *WorkMail) ListMailboxPermissionsPages(input *ListMailboxPermissionsInput, fn func(*ListMailboxPermissionsOutput, bool) bool) error {
	return c.ListMailboxPermissionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListMailboxPermissionsPagesWithContext same as ListMailboxPermissionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkMail) ListMailboxPermissionsPagesWithContext(ctx aws.Context, input *ListMailboxPermissionsInput, fn func(*ListMailboxPermissionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListMailboxPermissionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListMailboxPermissionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListMailboxPermissionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListOrganizations = "ListOrganizations"

// ListOrganizationsRequest generates a "aws/request.Request" representing the
// client's request for the ListOrganizations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListOrganizations for more information on using the ListOrganizations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListOrganizationsRequest method.
//    req, resp := client.ListOrganizationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListOrganizations
func (c *WorkMail) ListOrganizationsRequest(input *ListOrganizationsInput) (req *request.Request, output *ListOrganizationsOutput) {
	op := &request.Operation{
		Name:       opListOrganizations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListOrganizationsInput{}
	}

	output = &ListOrganizationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListOrganizations API operation for Amazon WorkMail.
//
// Returns summaries of the customer's organizations.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkMail's
// API operation ListOrganizations for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   One or more of the input parameters don't match the service's restrictions.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListOrganizations
func (c *WorkMail) ListOrganizations(input *ListOrganizationsInput) (*ListOrganizationsOutput, error) {
	req, out := c.ListOrganizationsRequest(input)
	return out, req.Send()
}

// ListOrganizationsWithContext is the same as ListOrganizations with the addition of
// the ability to pass a context and additional request options.
//
// See ListOrganizations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkMail) ListOrganizationsWithContext(ctx aws.Context, input *ListOrganizationsInput, opts ...request.Option) (*ListOrganizationsOutput, error) {
	req, out := c.ListOrganizationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListOrganizationsPages iterates over the pages of a ListOrganizations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListOrganizations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListOrganizations operation.
//    pageNum := 0
//    err := client.ListOrganizationsPages(params,
//        func(page *workmail.ListOrganizationsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *WorkMail) ListOrganizationsPages(input *ListOrganizationsInput, fn func(*ListOrganizationsOutput, bool) bool) error {
	return c.ListOrganizationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListOrganizationsPagesWithContext same as ListOrganizationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkMail) ListOrganizationsPagesWithContext(ctx aws.Context, input *ListOrganizationsInput, fn func(*ListOrganizationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListOrganizationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListOrganizationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListOrganizationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListResourceDelegates = "ListResourceDelegates"

// ListResourceDelegatesRequest generates a "aws/request.Request" representing the
// client's request for the ListResourceDelegates operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListResourceDelegates for more information on using the ListResourceDelegates
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListResourceDelegatesRequest method.
//    req, resp := client.ListResourceDelegatesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListResourceDelegates
func (c *WorkMail) ListResourceDelegatesRequest(input *ListResourceDelegatesInput) (req *request.Request, output *ListResourceDelegatesOutput) {
	op := &request.Operation{
		Name:       opListResourceDelegates,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListResourceDelegatesInput{}
	}

	output = &ListResourceDelegatesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListResourceDelegates API operation for Amazon WorkMail.
//
// Lists the delegates associated with a resource. Users and groups can be resource
// delegates and answer requests on behalf of the resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkMail's
// API operation ListResourceDelegates for usage and error information.
//
// Returned Error Types:
//   * EntityNotFoundException
//   The identifier supplied for the user, group, or resource does not exist in
//   your organization.
//
//   * EntityStateException
//   You are performing an operation on a user, group, or resource that isn't
//   in the expected state, such as trying to delete an active user.
//
//   * InvalidParameterException
//   One or more of the input parameters don't match the service's restrictions.
//
//   * OrganizationNotFoundException
//   An operation received a valid organization identifier that either doesn't
//   belong or exist in the system.
//
//   * OrganizationStateException
//   The organization must have a valid state to perform certain operations on
//   the organization or its members.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListResourceDelegates
func (c *WorkMail) ListResourceDelegates(input *ListResourceDelegatesInput) (*ListResourceDelegatesOutput, error) {
	req, out := c.ListResourceDelegatesRequest(input)
	return out, req.Send()
}

// ListResourceDelegatesWithContext is the same as ListResourceDelegates with the addition of
// the ability to pass a context and additional request options.
//
// See ListResourceDelegates for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkMail) ListResourceDelegatesWithContext(ctx aws.Context, input *ListResourceDelegatesInput, opts ...request.Option) (*ListResourceDelegatesOutput, error) {
	req, out := c.ListResourceDelegatesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListResourceDelegatesPages iterates over the pages of a ListResourceDelegates operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListResourceDelegates method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListResourceDelegates operation.
//    pageNum := 0
//    err := client.ListResourceDelegatesPages(params,
//        func(page *workmail.ListResourceDelegatesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *WorkMail) ListResourceDelegatesPages(input *ListResourceDelegatesInput, fn func(*ListResourceDelegatesOutput, bool) bool) error {
	return c.ListResourceDelegatesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListResourceDelegatesPagesWithContext same as ListResourceDelegatesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkMail) ListResourceDelegatesPagesWithContext(ctx aws.Context, input *ListResourceDelegatesInput, fn func(*ListResourceDelegatesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListResourceDelegatesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListResourceDelegatesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListResourceDelegatesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListResources = "ListResources"

// ListResourcesRequest generates a "aws/request.Request" representing the
// client's request for the ListResources operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListResources for more information on using the ListResources
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListResourcesRequest method.
//    req, resp := client.ListResourcesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListResources
func (c *WorkMail) ListResourcesRequest(input *ListResourcesInput) (req *request.Request, output *ListResourcesOutput) {
	op := &request.Operation{
		Name:       opListResources,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListResourcesInput{}
	}

	output = &ListResourcesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListResources API operation for Amazon WorkMail.
//
// Returns summaries of the organization's resources.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkMail's
// API operation ListResources for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   One or more of the input parameters don't match the service's restrictions.
//
//   * OrganizationNotFoundException
//   An operation received a valid organization identifier that either doesn't
//   belong or exist in the system.
//
//   * OrganizationStateException
//   The organization must have a valid state to perform certain operations on
//   the organization or its members.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListResources
func (c *WorkMail) ListResources(input *ListResourcesInput) (*ListResourcesOutput, error) {
	req, out := c.ListResourcesRequest(input)
	return out, req.Send()
}

// ListResourcesWithContext is the same as ListResources with the addition of
// the ability to pass a context and additional request options.
//
// See ListResources for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkMail) ListResourcesWithContext(ctx aws.Context, input *ListResourcesInput, opts ...request.Option) (*ListResourcesOutput, error) {
	req, out := c.ListResourcesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListResourcesPages iterates over the pages of a ListResources operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListResources method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListResources operation.
//    pageNum := 0
//    err := client.ListResourcesPages(params,
//        func(page *workmail.ListResourcesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *WorkMail) ListResourcesPages(input *ListResourcesInput, fn func(*ListResourcesOutput, bool) bool) error {
	return c.ListResourcesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListResourcesPagesWithContext same as ListResourcesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkMail) ListResourcesPagesWithContext(ctx aws.Context, input *ListResourcesInput, fn func(*ListResourcesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListResourcesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListResourcesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListResourcesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListTagsForResource
func (c *WorkMail) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Amazon WorkMail.
//
// Lists the tags applied to an Amazon WorkMail organization resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkMail's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The resource cannot be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListTagsForResource
func (c *WorkMail) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkMail) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListUsers = "ListUsers"

// ListUsersRequest generates a "aws/request.Request" representing the
// client's request for the ListUsers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListUsers for more information on using the ListUsers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListUsersRequest method.
//    req, resp := client.ListUsersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListUsers
func (c *WorkMail) ListUsersRequest(input *ListUsersInput) (req *request.Request, output *ListUsersOutput) {
	op := &request.Operation{
		Name:       opListUsers,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListUsersInput{}
	}

	output = &ListUsersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListUsers API operation for Amazon WorkMail.
//
// Returns summaries of the organization's users.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkMail's
// API operation ListUsers for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   One or more of the input parameters don't match the service's restrictions.
//
//   * OrganizationNotFoundException
//   An operation received a valid organization identifier that either doesn't
//   belong or exist in the system.
//
//   * OrganizationStateException
//   The organization must have a valid state to perform certain operations on
//   the organization or its members.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListUsers
func (c *WorkMail) ListUsers(input *ListUsersInput) (*ListUsersOutput, error) {
	req, out := c.ListUsersRequest(input)
	return out, req.Send()
}

// ListUsersWithContext is the same as ListUsers with the addition of
// the ability to pass a context and additional request options.
//
// See ListUsers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkMail) ListUsersWithContext(ctx aws.Context, input *ListUsersInput, opts ...request.Option) (*ListUsersOutput, error) {
	req, out := c.ListUsersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListUsersPages iterates over the pages of a ListUsers operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListUsers method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListUsers operation.
//    pageNum := 0
//    err := client.ListUsersPages(params,
//        func(page *workmail.ListUsersOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *WorkMail) ListUsersPages(input *ListUsersInput, fn func(*ListUsersOutput, bool) bool) error {
	return c.ListUsersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListUsersPagesWithContext same as ListUsersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkMail) ListUsersPagesWithContext(ctx aws.Context, input *ListUsersInput, fn func(*ListUsersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListUsersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListUsersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListUsersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opPutAccessControlRule = "PutAccessControlRule"

// PutAccessControlRuleRequest generates a "aws/request.Request" representing the
// client's request for the PutAccessControlRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutAccessControlRule for more information on using the PutAccessControlRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutAccessControlRuleRequest method.
//    req, resp := client.PutAccessControlRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/PutAccessControlRule
func (c *WorkMail) PutAccessControlRuleRequest(input *PutAccessControlRuleInput) (req *request.Request, output *PutAccessControlRuleOutput) {
	op := &request.Operation{
		Name:       opPutAccessControlRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutAccessControlRuleInput{}
	}

	output = &PutAccessControlRuleOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutAccessControlRule API operation for Amazon WorkMail.
//
// Adds a new access control rule for the specified organization. The rule allows
// or denies access to the organization for the specified IPv4 addresses, access
// protocol actions, and user IDs. Adding a new rule with the same name as an
// existing rule replaces the older rule.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkMail's
// API operation PutAccessControlRule for usage and error information.
//
// Returned Error Types:
//   * LimitExceededException
//   The request exceeds the limit of the resource.
//
//   * InvalidParameterException
//   One or more of the input parameters don't match the service's restrictions.
//
//   * EntityNotFoundException
//   The identifier supplied for the user, group, or resource does not exist in
//   your organization.
//
//   * OrganizationNotFoundException
//   An operation received a valid organization identifier that either doesn't
//   belong or exist in the system.
//
//   * OrganizationStateException
//   The organization must have a valid state to perform certain operations on
//   the organization or its members.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/PutAccessControlRule
func (c *WorkMail) PutAccessControlRule(input *PutAccessControlRuleInput) (*PutAccessControlRuleOutput, error) {
	req, out := c.PutAccessControlRuleRequest(input)
	return out, req.Send()
}

// PutAccessControlRuleWithContext is the same as PutAccessControlRule with the addition of
// the ability to pass a context and additional request options.
//
// See PutAccessControlRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkMail) PutAccessControlRuleWithContext(ctx aws.Context, input *PutAccessControlRuleInput, opts ...request.Option) (*PutAccessControlRuleOutput, error) {
	req, out := c.PutAccessControlRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutMailboxPermissions = "PutMailboxPermissions"

// PutMailboxPermissionsRequest generates a "aws/request.Request" representing the
// client's request for the PutMailboxPermissions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutMailboxPermissions for more information on using the PutMailboxPermissions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutMailboxPermissionsRequest method.
//    req, resp := client.PutMailboxPermissionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/PutMailboxPermissions
func (c *WorkMail) PutMailboxPermissionsRequest(input *PutMailboxPermissionsInput) (req *request.Request, output *PutMailboxPermissionsOutput) {
	op := &request.Operation{
		Name:       opPutMailboxPermissions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutMailboxPermissionsInput{}
	}

	output = &PutMailboxPermissionsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutMailboxPermissions API operation for Amazon WorkMail.
//
// Sets permissions for a user, group, or resource. This replaces any pre-existing
// permissions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkMail's
// API operation PutMailboxPermissions for usage and error information.
//
// Returned Error Types:
//   * EntityNotFoundException
//   The identifier supplied for the user, group, or resource does not exist in
//   your organization.
//
//   * EntityStateException
//   You are performing an operation on a user, group, or resource that isn't
//   in the expected state, such as trying to delete an active user.
//
//   * InvalidParameterException
//   One or more of the input parameters don't match the service's restrictions.
//
//   * OrganizationNotFoundException
//   An operation received a valid organization identifier that either doesn't
//   belong or exist in the system.
//
//   * OrganizationStateException
//   The organization must have a valid state to perform certain operations on
//   the organization or its members.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/PutMailboxPermissions
func (c *WorkMail) PutMailboxPermissions(input *PutMailboxPermissionsInput) (*PutMailboxPermissionsOutput, error) {
	req, out := c.PutMailboxPermissionsRequest(input)
	return out, req.Send()
}

// PutMailboxPermissionsWithContext is the same as PutMailboxPermissions with the addition of
// the ability to pass a context and additional request options.
//
// See PutMailboxPermissions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkMail) PutMailboxPermissionsWithContext(ctx aws.Context, input *PutMailboxPermissionsInput, opts ...request.Option) (*PutMailboxPermissionsOutput, error) {
	req, out := c.PutMailboxPermissionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutRetentionPolicy = "PutRetentionPolicy"

// PutRetentionPolicyRequest generates a "aws/request.Request" representing the
// client's request for the PutRetentionPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutRetentionPolicy for more information on using the PutRetentionPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutRetentionPolicyRequest method.
//    req, resp := client.PutRetentionPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/PutRetentionPolicy
func (c *WorkMail) PutRetentionPolicyRequest(input *PutRetentionPolicyInput) (req *request.Request, output *PutRetentionPolicyOutput) {
	op := &request.Operation{
		Name:       opPutRetentionPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutRetentionPolicyInput{}
	}

	output = &PutRetentionPolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutRetentionPolicy API operation for Amazon WorkMail.
//
// Puts a retention policy to the specified organization.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkMail's
// API operation PutRetentionPolicy for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   One or more of the input parameters don't match the service's restrictions.
//
//   * OrganizationNotFoundException
//   An operation received a valid organization identifier that either doesn't
//   belong or exist in the system.
//
//   * OrganizationStateException
//   The organization must have a valid state to perform certain operations on
//   the organization or its members.
//
//   * LimitExceededException
//   The request exceeds the limit of the resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/PutRetentionPolicy
func (c *WorkMail) PutRetentionPolicy(input *PutRetentionPolicyInput) (*PutRetentionPolicyOutput, error) {
	req, out := c.PutRetentionPolicyRequest(input)
	return out, req.Send()
}

// PutRetentionPolicyWithContext is the same as PutRetentionPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See PutRetentionPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkMail) PutRetentionPolicyWithContext(ctx aws.Context, input *PutRetentionPolicyInput, opts ...request.Option) (*PutRetentionPolicyOutput, error) {
	req, out := c.PutRetentionPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRegisterToWorkMail = "RegisterToWorkMail"

// RegisterToWorkMailRequest generates a "aws/request.Request" representing the
// client's request for the RegisterToWorkMail operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RegisterToWorkMail for more information on using the RegisterToWorkMail
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RegisterToWorkMailRequest method.
//    req, resp := client.RegisterToWorkMailRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/RegisterToWorkMail
func (c *WorkMail) RegisterToWorkMailRequest(input *RegisterToWorkMailInput) (req *request.Request, output *RegisterToWorkMailOutput) {
	op := &request.Operation{
		Name:       opRegisterToWorkMail,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RegisterToWorkMailInput{}
	}

	output = &RegisterToWorkMailOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// RegisterToWorkMail API operation for Amazon WorkMail.
//
// Registers an existing and disabled user, group, or resource for Amazon WorkMail
// use by associating a mailbox and calendaring capabilities. It performs no
// change if the user, group, or resource is enabled and fails if the user,
// group, or resource is deleted. This operation results in the accumulation
// of costs. For more information, see Pricing (https://aws.amazon.com/workmail/pricing).
// The equivalent console functionality for this operation is Enable.
//
// Users can either be created by calling the CreateUser API operation or they
// can be synchronized from your directory. For more information, see DeregisterFromWorkMail.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkMail's
// API operation RegisterToWorkMail for usage and error information.
//
// Returned Error Types:
//   * DirectoryServiceAuthenticationFailedException
//   The directory service doesn't recognize the credentials supplied by WorkMail.
//
//   * DirectoryUnavailableException
//   The directory is unavailable. It might be located in another Region or deleted.
//
//   * EmailAddressInUseException
//   The email address that you're trying to assign is already created for a different
//   user, group, or resource.
//
//   * EntityNotFoundException
//   The identifier supplied for the user, group, or resource does not exist in
//   your organization.
//
//   * EntityStateException
//   You are performing an operation on a user, group, or resource that isn't
//   in the expected state, such as trying to delete an active user.
//
//   * EntityAlreadyRegisteredException
//   The user, group, or resource that you're trying to register is already registered.
//
//   * InvalidParameterException
//   One or more of the input parameters don't match the service's restrictions.
//
//   * MailDomainNotFoundException
//   For an email or alias to be created in Amazon WorkMail, the included domain
//   must be defined in the organization.
//
//   * MailDomainStateException
//   After a domain has been added to the organization, it must be verified. The
//   domain is not yet verified.
//
//   * OrganizationNotFoundException
//   An operation received a valid organization identifier that either doesn't
//   belong or exist in the system.
//
//   * OrganizationStateException
//   The organization must have a valid state to perform certain operations on
//   the organization or its members.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/RegisterToWorkMail
func (c *WorkMail) RegisterToWorkMail(input *RegisterToWorkMailInput) (*RegisterToWorkMailOutput, error) {
	req, out := c.RegisterToWorkMailRequest(input)
	return out, req.Send()
}

// RegisterToWorkMailWithContext is the same as RegisterToWorkMail with the addition of
// the ability to pass a context and additional request options.
//
// See RegisterToWorkMail for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkMail) RegisterToWorkMailWithContext(ctx aws.Context, input *RegisterToWorkMailInput, opts ...request.Option) (*RegisterToWorkMailOutput, error) {
	req, out := c.RegisterToWorkMailRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opResetPassword = "ResetPassword"

// ResetPasswordRequest generates a "aws/request.Request" representing the
// client's request for the ResetPassword operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ResetPassword for more information on using the ResetPassword
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ResetPasswordRequest method.
//    req, resp := client.ResetPasswordRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ResetPassword
func (c *WorkMail) ResetPasswordRequest(input *ResetPasswordInput) (req *request.Request, output *ResetPasswordOutput) {
	op := &request.Operation{
		Name:       opResetPassword,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ResetPasswordInput{}
	}

	output = &ResetPasswordOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// ResetPassword API operation for Amazon WorkMail.
//
// Allows the administrator to reset the password for a user.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkMail's
// API operation ResetPassword for usage and error information.
//
// Returned Error Types:
//   * DirectoryServiceAuthenticationFailedException
//   The directory service doesn't recognize the credentials supplied by WorkMail.
//
//   * DirectoryUnavailableException
//   The directory is unavailable. It might be located in another Region or deleted.
//
//   * EntityNotFoundException
//   The identifier supplied for the user, group, or resource does not exist in
//   your organization.
//
//   * EntityStateException
//   You are performing an operation on a user, group, or resource that isn't
//   in the expected state, such as trying to delete an active user.
//
//   * InvalidParameterException
//   One or more of the input parameters don't match the service's restrictions.
//
//   * InvalidPasswordException
//   The supplied password doesn't match the minimum security constraints, such
//   as length or use of special characters.
//
//   * OrganizationNotFoundException
//   An operation received a valid organization identifier that either doesn't
//   belong or exist in the system.
//
//   * OrganizationStateException
//   The organization must have a valid state to perform certain operations on
//   the organization or its members.
//
//   * UnsupportedOperationException
//   You can't perform a write operation against a read-only directory.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ResetPassword
func (c *WorkMail) ResetPassword(input *ResetPasswordInput) (*ResetPasswordOutput, error) {
	req, out := c.ResetPasswordRequest(input)
	return out, req.Send()
}

// ResetPasswordWithContext is the same as ResetPassword with the addition of
// the ability to pass a context and additional request options.
//
// See ResetPassword for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkMail) ResetPasswordWithContext(ctx aws.Context, input *ResetPasswordInput, opts ...request.Option) (*ResetPasswordOutput, error) {
	req, out := c.ResetPasswordRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartMailboxExportJob = "StartMailboxExportJob"

// StartMailboxExportJobRequest generates a "aws/request.Request" representing the
// client's request for the StartMailboxExportJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartMailboxExportJob for more information on using the StartMailboxExportJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartMailboxExportJobRequest method.
//    req, resp := client.StartMailboxExportJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/StartMailboxExportJob
func (c *WorkMail) StartMailboxExportJobRequest(input *StartMailboxExportJobInput) (req *request.Request, output *StartMailboxExportJobOutput) {
	op := &request.Operation{
		Name:       opStartMailboxExportJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartMailboxExportJobInput{}
	}

	output = &StartMailboxExportJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartMailboxExportJob API operation for Amazon WorkMail.
//
// Starts a mailbox export job to export MIME-format email messages and calendar
// items from the specified mailbox to the specified Amazon Simple Storage Service
// (Amazon S3) bucket. For more information, see Exporting mailbox content (https://docs.aws.amazon.com/workmail/latest/adminguide/mail-export.html)
// in the Amazon WorkMail Administrator Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkMail's
// API operation StartMailboxExportJob for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   One or more of the input parameters don't match the service's restrictions.
//
//   * OrganizationNotFoundException
//   An operation received a valid organization identifier that either doesn't
//   belong or exist in the system.
//
//   * OrganizationStateException
//   The organization must have a valid state to perform certain operations on
//   the organization or its members.
//
//   * EntityNotFoundException
//   The identifier supplied for the user, group, or resource does not exist in
//   your organization.
//
//   * LimitExceededException
//   The request exceeds the limit of the resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/StartMailboxExportJob
func (c *WorkMail) StartMailboxExportJob(input *StartMailboxExportJobInput) (*StartMailboxExportJobOutput, error) {
	req, out := c.StartMailboxExportJobRequest(input)
	return out, req.Send()
}

// StartMailboxExportJobWithContext is the same as StartMailboxExportJob with the addition of
// the ability to pass a context and additional request options.
//
// See StartMailboxExportJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkMail) StartMailboxExportJobWithContext(ctx aws.Context, input *StartMailboxExportJobInput, opts ...request.Option) (*StartMailboxExportJobOutput, error) {
	req, out := c.StartMailboxExportJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/TagResource
func (c *WorkMail) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Amazon WorkMail.
//
// Applies the specified tags to the specified Amazon WorkMail organization
// resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkMail's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The resource cannot be found.
//
//   * TooManyTagsException
//   The resource can have up to 50 user-applied tags.
//
//   * OrganizationStateException
//   The organization must have a valid state to perform certain operations on
//   the organization or its members.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/TagResource
func (c *WorkMail) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkMail) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/UntagResource
func (c *WorkMail) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Amazon WorkMail.
//
// Untags the specified tags from the specified Amazon WorkMail organization
// resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkMail's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The resource cannot be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/UntagResource
func (c *WorkMail) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkMail) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateMailboxQuota = "UpdateMailboxQuota"

// UpdateMailboxQuotaRequest generates a "aws/request.Request" representing the
// client's request for the UpdateMailboxQuota operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateMailboxQuota for more information on using the UpdateMailboxQuota
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateMailboxQuotaRequest method.
//    req, resp := client.UpdateMailboxQuotaRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/UpdateMailboxQuota
func (c *WorkMail) UpdateMailboxQuotaRequest(input *UpdateMailboxQuotaInput) (req *request.Request, output *UpdateMailboxQuotaOutput) {
	op := &request.Operation{
		Name:       opUpdateMailboxQuota,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateMailboxQuotaInput{}
	}

	output = &UpdateMailboxQuotaOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateMailboxQuota API operation for Amazon WorkMail.
//
// Updates a user's current mailbox quota for a specified organization and user.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkMail's
// API operation UpdateMailboxQuota for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   One or more of the input parameters don't match the service's restrictions.
//
//   * OrganizationNotFoundException
//   An operation received a valid organization identifier that either doesn't
//   belong or exist in the system.
//
//   * OrganizationStateException
//   The organization must have a valid state to perform certain operations on
//   the organization or its members.
//
//   * EntityNotFoundException
//   The identifier supplied for the user, group, or resource does not exist in
//   your organization.
//
//   * EntityStateException
//   You are performing an operation on a user, group, or resource that isn't
//   in the expected state, such as trying to delete an active user.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/UpdateMailboxQuota
func (c *WorkMail) UpdateMailboxQuota(input *UpdateMailboxQuotaInput) (*UpdateMailboxQuotaOutput, error) {
	req, out := c.UpdateMailboxQuotaRequest(input)
	return out, req.Send()
}

// UpdateMailboxQuotaWithContext is the same as UpdateMailboxQuota with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateMailboxQuota for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkMail) UpdateMailboxQuotaWithContext(ctx aws.Context, input *UpdateMailboxQuotaInput, opts ...request.Option) (*UpdateMailboxQuotaOutput, error) {
	req, out := c.UpdateMailboxQuotaRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdatePrimaryEmailAddress = "UpdatePrimaryEmailAddress"

// UpdatePrimaryEmailAddressRequest generates a "aws/request.Request" representing the
// client's request for the UpdatePrimaryEmailAddress operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdatePrimaryEmailAddress for more information on using the UpdatePrimaryEmailAddress
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdatePrimaryEmailAddressRequest method.
//    req, resp := client.UpdatePrimaryEmailAddressRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/UpdatePrimaryEmailAddress
func (c *WorkMail) UpdatePrimaryEmailAddressRequest(input *UpdatePrimaryEmailAddressInput) (req *request.Request, output *UpdatePrimaryEmailAddressOutput) {
	op := &request.Operation{
		Name:       opUpdatePrimaryEmailAddress,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdatePrimaryEmailAddressInput{}
	}

	output = &UpdatePrimaryEmailAddressOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdatePrimaryEmailAddress API operation for Amazon WorkMail.
//
// Updates the primary email for a user, group, or resource. The current email
// is moved into the list of aliases (or swapped between an existing alias and
// the current primary email), and the email provided in the input is promoted
// as the primary.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkMail's
// API operation UpdatePrimaryEmailAddress for usage and error information.
//
// Returned Error Types:
//   * DirectoryServiceAuthenticationFailedException
//   The directory service doesn't recognize the credentials supplied by WorkMail.
//
//   * DirectoryUnavailableException
//   The directory is unavailable. It might be located in another Region or deleted.
//
//   * EmailAddressInUseException
//   The email address that you're trying to assign is already created for a different
//   user, group, or resource.
//
//   * EntityNotFoundException
//   The identifier supplied for the user, group, or resource does not exist in
//   your organization.
//
//   * EntityStateException
//   You are performing an operation on a user, group, or resource that isn't
//   in the expected state, such as trying to delete an active user.
//
//   * InvalidParameterException
//   One or more of the input parameters don't match the service's restrictions.
//
//   * MailDomainNotFoundException
//   For an email or alias to be created in Amazon WorkMail, the included domain
//   must be defined in the organization.
//
//   * MailDomainStateException
//   After a domain has been added to the organization, it must be verified. The
//   domain is not yet verified.
//
//   * InvalidParameterException
//   One or more of the input parameters don't match the service's restrictions.
//
//   * OrganizationNotFoundException
//   An operation received a valid organization identifier that either doesn't
//   belong or exist in the system.
//
//   * OrganizationStateException
//   The organization must have a valid state to perform certain operations on
//   the organization or its members.
//
//   * UnsupportedOperationException
//   You can't perform a write operation against a read-only directory.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/UpdatePrimaryEmailAddress
func (c *WorkMail) UpdatePrimaryEmailAddress(input *UpdatePrimaryEmailAddressInput) (*UpdatePrimaryEmailAddressOutput, error) {
	req, out := c.UpdatePrimaryEmailAddressRequest(input)
	return out, req.Send()
}

// UpdatePrimaryEmailAddressWithContext is the same as UpdatePrimaryEmailAddress with the addition of
// the ability to pass a context and additional request options.
//
// See UpdatePrimaryEmailAddress for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkMail) UpdatePrimaryEmailAddressWithContext(ctx aws.Context, input *UpdatePrimaryEmailAddressInput, opts ...request.Option) (*UpdatePrimaryEmailAddressOutput, error) {
	req, out := c.UpdatePrimaryEmailAddressRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateResource = "UpdateResource"

// UpdateResourceRequest generates a "aws/request.Request" representing the
// client's request for the UpdateResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateResource for more information on using the UpdateResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateResourceRequest method.
//    req, resp := client.UpdateResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/UpdateResource
func (c *WorkMail) UpdateResourceRequest(input *UpdateResourceInput) (req *request.Request, output *UpdateResourceOutput) {
	op := &request.Operation{
		Name:       opUpdateResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateResourceInput{}
	}

	output = &UpdateResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateResource API operation for Amazon WorkMail.
//
// Updates data for the resource. To have the latest information, it must be
// preceded by a DescribeResource call. The dataset in the request should be
// the one expected when performing another DescribeResource call.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkMail's
// API operation UpdateResource for usage and error information.
//
// Returned Error Types:
//   * DirectoryUnavailableException
//   The directory is unavailable. It might be located in another Region or deleted.
//
//   * EntityNotFoundException
//   The identifier supplied for the user, group, or resource does not exist in
//   your organization.
//
//   * EntityStateException
//   You are performing an operation on a user, group, or resource that isn't
//   in the expected state, such as trying to delete an active user.
//
//   * InvalidConfigurationException
//   The configuration for a resource isn't valid. A resource must either be able
//   to auto-respond to requests or have at least one delegate associated that
//   can do so on its behalf.
//
//   * EmailAddressInUseException
//   The email address that you're trying to assign is already created for a different
//   user, group, or resource.
//
//   * MailDomainNotFoundException
//   For an email or alias to be created in Amazon WorkMail, the included domain
//   must be defined in the organization.
//
//   * MailDomainStateException
//   After a domain has been added to the organization, it must be verified. The
//   domain is not yet verified.
//
//   * NameAvailabilityException
//   The user, group, or resource name isn't unique in Amazon WorkMail.
//
//   * OrganizationNotFoundException
//   An operation received a valid organization identifier that either doesn't
//   belong or exist in the system.
//
//   * OrganizationStateException
//   The organization must have a valid state to perform certain operations on
//   the organization or its members.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/UpdateResource
func (c *WorkMail) UpdateResource(input *UpdateResourceInput) (*UpdateResourceOutput, error) {
	req, out := c.UpdateResourceRequest(input)
	return out, req.Send()
}

// UpdateResourceWithContext is the same as UpdateResource with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkMail) UpdateResourceWithContext(ctx aws.Context, input *UpdateResourceInput, opts ...request.Option) (*UpdateResourceOutput, error) {
	req, out := c.UpdateResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// A rule that controls access to an Amazon WorkMail organization.
type AccessControlRule struct {
	_ struct{} `type:"structure"`

	// Access protocol actions to include in the rule. Valid values include ActiveSync,
	// AutoDiscover, EWS, IMAP, SMTP, WindowsOutlook, and WebMail.
	Actions []*string `type:"list"`

	// The date that the rule was created.
	DateCreated *time.Time `type:"timestamp"`

	// The date that the rule was modified.
	DateModified *time.Time `type:"timestamp"`

	// The rule description.
	Description *string `type:"string"`

	// The rule effect.
	Effect *string `type:"string" enum:"AccessControlRuleEffect"`

	// IPv4 CIDR ranges to include in the rule.
	IpRanges []*string `type:"list"`

	// The rule name.
	Name *string `min:"1" type:"string"`

	// Access protocol actions to exclude from the rule. Valid values include ActiveSync,
	// AutoDiscover, EWS, IMAP, SMTP, WindowsOutlook, and WebMail.
	NotActions []*string `type:"list"`

	// IPv4 CIDR ranges to exclude from the rule.
	NotIpRanges []*string `type:"list"`

	// User IDs to exclude from the rule.
	NotUserIds []*string `type:"list"`

	// User IDs to include in the rule.
	UserIds []*string `type:"list"`
}

// String returns the string representation
func (s AccessControlRule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccessControlRule) GoString() string {
	return s.String()
}

// SetActions sets the Actions field's value.
func (s *AccessControlRule) SetActions(v []*string) *AccessControlRule {
	s.Actions = v
	return s
}

// SetDateCreated sets the DateCreated field's value.
func (s *AccessControlRule) SetDateCreated(v time.Time) *AccessControlRule {
	s.DateCreated = &v
	return s
}

// SetDateModified sets the DateModified field's value.
func (s *AccessControlRule) SetDateModified(v time.Time) *AccessControlRule {
	s.DateModified = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *AccessControlRule) SetDescription(v string) *AccessControlRule {
	s.Description = &v
	return s
}

// SetEffect sets the Effect field's value.
func (s *AccessControlRule) SetEffect(v string) *AccessControlRule {
	s.Effect = &v
	return s
}

// SetIpRanges sets the IpRanges field's value.
func (s *AccessControlRule) SetIpRanges(v []*string) *AccessControlRule {
	s.IpRanges = v
	return s
}

// SetName sets the Name field's value.
func (s *AccessControlRule) SetName(v string) *AccessControlRule {
	s.Name = &v
	return s
}

// SetNotActions sets the NotActions field's value.
func (s *AccessControlRule) SetNotActions(v []*string) *AccessControlRule {
	s.NotActions = v
	return s
}

// SetNotIpRanges sets the NotIpRanges field's value.
func (s *AccessControlRule) SetNotIpRanges(v []*string) *AccessControlRule {
	s.NotIpRanges = v
	return s
}

// SetNotUserIds sets the NotUserIds field's value.
func (s *AccessControlRule) SetNotUserIds(v []*string) *AccessControlRule {
	s.NotUserIds = v
	return s
}

// SetUserIds sets the UserIds field's value.
func (s *AccessControlRule) SetUserIds(v []*string) *AccessControlRule {
	s.UserIds = v
	return s
}

type AssociateDelegateToResourceInput struct {
	_ struct{} `type:"structure"`

	// The member (user or group) to associate to the resource.
	//
	// EntityId is a required field
	EntityId *string `min:"12" type:"string" required:"true"`

	// The organization under which the resource exists.
	//
	// OrganizationId is a required field
	OrganizationId *string `min:"34" type:"string" required:"true"`

	// The resource for which members (users or groups) are associated.
	//
	// ResourceId is a required field
	ResourceId *string `min:"34" type:"string" required:"true"`
}

// String returns the string representation
func (s AssociateDelegateToResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateDelegateToResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateDelegateToResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateDelegateToResourceInput"}
	if s.EntityId == nil {
		invalidParams.Add(request.NewErrParamRequired("EntityId"))
	}
	if s.EntityId != nil && len(*s.EntityId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("EntityId", 12))
	}
	if s.OrganizationId == nil {
		invalidParams.Add(request.NewErrParamRequired("OrganizationId"))
	}
	if s.OrganizationId != nil && len(*s.OrganizationId) < 34 {
		invalidParams.Add(request.NewErrParamMinLen("OrganizationId", 34))
	}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 34 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 34))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEntityId sets the EntityId field's value.
func (s *AssociateDelegateToResourceInput) SetEntityId(v string) *AssociateDelegateToResourceInput {
	s.EntityId = &v
	return s
}

// SetOrganizationId sets the OrganizationId field's value.
func (s *AssociateDelegateToResourceInput) SetOrganizationId(v string) *AssociateDelegateToResourceInput {
	s.OrganizationId = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *AssociateDelegateToResourceInput) SetResourceId(v string) *AssociateDelegateToResourceInput {
	s.ResourceId = &v
	return s
}

type AssociateDelegateToResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AssociateDelegateToResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateDelegateToResourceOutput) GoString() string {
	return s.String()
}

type AssociateMemberToGroupInput struct {
	_ struct{} `type:"structure"`

	// The group to which the member (user or group) is associated.
	//
	// GroupId is a required field
	GroupId *string `min:"12" type:"string" required:"true"`

	// The member (user or group) to associate to the group.
	//
	// MemberId is a required field
	MemberId *string `min:"12" type:"string" required:"true"`

	// The organization under which the group exists.
	//
	// OrganizationId is a required field
	OrganizationId *string `min:"34" type:"string" required:"true"`
}

// String returns the string representation
func (s AssociateMemberToGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateMemberToGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateMemberToGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateMemberToGroupInput"}
	if s.GroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupId"))
	}
	if s.GroupId != nil && len(*s.GroupId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("GroupId", 12))
	}
	if s.MemberId == nil {
		invalidParams.Add(request.NewErrParamRequired("MemberId"))
	}
	if s.MemberId != nil && len(*s.MemberId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("MemberId", 12))
	}
	if s.OrganizationId == nil {
		invalidParams.Add(request.NewErrParamRequired("OrganizationId"))
	}
	if s.OrganizationId != nil && len(*s.OrganizationId) < 34 {
		invalidParams.Add(request.NewErrParamMinLen("OrganizationId", 34))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroupId sets the GroupId field's value.
func (s *AssociateMemberToGroupInput) SetGroupId(v string) *AssociateMemberToGroupInput {
	s.GroupId = &v
	return s
}

// SetMemberId sets the MemberId field's value.
func (s *AssociateMemberToGroupInput) SetMemberId(v string) *AssociateMemberToGroupInput {
	s.MemberId = &v
	return s
}

// SetOrganizationId sets the OrganizationId field's value.
func (s *AssociateMemberToGroupInput) SetOrganizationId(v string) *AssociateMemberToGroupInput {
	s.OrganizationId = &v
	return s
}

type AssociateMemberToGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AssociateMemberToGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateMemberToGroupOutput) GoString() string {
	return s.String()
}

// At least one delegate must be associated to the resource to disable automatic
// replies from the resource.
type BookingOptions struct {
	_ struct{} `type:"structure"`

	// The resource's ability to automatically reply to requests. If disabled, delegates
	// must be associated to the resource.
	AutoAcceptRequests *bool `type:"boolean"`

	// The resource's ability to automatically decline any conflicting requests.
	AutoDeclineConflictingRequests *bool `type:"boolean"`

	// The resource's ability to automatically decline any recurring requests.
	AutoDeclineRecurringRequests *bool `type:"boolean"`
}

// String returns the string representation
func (s BookingOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BookingOptions) GoString() string {
	return s.String()
}

// SetAutoAcceptRequests sets the AutoAcceptRequests field's value.
func (s *BookingOptions) SetAutoAcceptRequests(v bool) *BookingOptions {
	s.AutoAcceptRequests = &v
	return s
}

// SetAutoDeclineConflictingRequests sets the AutoDeclineConflictingRequests field's value.
func (s *BookingOptions) SetAutoDeclineConflictingRequests(v bool) *BookingOptions {
	s.AutoDeclineConflictingRequests = &v
	return s
}

// SetAutoDeclineRecurringRequests sets the AutoDeclineRecurringRequests field's value.
func (s *BookingOptions) SetAutoDeclineRecurringRequests(v bool) *BookingOptions {
	s.AutoDeclineRecurringRequests = &v
	return s
}

type CancelMailboxExportJobInput struct {
	_ struct{} `type:"structure"`

	// The idempotency token for the client request.
	ClientToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The job ID.
	//
	// JobId is a required field
	JobId *string `min:"1" type:"string" required:"true"`

	// The organization ID.
	//
	// OrganizationId is a required field
	OrganizationId *string `min:"34" type:"string" required:"true"`
}

// String returns the string representation
func (s CancelMailboxExportJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelMailboxExportJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelMailboxExportJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CancelMailboxExportJobInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}
	if s.OrganizationId == nil {
		invalidParams.Add(request.NewErrParamRequired("OrganizationId"))
	}
	if s.OrganizationId != nil && len(*s.OrganizationId) < 34 {
		invalidParams.Add(request.NewErrParamMinLen("OrganizationId", 34))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CancelMailboxExportJobInput) SetClientToken(v string) *CancelMailboxExportJobInput {
	s.ClientToken = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *CancelMailboxExportJobInput) SetJobId(v string) *CancelMailboxExportJobInput {
	s.JobId = &v
	return s
}

// SetOrganizationId sets the OrganizationId field's value.
func (s *CancelMailboxExportJobInput) SetOrganizationId(v string) *CancelMailboxExportJobInput {
	s.OrganizationId = &v
	return s
}

type CancelMailboxExportJobOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CancelMailboxExportJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelMailboxExportJobOutput) GoString() string {
	return s.String()
}

type CreateAliasInput struct {
	_ struct{} `type:"structure"`

	// The alias to add to the member set.
	//
	// Alias is a required field
	Alias *string `min:"1" type:"string" required:"true"`

	// The member (user or group) to which this alias is added.
	//
	// EntityId is a required field
	EntityId *string `min:"12" type:"string" required:"true"`

	// The organization under which the member (user or group) exists.
	//
	// OrganizationId is a required field
	OrganizationId *string `min:"34" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateAliasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAliasInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAliasInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAliasInput"}
	if s.Alias == nil {
		invalidParams.Add(request.NewErrParamRequired("Alias"))
	}
	if s.Alias != nil && len(*s.Alias) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Alias", 1))
	}
	if s.EntityId == nil {
		invalidParams.Add(request.NewErrParamRequired("EntityId"))
	}
	if s.EntityId != nil && len(*s.EntityId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("EntityId", 12))
	}
	if s.OrganizationId == nil {
		invalidParams.Add(request.NewErrParamRequired("OrganizationId"))
	}
	if s.OrganizationId != nil && len(*s.OrganizationId) < 34 {
		invalidParams.Add(request.NewErrParamMinLen("OrganizationId", 34))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAlias sets the Alias field's value.
func (s *CreateAliasInput) SetAlias(v string) *CreateAliasInput {
	s.Alias = &v
	return s
}

// SetEntityId sets the EntityId field's value.
func (s *CreateAliasInput) SetEntityId(v string) *CreateAliasInput {
	s.EntityId = &v
	return s
}

// SetOrganizationId sets the OrganizationId field's value.
func (s *CreateAliasInput) SetOrganizationId(v string) *CreateAliasInput {
	s.OrganizationId = &v
	return s
}

type CreateAliasOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateAliasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAliasOutput) GoString() string {
	return s.String()
}

type CreateGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the group.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The organization under which the group is to be created.
	//
	// OrganizationId is a required field
	OrganizationId *string `min:"34" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateGroupInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.OrganizationId == nil {
		invalidParams.Add(request.NewErrParamRequired("OrganizationId"))
	}
	if s.OrganizationId != nil && len(*s.OrganizationId) < 34 {
		invalidParams.Add(request.NewErrParamMinLen("OrganizationId", 34))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *CreateGroupInput) SetName(v string) *CreateGroupInput {
	s.Name = &v
	return s
}

// SetOrganizationId sets the OrganizationId field's value.
func (s *CreateGroupInput) SetOrganizationId(v string) *CreateGroupInput {
	s.OrganizationId = &v
	return s
}

type CreateGroupOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the group.
	GroupId *string `min:"12" type:"string"`
}

// String returns the string representation
func (s CreateGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateGroupOutput) GoString() string {
	return s.String()
}

// SetGroupId sets the GroupId field's value.
func (s *CreateGroupOutput) SetGroupId(v string) *CreateGroupOutput {
	s.GroupId = &v
	return s
}

type CreateOrganizationInput struct {
	_ struct{} `type:"structure"`

	// The organization alias.
	//
	// Alias is a required field
	Alias *string `min:"1" type:"string" required:"true"`

	// The idempotency token associated with the request.
	ClientToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The AWS Directory Service directory ID.
	DirectoryId *string `min:"12" type:"string"`

	// The email domains to associate with the organization.
	Domains []*Domain `type:"list"`

	// When true, allows organization interoperability between Amazon WorkMail and
	// Microsoft Exchange. Can only be set to true if an AD Connector directory
	// ID is included in the request.
	EnableInteroperability *bool `type:"boolean"`

	// The Amazon Resource Name (ARN) of a customer managed master key from AWS
	// KMS.
	KmsKeyArn *string `min:"20" type:"string"`
}

// String returns the string representation
func (s CreateOrganizationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateOrganizationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateOrganizationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateOrganizationInput"}
	if s.Alias == nil {
		invalidParams.Add(request.NewErrParamRequired("Alias"))
	}
	if s.Alias != nil && len(*s.Alias) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Alias", 1))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.DirectoryId != nil && len(*s.DirectoryId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("DirectoryId", 12))
	}
	if s.KmsKeyArn != nil && len(*s.KmsKeyArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("KmsKeyArn", 20))
	}
	if s.Domains != nil {
		for i, v := range s.Domains {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Domains", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAlias sets the Alias field's value.
func (s *CreateOrganizationInput) SetAlias(v string) *CreateOrganizationInput {
	s.Alias = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateOrganizationInput) SetClientToken(v string) *CreateOrganizationInput {
	s.ClientToken = &v
	return s
}

// SetDirectoryId sets the DirectoryId field's value.
func (s *CreateOrganizationInput) SetDirectoryId(v string) *CreateOrganizationInput {
	s.DirectoryId = &v
	return s
}

// SetDomains sets the Domains field's value.
func (s *CreateOrganizationInput) SetDomains(v []*Domain) *CreateOrganizationInput {
	s.Domains = v
	return s
}

// SetEnableInteroperability sets the EnableInteroperability field's value.
func (s *CreateOrganizationInput) SetEnableInteroperability(v bool) *CreateOrganizationInput {
	s.EnableInteroperability = &v
	return s
}

// SetKmsKeyArn sets the KmsKeyArn field's value.
func (s *CreateOrganizationInput) SetKmsKeyArn(v string) *CreateOrganizationInput {
	s.KmsKeyArn = &v
	return s
}

type CreateOrganizationOutput struct {
	_ struct{} `type:"structure"`

	// The organization ID.
	OrganizationId *string `min:"34" type:"string"`
}

// String returns the string representation
func (s CreateOrganizationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateOrganizationOutput) GoString() string {
	return s.String()
}

// SetOrganizationId sets the OrganizationId field's value.
func (s *CreateOrganizationOutput) SetOrganizationId(v string) *CreateOrganizationOutput {
	s.OrganizationId = &v
	return s
}

type CreateResourceInput struct {
	_ struct{} `type:"structure"`

	// The name of the new resource.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The identifier associated with the organization for which the resource is
	// created.
	//
	// OrganizationId is a required field
	OrganizationId *string `min:"34" type:"string" required:"true"`

	// The type of the new resource. The available types are equipment and room.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"ResourceType"`
}

// String returns the string representation
func (s CreateResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateResourceInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.OrganizationId == nil {
		invalidParams.Add(request.NewErrParamRequired("OrganizationId"))
	}
	if s.OrganizationId != nil && len(*s.OrganizationId) < 34 {
		invalidParams.Add(request.NewErrParamMinLen("OrganizationId", 34))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *CreateResourceInput) SetName(v string) *CreateResourceInput {
	s.Name = &v
	return s
}

// SetOrganizationId sets the OrganizationId field's value.
func (s *CreateResourceInput) SetOrganizationId(v string) *CreateResourceInput {
	s.OrganizationId = &v
	return s
}

// SetType sets the Type field's value.
func (s *CreateResourceInput) SetType(v string) *CreateResourceInput {
	s.Type = &v
	return s
}

type CreateResourceOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the new resource.
	ResourceId *string `min:"34" type:"string"`
}

// String returns the string representation
func (s CreateResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateResourceOutput) GoString() string {
	return s.String()
}

// SetResourceId sets the ResourceId field's value.
func (s *CreateResourceOutput) SetResourceId(v string) *CreateResourceOutput {
	s.ResourceId = &v
	return s
}

type CreateUserInput struct {
	_ struct{} `type:"structure"`

	// The display name for the new user.
	//
	// DisplayName is a required field
	DisplayName *string `type:"string" required:"true"`

	// The name for the new user. WorkMail directory user names have a maximum length
	// of 64. All others have a maximum length of 20.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The identifier of the organization for which the user is created.
	//
	// OrganizationId is a required field
	OrganizationId *string `min:"34" type:"string" required:"true"`

	// The password for the new user.
	//
	// Password is a required field
	Password *string `type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation
func (s CreateUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateUserInput"}
	if s.DisplayName == nil {
		invalidParams.Add(request.NewErrParamRequired("DisplayName"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.OrganizationId == nil {
		invalidParams.Add(request.NewErrParamRequired("OrganizationId"))
	}
	if s.OrganizationId != nil && len(*s.OrganizationId) < 34 {
		invalidParams.Add(request.NewErrParamMinLen("OrganizationId", 34))
	}
	if s.Password == nil {
		invalidParams.Add(request.NewErrParamRequired("Password"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDisplayName sets the DisplayName field's value.
func (s *CreateUserInput) SetDisplayName(v string) *CreateUserInput {
	s.DisplayName = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateUserInput) SetName(v string) *CreateUserInput {
	s.Name = &v
	return s
}

// SetOrganizationId sets the OrganizationId field's value.
func (s *CreateUserInput) SetOrganizationId(v string) *CreateUserInput {
	s.OrganizationId = &v
	return s
}

// SetPassword sets the Password field's value.
func (s *CreateUserInput) SetPassword(v string) *CreateUserInput {
	s.Password = &v
	return s
}

type CreateUserOutput struct {
	_ struct{} `type:"structure"`

	// The identifier for the new user.
	UserId *string `min:"12" type:"string"`
}

// String returns the string representation
func (s CreateUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateUserOutput) GoString() string {
	return s.String()
}

// SetUserId sets the UserId field's value.
func (s *CreateUserOutput) SetUserId(v string) *CreateUserOutput {
	s.UserId = &v
	return s
}

// The name of the attribute, which is one of the values defined in the UserAttribute
// enumeration.
type Delegate struct {
	_ struct{} `type:"structure"`

	// The identifier for the user or group associated as the resource's delegate.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// The type of the delegate: user or group.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"MemberType"`
}

// String returns the string representation
func (s Delegate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Delegate) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *Delegate) SetId(v string) *Delegate {
	s.Id = &v
	return s
}

// SetType sets the Type field's value.
func (s *Delegate) SetType(v string) *Delegate {
	s.Type = &v
	return s
}

type DeleteAccessControlRuleInput struct {
	_ struct{} `type:"structure"`

	// The name of the access control rule.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The identifier for the organization.
	//
	// OrganizationId is a required field
	OrganizationId *string `min:"34" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteAccessControlRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAccessControlRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAccessControlRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAccessControlRuleInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.OrganizationId == nil {
		invalidParams.Add(request.NewErrParamRequired("OrganizationId"))
	}
	if s.OrganizationId != nil && len(*s.OrganizationId) < 34 {
		invalidParams.Add(request.NewErrParamMinLen("OrganizationId", 34))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DeleteAccessControlRuleInput) SetName(v string) *DeleteAccessControlRuleInput {
	s.Name = &v
	return s
}

// SetOrganizationId sets the OrganizationId field's value.
func (s *DeleteAccessControlRuleInput) SetOrganizationId(v string) *DeleteAccessControlRuleInput {
	s.OrganizationId = &v
	return s
}

type DeleteAccessControlRuleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteAccessControlRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAccessControlRuleOutput) GoString() string {
	return s.String()
}

type DeleteAliasInput struct {
	_ struct{} `type:"structure"`

	// The aliases to be removed from the user's set of aliases. Duplicate entries
	// in the list are collapsed into single entries (the list is transformed into
	// a set).
	//
	// Alias is a required field
	Alias *string `min:"1" type:"string" required:"true"`

	// The identifier for the member (user or group) from which to have the aliases
	// removed.
	//
	// EntityId is a required field
	EntityId *string `min:"12" type:"string" required:"true"`

	// The identifier for the organization under which the user exists.
	//
	// OrganizationId is a required field
	OrganizationId *string `min:"34" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteAliasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAliasInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAliasInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAliasInput"}
	if s.Alias == nil {
		invalidParams.Add(request.NewErrParamRequired("Alias"))
	}
	if s.Alias != nil && len(*s.Alias) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Alias", 1))
	}
	if s.EntityId == nil {
		invalidParams.Add(request.NewErrParamRequired("EntityId"))
	}
	if s.EntityId != nil && len(*s.EntityId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("EntityId", 12))
	}
	if s.OrganizationId == nil {
		invalidParams.Add(request.NewErrParamRequired("OrganizationId"))
	}
	if s.OrganizationId != nil && len(*s.OrganizationId) < 34 {
		invalidParams.Add(request.NewErrParamMinLen("OrganizationId", 34))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAlias sets the Alias field's value.
func (s *DeleteAliasInput) SetAlias(v string) *DeleteAliasInput {
	s.Alias = &v
	return s
}

// SetEntityId sets the EntityId field's value.
func (s *DeleteAliasInput) SetEntityId(v string) *DeleteAliasInput {
	s.EntityId = &v
	return s
}

// SetOrganizationId sets the OrganizationId field's value.
func (s *DeleteAliasInput) SetOrganizationId(v string) *DeleteAliasInput {
	s.OrganizationId = &v
	return s
}

type DeleteAliasOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteAliasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAliasOutput) GoString() string {
	return s.String()
}

type DeleteGroupInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the group to be deleted.
	//
	// GroupId is a required field
	GroupId *string `min:"12" type:"string" required:"true"`

	// The organization that contains the group.
	//
	// OrganizationId is a required field
	OrganizationId *string `min:"34" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteGroupInput"}
	if s.GroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupId"))
	}
	if s.GroupId != nil && len(*s.GroupId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("GroupId", 12))
	}
	if s.OrganizationId == nil {
		invalidParams.Add(request.NewErrParamRequired("OrganizationId"))
	}
	if s.OrganizationId != nil && len(*s.OrganizationId) < 34 {
		invalidParams.Add(request.NewErrParamMinLen("OrganizationId", 34))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroupId sets the GroupId field's value.
func (s *DeleteGroupInput) SetGroupId(v string) *DeleteGroupInput {
	s.GroupId = &v
	return s
}

// SetOrganizationId sets the OrganizationId field's value.
func (s *DeleteGroupInput) SetOrganizationId(v string) *DeleteGroupInput {
	s.OrganizationId = &v
	return s
}

type DeleteGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteGroupOutput) GoString() string {
	return s.String()
}

type DeleteMailboxPermissionsInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the member (user or group) that owns the mailbox.
	//
	// EntityId is a required field
	EntityId *string `min:"12" type:"string" required:"true"`

	// The identifier of the member (user or group) for which to delete granted
	// permissions.
	//
	// GranteeId is a required field
	GranteeId *string `min:"12" type:"string" required:"true"`

	// The identifier of the organization under which the member (user or group)
	// exists.
	//
	// OrganizationId is a required field
	OrganizationId *string `min:"34" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteMailboxPermissionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteMailboxPermissionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteMailboxPermissionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteMailboxPermissionsInput"}
	if s.EntityId == nil {
		invalidParams.Add(request.NewErrParamRequired("EntityId"))
	}
	if s.EntityId != nil && len(*s.EntityId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("EntityId", 12))
	}
	if s.GranteeId == nil {
		invalidParams.Add(request.NewErrParamRequired("GranteeId"))
	}
	if s.GranteeId != nil && len(*s.GranteeId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("GranteeId", 12))
	}
	if s.OrganizationId == nil {
		invalidParams.Add(request.NewErrParamRequired("OrganizationId"))
	}
	if s.OrganizationId != nil && len(*s.OrganizationId) < 34 {
		invalidParams.Add(request.NewErrParamMinLen("OrganizationId", 34))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEntityId sets the EntityId field's value.
func (s *DeleteMailboxPermissionsInput) SetEntityId(v string) *DeleteMailboxPermissionsInput {
	s.EntityId = &v
	return s
}

// SetGranteeId sets the GranteeId field's value.
func (s *DeleteMailboxPermissionsInput) SetGranteeId(v string) *DeleteMailboxPermissionsInput {
	s.GranteeId = &v
	return s
}

// SetOrganizationId sets the OrganizationId field's value.
func (s *DeleteMailboxPermissionsInput) SetOrganizationId(v string) *DeleteMailboxPermissionsInput {
	s.OrganizationId = &v
	return s
}

type DeleteMailboxPermissionsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteMailboxPermissionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteMailboxPermissionsOutput) GoString() string {
	return s.String()
}

type DeleteOrganizationInput struct {
	_ struct{} `type:"structure"`

	// The idempotency token associated with the request.
	ClientToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// If true, deletes the AWS Directory Service directory associated with the
	// organization.
	//
	// DeleteDirectory is a required field
	DeleteDirectory *bool `type:"boolean" required:"true"`

	// The organization ID.
	//
	// OrganizationId is a required field
	OrganizationId *string `min:"34" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteOrganizationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteOrganizationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteOrganizationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteOrganizationInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.DeleteDirectory == nil {
		invalidParams.Add(request.NewErrParamRequired("DeleteDirectory"))
	}
	if s.OrganizationId == nil {
		invalidParams.Add(request.NewErrParamRequired("OrganizationId"))
	}
	if s.OrganizationId != nil && len(*s.OrganizationId) < 34 {
		invalidParams.Add(request.NewErrParamMinLen("OrganizationId", 34))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *DeleteOrganizationInput) SetClientToken(v string) *DeleteOrganizationInput {
	s.ClientToken = &v
	return s
}

// SetDeleteDirectory sets the DeleteDirectory field's value.
func (s *DeleteOrganizationInput) SetDeleteDirectory(v bool) *DeleteOrganizationInput {
	s.DeleteDirectory = &v
	return s
}

// SetOrganizationId sets the OrganizationId field's value.
func (s *DeleteOrganizationInput) SetOrganizationId(v string) *DeleteOrganizationInput {
	s.OrganizationId = &v
	return s
}

type DeleteOrganizationOutput struct {
	_ struct{} `type:"structure"`

	// The organization ID.
	OrganizationId *string `min:"34" type:"string"`

	// The state of the organization.
	State *string `type:"string"`
}

// String returns the string representation
func (s DeleteOrganizationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteOrganizationOutput) GoString() string {
	return s.String()
}

// SetOrganizationId sets the OrganizationId field's value.
func (s *DeleteOrganizationOutput) SetOrganizationId(v string) *DeleteOrganizationOutput {
	s.OrganizationId = &v
	return s
}

// SetState sets the State field's value.
func (s *DeleteOrganizationOutput) SetState(v string) *DeleteOrganizationOutput {
	s.State = &v
	return s
}

type DeleteResourceInput struct {
	_ struct{} `type:"structure"`

	// The identifier associated with the organization from which the resource is
	// deleted.
	//
	// OrganizationId is a required field
	OrganizationId *string `min:"34" type:"string" required:"true"`

	// The identifier of the resource to be deleted.
	//
	// ResourceId is a required field
	ResourceId *string `min:"34" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteResourceInput"}
	if s.OrganizationId == nil {
		invalidParams.Add(request.NewErrParamRequired("OrganizationId"))
	}
	if s.OrganizationId != nil && len(*s.OrganizationId) < 34 {
		invalidParams.Add(request.NewErrParamMinLen("OrganizationId", 34))
	}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 34 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 34))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOrganizationId sets the OrganizationId field's value.
func (s *DeleteResourceInput) SetOrganizationId(v string) *DeleteResourceInput {
	s.OrganizationId = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *DeleteResourceInput) SetResourceId(v string) *DeleteResourceInput {
	s.ResourceId = &v
	return s
}

type DeleteResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteResourceOutput) GoString() string {
	return s.String()
}

type DeleteRetentionPolicyInput struct {
	_ struct{} `type:"structure"`

	// The retention policy ID.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`

	// The organization ID.
	//
	// OrganizationId is a required field
	OrganizationId *string `min:"34" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteRetentionPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRetentionPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteRetentionPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteRetentionPolicyInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.OrganizationId == nil {
		invalidParams.Add(request.NewErrParamRequired("OrganizationId"))
	}
	if s.OrganizationId != nil && len(*s.OrganizationId) < 34 {
		invalidParams.Add(request.NewErrParamMinLen("OrganizationId", 34))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *DeleteRetentionPolicyInput) SetId(v string) *DeleteRetentionPolicyInput {
	s.Id = &v
	return s
}

// SetOrganizationId sets the OrganizationId field's value.
func (s *DeleteRetentionPolicyInput) SetOrganizationId(v string) *DeleteRetentionPolicyInput {
	s.OrganizationId = &v
	return s
}

type DeleteRetentionPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteRetentionPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRetentionPolicyOutput) GoString() string {
	return s.String()
}

type DeleteUserInput struct {
	_ struct{} `type:"structure"`

	// The organization that contains the user to be deleted.
	//
	// OrganizationId is a required field
	OrganizationId *string `min:"34" type:"string" required:"true"`

	// The identifier of the user to be deleted.
	//
	// UserId is a required field
	UserId *string `min:"12" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteUserInput"}
	if s.OrganizationId == nil {
		invalidParams.Add(request.NewErrParamRequired("OrganizationId"))
	}
	if s.OrganizationId != nil && len(*s.OrganizationId) < 34 {
		invalidParams.Add(request.NewErrParamMinLen("OrganizationId", 34))
	}
	if s.UserId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserId"))
	}
	if s.UserId != nil && len(*s.UserId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("UserId", 12))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOrganizationId sets the OrganizationId field's value.
func (s *DeleteUserInput) SetOrganizationId(v string) *DeleteUserInput {
	s.OrganizationId = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *DeleteUserInput) SetUserId(v string) *DeleteUserInput {
	s.UserId = &v
	return s
}

type DeleteUserOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteUserOutput) GoString() string {
	return s.String()
}

type DeregisterFromWorkMailInput struct {
	_ struct{} `type:"structure"`

	// The identifier for the member (user or group) to be updated.
	//
	// EntityId is a required field
	EntityId *string `min:"12" type:"string" required:"true"`

	// The identifier for the organization under which the Amazon WorkMail entity
	// exists.
	//
	// OrganizationId is a required field
	OrganizationId *string `min:"34" type:"string" required:"true"`
}

// String returns the string representation
func (s DeregisterFromWorkMailInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeregisterFromWorkMailInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeregisterFromWorkMailInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeregisterFromWorkMailInput"}
	if s.EntityId == nil {
		invalidParams.Add(request.NewErrParamRequired("EntityId"))
	}
	if s.EntityId != nil && len(*s.EntityId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("EntityId", 12))
	}
	if s.OrganizationId == nil {
		invalidParams.Add(request.NewErrParamRequired("OrganizationId"))
	}
	if s.OrganizationId != nil && len(*s.OrganizationId) < 34 {
		invalidParams.Add(request.NewErrParamMinLen("OrganizationId", 34))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEntityId sets the EntityId field's value.
func (s *DeregisterFromWorkMailInput) SetEntityId(v string) *DeregisterFromWorkMailInput {
	s.EntityId = &v
	return s
}

// SetOrganizationId sets the OrganizationId field's value.
func (s *DeregisterFromWorkMailInput) SetOrganizationId(v string) *DeregisterFromWorkMailInput {
	s.OrganizationId = &v
	return s
}

type DeregisterFromWorkMailOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeregisterFromWorkMailOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeregisterFromWorkMailOutput) GoString() string {
	return s.String()
}

type DescribeGroupInput struct {
	_ struct{} `type:"structure"`

	// The identifier for the group to be described.
	//
	// GroupId is a required field
	GroupId *string `min:"12" type:"string" required:"true"`

	// The identifier for the organization under which the group exists.
	//
	// OrganizationId is a required field
	OrganizationId *string `min:"34" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeGroupInput"}
	if s.GroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupId"))
	}
	if s.GroupId != nil && len(*s.GroupId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("GroupId", 12))
	}
	if s.OrganizationId == nil {
		invalidParams.Add(request.NewErrParamRequired("OrganizationId"))
	}
	if s.OrganizationId != nil && len(*s.OrganizationId) < 34 {
		invalidParams.Add(request.NewErrParamMinLen("OrganizationId", 34))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroupId sets the GroupId field's value.
func (s *DescribeGroupInput) SetGroupId(v string) *DescribeGroupInput {
	s.GroupId = &v
	return s
}

// SetOrganizationId sets the OrganizationId field's value.
func (s *DescribeGroupInput) SetOrganizationId(v string) *DescribeGroupInput {
	s.OrganizationId = &v
	return s
}

type DescribeGroupOutput struct {
	_ struct{} `type:"structure"`

	// The date and time when a user was deregistered from WorkMail, in UNIX epoch
	// time format.
	DisabledDate *time.Time `type:"timestamp"`

	// The email of the described group.
	Email *string `min:"1" type:"string"`

	// The date and time when a user was registered to WorkMail, in UNIX epoch time
	// format.
	EnabledDate *time.Time `type:"timestamp"`

	// The identifier of the described group.
	GroupId *string `min:"12" type:"string"`

	// The name of the described group.
	Name *string `min:"1" type:"string"`

	// The state of the user: enabled (registered to Amazon WorkMail) or disabled
	// (deregistered or never registered to WorkMail).
	State *string `type:"string" enum:"EntityState"`
}

// String returns the string representation
func (s DescribeGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeGroupOutput) GoString() string {
	return s.String()
}

// SetDisabledDate sets the DisabledDate field's value.
func (s *DescribeGroupOutput) SetDisabledDate(v time.Time) *DescribeGroupOutput {
	s.DisabledDate = &v
	return s
}

// SetEmail sets the Email field's value.
func (s *DescribeGroupOutput) SetEmail(v string) *DescribeGroupOutput {
	s.Email = &v
	return s
}

// SetEnabledDate sets the EnabledDate field's value.
func (s *DescribeGroupOutput) SetEnabledDate(v time.Time) *DescribeGroupOutput {
	s.EnabledDate = &v
	return s
}

// SetGroupId sets the GroupId field's value.
func (s *DescribeGroupOutput) SetGroupId(v string) *DescribeGroupOutput {
	s.GroupId = &v
	return s
}

// SetName sets the Name field's value.
func (s *DescribeGroupOutput) SetName(v string) *DescribeGroupOutput {
	s.Name = &v
	return s
}

// SetState sets the State field's value.
func (s *DescribeGroupOutput) SetState(v string) *DescribeGroupOutput {
	s.State = &v
	return s
}

type DescribeMailboxExportJobInput struct {
	_ struct{} `type:"structure"`

	// The mailbox export job ID.
	//
	// JobId is a required field
	JobId *string `min:"1" type:"string" required:"true"`

	// The organization ID.
	//
	// OrganizationId is a required field
	OrganizationId *string `min:"34" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeMailboxExportJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeMailboxExportJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeMailboxExportJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeMailboxExportJobInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}
	if s.OrganizationId == nil {
		invalidParams.Add(request.NewErrParamRequired("OrganizationId"))
	}
	if s.OrganizationId != nil && len(*s.OrganizationId) < 34 {
		invalidParams.Add(request.NewErrParamMinLen("OrganizationId", 34))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *DescribeMailboxExportJobInput) SetJobId(v string) *DescribeMailboxExportJobInput {
	s.JobId = &v
	return s
}

// SetOrganizationId sets the OrganizationId field's value.
func (s *DescribeMailboxExportJobInput) SetOrganizationId(v string) *DescribeMailboxExportJobInput {
	s.OrganizationId = &v
	return s
}

type DescribeMailboxExportJobOutput struct {
	_ struct{} `type:"structure"`

	// The mailbox export job description.
	Description *string `type:"string"`

	// The mailbox export job end timestamp.
	EndTime *time.Time `type:"timestamp"`

	// The identifier of the user or resource associated with the mailbox.
	EntityId *string `min:"12" type:"string"`

	// Error information for failed mailbox export jobs.
	ErrorInfo *string `min:"1" type:"string"`

	// The estimated progress of the mailbox export job, in percentage points.
	EstimatedProgress *int64 `type:"integer"`

	// The Amazon Resource Name (ARN) of the symmetric AWS Key Management Service
	// (AWS KMS) key that encrypts the exported mailbox content.
	KmsKeyArn *string `min:"20" type:"string"`

	// The ARN of the AWS Identity and Access Management (IAM) role that grants
	// write permission to the Amazon Simple Storage Service (Amazon S3) bucket.
	RoleArn *string `min:"20" type:"string"`

	// The name of the S3 bucket.
	S3BucketName *string `min:"1" type:"string"`

	// The path to the S3 bucket and file that the mailbox export job is exporting
	// to.
	S3Path *string `min:"1" type:"string"`

	// The S3 bucket prefix.
	S3Prefix *string `min:"1" type:"string"`

	// The mailbox export job start timestamp.
	StartTime *time.Time `type:"timestamp"`

	// The state of the mailbox export job.
	State *string `type:"string" enum:"MailboxExportJobState"`
}

// String returns the string representation
func (s DescribeMailboxExportJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeMailboxExportJobOutput) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *DescribeMailboxExportJobOutput) SetDescription(v string) *DescribeMailboxExportJobOutput {
	s.Description = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *DescribeMailboxExportJobOutput) SetEndTime(v time.Time) *DescribeMailboxExportJobOutput {
	s.EndTime = &v
	return s
}

// SetEntityId sets the EntityId field's value.
func (s *DescribeMailboxExportJobOutput) SetEntityId(v string) *DescribeMailboxExportJobOutput {
	s.EntityId = &v
	return s
}

// SetErrorInfo sets the ErrorInfo field's value.
func (s *DescribeMailboxExportJobOutput) SetErrorInfo(v string) *DescribeMailboxExportJobOutput {
	s.ErrorInfo = &v
	return s
}

// SetEstimatedProgress sets the EstimatedProgress field's value.
func (s *DescribeMailboxExportJobOutput) SetEstimatedProgress(v int64) *DescribeMailboxExportJobOutput {
	s.EstimatedProgress = &v
	return s
}

// SetKmsKeyArn sets the KmsKeyArn field's value.
func (s *DescribeMailboxExportJobOutput) SetKmsKeyArn(v string) *DescribeMailboxExportJobOutput {
	s.KmsKeyArn = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *DescribeMailboxExportJobOutput) SetRoleArn(v string) *DescribeMailboxExportJobOutput {
	s.RoleArn = &v
	return s
}

// SetS3BucketName sets the S3BucketName field's value.
func (s *DescribeMailboxExportJobOutput) SetS3BucketName(v string) *DescribeMailboxExportJobOutput {
	s.S3BucketName = &v
	return s
}

// SetS3Path sets the S3Path field's value.
func (s *DescribeMailboxExportJobOutput) SetS3Path(v string) *DescribeMailboxExportJobOutput {
	s.S3Path = &v
	return s
}

// SetS3Prefix sets the S3Prefix field's value.
func (s *DescribeMailboxExportJobOutput) SetS3Prefix(v string) *DescribeMailboxExportJobOutput {
	s.S3Prefix = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *DescribeMailboxExportJobOutput) SetStartTime(v time.Time) *DescribeMailboxExportJobOutput {
	s.StartTime = &v
	return s
}

// SetState sets the State field's value.
func (s *DescribeMailboxExportJobOutput) SetState(v string) *DescribeMailboxExportJobOutput {
	s.State = &v
	return s
}

type DescribeOrganizationInput struct {
	_ struct{} `type:"structure"`

	// The identifier for the organization to be described.
	//
	// OrganizationId is a required field
	OrganizationId *string `min:"34" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeOrganizationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeOrganizationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeOrganizationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeOrganizationInput"}
	if s.OrganizationId == nil {
		invalidParams.Add(request.NewErrParamRequired("OrganizationId"))
	}
	if s.OrganizationId != nil && len(*s.OrganizationId) < 34 {
		invalidParams.Add(request.NewErrParamMinLen("OrganizationId", 34))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOrganizationId sets the OrganizationId field's value.
func (s *DescribeOrganizationInput) SetOrganizationId(v string) *DescribeOrganizationInput {
	s.OrganizationId = &v
	return s
}

type DescribeOrganizationOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the organization.
	ARN *string `min:"1" type:"string"`

	// The alias for an organization.
	Alias *string `min:"1" type:"string"`

	// The date at which the organization became usable in the WorkMail context,
	// in UNIX epoch time format.
	CompletedDate *time.Time `type:"timestamp"`

	// The default mail domain associated with the organization.
	DefaultMailDomain *string `type:"string"`

	// The identifier for the directory associated with an Amazon WorkMail organization.
	DirectoryId *string `type:"string"`

	// The type of directory associated with the WorkMail organization.
	DirectoryType *string `type:"string"`

	// (Optional) The error message indicating if unexpected behavior was encountered
	// with regards to the organization.
	ErrorMessage *string `type:"string"`

	// The identifier of an organization.
	OrganizationId *string `min:"34" type:"string"`

	// The state of an organization.
	State *string `type:"string"`
}

// String returns the string representation
func (s DescribeOrganizationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeOrganizationOutput) GoString() string {
	return s.String()
}

// SetARN sets the ARN field's value.
func (s *DescribeOrganizationOutput) SetARN(v string) *DescribeOrganizationOutput {
	s.ARN = &v
	return s
}

// SetAlias sets the Alias field's value.
func (s *DescribeOrganizationOutput) SetAlias(v string) *DescribeOrganizationOutput {
	s.Alias = &v
	return s
}

// SetCompletedDate sets the CompletedDate field's value.
func (s *DescribeOrganizationOutput) SetCompletedDate(v time.Time) *DescribeOrganizationOutput {
	s.CompletedDate = &v
	return s
}

// SetDefaultMailDomain sets the DefaultMailDomain field's value.
func (s *DescribeOrganizationOutput) SetDefaultMailDomain(v string) *DescribeOrganizationOutput {
	s.DefaultMailDomain = &v
	return s
}

// SetDirectoryId sets the DirectoryId field's value.
func (s *DescribeOrganizationOutput) SetDirectoryId(v string) *DescribeOrganizationOutput {
	s.DirectoryId = &v
	return s
}

// SetDirectoryType sets the DirectoryType field's value.
func (s *DescribeOrganizationOutput) SetDirectoryType(v string) *DescribeOrganizationOutput {
	s.DirectoryType = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *DescribeOrganizationOutput) SetErrorMessage(v string) *DescribeOrganizationOutput {
	s.ErrorMessage = &v
	return s
}

// SetOrganizationId sets the OrganizationId field's value.
func (s *DescribeOrganizationOutput) SetOrganizationId(v string) *DescribeOrganizationOutput {
	s.OrganizationId = &v
	return s
}

// SetState sets the State field's value.
func (s *DescribeOrganizationOutput) SetState(v string) *DescribeOrganizationOutput {
	s.State = &v
	return s
}

type DescribeResourceInput struct {
	_ struct{} `type:"structure"`

	// The identifier associated with the organization for which the resource is
	// described.
	//
	// OrganizationId is a required field
	OrganizationId *string `min:"34" type:"string" required:"true"`

	// The identifier of the resource to be described.
	//
	// ResourceId is a required field
	ResourceId *string `min:"34" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeResourceInput"}
	if s.OrganizationId == nil {
		invalidParams.Add(request.NewErrParamRequired("OrganizationId"))
	}
	if s.OrganizationId != nil && len(*s.OrganizationId) < 34 {
		invalidParams.Add(request.NewErrParamMinLen("OrganizationId", 34))
	}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 34 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 34))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOrganizationId sets the OrganizationId field's value.
func (s *DescribeResourceInput) SetOrganizationId(v string) *DescribeResourceInput {
	s.OrganizationId = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *DescribeResourceInput) SetResourceId(v string) *DescribeResourceInput {
	s.ResourceId = &v
	return s
}

type DescribeResourceOutput struct {
	_ struct{} `type:"structure"`

	// The booking options for the described resource.
	BookingOptions *BookingOptions `type:"structure"`

	// The date and time when a resource was disabled from WorkMail, in UNIX epoch
	// time format.
	DisabledDate *time.Time `type:"timestamp"`

	// The email of the described resource.
	Email *string `min:"1" type:"string"`

	// The date and time when a resource was enabled for WorkMail, in UNIX epoch
	// time format.
	EnabledDate *time.Time `type:"timestamp"`

	// The name of the described resource.
	Name *string `min:"1" type:"string"`

	// The identifier of the described resource.
	ResourceId *string `min:"34" type:"string"`

	// The state of the resource: enabled (registered to Amazon WorkMail), disabled
	// (deregistered or never registered to WorkMail), or deleted.
	State *string `type:"string" enum:"EntityState"`

	// The type of the described resource.
	Type *string `type:"string" enum:"ResourceType"`
}

// String returns the string representation
func (s DescribeResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeResourceOutput) GoString() string {
	return s.String()
}

// SetBookingOptions sets the BookingOptions field's value.
func (s *DescribeResourceOutput) SetBookingOptions(v *BookingOptions) *DescribeResourceOutput {
	s.BookingOptions = v
	return s
}

// SetDisabledDate sets the DisabledDate field's value.
func (s *DescribeResourceOutput) SetDisabledDate(v time.Time) *DescribeResourceOutput {
	s.DisabledDate = &v
	return s
}

// SetEmail sets the Email field's value.
func (s *DescribeResourceOutput) SetEmail(v string) *DescribeResourceOutput {
	s.Email = &v
	return s
}

// SetEnabledDate sets the EnabledDate field's value.
func (s *DescribeResourceOutput) SetEnabledDate(v time.Time) *DescribeResourceOutput {
	s.EnabledDate = &v
	return s
}

// SetName sets the Name field's value.
func (s *DescribeResourceOutput) SetName(v string) *DescribeResourceOutput {
	s.Name = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *DescribeResourceOutput) SetResourceId(v string) *DescribeResourceOutput {
	s.ResourceId = &v
	return s
}

// SetState sets the State field's value.
func (s *DescribeResourceOutput) SetState(v string) *DescribeResourceOutput {
	s.State = &v
	return s
}

// SetType sets the Type field's value.
func (s *DescribeResourceOutput) SetType(v string) *DescribeResourceOutput {
	s.Type = &v
	return s
}

type DescribeUserInput struct {
	_ struct{} `type:"structure"`

	// The identifier for the organization under which the user exists.
	//
	// OrganizationId is a required field
	OrganizationId *string `min:"34" type:"string" required:"true"`

	// The identifier for the user to be described.
	//
	// UserId is a required field
	UserId *string `min:"12" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeUserInput"}
	if s.OrganizationId == nil {
		invalidParams.Add(request.NewErrParamRequired("OrganizationId"))
	}
	if s.OrganizationId != nil && len(*s.OrganizationId) < 34 {
		invalidParams.Add(request.NewErrParamMinLen("OrganizationId", 34))
	}
	if s.UserId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserId"))
	}
	if s.UserId != nil && len(*s.UserId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("UserId", 12))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOrganizationId sets the OrganizationId field's value.
func (s *DescribeUserInput) SetOrganizationId(v string) *DescribeUserInput {
	s.OrganizationId = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *DescribeUserInput) SetUserId(v string) *DescribeUserInput {
	s.UserId = &v
	return s
}

type DescribeUserOutput struct {
	_ struct{} `type:"structure"`

	// The date and time at which the user was disabled for Amazon WorkMail usage,
	// in UNIX epoch time format.
	DisabledDate *time.Time `type:"timestamp"`

	// The display name of the user.
	DisplayName *string `type:"string"`

	// The email of the user.
	Email *string `min:"1" type:"string"`

	// The date and time at which the user was enabled for Amazon WorkMail usage,
	// in UNIX epoch time format.
	EnabledDate *time.Time `type:"timestamp"`

	// The name for the user.
	Name *string `min:"1" type:"string"`

	// The state of a user: enabled (registered to Amazon WorkMail) or disabled
	// (deregistered or never registered to WorkMail).
	State *string `type:"string" enum:"EntityState"`

	// The identifier for the described user.
	UserId *string `min:"12" type:"string"`

	// In certain cases, other entities are modeled as users. If interoperability
	// is enabled, resources are imported into Amazon WorkMail as users. Because
	// different WorkMail organizations rely on different directory types, administrators
	// can distinguish between an unregistered user (account is disabled and has
	// a user role) and the directory administrators. The values are USER, RESOURCE,
	// and SYSTEM_USER.
	UserRole *string `type:"string" enum:"UserRole"`
}

// String returns the string representation
func (s DescribeUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeUserOutput) GoString() string {
	return s.String()
}

// SetDisabledDate sets the DisabledDate field's value.
func (s *DescribeUserOutput) SetDisabledDate(v time.Time) *DescribeUserOutput {
	s.DisabledDate = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *DescribeUserOutput) SetDisplayName(v string) *DescribeUserOutput {
	s.DisplayName = &v
	return s
}

// SetEmail sets the Email field's value.
func (s *DescribeUserOutput) SetEmail(v string) *DescribeUserOutput {
	s.Email = &v
	return s
}

// SetEnabledDate sets the EnabledDate field's value.
func (s *DescribeUserOutput) SetEnabledDate(v time.Time) *DescribeUserOutput {
	s.EnabledDate = &v
	return s
}

// SetName sets the Name field's value.
func (s *DescribeUserOutput) SetName(v string) *DescribeUserOutput {
	s.Name = &v
	return s
}

// SetState sets the State field's value.
func (s *DescribeUserOutput) SetState(v string) *DescribeUserOutput {
	s.State = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *DescribeUserOutput) SetUserId(v string) *DescribeUserOutput {
	s.UserId = &v
	return s
}

// SetUserRole sets the UserRole field's value.
func (s *DescribeUserOutput) SetUserRole(v string) *DescribeUserOutput {
	s.UserRole = &v
	return s
}

// The directory is already in use by another WorkMail organization in the same
// account and Region.
type DirectoryInUseException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s DirectoryInUseException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DirectoryInUseException) GoString() string {
	return s.String()
}

func newErrorDirectoryInUseException(v protocol.ResponseMetadata) error {
	return &DirectoryInUseException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *DirectoryInUseException) Code() string {
	return "DirectoryInUseException"
}

// Message returns the exception's message.
func (s *DirectoryInUseException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *DirectoryInUseException) OrigErr() error {
	return nil
}

func (s *DirectoryInUseException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *DirectoryInUseException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *DirectoryInUseException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The directory service doesn't recognize the credentials supplied by WorkMail.
type DirectoryServiceAuthenticationFailedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s DirectoryServiceAuthenticationFailedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DirectoryServiceAuthenticationFailedException) GoString() string {
	return s.String()
}

func newErrorDirectoryServiceAuthenticationFailedException(v protocol.ResponseMetadata) error {
	return &DirectoryServiceAuthenticationFailedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *DirectoryServiceAuthenticationFailedException) Code() string {
	return "DirectoryServiceAuthenticationFailedException"
}

// Message returns the exception's message.
func (s *DirectoryServiceAuthenticationFailedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *DirectoryServiceAuthenticationFailedException) OrigErr() error {
	return nil
}

func (s *DirectoryServiceAuthenticationFailedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *DirectoryServiceAuthenticationFailedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *DirectoryServiceAuthenticationFailedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The directory is unavailable. It might be located in another Region or deleted.
type DirectoryUnavailableException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s DirectoryUnavailableException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DirectoryUnavailableException) GoString() string {
	return s.String()
}

func newErrorDirectoryUnavailableException(v protocol.ResponseMetadata) error {
	return &DirectoryUnavailableException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *DirectoryUnavailableException) Code() string {
	return "DirectoryUnavailableException"
}

// Message returns the exception's message.
func (s *DirectoryUnavailableException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *DirectoryUnavailableException) OrigErr() error {
	return nil
}

func (s *DirectoryUnavailableException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *DirectoryUnavailableException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *DirectoryUnavailableException) RequestID() string {
	return s.RespMetadata.RequestID
}

type DisassociateDelegateFromResourceInput struct {
	_ struct{} `type:"structure"`

	// The identifier for the member (user, group) to be removed from the resource's
	// delegates.
	//
	// EntityId is a required field
	EntityId *string `min:"12" type:"string" required:"true"`

	// The identifier for the organization under which the resource exists.
	//
	// OrganizationId is a required field
	OrganizationId *string `min:"34" type:"string" required:"true"`

	// The identifier of the resource from which delegates' set members are removed.
	//
	// ResourceId is a required field
	ResourceId *string `min:"34" type:"string" required:"true"`
}

// String returns the string representation
func (s DisassociateDelegateFromResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateDelegateFromResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateDelegateFromResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateDelegateFromResourceInput"}
	if s.EntityId == nil {
		invalidParams.Add(request.NewErrParamRequired("EntityId"))
	}
	if s.EntityId != nil && len(*s.EntityId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("EntityId", 12))
	}
	if s.OrganizationId == nil {
		invalidParams.Add(request.NewErrParamRequired("OrganizationId"))
	}
	if s.OrganizationId != nil && len(*s.OrganizationId) < 34 {
		invalidParams.Add(request.NewErrParamMinLen("OrganizationId", 34))
	}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 34 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 34))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEntityId sets the EntityId field's value.
func (s *DisassociateDelegateFromResourceInput) SetEntityId(v string) *DisassociateDelegateFromResourceInput {
	s.EntityId = &v
	return s
}

// SetOrganizationId sets the OrganizationId field's value.
func (s *DisassociateDelegateFromResourceInput) SetOrganizationId(v string) *DisassociateDelegateFromResourceInput {
	s.OrganizationId = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *DisassociateDelegateFromResourceInput) SetResourceId(v string) *DisassociateDelegateFromResourceInput {
	s.ResourceId = &v
	return s
}

type DisassociateDelegateFromResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisassociateDelegateFromResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateDelegateFromResourceOutput) GoString() string {
	return s.String()
}

type DisassociateMemberFromGroupInput struct {
	_ struct{} `type:"structure"`

	// The identifier for the group from which members are removed.
	//
	// GroupId is a required field
	GroupId *string `min:"12" type:"string" required:"true"`

	// The identifier for the member to be removed to the group.
	//
	// MemberId is a required field
	MemberId *string `min:"12" type:"string" required:"true"`

	// The identifier for the organization under which the group exists.
	//
	// OrganizationId is a required field
	OrganizationId *string `min:"34" type:"string" required:"true"`
}

// String returns the string representation
func (s DisassociateMemberFromGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateMemberFromGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateMemberFromGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateMemberFromGroupInput"}
	if s.GroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupId"))
	}
	if s.GroupId != nil && len(*s.GroupId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("GroupId", 12))
	}
	if s.MemberId == nil {
		invalidParams.Add(request.NewErrParamRequired("MemberId"))
	}
	if s.MemberId != nil && len(*s.MemberId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("MemberId", 12))
	}
	if s.OrganizationId == nil {
		invalidParams.Add(request.NewErrParamRequired("OrganizationId"))
	}
	if s.OrganizationId != nil && len(*s.OrganizationId) < 34 {
		invalidParams.Add(request.NewErrParamMinLen("OrganizationId", 34))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroupId sets the GroupId field's value.
func (s *DisassociateMemberFromGroupInput) SetGroupId(v string) *DisassociateMemberFromGroupInput {
	s.GroupId = &v
	return s
}

// SetMemberId sets the MemberId field's value.
func (s *DisassociateMemberFromGroupInput) SetMemberId(v string) *DisassociateMemberFromGroupInput {
	s.MemberId = &v
	return s
}

// SetOrganizationId sets the OrganizationId field's value.
func (s *DisassociateMemberFromGroupInput) SetOrganizationId(v string) *DisassociateMemberFromGroupInput {
	s.OrganizationId = &v
	return s
}

type DisassociateMemberFromGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisassociateMemberFromGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateMemberFromGroupOutput) GoString() string {
	return s.String()
}

// The domain to associate with an Amazon WorkMail organization.
//
// When you configure a domain hosted in Amazon Route 53 (Route 53), all recommended
// DNS records are added to the organization when you create it. For more information,
// see Adding a domain (https://docs.aws.amazon.com/workmail/latest/adminguide/add_domain.html)
// in the Amazon WorkMail Administrator Guide.
type Domain struct {
	_ struct{} `type:"structure"`

	// The fully qualified domain name.
	DomainName *string `min:"3" type:"string"`

	// The hosted zone ID for a domain hosted in Route 53. Required when configuring
	// a domain hosted in Route 53.
	HostedZoneId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s Domain) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Domain) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Domain) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Domain"}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}
	if s.HostedZoneId != nil && len(*s.HostedZoneId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("HostedZoneId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *Domain) SetDomainName(v string) *Domain {
	s.DomainName = &v
	return s
}

// SetHostedZoneId sets the HostedZoneId field's value.
func (s *Domain) SetHostedZoneId(v string) *Domain {
	s.HostedZoneId = &v
	return s
}

// The email address that you're trying to assign is already created for a different
// user, group, or resource.
type EmailAddressInUseException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s EmailAddressInUseException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EmailAddressInUseException) GoString() string {
	return s.String()
}

func newErrorEmailAddressInUseException(v protocol.ResponseMetadata) error {
	return &EmailAddressInUseException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *EmailAddressInUseException) Code() string {
	return "EmailAddressInUseException"
}

// Message returns the exception's message.
func (s *EmailAddressInUseException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *EmailAddressInUseException) OrigErr() error {
	return nil
}

func (s *EmailAddressInUseException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *EmailAddressInUseException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *EmailAddressInUseException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The user, group, or resource that you're trying to register is already registered.
type EntityAlreadyRegisteredException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s EntityAlreadyRegisteredException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EntityAlreadyRegisteredException) GoString() string {
	return s.String()
}

func newErrorEntityAlreadyRegisteredException(v protocol.ResponseMetadata) error {
	return &EntityAlreadyRegisteredException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *EntityAlreadyRegisteredException) Code() string {
	return "EntityAlreadyRegisteredException"
}

// Message returns the exception's message.
func (s *EntityAlreadyRegisteredException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *EntityAlreadyRegisteredException) OrigErr() error {
	return nil
}

func (s *EntityAlreadyRegisteredException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *EntityAlreadyRegisteredException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *EntityAlreadyRegisteredException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The identifier supplied for the user, group, or resource does not exist in
// your organization.
type EntityNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s EntityNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EntityNotFoundException) GoString() string {
	return s.String()
}

func newErrorEntityNotFoundException(v protocol.ResponseMetadata) error {
	return &EntityNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *EntityNotFoundException) Code() string {
	return "EntityNotFoundException"
}

// Message returns the exception's message.
func (s *EntityNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *EntityNotFoundException) OrigErr() error {
	return nil
}

func (s *EntityNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *EntityNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *EntityNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// You are performing an operation on a user, group, or resource that isn't
// in the expected state, such as trying to delete an active user.
type EntityStateException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s EntityStateException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EntityStateException) GoString() string {
	return s.String()
}

func newErrorEntityStateException(v protocol.ResponseMetadata) error {
	return &EntityStateException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *EntityStateException) Code() string {
	return "EntityStateException"
}

// Message returns the exception's message.
func (s *EntityStateException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *EntityStateException) OrigErr() error {
	return nil
}

func (s *EntityStateException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *EntityStateException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *EntityStateException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The configuration applied to an organization's folders by its retention policy.
type FolderConfiguration struct {
	_ struct{} `type:"structure"`

	// The action to take on the folder contents at the end of the folder configuration
	// period.
	//
	// Action is a required field
	Action *string `type:"string" required:"true" enum:"RetentionAction"`

	// The folder name.
	//
	// Name is a required field
	Name *string `type:"string" required:"true" enum:"FolderName"`

	// The period of time at which the folder configuration action is applied.
	Period *int64 `min:"1" type:"integer"`
}

// String returns the string representation
func (s FolderConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FolderConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FolderConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FolderConfiguration"}
	if s.Action == nil {
		invalidParams.Add(request.NewErrParamRequired("Action"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Period != nil && *s.Period < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Period", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAction sets the Action field's value.
func (s *FolderConfiguration) SetAction(v string) *FolderConfiguration {
	s.Action = &v
	return s
}

// SetName sets the Name field's value.
func (s *FolderConfiguration) SetName(v string) *FolderConfiguration {
	s.Name = &v
	return s
}

// SetPeriod sets the Period field's value.
func (s *FolderConfiguration) SetPeriod(v int64) *FolderConfiguration {
	s.Period = &v
	return s
}

type GetAccessControlEffectInput struct {
	_ struct{} `type:"structure"`

	// The access protocol action. Valid values include ActiveSync, AutoDiscover,
	// EWS, IMAP, SMTP, WindowsOutlook, and WebMail.
	//
	// Action is a required field
	Action *string `min:"1" type:"string" required:"true"`

	// The IPv4 address.
	//
	// IpAddress is a required field
	IpAddress *string `min:"1" type:"string" required:"true"`

	// The identifier for the organization.
	//
	// OrganizationId is a required field
	OrganizationId *string `min:"34" type:"string" required:"true"`

	// The user ID.
	//
	// UserId is a required field
	UserId *string `min:"12" type:"string" required:"true"`
}

// String returns the string representation
func (s GetAccessControlEffectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAccessControlEffectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAccessControlEffectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAccessControlEffectInput"}
	if s.Action == nil {
		invalidParams.Add(request.NewErrParamRequired("Action"))
	}
	if s.Action != nil && len(*s.Action) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Action", 1))
	}
	if s.IpAddress == nil {
		invalidParams.Add(request.NewErrParamRequired("IpAddress"))
	}
	if s.IpAddress != nil && len(*s.IpAddress) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IpAddress", 1))
	}
	if s.OrganizationId == nil {
		invalidParams.Add(request.NewErrParamRequired("OrganizationId"))
	}
	if s.OrganizationId != nil && len(*s.OrganizationId) < 34 {
		invalidParams.Add(request.NewErrParamMinLen("OrganizationId", 34))
	}
	if s.UserId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserId"))
	}
	if s.UserId != nil && len(*s.UserId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("UserId", 12))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAction sets the Action field's value.
func (s *GetAccessControlEffectInput) SetAction(v string) *GetAccessControlEffectInput {
	s.Action = &v
	return s
}

// SetIpAddress sets the IpAddress field's value.
func (s *GetAccessControlEffectInput) SetIpAddress(v string) *GetAccessControlEffectInput {
	s.IpAddress = &v
	return s
}

// SetOrganizationId sets the OrganizationId field's value.
func (s *GetAccessControlEffectInput) SetOrganizationId(v string) *GetAccessControlEffectInput {
	s.OrganizationId = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *GetAccessControlEffectInput) SetUserId(v string) *GetAccessControlEffectInput {
	s.UserId = &v
	return s
}

type GetAccessControlEffectOutput struct {
	_ struct{} `type:"structure"`

	// The rule effect.
	Effect *string `type:"string" enum:"AccessControlRuleEffect"`

	// The rules that match the given parameters, resulting in an effect.
	MatchedRules []*string `type:"list"`
}

// String returns the string representation
func (s GetAccessControlEffectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAccessControlEffectOutput) GoString() string {
	return s.String()
}

// SetEffect sets the Effect field's value.
func (s *GetAccessControlEffectOutput) SetEffect(v string) *GetAccessControlEffectOutput {
	s.Effect = &v
	return s
}

// SetMatchedRules sets the MatchedRules field's value.
func (s *GetAccessControlEffectOutput) SetMatchedRules(v []*string) *GetAccessControlEffectOutput {
	s.MatchedRules = v
	return s
}

type GetDefaultRetentionPolicyInput struct {
	_ struct{} `type:"structure"`

	// The organization ID.
	//
	// OrganizationId is a required field
	OrganizationId *string `min:"34" type:"string" required:"true"`
}

// String returns the string representation
func (s GetDefaultRetentionPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDefaultRetentionPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDefaultRetentionPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDefaultRetentionPolicyInput"}
	if s.OrganizationId == nil {
		invalidParams.Add(request.NewErrParamRequired("OrganizationId"))
	}
	if s.OrganizationId != nil && len(*s.OrganizationId) < 34 {
		invalidParams.Add(request.NewErrParamMinLen("OrganizationId", 34))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOrganizationId sets the OrganizationId field's value.
func (s *GetDefaultRetentionPolicyInput) SetOrganizationId(v string) *GetDefaultRetentionPolicyInput {
	s.OrganizationId = &v
	return s
}

type GetDefaultRetentionPolicyOutput struct {
	_ struct{} `type:"structure"`

	// The retention policy description.
	Description *string `type:"string"`

	// The retention policy folder configurations.
	FolderConfigurations []*FolderConfiguration `type:"list"`

	// The retention policy ID.
	Id *string `min:"1" type:"string"`

	// The retention policy name.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GetDefaultRetentionPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDefaultRetentionPolicyOutput) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *GetDefaultRetentionPolicyOutput) SetDescription(v string) *GetDefaultRetentionPolicyOutput {
	s.Description = &v
	return s
}

// SetFolderConfigurations sets the FolderConfigurations field's value.
func (s *GetDefaultRetentionPolicyOutput) SetFolderConfigurations(v []*FolderConfiguration) *GetDefaultRetentionPolicyOutput {
	s.FolderConfigurations = v
	return s
}

// SetId sets the Id field's value.
func (s *GetDefaultRetentionPolicyOutput) SetId(v string) *GetDefaultRetentionPolicyOutput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetDefaultRetentionPolicyOutput) SetName(v string) *GetDefaultRetentionPolicyOutput {
	s.Name = &v
	return s
}

type GetMailboxDetailsInput struct {
	_ struct{} `type:"structure"`

	// The identifier for the organization that contains the user whose mailbox
	// details are being requested.
	//
	// OrganizationId is a required field
	OrganizationId *string `min:"34" type:"string" required:"true"`

	// The identifier for the user whose mailbox details are being requested.
	//
	// UserId is a required field
	UserId *string `min:"12" type:"string" required:"true"`
}

// String returns the string representation
func (s GetMailboxDetailsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetMailboxDetailsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetMailboxDetailsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetMailboxDetailsInput"}
	if s.OrganizationId == nil {
		invalidParams.Add(request.NewErrParamRequired("OrganizationId"))
	}
	if s.OrganizationId != nil && len(*s.OrganizationId) < 34 {
		invalidParams.Add(request.NewErrParamMinLen("OrganizationId", 34))
	}
	if s.UserId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserId"))
	}
	if s.UserId != nil && len(*s.UserId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("UserId", 12))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOrganizationId sets the OrganizationId field's value.
func (s *GetMailboxDetailsInput) SetOrganizationId(v string) *GetMailboxDetailsInput {
	s.OrganizationId = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *GetMailboxDetailsInput) SetUserId(v string) *GetMailboxDetailsInput {
	s.UserId = &v
	return s
}

type GetMailboxDetailsOutput struct {
	_ struct{} `type:"structure"`

	// The maximum allowed mailbox size, in MB, for the specified user.
	MailboxQuota *int64 `min:"1" type:"integer"`

	// The current mailbox size, in MB, for the specified user.
	MailboxSize *float64 `type:"double"`
}

// String returns the string representation
func (s GetMailboxDetailsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetMailboxDetailsOutput) GoString() string {
	return s.String()
}

// SetMailboxQuota sets the MailboxQuota field's value.
func (s *GetMailboxDetailsOutput) SetMailboxQuota(v int64) *GetMailboxDetailsOutput {
	s.MailboxQuota = &v
	return s
}

// SetMailboxSize sets the MailboxSize field's value.
func (s *GetMailboxDetailsOutput) SetMailboxSize(v float64) *GetMailboxDetailsOutput {
	s.MailboxSize = &v
	return s
}

// The representation of an Amazon WorkMail group.
type Group struct {
	_ struct{} `type:"structure"`

	// The date indicating when the group was disabled from Amazon WorkMail use.
	DisabledDate *time.Time `type:"timestamp"`

	// The email of the group.
	Email *string `min:"1" type:"string"`

	// The date indicating when the group was enabled for Amazon WorkMail use.
	EnabledDate *time.Time `type:"timestamp"`

	// The identifier of the group.
	Id *string `min:"12" type:"string"`

	// The name of the group.
	Name *string `min:"1" type:"string"`

	// The state of the group, which can be ENABLED, DISABLED, or DELETED.
	State *string `type:"string" enum:"EntityState"`
}

// String returns the string representation
func (s Group) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Group) GoString() string {
	return s.String()
}

// SetDisabledDate sets the DisabledDate field's value.
func (s *Group) SetDisabledDate(v time.Time) *Group {
	s.DisabledDate = &v
	return s
}

// SetEmail sets the Email field's value.
func (s *Group) SetEmail(v string) *Group {
	s.Email = &v
	return s
}

// SetEnabledDate sets the EnabledDate field's value.
func (s *Group) SetEnabledDate(v time.Time) *Group {
	s.EnabledDate = &v
	return s
}

// SetId sets the Id field's value.
func (s *Group) SetId(v string) *Group {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *Group) SetName(v string) *Group {
	s.Name = &v
	return s
}

// SetState sets the State field's value.
func (s *Group) SetState(v string) *Group {
	s.State = &v
	return s
}

// The configuration for a resource isn't valid. A resource must either be able
// to auto-respond to requests or have at least one delegate associated that
// can do so on its behalf.
type InvalidConfigurationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s InvalidConfigurationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidConfigurationException) GoString() string {
	return s.String()
}

func newErrorInvalidConfigurationException(v protocol.ResponseMetadata) error {
	return &InvalidConfigurationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidConfigurationException) Code() string {
	return "InvalidConfigurationException"
}

// Message returns the exception's message.
func (s *InvalidConfigurationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidConfigurationException) OrigErr() error {
	return nil
}

func (s *InvalidConfigurationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidConfigurationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidConfigurationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// One or more of the input parameters don't match the service's restrictions.
type InvalidParameterException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s InvalidParameterException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidParameterException) GoString() string {
	return s.String()
}

func newErrorInvalidParameterException(v protocol.ResponseMetadata) error {
	return &InvalidParameterException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidParameterException) Code() string {
	return "InvalidParameterException"
}

// Message returns the exception's message.
func (s *InvalidParameterException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidParameterException) OrigErr() error {
	return nil
}

func (s *InvalidParameterException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidParameterException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidParameterException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The supplied password doesn't match the minimum security constraints, such
// as length or use of special characters.
type InvalidPasswordException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s InvalidPasswordException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidPasswordException) GoString() string {
	return s.String()
}

func newErrorInvalidPasswordException(v protocol.ResponseMetadata) error {
	return &InvalidPasswordException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidPasswordException) Code() string {
	return "InvalidPasswordException"
}

// Message returns the exception's message.
func (s *InvalidPasswordException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidPasswordException) OrigErr() error {
	return nil
}

func (s *InvalidPasswordException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidPasswordException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidPasswordException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request exceeds the limit of the resource.
type LimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s LimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LimitExceededException) GoString() string {
	return s.String()
}

func newErrorLimitExceededException(v protocol.ResponseMetadata) error {
	return &LimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *LimitExceededException) Code() string {
	return "LimitExceededException"
}

// Message returns the exception's message.
func (s *LimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *LimitExceededException) OrigErr() error {
	return nil
}

func (s *LimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *LimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *LimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListAccessControlRulesInput struct {
	_ struct{} `type:"structure"`

	// The identifier for the organization.
	//
	// OrganizationId is a required field
	OrganizationId *string `min:"34" type:"string" required:"true"`
}

// String returns the string representation
func (s ListAccessControlRulesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAccessControlRulesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAccessControlRulesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAccessControlRulesInput"}
	if s.OrganizationId == nil {
		invalidParams.Add(request.NewErrParamRequired("OrganizationId"))
	}
	if s.OrganizationId != nil && len(*s.OrganizationId) < 34 {
		invalidParams.Add(request.NewErrParamMinLen("OrganizationId", 34))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOrganizationId sets the OrganizationId field's value.
func (s *ListAccessControlRulesInput) SetOrganizationId(v string) *ListAccessControlRulesInput {
	s.OrganizationId = &v
	return s
}

type ListAccessControlRulesOutput struct {
	_ struct{} `type:"structure"`

	// The access control rules.
	Rules []*AccessControlRule `type:"list"`
}

// String returns the string representation
func (s ListAccessControlRulesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAccessControlRulesOutput) GoString() string {
	return s.String()
}

// SetRules sets the Rules field's value.
func (s *ListAccessControlRulesOutput) SetRules(v []*AccessControlRule) *ListAccessControlRulesOutput {
	s.Rules = v
	return s
}

type ListAliasesInput struct {
	_ struct{} `type:"structure"`

	// The identifier for the entity for which to list the aliases.
	//
	// EntityId is a required field
	EntityId *string `min:"12" type:"string" required:"true"`

	// The maximum number of results to return in a single call.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token to use to retrieve the next page of results. The first call does
	// not contain any tokens.
	NextToken *string `min:"1" type:"string"`

	// The identifier for the organization under which the entity exists.
	//
	// OrganizationId is a required field
	OrganizationId *string `min:"34" type:"string" required:"true"`
}

// String returns the string representation
func (s ListAliasesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAliasesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAliasesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAliasesInput"}
	if s.EntityId == nil {
		invalidParams.Add(request.NewErrParamRequired("EntityId"))
	}
	if s.EntityId != nil && len(*s.EntityId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("EntityId", 12))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.OrganizationId == nil {
		invalidParams.Add(request.NewErrParamRequired("OrganizationId"))
	}
	if s.OrganizationId != nil && len(*s.OrganizationId) < 34 {
		invalidParams.Add(request.NewErrParamMinLen("OrganizationId", 34))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEntityId sets the EntityId field's value.
func (s *ListAliasesInput) SetEntityId(v string) *ListAliasesInput {
	s.EntityId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAliasesInput) SetMaxResults(v int64) *ListAliasesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAliasesInput) SetNextToken(v string) *ListAliasesInput {
	s.NextToken = &v
	return s
}

// SetOrganizationId sets the OrganizationId field's value.
func (s *ListAliasesInput) SetOrganizationId(v string) *ListAliasesInput {
	s.OrganizationId = &v
	return s
}

type ListAliasesOutput struct {
	_ struct{} `type:"structure"`

	// The entity's paginated aliases.
	Aliases []*string `type:"list"`

	// The token to use to retrieve the next page of results. The value is "null"
	// when there are no more results to return.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListAliasesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAliasesOutput) GoString() string {
	return s.String()
}

// SetAliases sets the Aliases field's value.
func (s *ListAliasesOutput) SetAliases(v []*string) *ListAliasesOutput {
	s.Aliases = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAliasesOutput) SetNextToken(v string) *ListAliasesOutput {
	s.NextToken = &v
	return s
}

type ListGroupMembersInput struct {
	_ struct{} `type:"structure"`

	// The identifier for the group to which the members (users or groups) are associated.
	//
	// GroupId is a required field
	GroupId *string `min:"12" type:"string" required:"true"`

	// The maximum number of results to return in a single call.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token to use to retrieve the next page of results. The first call does
	// not contain any tokens.
	NextToken *string `min:"1" type:"string"`

	// The identifier for the organization under which the group exists.
	//
	// OrganizationId is a required field
	OrganizationId *string `min:"34" type:"string" required:"true"`
}

// String returns the string representation
func (s ListGroupMembersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListGroupMembersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListGroupMembersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListGroupMembersInput"}
	if s.GroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupId"))
	}
	if s.GroupId != nil && len(*s.GroupId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("GroupId", 12))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.OrganizationId == nil {
		invalidParams.Add(request.NewErrParamRequired("OrganizationId"))
	}
	if s.OrganizationId != nil && len(*s.OrganizationId) < 34 {
		invalidParams.Add(request.NewErrParamMinLen("OrganizationId", 34))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroupId sets the GroupId field's value.
func (s *ListGroupMembersInput) SetGroupId(v string) *ListGroupMembersInput {
	s.GroupId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListGroupMembersInput) SetMaxResults(v int64) *ListGroupMembersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListGroupMembersInput) SetNextToken(v string) *ListGroupMembersInput {
	s.NextToken = &v
	return s
}

// SetOrganizationId sets the OrganizationId field's value.
func (s *ListGroupMembersInput) SetOrganizationId(v string) *ListGroupMembersInput {
	s.OrganizationId = &v
	return s
}

type ListGroupMembersOutput struct {
	_ struct{} `type:"structure"`

	// The members associated to the group.
	Members []*Member `type:"list"`

	// The token to use to retrieve the next page of results. The first call does
	// not contain any tokens.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListGroupMembersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListGroupMembersOutput) GoString() string {
	return s.String()
}

// SetMembers sets the Members field's value.
func (s *ListGroupMembersOutput) SetMembers(v []*Member) *ListGroupMembersOutput {
	s.Members = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListGroupMembersOutput) SetNextToken(v string) *ListGroupMembersOutput {
	s.NextToken = &v
	return s
}

type ListGroupsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return in a single call.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token to use to retrieve the next page of results. The first call does
	// not contain any tokens.
	NextToken *string `min:"1" type:"string"`

	// The identifier for the organization under which the groups exist.
	//
	// OrganizationId is a required field
	OrganizationId *string `min:"34" type:"string" required:"true"`
}

// String returns the string representation
func (s ListGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListGroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListGroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListGroupsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.OrganizationId == nil {
		invalidParams.Add(request.NewErrParamRequired("OrganizationId"))
	}
	if s.OrganizationId != nil && len(*s.OrganizationId) < 34 {
		invalidParams.Add(request.NewErrParamMinLen("OrganizationId", 34))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListGroupsInput) SetMaxResults(v int64) *ListGroupsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListGroupsInput) SetNextToken(v string) *ListGroupsInput {
	s.NextToken = &v
	return s
}

// SetOrganizationId sets the OrganizationId field's value.
func (s *ListGroupsInput) SetOrganizationId(v string) *ListGroupsInput {
	s.OrganizationId = &v
	return s
}

type ListGroupsOutput struct {
	_ struct{} `type:"structure"`

	// The overview of groups for an organization.
	Groups []*Group `type:"list"`

	// The token to use to retrieve the next page of results. The value is "null"
	// when there are no more results to return.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListGroupsOutput) GoString() string {
	return s.String()
}

// SetGroups sets the Groups field's value.
func (s *ListGroupsOutput) SetGroups(v []*Group) *ListGroupsOutput {
	s.Groups = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListGroupsOutput) SetNextToken(v string) *ListGroupsOutput {
	s.NextToken = &v
	return s
}

type ListMailboxExportJobsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return in a single call.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token to use to retrieve the next page of results.
	NextToken *string `min:"1" type:"string"`

	// The organization ID.
	//
	// OrganizationId is a required field
	OrganizationId *string `min:"34" type:"string" required:"true"`
}

// String returns the string representation
func (s ListMailboxExportJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListMailboxExportJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListMailboxExportJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListMailboxExportJobsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.OrganizationId == nil {
		invalidParams.Add(request.NewErrParamRequired("OrganizationId"))
	}
	if s.OrganizationId != nil && len(*s.OrganizationId) < 34 {
		invalidParams.Add(request.NewErrParamMinLen("OrganizationId", 34))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListMailboxExportJobsInput) SetMaxResults(v int64) *ListMailboxExportJobsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListMailboxExportJobsInput) SetNextToken(v string) *ListMailboxExportJobsInput {
	s.NextToken = &v
	return s
}

// SetOrganizationId sets the OrganizationId field's value.
func (s *ListMailboxExportJobsInput) SetOrganizationId(v string) *ListMailboxExportJobsInput {
	s.OrganizationId = &v
	return s
}

type ListMailboxExportJobsOutput struct {
	_ struct{} `type:"structure"`

	// The mailbox export job details.
	Jobs []*MailboxExportJob `type:"list"`

	// The token to use to retrieve the next page of results.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListMailboxExportJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListMailboxExportJobsOutput) GoString() string {
	return s.String()
}

// SetJobs sets the Jobs field's value.
func (s *ListMailboxExportJobsOutput) SetJobs(v []*MailboxExportJob) *ListMailboxExportJobsOutput {
	s.Jobs = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListMailboxExportJobsOutput) SetNextToken(v string) *ListMailboxExportJobsOutput {
	s.NextToken = &v
	return s
}

type ListMailboxPermissionsInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the user, group, or resource for which to list mailbox
	// permissions.
	//
	// EntityId is a required field
	EntityId *string `min:"12" type:"string" required:"true"`

	// The maximum number of results to return in a single call.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token to use to retrieve the next page of results. The first call does
	// not contain any tokens.
	NextToken *string `min:"1" type:"string"`

	// The identifier of the organization under which the user, group, or resource
	// exists.
	//
	// OrganizationId is a required field
	OrganizationId *string `min:"34" type:"string" required:"true"`
}

// String returns the string representation
func (s ListMailboxPermissionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListMailboxPermissionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListMailboxPermissionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListMailboxPermissionsInput"}
	if s.EntityId == nil {
		invalidParams.Add(request.NewErrParamRequired("EntityId"))
	}
	if s.EntityId != nil && len(*s.EntityId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("EntityId", 12))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.OrganizationId == nil {
		invalidParams.Add(request.NewErrParamRequired("OrganizationId"))
	}
	if s.OrganizationId != nil && len(*s.OrganizationId) < 34 {
		invalidParams.Add(request.NewErrParamMinLen("OrganizationId", 34))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEntityId sets the EntityId field's value.
func (s *ListMailboxPermissionsInput) SetEntityId(v string) *ListMailboxPermissionsInput {
	s.EntityId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListMailboxPermissionsInput) SetMaxResults(v int64) *ListMailboxPermissionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListMailboxPermissionsInput) SetNextToken(v string) *ListMailboxPermissionsInput {
	s.NextToken = &v
	return s
}

// SetOrganizationId sets the OrganizationId field's value.
func (s *ListMailboxPermissionsInput) SetOrganizationId(v string) *ListMailboxPermissionsInput {
	s.OrganizationId = &v
	return s
}

type ListMailboxPermissionsOutput struct {
	_ struct{} `type:"structure"`

	// The token to use to retrieve the next page of results. The value is "null"
	// when there are no more results to return.
	NextToken *string `min:"1" type:"string"`

	// One page of the user, group, or resource mailbox permissions.
	Permissions []*Permission `type:"list"`
}

// String returns the string representation
func (s ListMailboxPermissionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListMailboxPermissionsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListMailboxPermissionsOutput) SetNextToken(v string) *ListMailboxPermissionsOutput {
	s.NextToken = &v
	return s
}

// SetPermissions sets the Permissions field's value.
func (s *ListMailboxPermissionsOutput) SetPermissions(v []*Permission) *ListMailboxPermissionsOutput {
	s.Permissions = v
	return s
}

type ListOrganizationsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return in a single call.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token to use to retrieve the next page of results. The first call does
	// not contain any tokens.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListOrganizationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListOrganizationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListOrganizationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListOrganizationsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListOrganizationsInput) SetMaxResults(v int64) *ListOrganizationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListOrganizationsInput) SetNextToken(v string) *ListOrganizationsInput {
	s.NextToken = &v
	return s
}

type ListOrganizationsOutput struct {
	_ struct{} `type:"structure"`

	// The token to use to retrieve the next page of results. The value is "null"
	// when there are no more results to return.
	NextToken *string `min:"1" type:"string"`

	// The overview of owned organizations presented as a list of organization summaries.
	OrganizationSummaries []*OrganizationSummary `type:"list"`
}

// String returns the string representation
func (s ListOrganizationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListOrganizationsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListOrganizationsOutput) SetNextToken(v string) *ListOrganizationsOutput {
	s.NextToken = &v
	return s
}

// SetOrganizationSummaries sets the OrganizationSummaries field's value.
func (s *ListOrganizationsOutput) SetOrganizationSummaries(v []*OrganizationSummary) *ListOrganizationsOutput {
	s.OrganizationSummaries = v
	return s
}

type ListResourceDelegatesInput struct {
	_ struct{} `type:"structure"`

	// The number of maximum results in a page.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token used to paginate through the delegates associated with a resource.
	NextToken *string `min:"1" type:"string"`

	// The identifier for the organization that contains the resource for which
	// delegates are listed.
	//
	// OrganizationId is a required field
	OrganizationId *string `min:"34" type:"string" required:"true"`

	// The identifier for the resource whose delegates are listed.
	//
	// ResourceId is a required field
	ResourceId *string `min:"12" type:"string" required:"true"`
}

// String returns the string representation
func (s ListResourceDelegatesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListResourceDelegatesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListResourceDelegatesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListResourceDelegatesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.OrganizationId == nil {
		invalidParams.Add(request.NewErrParamRequired("OrganizationId"))
	}
	if s.OrganizationId != nil && len(*s.OrganizationId) < 34 {
		invalidParams.Add(request.NewErrParamMinLen("OrganizationId", 34))
	}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 12))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListResourceDelegatesInput) SetMaxResults(v int64) *ListResourceDelegatesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListResourceDelegatesInput) SetNextToken(v string) *ListResourceDelegatesInput {
	s.NextToken = &v
	return s
}

// SetOrganizationId sets the OrganizationId field's value.
func (s *ListResourceDelegatesInput) SetOrganizationId(v string) *ListResourceDelegatesInput {
	s.OrganizationId = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *ListResourceDelegatesInput) SetResourceId(v string) *ListResourceDelegatesInput {
	s.ResourceId = &v
	return s
}

type ListResourceDelegatesOutput struct {
	_ struct{} `type:"structure"`

	// One page of the resource's delegates.
	Delegates []*Delegate `type:"list"`

	// The token used to paginate through the delegates associated with a resource.
	// While results are still available, it has an associated value. When the last
	// page is reached, the token is empty.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListResourceDelegatesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListResourceDelegatesOutput) GoString() string {
	return s.String()
}

// SetDelegates sets the Delegates field's value.
func (s *ListResourceDelegatesOutput) SetDelegates(v []*Delegate) *ListResourceDelegatesOutput {
	s.Delegates = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListResourceDelegatesOutput) SetNextToken(v string) *ListResourceDelegatesOutput {
	s.NextToken = &v
	return s
}

type ListResourcesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return in a single call.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token to use to retrieve the next page of results. The first call does
	// not contain any tokens.
	NextToken *string `min:"1" type:"string"`

	// The identifier for the organization under which the resources exist.
	//
	// OrganizationId is a required field
	OrganizationId *string `min:"34" type:"string" required:"true"`
}

// String returns the string representation
func (s ListResourcesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListResourcesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListResourcesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListResourcesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.OrganizationId == nil {
		invalidParams.Add(request.NewErrParamRequired("OrganizationId"))
	}
	if s.OrganizationId != nil && len(*s.OrganizationId) < 34 {
		invalidParams.Add(request.NewErrParamMinLen("OrganizationId", 34))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListResourcesInput) SetMaxResults(v int64) *ListResourcesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListResourcesInput) SetNextToken(v string) *ListResourcesInput {
	s.NextToken = &v
	return s
}

// SetOrganizationId sets the OrganizationId field's value.
func (s *ListResourcesInput) SetOrganizationId(v string) *ListResourcesInput {
	s.OrganizationId = &v
	return s
}

type ListResourcesOutput struct {
	_ struct{} `type:"structure"`

	// The token used to paginate through all the organization's resources. While
	// results are still available, it has an associated value. When the last page
	// is reached, the token is empty.
	NextToken *string `min:"1" type:"string"`

	// One page of the organization's resource representation.
	Resources []*Resource `type:"list"`
}

// String returns the string representation
func (s ListResourcesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListResourcesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListResourcesOutput) SetNextToken(v string) *ListResourcesOutput {
	s.NextToken = &v
	return s
}

// SetResources sets the Resources field's value.
func (s *ListResourcesOutput) SetResources(v []*Resource) *ListResourcesOutput {
	s.Resources = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The resource ARN.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *ListTagsForResourceInput) SetResourceARN(v string) *ListTagsForResourceInput {
	s.ResourceARN = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// A list of tag key-value pairs.
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v []*Tag) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

type ListUsersInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return in a single call.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token to use to retrieve the next page of results. The first call does
	// not contain any tokens.
	NextToken *string `min:"1" type:"string"`

	// The identifier for the organization under which the users exist.
	//
	// OrganizationId is a required field
	OrganizationId *string `min:"34" type:"string" required:"true"`
}

// String returns the string representation
func (s ListUsersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListUsersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListUsersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListUsersInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.OrganizationId == nil {
		invalidParams.Add(request.NewErrParamRequired("OrganizationId"))
	}
	if s.OrganizationId != nil && len(*s.OrganizationId) < 34 {
		invalidParams.Add(request.NewErrParamMinLen("OrganizationId", 34))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListUsersInput) SetMaxResults(v int64) *ListUsersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListUsersInput) SetNextToken(v string) *ListUsersInput {
	s.NextToken = &v
	return s
}

// SetOrganizationId sets the OrganizationId field's value.
func (s *ListUsersInput) SetOrganizationId(v string) *ListUsersInput {
	s.OrganizationId = &v
	return s
}

type ListUsersOutput struct {
	_ struct{} `type:"structure"`

	// The token to use to retrieve the next page of results. This value is `null`
	// when there are no more results to return.
	NextToken *string `min:"1" type:"string"`

	// The overview of users for an organization.
	Users []*User `type:"list"`
}

// String returns the string representation
func (s ListUsersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListUsersOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListUsersOutput) SetNextToken(v string) *ListUsersOutput {
	s.NextToken = &v
	return s
}

// SetUsers sets the Users field's value.
func (s *ListUsersOutput) SetUsers(v []*User) *ListUsersOutput {
	s.Users = v
	return s
}

// For an email or alias to be created in Amazon WorkMail, the included domain
// must be defined in the organization.
type MailDomainNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s MailDomainNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MailDomainNotFoundException) GoString() string {
	return s.String()
}

func newErrorMailDomainNotFoundException(v protocol.ResponseMetadata) error {
	return &MailDomainNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *MailDomainNotFoundException) Code() string {
	return "MailDomainNotFoundException"
}

// Message returns the exception's message.
func (s *MailDomainNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *MailDomainNotFoundException) OrigErr() error {
	return nil
}

func (s *MailDomainNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *MailDomainNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *MailDomainNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// After a domain has been added to the organization, it must be verified. The
// domain is not yet verified.
type MailDomainStateException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s MailDomainStateException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MailDomainStateException) GoString() string {
	return s.String()
}

func newErrorMailDomainStateException(v protocol.ResponseMetadata) error {
	return &MailDomainStateException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *MailDomainStateException) Code() string {
	return "MailDomainStateException"
}

// Message returns the exception's message.
func (s *MailDomainStateException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *MailDomainStateException) OrigErr() error {
	return nil
}

func (s *MailDomainStateException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *MailDomainStateException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *MailDomainStateException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The details of a mailbox export job, including the user or resource ID associated
// with the mailbox and the S3 bucket that the mailbox contents are exported
// to.
type MailboxExportJob struct {
	_ struct{} `type:"structure"`

	// The mailbox export job description.
	Description *string `type:"string"`

	// The mailbox export job end timestamp.
	EndTime *time.Time `type:"timestamp"`

	// The identifier of the user or resource associated with the mailbox.
	EntityId *string `min:"12" type:"string"`

	// The estimated progress of the mailbox export job, in percentage points.
	EstimatedProgress *int64 `type:"integer"`

	// The identifier of the mailbox export job.
	JobId *string `min:"1" type:"string"`

	// The name of the S3 bucket.
	S3BucketName *string `min:"1" type:"string"`

	// The path to the S3 bucket and file that the mailbox export job exports to.
	S3Path *string `min:"1" type:"string"`

	// The mailbox export job start timestamp.
	StartTime *time.Time `type:"timestamp"`

	// The state of the mailbox export job.
	State *string `type:"string" enum:"MailboxExportJobState"`
}

// String returns the string representation
func (s MailboxExportJob) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MailboxExportJob) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *MailboxExportJob) SetDescription(v string) *MailboxExportJob {
	s.Description = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *MailboxExportJob) SetEndTime(v time.Time) *MailboxExportJob {
	s.EndTime = &v
	return s
}

// SetEntityId sets the EntityId field's value.
func (s *MailboxExportJob) SetEntityId(v string) *MailboxExportJob {
	s.EntityId = &v
	return s
}

// SetEstimatedProgress sets the EstimatedProgress field's value.
func (s *MailboxExportJob) SetEstimatedProgress(v int64) *MailboxExportJob {
	s.EstimatedProgress = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *MailboxExportJob) SetJobId(v string) *MailboxExportJob {
	s.JobId = &v
	return s
}

// SetS3BucketName sets the S3BucketName field's value.
func (s *MailboxExportJob) SetS3BucketName(v string) *MailboxExportJob {
	s.S3BucketName = &v
	return s
}

// SetS3Path sets the S3Path field's value.
func (s *MailboxExportJob) SetS3Path(v string) *MailboxExportJob {
	s.S3Path = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *MailboxExportJob) SetStartTime(v time.Time) *MailboxExportJob {
	s.StartTime = &v
	return s
}

// SetState sets the State field's value.
func (s *MailboxExportJob) SetState(v string) *MailboxExportJob {
	s.State = &v
	return s
}

// The representation of a user or group.
type Member struct {
	_ struct{} `type:"structure"`

	// The date indicating when the member was disabled from Amazon WorkMail use.
	DisabledDate *time.Time `type:"timestamp"`

	// The date indicating when the member was enabled for Amazon WorkMail use.
	EnabledDate *time.Time `type:"timestamp"`

	// The identifier of the member.
	Id *string `type:"string"`

	// The name of the member.
	Name *string `type:"string"`

	// The state of the member, which can be ENABLED, DISABLED, or DELETED.
	State *string `type:"string" enum:"EntityState"`

	// A member can be a user or group.
	Type *string `type:"string" enum:"MemberType"`
}

// String returns the string representation
func (s Member) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Member) GoString() string {
	return s.String()
}

// SetDisabledDate sets the DisabledDate field's value.
func (s *Member) SetDisabledDate(v time.Time) *Member {
	s.DisabledDate = &v
	return s
}

// SetEnabledDate sets the EnabledDate field's value.
func (s *Member) SetEnabledDate(v time.Time) *Member {
	s.EnabledDate = &v
	return s
}

// SetId sets the Id field's value.
func (s *Member) SetId(v string) *Member {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *Member) SetName(v string) *Member {
	s.Name = &v
	return s
}

// SetState sets the State field's value.
func (s *Member) SetState(v string) *Member {
	s.State = &v
	return s
}

// SetType sets the Type field's value.
func (s *Member) SetType(v string) *Member {
	s.Type = &v
	return s
}

// The user, group, or resource name isn't unique in Amazon WorkMail.
type NameAvailabilityException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s NameAvailabilityException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NameAvailabilityException) GoString() string {
	return s.String()
}

func newErrorNameAvailabilityException(v protocol.ResponseMetadata) error {
	return &NameAvailabilityException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *NameAvailabilityException) Code() string {
	return "NameAvailabilityException"
}

// Message returns the exception's message.
func (s *NameAvailabilityException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *NameAvailabilityException) OrigErr() error {
	return nil
}

func (s *NameAvailabilityException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *NameAvailabilityException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *NameAvailabilityException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An operation received a valid organization identifier that either doesn't
// belong or exist in the system.
type OrganizationNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s OrganizationNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OrganizationNotFoundException) GoString() string {
	return s.String()
}

func newErrorOrganizationNotFoundException(v protocol.ResponseMetadata) error {
	return &OrganizationNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *OrganizationNotFoundException) Code() string {
	return "OrganizationNotFoundException"
}

// Message returns the exception's message.
func (s *OrganizationNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *OrganizationNotFoundException) OrigErr() error {
	return nil
}

func (s *OrganizationNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *OrganizationNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *OrganizationNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The organization must have a valid state to perform certain operations on
// the organization or its members.
type OrganizationStateException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s OrganizationStateException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OrganizationStateException) GoString() string {
	return s.String()
}

func newErrorOrganizationStateException(v protocol.ResponseMetadata) error {
	return &OrganizationStateException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *OrganizationStateException) Code() string {
	return "OrganizationStateException"
}

// Message returns the exception's message.
func (s *OrganizationStateException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *OrganizationStateException) OrigErr() error {
	return nil
}

func (s *OrganizationStateException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *OrganizationStateException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *OrganizationStateException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The representation of an organization.
type OrganizationSummary struct {
	_ struct{} `type:"structure"`

	// The alias associated with the organization.
	Alias *string `min:"1" type:"string"`

	// The default email domain associated with the organization.
	DefaultMailDomain *string `min:"3" type:"string"`

	// The error message associated with the organization. It is only present if
	// unexpected behavior has occurred with regards to the organization. It provides
	// insight or solutions regarding unexpected behavior.
	ErrorMessage *string `type:"string"`

	// The identifier associated with the organization.
	OrganizationId *string `min:"34" type:"string"`

	// The state associated with the organization.
	State *string `type:"string"`
}

// String returns the string representation
func (s OrganizationSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OrganizationSummary) GoString() string {
	return s.String()
}

// SetAlias sets the Alias field's value.
func (s *OrganizationSummary) SetAlias(v string) *OrganizationSummary {
	s.Alias = &v
	return s
}

// SetDefaultMailDomain sets the DefaultMailDomain field's value.
func (s *OrganizationSummary) SetDefaultMailDomain(v string) *OrganizationSummary {
	s.DefaultMailDomain = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *OrganizationSummary) SetErrorMessage(v string) *OrganizationSummary {
	s.ErrorMessage = &v
	return s
}

// SetOrganizationId sets the OrganizationId field's value.
func (s *OrganizationSummary) SetOrganizationId(v string) *OrganizationSummary {
	s.OrganizationId = &v
	return s
}

// SetState sets the State field's value.
func (s *OrganizationSummary) SetState(v string) *OrganizationSummary {
	s.State = &v
	return s
}

// Permission granted to a user, group, or resource to access a certain aspect
// of another user, group, or resource mailbox.
type Permission struct {
	_ struct{} `type:"structure"`

	// The identifier of the user, group, or resource to which the permissions are
	// granted.
	//
	// GranteeId is a required field
	GranteeId *string `min:"12" type:"string" required:"true"`

	// The type of user, group, or resource referred to in GranteeId.
	//
	// GranteeType is a required field
	GranteeType *string `type:"string" required:"true" enum:"MemberType"`

	// The permissions granted to the grantee. SEND_AS allows the grantee to send
	// email as the owner of the mailbox (the grantee is not mentioned on these
	// emails). SEND_ON_BEHALF allows the grantee to send email on behalf of the
	// owner of the mailbox (the grantee is not mentioned as the physical sender
	// of these emails). FULL_ACCESS allows the grantee full access to the mailbox,
	// irrespective of other folder-level permissions set on the mailbox.
	//
	// PermissionValues is a required field
	PermissionValues []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s Permission) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Permission) GoString() string {
	return s.String()
}

// SetGranteeId sets the GranteeId field's value.
func (s *Permission) SetGranteeId(v string) *Permission {
	s.GranteeId = &v
	return s
}

// SetGranteeType sets the GranteeType field's value.
func (s *Permission) SetGranteeType(v string) *Permission {
	s.GranteeType = &v
	return s
}

// SetPermissionValues sets the PermissionValues field's value.
func (s *Permission) SetPermissionValues(v []*string) *Permission {
	s.PermissionValues = v
	return s
}

type PutAccessControlRuleInput struct {
	_ struct{} `type:"structure"`

	// Access protocol actions to include in the rule. Valid values include ActiveSync,
	// AutoDiscover, EWS, IMAP, SMTP, WindowsOutlook, and WebMail.
	Actions []*string `type:"list"`

	// The rule description.
	//
	// Description is a required field
	Description *string `type:"string" required:"true"`

	// The rule effect.
	//
	// Effect is a required field
	Effect *string `type:"string" required:"true" enum:"AccessControlRuleEffect"`

	// IPv4 CIDR ranges to include in the rule.
	IpRanges []*string `type:"list"`

	// The rule name.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// Access protocol actions to exclude from the rule. Valid values include ActiveSync,
	// AutoDiscover, EWS, IMAP, SMTP, WindowsOutlook, and WebMail.
	NotActions []*string `type:"list"`

	// IPv4 CIDR ranges to exclude from the rule.
	NotIpRanges []*string `type:"list"`

	// User IDs to exclude from the rule.
	NotUserIds []*string `type:"list"`

	// The identifier of the organization.
	//
	// OrganizationId is a required field
	OrganizationId *string `min:"34" type:"string" required:"true"`

	// User IDs to include in the rule.
	UserIds []*string `type:"list"`
}

// String returns the string representation
func (s PutAccessControlRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutAccessControlRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutAccessControlRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutAccessControlRuleInput"}
	if s.Description == nil {
		invalidParams.Add(request.NewErrParamRequired("Description"))
	}
	if s.Effect == nil {
		invalidParams.Add(request.NewErrParamRequired("Effect"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.OrganizationId == nil {
		invalidParams.Add(request.NewErrParamRequired("OrganizationId"))
	}
	if s.OrganizationId != nil && len(*s.OrganizationId) < 34 {
		invalidParams.Add(request.NewErrParamMinLen("OrganizationId", 34))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActions sets the Actions field's value.
func (s *PutAccessControlRuleInput) SetActions(v []*string) *PutAccessControlRuleInput {
	s.Actions = v
	return s
}

// SetDescription sets the Description field's value.
func (s *PutAccessControlRuleInput) SetDescription(v string) *PutAccessControlRuleInput {
	s.Description = &v
	return s
}

// SetEffect sets the Effect field's value.
func (s *PutAccessControlRuleInput) SetEffect(v string) *PutAccessControlRuleInput {
	s.Effect = &v
	return s
}

// SetIpRanges sets the IpRanges field's value.
func (s *PutAccessControlRuleInput) SetIpRanges(v []*string) *PutAccessControlRuleInput {
	s.IpRanges = v
	return s
}

// SetName sets the Name field's value.
func (s *PutAccessControlRuleInput) SetName(v string) *PutAccessControlRuleInput {
	s.Name = &v
	return s
}

// SetNotActions sets the NotActions field's value.
func (s *PutAccessControlRuleInput) SetNotActions(v []*string) *PutAccessControlRuleInput {
	s.NotActions = v
	return s
}

// SetNotIpRanges sets the NotIpRanges field's value.
func (s *PutAccessControlRuleInput) SetNotIpRanges(v []*string) *PutAccessControlRuleInput {
	s.NotIpRanges = v
	return s
}

// SetNotUserIds sets the NotUserIds field's value.
func (s *PutAccessControlRuleInput) SetNotUserIds(v []*string) *PutAccessControlRuleInput {
	s.NotUserIds = v
	return s
}

// SetOrganizationId sets the OrganizationId field's value.
func (s *PutAccessControlRuleInput) SetOrganizationId(v string) *PutAccessControlRuleInput {
	s.OrganizationId = &v
	return s
}

// SetUserIds sets the UserIds field's value.
func (s *PutAccessControlRuleInput) SetUserIds(v []*string) *PutAccessControlRuleInput {
	s.UserIds = v
	return s
}

type PutAccessControlRuleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutAccessControlRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutAccessControlRuleOutput) GoString() string {
	return s.String()
}

type PutMailboxPermissionsInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the user, group, or resource for which to update mailbox
	// permissions.
	//
	// EntityId is a required field
	EntityId *string `min:"12" type:"string" required:"true"`

	// The identifier of the user, group, or resource to which to grant the permissions.
	//
	// GranteeId is a required field
	GranteeId *string `min:"12" type:"string" required:"true"`

	// The identifier of the organization under which the user, group, or resource
	// exists.
	//
	// OrganizationId is a required field
	OrganizationId *string `min:"34" type:"string" required:"true"`

	// The permissions granted to the grantee. SEND_AS allows the grantee to send
	// email as the owner of the mailbox (the grantee is not mentioned on these
	// emails). SEND_ON_BEHALF allows the grantee to send email on behalf of the
	// owner of the mailbox (the grantee is not mentioned as the physical sender
	// of these emails). FULL_ACCESS allows the grantee full access to the mailbox,
	// irrespective of other folder-level permissions set on the mailbox.
	//
	// PermissionValues is a required field
	PermissionValues []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s PutMailboxPermissionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutMailboxPermissionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutMailboxPermissionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutMailboxPermissionsInput"}
	if s.EntityId == nil {
		invalidParams.Add(request.NewErrParamRequired("EntityId"))
	}
	if s.EntityId != nil && len(*s.EntityId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("EntityId", 12))
	}
	if s.GranteeId == nil {
		invalidParams.Add(request.NewErrParamRequired("GranteeId"))
	}
	if s.GranteeId != nil && len(*s.GranteeId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("GranteeId", 12))
	}
	if s.OrganizationId == nil {
		invalidParams.Add(request.NewErrParamRequired("OrganizationId"))
	}
	if s.OrganizationId != nil && len(*s.OrganizationId) < 34 {
		invalidParams.Add(request.NewErrParamMinLen("OrganizationId", 34))
	}
	if s.PermissionValues == nil {
		invalidParams.Add(request.NewErrParamRequired("PermissionValues"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEntityId sets the EntityId field's value.
func (s *PutMailboxPermissionsInput) SetEntityId(v string) *PutMailboxPermissionsInput {
	s.EntityId = &v
	return s
}

// SetGranteeId sets the GranteeId field's value.
func (s *PutMailboxPermissionsInput) SetGranteeId(v string) *PutMailboxPermissionsInput {
	s.GranteeId = &v
	return s
}

// SetOrganizationId sets the OrganizationId field's value.
func (s *PutMailboxPermissionsInput) SetOrganizationId(v string) *PutMailboxPermissionsInput {
	s.OrganizationId = &v
	return s
}

// SetPermissionValues sets the PermissionValues field's value.
func (s *PutMailboxPermissionsInput) SetPermissionValues(v []*string) *PutMailboxPermissionsInput {
	s.PermissionValues = v
	return s
}

type PutMailboxPermissionsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutMailboxPermissionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutMailboxPermissionsOutput) GoString() string {
	return s.String()
}

type PutRetentionPolicyInput struct {
	_ struct{} `type:"structure"`

	// The retention policy description.
	Description *string `type:"string" sensitive:"true"`

	// The retention policy folder configurations.
	//
	// FolderConfigurations is a required field
	FolderConfigurations []*FolderConfiguration `type:"list" required:"true"`

	// The retention policy ID.
	Id *string `min:"1" type:"string"`

	// The retention policy name.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The organization ID.
	//
	// OrganizationId is a required field
	OrganizationId *string `min:"34" type:"string" required:"true"`
}

// String returns the string representation
func (s PutRetentionPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutRetentionPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutRetentionPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutRetentionPolicyInput"}
	if s.FolderConfigurations == nil {
		invalidParams.Add(request.NewErrParamRequired("FolderConfigurations"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.OrganizationId == nil {
		invalidParams.Add(request.NewErrParamRequired("OrganizationId"))
	}
	if s.OrganizationId != nil && len(*s.OrganizationId) < 34 {
		invalidParams.Add(request.NewErrParamMinLen("OrganizationId", 34))
	}
	if s.FolderConfigurations != nil {
		for i, v := range s.FolderConfigurations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "FolderConfigurations", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *PutRetentionPolicyInput) SetDescription(v string) *PutRetentionPolicyInput {
	s.Description = &v
	return s
}

// SetFolderConfigurations sets the FolderConfigurations field's value.
func (s *PutRetentionPolicyInput) SetFolderConfigurations(v []*FolderConfiguration) *PutRetentionPolicyInput {
	s.FolderConfigurations = v
	return s
}

// SetId sets the Id field's value.
func (s *PutRetentionPolicyInput) SetId(v string) *PutRetentionPolicyInput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *PutRetentionPolicyInput) SetName(v string) *PutRetentionPolicyInput {
	s.Name = &v
	return s
}

// SetOrganizationId sets the OrganizationId field's value.
func (s *PutRetentionPolicyInput) SetOrganizationId(v string) *PutRetentionPolicyInput {
	s.OrganizationId = &v
	return s
}

type PutRetentionPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutRetentionPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutRetentionPolicyOutput) GoString() string {
	return s.String()
}

type RegisterToWorkMailInput struct {
	_ struct{} `type:"structure"`

	// The email for the user, group, or resource to be updated.
	//
	// Email is a required field
	Email *string `min:"1" type:"string" required:"true"`

	// The identifier for the user, group, or resource to be updated.
	//
	// EntityId is a required field
	EntityId *string `min:"12" type:"string" required:"true"`

	// The identifier for the organization under which the user, group, or resource
	// exists.
	//
	// OrganizationId is a required field
	OrganizationId *string `min:"34" type:"string" required:"true"`
}

// String returns the string representation
func (s RegisterToWorkMailInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RegisterToWorkMailInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RegisterToWorkMailInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RegisterToWorkMailInput"}
	if s.Email == nil {
		invalidParams.Add(request.NewErrParamRequired("Email"))
	}
	if s.Email != nil && len(*s.Email) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Email", 1))
	}
	if s.EntityId == nil {
		invalidParams.Add(request.NewErrParamRequired("EntityId"))
	}
	if s.EntityId != nil && len(*s.EntityId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("EntityId", 12))
	}
	if s.OrganizationId == nil {
		invalidParams.Add(request.NewErrParamRequired("OrganizationId"))
	}
	if s.OrganizationId != nil && len(*s.OrganizationId) < 34 {
		invalidParams.Add(request.NewErrParamMinLen("OrganizationId", 34))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEmail sets the Email field's value.
func (s *RegisterToWorkMailInput) SetEmail(v string) *RegisterToWorkMailInput {
	s.Email = &v
	return s
}

// SetEntityId sets the EntityId field's value.
func (s *RegisterToWorkMailInput) SetEntityId(v string) *RegisterToWorkMailInput {
	s.EntityId = &v
	return s
}

// SetOrganizationId sets the OrganizationId field's value.
func (s *RegisterToWorkMailInput) SetOrganizationId(v string) *RegisterToWorkMailInput {
	s.OrganizationId = &v
	return s
}

type RegisterToWorkMailOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RegisterToWorkMailOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RegisterToWorkMailOutput) GoString() string {
	return s.String()
}

// This user, group, or resource name is not allowed in Amazon WorkMail.
type ReservedNameException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s ReservedNameException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReservedNameException) GoString() string {
	return s.String()
}

func newErrorReservedNameException(v protocol.ResponseMetadata) error {
	return &ReservedNameException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ReservedNameException) Code() string {
	return "ReservedNameException"
}

// Message returns the exception's message.
func (s *ReservedNameException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ReservedNameException) OrigErr() error {
	return nil
}

func (s *ReservedNameException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ReservedNameException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ReservedNameException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ResetPasswordInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the organization that contains the user for which the password
	// is reset.
	//
	// OrganizationId is a required field
	OrganizationId *string `min:"34" type:"string" required:"true"`

	// The new password for the user.
	//
	// Password is a required field
	Password *string `type:"string" required:"true" sensitive:"true"`

	// The identifier of the user for whom the password is reset.
	//
	// UserId is a required field
	UserId *string `min:"12" type:"string" required:"true"`
}

// String returns the string representation
func (s ResetPasswordInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResetPasswordInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResetPasswordInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ResetPasswordInput"}
	if s.OrganizationId == nil {
		invalidParams.Add(request.NewErrParamRequired("OrganizationId"))
	}
	if s.OrganizationId != nil && len(*s.OrganizationId) < 34 {
		invalidParams.Add(request.NewErrParamMinLen("OrganizationId", 34))
	}
	if s.Password == nil {
		invalidParams.Add(request.NewErrParamRequired("Password"))
	}
	if s.UserId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserId"))
	}
	if s.UserId != nil && len(*s.UserId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("UserId", 12))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOrganizationId sets the OrganizationId field's value.
func (s *ResetPasswordInput) SetOrganizationId(v string) *ResetPasswordInput {
	s.OrganizationId = &v
	return s
}

// SetPassword sets the Password field's value.
func (s *ResetPasswordInput) SetPassword(v string) *ResetPasswordInput {
	s.Password = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *ResetPasswordInput) SetUserId(v string) *ResetPasswordInput {
	s.UserId = &v
	return s
}

type ResetPasswordOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ResetPasswordOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResetPasswordOutput) GoString() string {
	return s.String()
}

// The representation of a resource.
type Resource struct {
	_ struct{} `type:"structure"`

	// The date indicating when the resource was disabled from Amazon WorkMail use.
	DisabledDate *time.Time `type:"timestamp"`

	// The email of the resource.
	Email *string `min:"1" type:"string"`

	// The date indicating when the resource was enabled for Amazon WorkMail use.
	EnabledDate *time.Time `type:"timestamp"`

	// The identifier of the resource.
	Id *string `min:"12" type:"string"`

	// The name of the resource.
	Name *string `min:"1" type:"string"`

	// The state of the resource, which can be ENABLED, DISABLED, or DELETED.
	State *string `type:"string" enum:"EntityState"`

	// The type of the resource: equipment or room.
	Type *string `type:"string" enum:"ResourceType"`
}

// String returns the string representation
func (s Resource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Resource) GoString() string {
	return s.String()
}

// SetDisabledDate sets the DisabledDate field's value.
func (s *Resource) SetDisabledDate(v time.Time) *Resource {
	s.DisabledDate = &v
	return s
}

// SetEmail sets the Email field's value.
func (s *Resource) SetEmail(v string) *Resource {
	s.Email = &v
	return s
}

// SetEnabledDate sets the EnabledDate field's value.
func (s *Resource) SetEnabledDate(v time.Time) *Resource {
	s.EnabledDate = &v
	return s
}

// SetId sets the Id field's value.
func (s *Resource) SetId(v string) *Resource {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *Resource) SetName(v string) *Resource {
	s.Name = &v
	return s
}

// SetState sets the State field's value.
func (s *Resource) SetState(v string) *Resource {
	s.State = &v
	return s
}

// SetType sets the Type field's value.
func (s *Resource) SetType(v string) *Resource {
	s.Type = &v
	return s
}

// The resource cannot be found.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

type StartMailboxExportJobInput struct {
	_ struct{} `type:"structure"`

	// The idempotency token for the client request.
	ClientToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The mailbox export job description.
	Description *string `type:"string"`

	// The identifier of the user or resource associated with the mailbox.
	//
	// EntityId is a required field
	EntityId *string `min:"12" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the symmetric AWS Key Management Service
	// (AWS KMS) key that encrypts the exported mailbox content.
	//
	// KmsKeyArn is a required field
	KmsKeyArn *string `min:"20" type:"string" required:"true"`

	// The identifier associated with the organization.
	//
	// OrganizationId is a required field
	OrganizationId *string `min:"34" type:"string" required:"true"`

	// The ARN of the AWS Identity and Access Management (IAM) role that grants
	// write permission to the S3 bucket.
	//
	// RoleArn is a required field
	RoleArn *string `min:"20" type:"string" required:"true"`

	// The name of the S3 bucket.
	//
	// S3BucketName is a required field
	S3BucketName *string `min:"1" type:"string" required:"true"`

	// The S3 bucket prefix.
	//
	// S3Prefix is a required field
	S3Prefix *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StartMailboxExportJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartMailboxExportJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartMailboxExportJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartMailboxExportJobInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.EntityId == nil {
		invalidParams.Add(request.NewErrParamRequired("EntityId"))
	}
	if s.EntityId != nil && len(*s.EntityId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("EntityId", 12))
	}
	if s.KmsKeyArn == nil {
		invalidParams.Add(request.NewErrParamRequired("KmsKeyArn"))
	}
	if s.KmsKeyArn != nil && len(*s.KmsKeyArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("KmsKeyArn", 20))
	}
	if s.OrganizationId == nil {
		invalidParams.Add(request.NewErrParamRequired("OrganizationId"))
	}
	if s.OrganizationId != nil && len(*s.OrganizationId) < 34 {
		invalidParams.Add(request.NewErrParamMinLen("OrganizationId", 34))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 20))
	}
	if s.S3BucketName == nil {
		invalidParams.Add(request.NewErrParamRequired("S3BucketName"))
	}
	if s.S3BucketName != nil && len(*s.S3BucketName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("S3BucketName", 1))
	}
	if s.S3Prefix == nil {
		invalidParams.Add(request.NewErrParamRequired("S3Prefix"))
	}
	if s.S3Prefix != nil && len(*s.S3Prefix) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("S3Prefix", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *StartMailboxExportJobInput) SetClientToken(v string) *StartMailboxExportJobInput {
	s.ClientToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *StartMailboxExportJobInput) SetDescription(v string) *StartMailboxExportJobInput {
	s.Description = &v
	return s
}

// SetEntityId sets the EntityId field's value.
func (s *StartMailboxExportJobInput) SetEntityId(v string) *StartMailboxExportJobInput {
	s.EntityId = &v
	return s
}

// SetKmsKeyArn sets the KmsKeyArn field's value.
func (s *StartMailboxExportJobInput) SetKmsKeyArn(v string) *StartMailboxExportJobInput {
	s.KmsKeyArn = &v
	return s
}

// SetOrganizationId sets the OrganizationId field's value.
func (s *StartMailboxExportJobInput) SetOrganizationId(v string) *StartMailboxExportJobInput {
	s.OrganizationId = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *StartMailboxExportJobInput) SetRoleArn(v string) *StartMailboxExportJobInput {
	s.RoleArn = &v
	return s
}

// SetS3BucketName sets the S3BucketName field's value.
func (s *StartMailboxExportJobInput) SetS3BucketName(v string) *StartMailboxExportJobInput {
	s.S3BucketName = &v
	return s
}

// SetS3Prefix sets the S3Prefix field's value.
func (s *StartMailboxExportJobInput) SetS3Prefix(v string) *StartMailboxExportJobInput {
	s.S3Prefix = &v
	return s
}

type StartMailboxExportJobOutput struct {
	_ struct{} `type:"structure"`

	// The job ID.
	JobId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s StartMailboxExportJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartMailboxExportJobOutput) GoString() string {
	return s.String()
}

// SetJobId sets the JobId field's value.
func (s *StartMailboxExportJobOutput) SetJobId(v string) *StartMailboxExportJobOutput {
	s.JobId = &v
	return s
}

// Describes a tag applied to a resource.
type Tag struct {
	_ struct{} `type:"structure"`

	// The key of the tag.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// The value of the tag.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The resource ARN.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"1" type:"string" required:"true"`

	// The tag key-value pairs.
	//
	// Tags is a required field
	Tags []*Tag `type:"list" required:"true"`
}

// String returns the string representation
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *TagResourceInput) SetResourceARN(v string) *TagResourceInput {
	s.ResourceARN = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v []*Tag) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// The resource can have up to 50 user-applied tags.
type TooManyTagsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s TooManyTagsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TooManyTagsException) GoString() string {
	return s.String()
}

func newErrorTooManyTagsException(v protocol.ResponseMetadata) error {
	return &TooManyTagsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *TooManyTagsException) Code() string {
	return "TooManyTagsException"
}

// Message returns the exception's message.
func (s *TooManyTagsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *TooManyTagsException) OrigErr() error {
	return nil
}

func (s *TooManyTagsException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *TooManyTagsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *TooManyTagsException) RequestID() string {
	return s.RespMetadata.RequestID
}

// You can't perform a write operation against a read-only directory.
type UnsupportedOperationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s UnsupportedOperationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UnsupportedOperationException) GoString() string {
	return s.String()
}

func newErrorUnsupportedOperationException(v protocol.ResponseMetadata) error {
	return &UnsupportedOperationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *UnsupportedOperationException) Code() string {
	return "UnsupportedOperationException"
}

// Message returns the exception's message.
func (s *UnsupportedOperationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *UnsupportedOperationException) OrigErr() error {
	return nil
}

func (s *UnsupportedOperationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *UnsupportedOperationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *UnsupportedOperationException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The resource ARN.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"1" type:"string" required:"true"`

	// The tag keys.
	//
	// TagKeys is a required field
	TagKeys []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *UntagResourceInput) SetResourceARN(v string) *UntagResourceInput {
	s.ResourceARN = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateMailboxQuotaInput struct {
	_ struct{} `type:"structure"`

	// The updated mailbox quota, in MB, for the specified user.
	//
	// MailboxQuota is a required field
	MailboxQuota *int64 `min:"1" type:"integer" required:"true"`

	// The identifier for the organization that contains the user for whom to update
	// the mailbox quota.
	//
	// OrganizationId is a required field
	OrganizationId *string `min:"34" type:"string" required:"true"`

	// The identifer for the user for whom to update the mailbox quota.
	//
	// UserId is a required field
	UserId *string `min:"12" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateMailboxQuotaInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateMailboxQuotaInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateMailboxQuotaInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateMailboxQuotaInput"}
	if s.MailboxQuota == nil {
		invalidParams.Add(request.NewErrParamRequired("MailboxQuota"))
	}
	if s.MailboxQuota != nil && *s.MailboxQuota < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MailboxQuota", 1))
	}
	if s.OrganizationId == nil {
		invalidParams.Add(request.NewErrParamRequired("OrganizationId"))
	}
	if s.OrganizationId != nil && len(*s.OrganizationId) < 34 {
		invalidParams.Add(request.NewErrParamMinLen("OrganizationId", 34))
	}
	if s.UserId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserId"))
	}
	if s.UserId != nil && len(*s.UserId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("UserId", 12))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMailboxQuota sets the MailboxQuota field's value.
func (s *UpdateMailboxQuotaInput) SetMailboxQuota(v int64) *UpdateMailboxQuotaInput {
	s.MailboxQuota = &v
	return s
}

// SetOrganizationId sets the OrganizationId field's value.
func (s *UpdateMailboxQuotaInput) SetOrganizationId(v string) *UpdateMailboxQuotaInput {
	s.OrganizationId = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *UpdateMailboxQuotaInput) SetUserId(v string) *UpdateMailboxQuotaInput {
	s.UserId = &v
	return s
}

type UpdateMailboxQuotaOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateMailboxQuotaOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateMailboxQuotaOutput) GoString() string {
	return s.String()
}

type UpdatePrimaryEmailAddressInput struct {
	_ struct{} `type:"structure"`

	// The value of the email to be updated as primary.
	//
	// Email is a required field
	Email *string `min:"1" type:"string" required:"true"`

	// The user, group, or resource to update.
	//
	// EntityId is a required field
	EntityId *string `min:"12" type:"string" required:"true"`

	// The organization that contains the user, group, or resource to update.
	//
	// OrganizationId is a required field
	OrganizationId *string `min:"34" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdatePrimaryEmailAddressInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdatePrimaryEmailAddressInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdatePrimaryEmailAddressInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdatePrimaryEmailAddressInput"}
	if s.Email == nil {
		invalidParams.Add(request.NewErrParamRequired("Email"))
	}
	if s.Email != nil && len(*s.Email) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Email", 1))
	}
	if s.EntityId == nil {
		invalidParams.Add(request.NewErrParamRequired("EntityId"))
	}
	if s.EntityId != nil && len(*s.EntityId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("EntityId", 12))
	}
	if s.OrganizationId == nil {
		invalidParams.Add(request.NewErrParamRequired("OrganizationId"))
	}
	if s.OrganizationId != nil && len(*s.OrganizationId) < 34 {
		invalidParams.Add(request.NewErrParamMinLen("OrganizationId", 34))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEmail sets the Email field's value.
func (s *UpdatePrimaryEmailAddressInput) SetEmail(v string) *UpdatePrimaryEmailAddressInput {
	s.Email = &v
	return s
}

// SetEntityId sets the EntityId field's value.
func (s *UpdatePrimaryEmailAddressInput) SetEntityId(v string) *UpdatePrimaryEmailAddressInput {
	s.EntityId = &v
	return s
}

// SetOrganizationId sets the OrganizationId field's value.
func (s *UpdatePrimaryEmailAddressInput) SetOrganizationId(v string) *UpdatePrimaryEmailAddressInput {
	s.OrganizationId = &v
	return s
}

type UpdatePrimaryEmailAddressOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdatePrimaryEmailAddressOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdatePrimaryEmailAddressOutput) GoString() string {
	return s.String()
}

type UpdateResourceInput struct {
	_ struct{} `type:"structure"`

	// The resource's booking options to be updated.
	BookingOptions *BookingOptions `type:"structure"`

	// The name of the resource to be updated.
	Name *string `min:"1" type:"string"`

	// The identifier associated with the organization for which the resource is
	// updated.
	//
	// OrganizationId is a required field
	OrganizationId *string `min:"34" type:"string" required:"true"`

	// The identifier of the resource to be updated.
	//
	// ResourceId is a required field
	ResourceId *string `min:"34" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateResourceInput"}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.OrganizationId == nil {
		invalidParams.Add(request.NewErrParamRequired("OrganizationId"))
	}
	if s.OrganizationId != nil && len(*s.OrganizationId) < 34 {
		invalidParams.Add(request.NewErrParamMinLen("OrganizationId", 34))
	}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 34 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 34))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBookingOptions sets the BookingOptions field's value.
func (s *UpdateResourceInput) SetBookingOptions(v *BookingOptions) *UpdateResourceInput {
	s.BookingOptions = v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateResourceInput) SetName(v string) *UpdateResourceInput {
	s.Name = &v
	return s
}

// SetOrganizationId sets the OrganizationId field's value.
func (s *UpdateResourceInput) SetOrganizationId(v string) *UpdateResourceInput {
	s.OrganizationId = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *UpdateResourceInput) SetResourceId(v string) *UpdateResourceInput {
	s.ResourceId = &v
	return s
}

type UpdateResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateResourceOutput) GoString() string {
	return s.String()
}

// The representation of an Amazon WorkMail user.
type User struct {
	_ struct{} `type:"structure"`

	// The date indicating when the user was disabled from Amazon WorkMail use.
	DisabledDate *time.Time `type:"timestamp"`

	// The display name of the user.
	DisplayName *string `type:"string"`

	// The email of the user.
	Email *string `min:"1" type:"string"`

	// The date indicating when the user was enabled for Amazon WorkMail use.
	EnabledDate *time.Time `type:"timestamp"`

	// The identifier of the user.
	Id *string `min:"12" type:"string"`

	// The name of the user.
	Name *string `min:"1" type:"string"`

	// The state of the user, which can be ENABLED, DISABLED, or DELETED.
	State *string `type:"string" enum:"EntityState"`

	// The role of the user.
	UserRole *string `type:"string" enum:"UserRole"`
}

// String returns the string representation
func (s User) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s User) GoString() string {
	return s.String()
}

// SetDisabledDate sets the DisabledDate field's value.
func (s *User) SetDisabledDate(v time.Time) *User {
	s.DisabledDate = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *User) SetDisplayName(v string) *User {
	s.DisplayName = &v
	return s
}

// SetEmail sets the Email field's value.
func (s *User) SetEmail(v string) *User {
	s.Email = &v
	return s
}

// SetEnabledDate sets the EnabledDate field's value.
func (s *User) SetEnabledDate(v time.Time) *User {
	s.EnabledDate = &v
	return s
}

// SetId sets the Id field's value.
func (s *User) SetId(v string) *User {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *User) SetName(v string) *User {
	s.Name = &v
	return s
}

// SetState sets the State field's value.
func (s *User) SetState(v string) *User {
	s.State = &v
	return s
}

// SetUserRole sets the UserRole field's value.
func (s *User) SetUserRole(v string) *User {
	s.UserRole = &v
	return s
}

const (
	// AccessControlRuleEffectAllow is a AccessControlRuleEffect enum value
	AccessControlRuleEffectAllow = "ALLOW"

	// AccessControlRuleEffectDeny is a AccessControlRuleEffect enum value
	AccessControlRuleEffectDeny = "DENY"
)

// AccessControlRuleEffect_Values returns all elements of the AccessControlRuleEffect enum
func AccessControlRuleEffect_Values() []string {
	return []string{
		AccessControlRuleEffectAllow,
		AccessControlRuleEffectDeny,
	}
}

const (
	// EntityStateEnabled is a EntityState enum value
	EntityStateEnabled = "ENABLED"

	// EntityStateDisabled is a EntityState enum value
	EntityStateDisabled = "DISABLED"

	// EntityStateDeleted is a EntityState enum value
	EntityStateDeleted = "DELETED"
)

// EntityState_Values returns all elements of the EntityState enum
func EntityState_Values() []string {
	return []string{
		EntityStateEnabled,
		EntityStateDisabled,
		EntityStateDeleted,
	}
}

const (
	// FolderNameInbox is a FolderName enum value
	FolderNameInbox = "INBOX"

	// FolderNameDeletedItems is a FolderName enum value
	FolderNameDeletedItems = "DELETED_ITEMS"

	// FolderNameSentItems is a FolderName enum value
	FolderNameSentItems = "SENT_ITEMS"

	// FolderNameDrafts is a FolderName enum value
	FolderNameDrafts = "DRAFTS"

	// FolderNameJunkEmail is a FolderName enum value
	FolderNameJunkEmail = "JUNK_EMAIL"
)

// FolderName_Values returns all elements of the FolderName enum
func FolderName_Values() []string {
	return []string{
		FolderNameInbox,
		FolderNameDeletedItems,
		FolderNameSentItems,
		FolderNameDrafts,
		FolderNameJunkEmail,
	}
}

const (
	// MailboxExportJobStateRunning is a MailboxExportJobState enum value
	MailboxExportJobStateRunning = "RUNNING"

	// MailboxExportJobStateCompleted is a MailboxExportJobState enum value
	MailboxExportJobStateCompleted = "COMPLETED"

	// MailboxExportJobStateFailed is a MailboxExportJobState enum value
	MailboxExportJobStateFailed = "FAILED"

	// MailboxExportJobStateCancelled is a MailboxExportJobState enum value
	MailboxExportJobStateCancelled = "CANCELLED"
)

// MailboxExportJobState_Values returns all elements of the MailboxExportJobState enum
func MailboxExportJobState_Values() []string {
	return []string{
		MailboxExportJobStateRunning,
		MailboxExportJobStateCompleted,
		MailboxExportJobStateFailed,
		MailboxExportJobStateCancelled,
	}
}

const (
	// MemberTypeGroup is a MemberType enum value
	MemberTypeGroup = "GROUP"

	// MemberTypeUser is a MemberType enum value
	MemberTypeUser = "USER"
)

// MemberType_Values returns all elements of the MemberType enum
func MemberType_Values() []string {
	return []string{
		MemberTypeGroup,
		MemberTypeUser,
	}
}

const (
	// PermissionTypeFullAccess is a PermissionType enum value
	PermissionTypeFullAccess = "FULL_ACCESS"

	// PermissionTypeSendAs is a PermissionType enum value
	PermissionTypeSendAs = "SEND_AS"

	// PermissionTypeSendOnBehalf is a PermissionType enum value
	PermissionTypeSendOnBehalf = "SEND_ON_BEHALF"
)

// PermissionType_Values returns all elements of the PermissionType enum
func PermissionType_Values() []string {
	return []string{
		PermissionTypeFullAccess,
		PermissionTypeSendAs,
		PermissionTypeSendOnBehalf,
	}
}

const (
	// ResourceTypeRoom is a ResourceType enum value
	ResourceTypeRoom = "ROOM"

	// ResourceTypeEquipment is a ResourceType enum value
	ResourceTypeEquipment = "EQUIPMENT"
)

// ResourceType_Values returns all elements of the ResourceType enum
func ResourceType_Values() []string {
	return []string{
		ResourceTypeRoom,
		ResourceTypeEquipment,
	}
}

const (
	// RetentionActionNone is a RetentionAction enum value
	RetentionActionNone = "NONE"

	// RetentionActionDelete is a RetentionAction enum value
	RetentionActionDelete = "DELETE"

	// RetentionActionPermanentlyDelete is a RetentionAction enum value
	RetentionActionPermanentlyDelete = "PERMANENTLY_DELETE"
)

// RetentionAction_Values returns all elements of the RetentionAction enum
func RetentionAction_Values() []string {
	return []string{
		RetentionActionNone,
		RetentionActionDelete,
		RetentionActionPermanentlyDelete,
	}
}

const (
	// UserRoleUser is a UserRole enum value
	UserRoleUser = "USER"

	// UserRoleResource is a UserRole enum value
	UserRoleResource = "RESOURCE"

	// UserRoleSystemUser is a UserRole enum value
	UserRoleSystemUser = "SYSTEM_USER"
)

// UserRole_Values returns all elements of the UserRole enum
func UserRole_Values() []string {
	return []string{
		UserRoleUser,
		UserRoleResource,
		UserRoleSystemUser,
	}
}
