/*
 * stmp378x: UARTDBG register definitions
 *
 * Copyright (c) 2008 Freescale Semiconductor
 * Copyright 2008 Embedded Alley Solutions, Inc All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */
#define REGS_UARTDBG_BASE	(STMP3XXX_REGS_BASE + 0x70000)
#define REGS_UARTDBG_PHYS	0x80070000
#define REGS_UARTDBG_SIZE	0x2000

#define HW_UARTDBGDR 0x00000000
#define BP_UARTDBGDR_UNAVAILABLE      16
#define BM_UARTDBGDR_UNAVAILABLE 0xFFFF0000
#define BF_UARTDBGDR_UNAVAILABLE(v) \
	(((v) << 16) & BM_UARTDBGDR_UNAVAILABLE)
#define BP_UARTDBGDR_RESERVED      12
#define BM_UARTDBGDR_RESERVED 0x0000F000
#define BF_UARTDBGDR_RESERVED(v)  \
	(((v) << 12) & BM_UARTDBGDR_RESERVED)
#define BM_UARTDBGDR_OE 0x00000800
#define BM_UARTDBGDR_BE 0x00000400
#define BM_UARTDBGDR_PE 0x00000200
#define BM_UARTDBGDR_FE 0x00000100
#define BP_UARTDBGDR_DATA      0
#define BM_UARTDBGDR_DATA 0x000000FF
#define BF_UARTDBGDR_DATA(v)  \
	(((v) << 0) & BM_UARTDBGDR_DATA)
#define HW_UARTDBGRSR_ECR 0x00000004
#define BP_UARTDBGRSR_ECR_UNAVAILABLE      8
#define BM_UARTDBGRSR_ECR_UNAVAILABLE 0xFFFFFF00
#define BF_UARTDBGRSR_ECR_UNAVAILABLE(v) \
	(((v) << 8) & BM_UARTDBGRSR_ECR_UNAVAILABLE)
#define BP_UARTDBGRSR_ECR_EC      4
#define BM_UARTDBGRSR_ECR_EC 0x000000F0
#define BF_UARTDBGRSR_ECR_EC(v)  \
	(((v) << 4) & BM_UARTDBGRSR_ECR_EC)
#define BM_UARTDBGRSR_ECR_OE 0x00000008
#define BM_UARTDBGRSR_ECR_BE 0x00000004
#define BM_UARTDBGRSR_ECR_PE 0x00000002
#define BM_UARTDBGRSR_ECR_FE 0x00000001
#define HW_UARTDBGFR 0x00000018
#define BP_UARTDBGFR_UNAVAILABLE      16
#define BM_UARTDBGFR_UNAVAILABLE 0xFFFF0000
#define BF_UARTDBGFR_UNAVAILABLE(v) \
	(((v) << 16) & BM_UARTDBGFR_UNAVAILABLE)
#define BP_UARTDBGFR_RESERVED      9
#define BM_UARTDBGFR_RESERVED 0x0000FE00
#define BF_UARTDBGFR_RESERVED(v)  \
	(((v) << 9) & BM_UARTDBGFR_RESERVED)
#define BM_UARTDBGFR_RI 0x00000100
#define BM_UARTDBGFR_TXFE 0x00000080
#define BM_UARTDBGFR_RXFF 0x00000040
#define BM_UARTDBGFR_TXFF 0x00000020
#define BM_UARTDBGFR_RXFE 0x00000010
#define BM_UARTDBGFR_BUSY 0x00000008
#define BM_UARTDBGFR_DCD 0x00000004
#define BM_UARTDBGFR_DSR 0x00000002
#define BM_UARTDBGFR_CTS 0x00000001
#define HW_UARTDBGILPR 0x00000020
#define BP_UARTDBGILPR_UNAVAILABLE      8
#define BM_UARTDBGILPR_UNAVAILABLE 0xFFFFFF00
#define BF_UARTDBGILPR_UNAVAILABLE(v) \
	(((v) << 8) & BM_UARTDBGILPR_UNAVAILABLE)
#define BP_UARTDBGILPR_ILPDVSR      0
#define BM_UARTDBGILPR_ILPDVSR 0x000000FF
#define BF_UARTDBGILPR_ILPDVSR(v)  \
	(((v) << 0) & BM_UARTDBGILPR_ILPDVSR)
#define HW_UARTDBGIBRD 0x00000024
#define BP_UARTDBGIBRD_UNAVAILABLE      16
#define BM_UARTDBGIBRD_UNAVAILABLE 0xFFFF0000
#define BF_UARTDBGIBRD_UNAVAILABLE(v) \
	(((v) << 16) & BM_UARTDBGIBRD_UNAVAILABLE)
#define BP_UARTDBGIBRD_BAUD_DIVINT      0
#define BM_UARTDBGIBRD_BAUD_DIVINT 0x0000FFFF
#define BF_UARTDBGIBRD_BAUD_DIVINT(v)  \
	(((v) << 0) & BM_UARTDBGIBRD_BAUD_DIVINT)
#define HW_UARTDBGFBRD 0x00000028
#define BP_UARTDBGFBRD_UNAVAILABLE      8
#define BM_UARTDBGFBRD_UNAVAILABLE 0xFFFFFF00
#define BF_UARTDBGFBRD_UNAVAILABLE(v) \
	(((v) << 8) & BM_UARTDBGFBRD_UNAVAILABLE)
#define BP_UARTDBGFBRD_RESERVED      6
#define BM_UARTDBGFBRD_RESERVED 0x000000C0
#define BF_UARTDBGFBRD_RESERVED(v)  \
	(((v) << 6) & BM_UARTDBGFBRD_RESERVED)
#define BP_UARTDBGFBRD_BAUD_DIVFRAC      0
#define BM_UARTDBGFBRD_BAUD_DIVFRAC 0x0000003F
#define BF_UARTDBGFBRD_BAUD_DIVFRAC(v)  \
	(((v) << 0) & BM_UARTDBGFBRD_BAUD_DIVFRAC)
#define HW_UARTDBGLCR_H 0x0000002c
#define BP_UARTDBGLCR_H_UNAVAILABLE      16
#define BM_UARTDBGLCR_H_UNAVAILABLE 0xFFFF0000
#define BF_UARTDBGLCR_H_UNAVAILABLE(v) \
	(((v) << 16) & BM_UARTDBGLCR_H_UNAVAILABLE)
#define BP_UARTDBGLCR_H_RESERVED      8
#define BM_UARTDBGLCR_H_RESERVED 0x0000FF00
#define BF_UARTDBGLCR_H_RESERVED(v)  \
	(((v) << 8) & BM_UARTDBGLCR_H_RESERVED)
#define BM_UARTDBGLCR_H_SPS 0x00000080
#define BP_UARTDBGLCR_H_WLEN      5
#define BM_UARTDBGLCR_H_WLEN 0x00000060
#define BF_UARTDBGLCR_H_WLEN(v)  \
	(((v) << 5) & BM_UARTDBGLCR_H_WLEN)
#define BM_UARTDBGLCR_H_FEN 0x00000010
#define BM_UARTDBGLCR_H_STP2 0x00000008
#define BM_UARTDBGLCR_H_EPS 0x00000004
#define BM_UARTDBGLCR_H_PEN 0x00000002
#define BM_UARTDBGLCR_H_BRK 0x00000001
#define HW_UARTDBGCR 0x00000030
#define BP_UARTDBGCR_UNAVAILABLE      16
#define BM_UARTDBGCR_UNAVAILABLE 0xFFFF0000
#define BF_UARTDBGCR_UNAVAILABLE(v) \
	(((v) << 16) & BM_UARTDBGCR_UNAVAILABLE)
#define BM_UARTDBGCR_CTSEN 0x00008000
#define BM_UARTDBGCR_RTSEN 0x00004000
#define BM_UARTDBGCR_OUT2 0x00002000
#define BM_UARTDBGCR_OUT1 0x00001000
#define BM_UARTDBGCR_RTS 0x00000800
#define BM_UARTDBGCR_DTR 0x00000400
#define BM_UARTDBGCR_RXE 0x00000200
#define BM_UARTDBGCR_TXE 0x00000100
#define BM_UARTDBGCR_LBE 0x00000080
#define BP_UARTDBGCR_RESERVED      3
#define BM_UARTDBGCR_RESERVED 0x00000078
#define BF_UARTDBGCR_RESERVED(v)  \
	(((v) << 3) & BM_UARTDBGCR_RESERVED)
#define BM_UARTDBGCR_SIRLP 0x00000004
#define BM_UARTDBGCR_SIREN 0x00000002
#define BM_UARTDBGCR_UARTEN 0x00000001
#define HW_UARTDBGIFLS 0x00000034
#define BP_UARTDBGIFLS_UNAVAILABLE      16
#define BM_UARTDBGIFLS_UNAVAILABLE 0xFFFF0000
#define BF_UARTDBGIFLS_UNAVAILABLE(v) \
	(((v) << 16) & BM_UARTDBGIFLS_UNAVAILABLE)
#define BP_UARTDBGIFLS_RESERVED      6
#define BM_UARTDBGIFLS_RESERVED 0x0000FFC0
#define BF_UARTDBGIFLS_RESERVED(v)  \
	(((v) << 6) & BM_UARTDBGIFLS_RESERVED)
#define BP_UARTDBGIFLS_RXIFLSEL      3
#define BM_UARTDBGIFLS_RXIFLSEL 0x00000038
#define BF_UARTDBGIFLS_RXIFLSEL(v)  \
	(((v) << 3) & BM_UARTDBGIFLS_RXIFLSEL)
#define BV_UARTDBGIFLS_RXIFLSEL__NOT_EMPTY      0x0
#define BV_UARTDBGIFLS_RXIFLSEL__ONE_QUARTER    0x1
#define BV_UARTDBGIFLS_RXIFLSEL__ONE_HALF       0x2
#define BV_UARTDBGIFLS_RXIFLSEL__THREE_QUARTERS 0x3
#define BV_UARTDBGIFLS_RXIFLSEL__SEVEN_EIGHTHS  0x4
#define BV_UARTDBGIFLS_RXIFLSEL__INVALID5       0x5
#define BV_UARTDBGIFLS_RXIFLSEL__INVALID6       0x6
#define BV_UARTDBGIFLS_RXIFLSEL__INVALID7       0x7
#define BP_UARTDBGIFLS_TXIFLSEL      0
#define BM_UARTDBGIFLS_TXIFLSEL 0x00000007
#define BF_UARTDBGIFLS_TXIFLSEL(v)  \
	(((v) << 0) & BM_UARTDBGIFLS_TXIFLSEL)
#define BV_UARTDBGIFLS_TXIFLSEL__EMPTY	  0x0
#define BV_UARTDBGIFLS_TXIFLSEL__ONE_QUARTER    0x1
#define BV_UARTDBGIFLS_TXIFLSEL__ONE_HALF       0x2
#define BV_UARTDBGIFLS_TXIFLSEL__THREE_QUARTERS 0x3
#define BV_UARTDBGIFLS_TXIFLSEL__SEVEN_EIGHTHS  0x4
#define BV_UARTDBGIFLS_TXIFLSEL__INVALID5       0x5
#define BV_UARTDBGIFLS_TXIFLSEL__INVALID6       0x6
#define BV_UARTDBGIFLS_TXIFLSEL__INVALID7       0x7
#define HW_UARTDBGIMSC 0x00000038
#define BP_UARTDBGIMSC_UNAVAILABLE      16
#define BM_UARTDBGIMSC_UNAVAILABLE 0xFFFF0000
#define BF_UARTDBGIMSC_UNAVAILABLE(v) \
	(((v) << 16) & BM_UARTDBGIMSC_UNAVAILABLE)
#define BP_UARTDBGIMSC_RESERVED      11
#define BM_UARTDBGIMSC_RESERVED 0x0000F800
#define BF_UARTDBGIMSC_RESERVED(v)  \
	(((v) << 11) & BM_UARTDBGIMSC_RESERVED)
#define BM_UARTDBGIMSC_OEIM 0x00000400
#define BM_UARTDBGIMSC_BEIM 0x00000200
#define BM_UARTDBGIMSC_PEIM 0x00000100
#define BM_UARTDBGIMSC_FEIM 0x00000080
#define BM_UARTDBGIMSC_RTIM 0x00000040
#define BM_UARTDBGIMSC_TXIM 0x00000020
#define BM_UARTDBGIMSC_RXIM 0x00000010
#define BM_UARTDBGIMSC_DSRMIM 0x00000008
#define BM_UARTDBGIMSC_DCDMIM 0x00000004
#define BM_UARTDBGIMSC_CTSMIM 0x00000002
#define BM_UARTDBGIMSC_RIMIM 0x00000001
#define HW_UARTDBGRIS 0x0000003c
#define BP_UARTDBGRIS_UNAVAILABLE      16
#define BM_UARTDBGRIS_UNAVAILABLE 0xFFFF0000
#define BF_UARTDBGRIS_UNAVAILABLE(v) \
	(((v) << 16) & BM_UARTDBGRIS_UNAVAILABLE)
#define BP_UARTDBGRIS_RESERVED      11
#define BM_UARTDBGRIS_RESERVED 0x0000F800
#define BF_UARTDBGRIS_RESERVED(v)  \
	(((v) << 11) & BM_UARTDBGRIS_RESERVED)
#define BM_UARTDBGRIS_OERIS 0x00000400
#define BM_UARTDBGRIS_BERIS 0x00000200
#define BM_UARTDBGRIS_PERIS 0x00000100
#define BM_UARTDBGRIS_FERIS 0x00000080
#define BM_UARTDBGRIS_RTRIS 0x00000040
#define BM_UARTDBGRIS_TXRIS 0x00000020
#define BM_UARTDBGRIS_RXRIS 0x00000010
#define BM_UARTDBGRIS_DSRRMIS 0x00000008
#define BM_UARTDBGRIS_DCDRMIS 0x00000004
#define BM_UARTDBGRIS_CTSRMIS 0x00000002
#define BM_UARTDBGRIS_RIRMIS 0x00000001
#define HW_UARTDBGMIS 0x00000040
#define BP_UARTDBGMIS_UNAVAILABLE      16
#define BM_UARTDBGMIS_UNAVAILABLE 0xFFFF0000
#define BF_UARTDBGMIS_UNAVAILABLE(v) \
	(((v) << 16) & BM_UARTDBGMIS_UNAVAILABLE)
#define BP_UARTDBGMIS_RESERVED      11
#define BM_UARTDBGMIS_RESERVED 0x0000F800
#define BF_UARTDBGMIS_RESERVED(v)  \
	(((v) << 11) & BM_UARTDBGMIS_RESERVED)
#define BM_UARTDBGMIS_OEMIS 0x00000400
#define BM_UARTDBGMIS_BEMIS 0x00000200
#define BM_UARTDBGMIS_PEMIS 0x00000100
#define BM_UARTDBGMIS_FEMIS 0x00000080
#define BM_UARTDBGMIS_RTMIS 0x00000040
#define BM_UARTDBGMIS_TXMIS 0x00000020
#define BM_UARTDBGMIS_RXMIS 0x00000010
#define BM_UARTDBGMIS_DSRMMIS 0x00000008
#define BM_UARTDBGMIS_DCDMMIS 0x00000004
#define BM_UARTDBGMIS_CTSMMIS 0x00000002
#define BM_UARTDBGMIS_RIMMIS 0x00000001
#define HW_UARTDBGICR 0x00000044
#define BP_UARTDBGICR_UNAVAILABLE      16
#define BM_UARTDBGICR_UNAVAILABLE 0xFFFF0000
#define BF_UARTDBGICR_UNAVAILABLE(v) \
	(((v) << 16) & BM_UARTDBGICR_UNAVAILABLE)
#define BP_UARTDBGICR_RESERVED      11
#define BM_UARTDBGICR_RESERVED 0x0000F800
#define BF_UARTDBGICR_RESERVED(v)  \
	(((v) << 11) & BM_UARTDBGICR_RESERVED)
#define BM_UARTDBGICR_OEIC 0x00000400
#define BM_UARTDBGICR_BEIC 0x00000200
#define BM_UARTDBGICR_PEIC 0x00000100
#define BM_UARTDBGICR_FEIC 0x00000080
#define BM_UARTDBGICR_RTIC 0x00000040
#define BM_UARTDBGICR_TXIC 0x00000020
#define BM_UARTDBGICR_RXIC 0x00000010
#define BM_UARTDBGICR_DSRMIC 0x00000008
#define BM_UARTDBGICR_DCDMIC 0x00000004
#define BM_UARTDBGICR_CTSMIC 0x00000002
#define BM_UARTDBGICR_RIMIC 0x00000001
#define HW_UARTDBGDMACR 0x00000048
#define BP_UARTDBGDMACR_UNAVAILABLE      16
#define BM_UARTDBGDMACR_UNAVAILABLE 0xFFFF0000
#define BF_UARTDBGDMACR_UNAVAILABLE(v) \
	(((v) << 16) & BM_UARTDBGDMACR_UNAVAILABLE)
#define BP_UARTDBGDMACR_RESERVED      3
#define BM_UARTDBGDMACR_RESERVED 0x0000FFF8
#define BF_UARTDBGDMACR_RESERVED(v)  \
	(((v) << 3) & BM_UARTDBGDMACR_RESERVED)
#define BM_UARTDBGDMACR_DMAONERR 0x00000004
#define BM_UARTDBGDMACR_TXDMAE 0x00000002
#define BM_UARTDBGDMACR_RXDMAE 0x00000001
